<?php
/**
 * Includes theme defaults and starter functions
 * 
 * @package News Event
 * @since 1.0.0
 */
 namespace NewsEvent\CustomizerDefault;

 if( !function_exists( 'news_event_get_customizer_option' ) ) :
    /**
     * Gets customizer "theme_mods" value
     * 
     * @package News Event
     * @since 1.0.0
     * 
     */
    function news_event_get_customizer_option( $key ) {
        return get_theme_mod( $key, news_event_get_customizer_default( $key ) );
    }
 endif;

 if( !function_exists( 'news_event_get_customizer_default' ) ) :
    /**
     * Gets customizer "theme_mods" value
     * 
     * @package News Event
     * @since 1.0.0
     */
    function news_event_get_customizer_default($key) {
        $array_defaults = apply_filters( 'news_event_get_customizer_defaults', array(
            'header_layout' => 'two',
            'solid_presets' =>  [ '#64748b', '#27272a', '#ef4444', '#eab308', '#84cc16', '#22c55e', '#06b6d4', '#0284c7', '#6366f1', '#84cc16', '#a855f7', '#f43f5e' ],
            'gradient_presets' =>  [ 'linear-gradient( 135deg, #485563 10%, #29323c 100%)', 'linear-gradient( 135deg, #FF512F 10%, #F09819 100%)', 'linear-gradient( 135deg, #00416A 10%, #E4E5E6 100%)', 'linear-gradient( 135deg, #CE9FFC 10%, #7367F0 100%)', 'linear-gradient( 135deg, #90F7EC 10%, #32CCBC 100%)', 'linear-gradient( 135deg, #81FBB8 10%, #28C76F 100%)', 'linear-gradient( 135deg, #EB3349 10%, #F45C43 100%)', 'linear-gradient( 135deg, #FFF720 10%, #3CD500 100%)', 'linear-gradient( 135deg, #FF96F9 10%, #C32BAC 100%)', 'linear-gradient( 135deg, #69FF97 10%, #00E4FF 100%)', 'linear-gradient( 135deg, #3C8CE7 10%, #00EAFF 100%)', 'linear-gradient( 135deg, #FF7AF5 10%, #513162 100%)' ],
            'default_typo_one'  =>  news_event_get_typography_defaults([
                'font_family'       =>  [ 'value' => 'Public Sans', 'label' => 'Public Sans' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ]
            ]),
            'default_typo_two'  =>  news_event_get_typography_defaults([
                'font_family'       =>  [ 'value' => 'Plus Jakarta Sans', 'label' => 'Plus Jakarta Sans' ],
            ]),
            'theme_color'   => '#d71d4f',
            'site_background_color'  => news_event_get_color_defaults(),
            'site_background_animation' =>  'none',
            'animation_object_color' => news_event_get_color_defaults([ 'solid' => '--news-event-global-preset-theme-color' ]),
            'global_button_label'   =>  esc_html__( 'Read More', 'news-event' ),
            'global_button_typo'    => news_event_get_typography_defaults(),
            'preloader_option'  => false,
            'preloader_type'  => 1,
            'website_layout'    => 'full-width--layout',
            'website_content_layout'    => 'boxed--layout',
            'frontpage_sidebar_layout'  => 'right-sidebar',
            'frontpage_sidebar_sticky_option'    => false,
            'archive_sidebar_layout'    => 'right-sidebar',
            'archive_sidebar_sticky_option'    => false,
            'single_sidebar_layout' => 'right-sidebar',
            'single_sidebar_sticky_option'    => false,
            'page_sidebar_layout'   => 'right-sidebar',
            'page_sidebar_sticky_option'    => false,
            'post_title_hover_effects'  => 'two',
            'site_image_hover_effects'  => 'none',
            'cursor_animation'  =>  'none',
            'site_breadcrumb_option'    => true,
            'site_breadcrumb_type'  => 'default',
            'site_schema_ready' => true,
            'site_date_format'  => 'default',
            'site_date_to_show' => 'published',
            'site_title_hover_textcolor'=> '--news-event-global-preset-theme-color',
            'site_description_color'    => '#777',
            'homepage_content_order'    => json_encode([
                'full_width_section'    => false,
                'leftc_rights_section'  => false,
                'lefts_rightc_section'  => false,
                'latest_posts'  => true,
                'bottom_full_width_section' => true,
                'two_column_section'    => false
            ]),
            'news_event_site_logo_width'    => news_event_get_responsive_defaults( 230, 200, 200 ),
            'site_title_typo'   =>  news_event_get_typography_defaults([
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  news_event_get_responsive_defaults( 30, 30, 30 ),
                'line_height' =>  news_event_get_responsive_defaults( 42, 42, 42 ),
            ]),
            'site_tagline_typo' =>   news_event_get_typography_defaults([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'line_height'   =>  news_event_get_responsive_defaults( 15, 15, 15 )
            ]),
            'top_header_option' => true,
            'top_header_date_time_option'   => false,
            'top_header_menu_option'  => true,
            'top_header_social_option'  => true,
            'top_header_background_color_group' => news_event_get_color_defaults([ 'solid' => '#000' ]),
            'header_newsletter_option'   => false,
            'newsletter_label'   =>  esc_html__( 'Subscribe', 'news-event' ),
            'header_newsletter_redirect_href_target'    => '_blank',
            'header_newsletter_redirect_href_link'  => '',
            'header_newsletter_background_color'    =>  news_event_get_color_defaults([ 
                'initial'   =>  [ 'solid' => '--news-event-global-preset-theme-color' ],
                'hover'     =>  [ 'solid' => '--news-event-global-preset-theme-color' ]
            ]),
            'header_random_news_option'   => true,
            'header_random_news_redirect_href_target'    => '_blank',
            'header_ads_banner_responsive_option'  => array(
                'desktop'   => true,
                'tablet'   => true,
                'mobile'   => true
            ),
            'header_ads_banner_type'    => 'custom',
            'header_ads_banner_custom_image'  => '',
            'header_ads_banner_custom_url'  => '',
            'header_ads_banner_custom_target'  => '_self',
            'header_off_canvas_option'  => true,
            'off_canvas_position'  => 'left',
            'header_search_option'  => true,
            'header_theme_mode_toggle_option'  => true,
            'header_width_layout'   => 'boxed--layout',
            'header_vertical_padding'   => news_event_get_responsive_defaults( 15, 20, 20 ),
            'header_background_color_group' => news_event_get_color_defaults([ 'solid' => '#fff' ]),
            'header_menu_hover_effect'  => 'none',
            'header_menu_background_color_group' => news_event_get_color_defaults([ 'solid' => '151515' ]),
            'header_sub_menu_background_color_group' => news_event_get_color_defaults([ 'solid' => '#fff' ]),
            'header_menu_typo'    => news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '800', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  news_event_get_responsive_defaults( 15, 15, 14 ),
                'line_height'   => news_event_get_responsive_defaults( 20, 20, 20 )
            ]),
            'header_sub_menu_typo'    => news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  news_event_get_responsive_defaults( 14, 14, 14 ),
                'line_height'   => news_event_get_responsive_defaults( 20, 20, 20 )
            ]),
            'social_icons_target' => '_blank',
            'social_icons' => json_encode(array(
                array(
                    'icon_class'    => 'fa-brands fa-facebook-f',
                    'icon_url'      => '',
                    'icon_count'      => '1K',
                    'item_option'   => 'show'
                ),
                array(
                    'icon_class'    => 'fa-brands fa-instagram',
                    'icon_url'      => '',
                    'icon_count'      => '1K',
                    'item_option'   => 'show'
                ),
                array(
                    'icon_class'    => 'fa-brands fa-x-twitter',
                    'icon_url'      => '',
                    'icon_count'      => '1K',
                    'item_option'   => 'show'
                )
            )),
            'social_icons_enable_title'   =>  true,
            'social_icons_columns'   =>  2,
            'social_icons_border_radius'   =>  15,
            'ticker_news_width_layout'  => 'global',
            'ticker_news_visible'   => 'none',
            'ticker_news_order_by'  => 'date-desc',
            'ticker_news_categories' => [],
            'ticker_news_posts' => [],
            'ticker_news_date_filter' => 'all',
            'ticker_news_title' => esc_html__( 'Headlines', 'news-event' ),
            'main_banner_option'    => true,
            'main_banner_block_posts_order_by'  => 'date-desc',
            'main_banner_block_posts_to_include'    =>  [],
            'main_banner_block_posts_categories'   => [],
            'main_banner_block_posts_categories_option'  => true,
            'main_banner_block_posts_date_option'  => true,
            'main_banner_width_layout'  => 'global',
            'main_banner_image_border_radius'    =>  news_event_get_responsive_defaults( 0, 0, 0 ),
            'full_width_blocks'   => json_encode(array(
                array(
                    'type'  => 'news-grid',
                    'blockId'    => '',
                    'option'    => true,
                    'column'    => 'four',
                    'layout'    => 'one',
                    'title'     => esc_html__( 'Latest posts', 'news-event' ),
                    'thumbOption'    => true,
                    'categoryOption'    => false,
                    'authorOption'  => false,
                    'dateOption'    => true,
                    'commentOption' => false,
                    'excerptOption' => false,
                    'excerptLength' => 10,
                    'query' => json_encode([
                        'order' => 'date-desc',
                        'count' => 4,
                        'offset' => 0,
                        'dateFilter' => 'all',
                        'posts' => [],
                        'categories' => [],
                        'ids' => []
                    ]),
                    'buttonOption' => false,
                    'viewallUrl'   => '',
                    'viewallLabelOption'=> true,
                    'viewallLabel'   => esc_html__( 'View all', 'news-event' ),
                    'imageRatio'   =>  json_encode( news_event_get_responsive_defaults() ),
                    'imageSize' =>  "medium",
                )
            )),
            'full_width_blocks_width_layout'  => 'global',
            'full_width_blocks_background_color_group' => news_event_get_color_defaults([ 'solid' => '' ]),
            'leftc_rights_blocks'   => json_encode(array(
                array(
                    'type'  => 'news-filter',
                    'blockId'    => '',
                    'option'    => true,
                    'layout'    => 'six',
                    'title'     => esc_html__( 'Latest posts', 'news-event' ),
                    'categoryOption'    => true,
                    'authorOption'  => true,
                    'dateOption'    => true,
                    'commentOption' => false,
                    'excerptOption' => false,
                    'excerptLength' => 10,
                    'query' => json_encode([
                        'order' => 'date-desc',
                        'count' => 5,
                        'offset' => 0,
                        'dateFilter' => 'all',
                        'posts' => [],
                        'categories' => [],
                        'ids' => []
                    ]),
                    'buttonOption'    => false,
                    'viewallUrl'   => '',
                    'viewallLabelOption'=> true,
                    'viewallLabel'   => esc_html__( 'View all', 'news-event' ),
                    'imageRatio'   =>  json_encode( news_event_get_responsive_defaults() )
                )
            )),
            'leftc_rights_blocks_width_layout'  => 'global',
            'leftc_rights_blocks_background_color_group' => news_event_get_color_defaults([ 'solid' => '' ]),
            'lefts_rightc_blocks'   => json_encode(array(
                array(
                    'type'  => 'news-list',
                    'blockId'    => '',
                    'option'    => true,
                    'layout'    => 'one',
                    'column'    => 'one',
                    'title'     => esc_html__( 'Latest posts', 'news-event' ),
                    'thumbOption'    => true,
                    'categoryOption'    => true,
                    'authorOption'  => true,
                    'dateOption'    => true,
                    'commentOption' => false,
                    'excerptOption' => true,
                    'excerptLength' => 10,
                    'query' => json_encode([
                        'order' => 'date-desc',
                        'count' => 4,
                        'offset' => 0,
                        'dateFilter' => 'all',
                        'posts' => [],
                        'categories' => [],
                        'ids' => []
                    ]),
                    'buttonOption'    => false,
                    'viewallUrl'   => '',
                    'viewallLabelOption'=> true,
                    'viewallLabel'   => esc_html__( 'View all', 'news-event' ),
                    'imageRatio'   =>  json_encode( news_event_get_responsive_defaults() )
                )
            )),
            'lefts_rightc_blocks_width_layout'  => 'global',
            'lefts_rightc_blocks_background_color_group' => news_event_get_color_defaults([ 'solid' => '' ]),
            'bottom_full_width_blocks'   => json_encode(array(
                array(
                    'type'  => 'news-carousel',
                    'blockId'    => '',
                    'option'    => true,
                    'layout'    => 'one',
                    'title'     => esc_html__( 'You May Have Missed', 'news-event' ),
                    'categoryOption'    => true,
                    'authorOption'  => true,
                    'dateOption'    => true,
                    'commentOption' => false,
                    'excerptOption' => false,
                    'excerptLength' => 10,
                    'columns' => 3,
                    'query' => json_encode([
                        'order' => 'rand-desc',
                        'count' => 8,
                        'offset' => 0,
                        'dateFilter' => 'all',
                        'posts' => [],
                        'categories' => [],
                        'ids' => []
                    ]),
                    'buttonOption'    => false,
                    'viewallUrl'   => '',
                    'viewallLabelOption'=> true,
                    'viewallLabel'   => esc_html__( 'View all', 'news-event' ),
                    'dots' => true,
                    'loop' => false,
                    'arrows' => true,
                    'auto' => false,
                    'imageRatio'   =>  json_encode( news_event_get_responsive_defaults() ),
                    'imageSize' =>  "medium_large",
                )
            )),
            'bottom_full_width_blocks_width_layout'  => 'global',
            'bottom_full_width_blocks_background_color_group' => news_event_get_color_defaults([ 'solid' => '' ]),
            'two_column_first_column_blocks'   => json_encode(array(
                array(
                    'type'  => 'news-list',
                    'blockId'    => '',
                    'option'    => true,
                    'layout'    => 'one',
                    'title'     => esc_html__( 'Latest posts', 'news-event' ),
                    'thumbOption'    => true,
                    'categoryOption'    => true,
                    'authorOption'  => true,
                    'dateOption'    => true,
                    'commentOption' => false,
                    'query' => json_encode([
                        'order' => 'date-desc',
                        'count' => 4,
                        'offset' => 0,
                        'dateFilter' => 'all',
                        'posts' => [],
                        'categories' => [],
                        'ids' => []
                    ]),
                    'viewallUrl'   => '',
                    'viewallLabelOption'=> true,
                    'viewallLabel'   => esc_html__( 'View all', 'news-event' ),
                    'imageRatio'   =>  json_encode( news_event_get_responsive_defaults() )
                )
            )),
            'two_column_second_column_blocks'   => json_encode(array(
                array(
                    'type'  => 'news-list',
                    'blockId'    => '',
                    'option'    => true,
                    'layout'    => 'one',
                    'title'     => esc_html__( 'Latest posts', 'news-event' ),
                    'thumbOption'    => true,
                    'categoryOption'    => true,
                    'authorOption'  => true,
                    'dateOption'    => true,
                    'commentOption' => true,
                    'query' => json_encode([
                        'order' => 'date-desc',
                        'count' => 4,
                        'offset' => 0,
                        'dateFilter' => 'all',
                        'posts' => [],
                        'categories' => [],
                        'ids' => []
                    ]),
                    'viewallUrl'   => '',
                    'viewallLabelOption'=> true,
                    'viewallLabel'   => esc_html__( 'View all', 'news-event' ),
                    'imageRatio'   =>  json_encode( news_event_get_responsive_defaults() )
                )
            )),
            'two_column_section_layout'  => 'global',
            'two_column_background_color_group' =>  news_event_get_color_defaults([ 'solid' => '' ]),
            'footer_option' => false,
            'footer_section_width'  => 'boxed-width',
            'footer_widget_column'  => 'column-three',
            'footer_top_border'    => array( "type"  => "none", "width"   => 1, "color"   => "--news-event-global-preset-theme-color" ),
            'footer_background_color_group' => news_event_get_color_defaults([ 'solid' => '#0f0f11' ]),
            'bottom_footer_option'  => true,
            'bottom_footer_social_option'   => true,
            'bottom_footer_menu_option'     => true,
            'bottom_footer_site_info'   => sprintf( esc_html__( 'News Event - Modern WordPress Theme. Developed by. %s.', 'news-event' ), '<a href="https://blazethemes.com/">' .esc_html( 'Blaze Themes' ). '</a>'  ),
            'bottom_footer_width_layout'    => 'global',
            'bottom_footer_background_color_group'  => news_event_get_color_defaults([ 'solid' => '' ]),
            'single_post_related_posts_option'  => true,
            'single_post_related_posts_title'   => esc_html__( 'Related News', 'news-event' ),
            'single_post_show_original_image_option'=> false,
            'single_post_image_caption'=> false,
            'single_post_image_ratio'   =>  news_event_get_responsive_defaults(),
            'single_post_width_layout'=> 'global',
            'single_post_title_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size'         =>  news_event_get_responsive_defaults( 35, 35, 35 ),
                'line_height'       =>  news_event_get_responsive_defaults( 46, 46, 46 )
            ]),
            'single_post_meta_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size'       =>  news_event_get_responsive_defaults( 11, 11, 11 ),
                'line_height'       =>  news_event_get_responsive_defaults( 26, 26, 26 ),
                'letter_spacing'    =>  news_event_get_responsive_defaults( 0.48, 0.48, 0.48 ),
                'text_transform'    =>  'uppercase'
            ]),
            'single_post_content_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size'       =>  news_event_get_responsive_defaults( 16, 16, 16 ),
                'line_height'       =>  news_event_get_responsive_defaults( 27, 27, 27 )
            ]),
            'single_post_content_h1_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size'       =>  news_event_get_responsive_defaults( 32, 16, 16 ),
                'line_height'       =>  news_event_get_responsive_defaults( 46, 22, 22 )
            ]),
            'single_post_content_h2_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size'       =>  news_event_get_responsive_defaults( 24, 16, 16 ),
                'line_height'       =>  news_event_get_responsive_defaults( 38, 22, 22 )
            ]),
            'single_post_content_h3_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size'       =>  news_event_get_responsive_defaults( 18, 16, 16 ),
                'line_height'       =>  news_event_get_responsive_defaults( 27, 22, 22 )
            ]),
            'single_post_content_h4_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size'       =>  news_event_get_responsive_defaults( 16, 16, 16 ),
                'line_height'       =>  news_event_get_responsive_defaults( 24, 22, 22 )
            ]),
            'single_post_content_h5_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size'       =>  news_event_get_responsive_defaults( 13, 14, 14 ),
                'line_height'       =>  news_event_get_responsive_defaults( 20, 20, 20 )
            ]),
            'single_post_content_h6_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size'       =>  news_event_get_responsive_defaults( 10, 12, 14 ),
                'line_height'       =>  news_event_get_responsive_defaults( 16, 16, 16 )
            ]),
            'archive_page_layout'   => 'one',
            'archive_page_title_prefix'   => false,
            'archive_page_category_option'   => true,
            'archive_pagination_type'   => 'number',
            'archive_image_size'   =>  'medium_large',
            'archive_post_element_order'    => json_encode(array(
                'title' => true,
                'meta'  => true,
                'excerpt'   => true,
                'button'    => false
            )),
            'archive_image_ratio'   =>  news_event_get_responsive_defaults(),
            'archive_width_layout'=> 'global',
            'archive_vertical_spacing_top'    =>  news_event_get_responsive_defaults( 25, 25, 25 ),
            'archive_vertical_spacing_bottom'    =>  news_event_get_responsive_defaults( 25, 25, 25 ),
            'single_page_width_layout' => 'global',
            'single_page_show_original_image_option'  =>  false,
            'single_page_image_caption'  =>  false,
            'single_page_image_ratio'   =>  news_event_get_responsive_defaults(),
            'error_page_image'  => 0,
            'error_page_width_layout' => 'global',
            'search_page_width_layout' => 'global',
            'site_section_block_title_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size'         =>  news_event_get_responsive_defaults( 16, 16, 16 ),
                'line_height'       =>  news_event_get_responsive_defaults( 20, 20, 20 ),
                'letter_spacing'    =>  news_event_get_responsive_defaults( 0.48, 0.48, 0.48 ),
                'text_transform'    =>  'capitalize'
            ]),
            'site_archive_post_title_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size'         =>  news_event_get_responsive_defaults( 22, 21, 20 ),
                'line_height'       =>  news_event_get_responsive_defaults( 24, 32, 30 )
            ]),
            'site_archive_post_meta_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size'         =>  news_event_get_responsive_defaults( 12, 12, 12 ),
                'line_height'       =>  news_event_get_responsive_defaults( 20, 20, 20 ),
                'text_transform'    =>  'capitalize',
            ]),
            'site_archive_post_content_typo' =>  news_event_get_typography_defaults([
                'font_weight'       =>  [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size'         =>  news_event_get_responsive_defaults( 15, 15, 15 ),
                'line_height'       =>  news_event_get_responsive_defaults( 24, 24, 24 )
            ]),
            'stt_responsive_option'    => array(
                'desktop'   => true,
                'tablet'   => true,
                'mobile'   => false
            ),
            'widgets_styles_image_border'   =>  array( "type"  => "none", "width"   => 1, "color"   => "#d71d4f" ),
            'widgets_styles_image_border_radius'    =>  news_event_get_responsive_defaults( 0, 0, 0 ),
            'widgets_styles_image_box_shadow'   =>  array(
                'option'    => false,
                'hoffset'   => 0,
                'voffset'   => 4,
                'blur'  => 9,
                'spread'    => -3,
                'type'  => 'outset',
                'color' => 'rgb(7 10 25 / 35%)'
            )
        ));
        $totalCats = get_categories();
        if( $totalCats ) :
            foreach( $totalCats as $singleCat ) :
                $array_defaults['category_' .absint($singleCat->term_id). '_color'] = [
                    'initial'   =>  news_event_get_color_defaults([ 'solid' => '#333333' ]),
                    'hover'   =>  news_event_get_color_defaults([ 'solid' => '#d71d4f' ])
                ];
            endforeach;
        endif;
        return $array_defaults[$key];
    }
 endif;

if( ! function_exists( 'news_event_get_typography_defaults' ) ) :
    /**
     * Get typography control default values
     * 
     * @since 1.0.0
     */
    function news_event_get_typography_defaults( $value = [] ){
        $default = [
            'font_family'       =>  [ 'value' => 'Plus Jakarta Sans', 'label' => 'Plus Jakarta Sans' ],
            'font_weight'       =>  [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
            'font_size'         =>  news_event_get_responsive_defaults( 14, 14, 14 ),
            'line_height'       =>  news_event_get_responsive_defaults( 21, 21, 21 ),
            'letter_spacing'    =>  news_event_get_responsive_defaults(),
            'text_transform'    =>  'unset',
            'text_decoration'   =>  'none'
        ];
        return array_merge( $default, $value );
    }
endif;

if( ! function_exists( 'news_event_get_responsive_defaults' ) ) :
    /**
     * Get default responsive values
     * 
     * @since 1.0.0
     */
    function news_event_get_responsive_defaults( $desktop = 0, $tablet = 0, $smartphone = 0 ){
        $value = [
            'desktop'   => $desktop,
            'tablet'    => $tablet,
            'smartphone' => $smartphone
        ];
        return $value;
    }
endif;

if( ! function_exists( 'news_event_get_color_defaults' ) ) :
    /**
     * Get default responsive values
     * 
     * @since 1.0.0
     */
    function news_event_get_color_defaults( $value = [] ){
        $default = [
            'type'  =>  'solid',
            'solid' =>  '#fff'
        ];
        if( array_key_exists( 'initial', $value ) ) :
            $new_value = [
                'initial'   =>  array_merge( $default, $value[ 'initial' ] ),
                'hover'     =>  array_merge( $default, $value[ 'hover' ] )
            ];
            return $new_value;
        endif;
        return array_merge( $default, $value );
    }
endif;