<?php
/**
 * Includes the inline css
 * 
 * @package News Event
 * @since 1.0.0
 */
use NewsEvent\CustomizerDefault as NEV;
if( ! function_exists( 'news_event_assign_variable' ) ) :
   /**
   * Generate css code
   *
   * @package News Event
   * @since 1.0.0 
   */
   function news_event_assign_variable( $selector, $control, $unit = '' ) {
         $decoded_control =  NEV\news_event_get_customizer_option( $control );
         if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
         if( ! $decoded_control ) return;
         echo " body.news-event-variables{ ", $selector, ": ", esc_html( $decoded_control ), esc_html( $unit ), ";}\n";
   }
endif;

if( ! function_exists( 'news_event_typography_css' ) ) :
   /**
   * Generate css code for typography control.
   *
   * @package News Event
   * @since 1.0.0 
   */
   function news_event_typography_css( $selector, $control ) {
      $value = NEV\news_event_get_customizer_option( $control );
      if( $value === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! $value ) return;
      echo "body.news-event-variables {\n";
      if( isset( $value['font_family'] ) ) echo $selector, '-family', ": ", esc_html( $value['font_family']['value'] ), ";\n";
      if( isset( $value['font_weight'] ) ) echo $selector, '-weight', ": ", esc_html( $value['font_weight']['value'] ), ";\n", $selector, '-style', ": ", esc_html( $value['font_weight']['variant'] ), ";\n";
      if( isset( $value['text_transform'] ) ) echo $selector, '-texttransform', ": ", esc_html( $value['text_transform'] ), ";\n";
      if( isset( $value['text_decoration'] ) ) echo $selector, '-textdecoration', " : ", esc_html( $value['text_decoration'] ), ";\n";
      if( isset( $value['font_size'] ) && isset( $value['font_size']['desktop'] ) ) echo $selector, '-size', ": ", esc_html( $value['font_size']['desktop'] ), 'px', ";\n";
      if( isset( $value['line_height'] ) && isset( $value['line_height']['desktop'] ) ) echo $selector, '-lineheight', ": ", esc_html( $value['line_height']['desktop'] ), 'px', ";\n";
      if( isset( $value['letter_spacing'] ) && isset( $value['letter_spacing']['desktop'] ) ) echo $selector, '-letterspacing', ": ", esc_html( $value['letter_spacing']['desktop'] ), 'px', ";\n";
      echo "}\n";
   
      // tablet responsive
      echo "@media(max-width: 940px) {", "body.news-event-variables {\n"; 
      if( isset( $value['font_size'] ) && isset( $value['font_size']['tablet'] ) ) echo $selector, '-size-tab', ": ", esc_html( $value['font_size']['tablet'] ), 'px', ";\n";
      if( isset( $value['line_height'] ) && isset( $value['line_height']['tablet'] ) ) echo $selector, '-lineheight-tab', ": ", esc_html( $value['line_height']['tablet'] ), 'px', ";\n";
      if( isset( $value['letter_spacing'] ) && isset( $value['letter_spacing']['tablet'] ) ) echo $selector, '-letterspacing-tab', ": ", esc_html( $value['letter_spacing']['tablet'] ), 'px', ";\n";
      echo "}}\n"; 
      // mobile responsive
      echo "@media(max-width: 610px) {", "body.news-event-variables {\n"; 
      if( isset( $value['font_size'] ) && isset( $value['font_size']['smartphone'] ) ) echo $selector, '-size-mobile', ": ", esc_html( $value['font_size']['smartphone'] ), 'px', ";\n";
      if( isset( $value['line_height'] ) && isset( $value['line_height']['smartphone'] ) ) echo $selector, '-lineheight-mobile', ": ", esc_html( $value['line_height']['smartphone'] ), 'px', ";\n";
      if( isset( $value['letter_spacing'] ) && isset( $value['letter_spacing']['smartphone'] ) ) echo $selector, '-letterspacing-mobile', ": ", esc_html( $value['letter_spacing']['smartphone'] ), 'px', ";\n";
      echo "}}\n";
   }
endif;

if( ! function_exists( 'news_event_responsive_range_css' ) ) :
   /**
   * Generate css code for Logo Width
   *
   * @package News Event
   * @since 1.0.0 
   */
   function news_event_responsive_range_css( $selector, $control, $property = 'width'  ) {
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! $decoded_control ) return;
      $is_variable = ( $selector === 'body.news-event-variables' );
      if( $is_variable ) {
         echo $selector . "{\n";
            if( isset( $decoded_control['desktop'] ) ) echo esc_html( $property ), ": ", esc_html( $decoded_control[ 'desktop' ] ), "px;\n";
            if( isset( $decoded_control['tablet'] ) ) echo esc_html( $property ), "-tablet: ", esc_html( $decoded_control[ 'tablet' ] ), "px;\n";
            if( isset( $decoded_control['smartphone'] ) ) echo esc_html( $property ), "-smartphone: ", esc_html( $decoded_control[ 'smartphone' ] ), "px;\n";
         echo "}";
      } else {
         if( isset( $decoded_control['desktop'] ) ) echo $selector . "{ " . esc_html( $property ). ": ".esc_html( $decoded_control[ 'desktop' ] ).  "px; }\n";
         if( isset( $decoded_control['tablet'] ) ) echo "@media(max-width: 940px) { " .$selector . "{ " . esc_html( $property ). ": ".esc_html( $decoded_control[ 'tablet' ] ).  "px; } }\n";
         if( isset( $decoded_control['smartphone'] ) ) echo "@media(max-width: 610px) { " .$selector . "{ " . esc_html( $property ). ": ".esc_html( $decoded_control[ 'smartphone' ] ).  "px; } }\n";
      }
   }
endif;

if( ! function_exists( 'news_event_top_border_color' ) ) :
   /**
    * Generate css code for top header color options
    *
    * @package News Event
    * @since 1.0.0 
    */
   function news_event_top_border_color( $selector, $control, $property = 'border-color' ) {
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! $decoded_control ) return;
      if( isset( $decoded_control['type'] ) ) :
         $type = $decoded_control['type'];
         if( isset( $decoded_control[$type] ) ) echo $selector . "{ " . esc_html( $property ). ": ".esc_html( $decoded_control[$type] ).  "}\n";
         if($type == 'solid'){
            echo $selector . "{ border-color: ". news_event_get_color_format( $decoded_control[$type] ) .";}\n";
            echo $selector . " li{ border-color: ". news_event_get_color_format( $decoded_control[$type] ) .";}\n";
         }
         if($type == 'gradient') echo $selector . " li{ border: none;}\n";
      endif;
   }
endif;

if( ! function_exists('news_event_visibility_options') ):
   /**
    * Generate css code for top header color options
    *
    * @package News Event
    * @since 1.0.0 
    */
   function news_event_visibility_options( $selector, $control ) {
      $decoded_control =  NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! $decoded_control ) return;
      if( isset( $decoded_control['desktop'] ) ) :
         if($decoded_control['desktop'] == false) echo $selector . "{ display : none;}\n";
      endif;

      if( isset( $decoded_control['tablet'] ) ) :
         if($decoded_control['tablet'] == false) echo "@media(max-width: 940px) and (min-width:611px) { " .$selector . "{ display : none;} }\n";
      endif;

      if( isset( $decoded_control['mobile'] ) ) :
         if($decoded_control['mobile'] == false) { 
            echo "@media(max-width: 610px) { " .$selector . "{ display : none;} }\n";
         }
         if($decoded_control['mobile'] == true){
            echo "@media(max-width: 610px) { " .$selector . "{ display : block;} }\n";
         }
      endif;
   }
endif;

if( ! function_exists( 'news_event_border_option' ) ) :
   /**
    * Generate css code for Top header Text Color
    *
    * @package News Event
    * @since 1.0.0 
    */
   function news_event_border_option( $selector, $control, $property="border" ) {
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! $decoded_control ) return;
      if( isset( $decoded_control['type'] ) || isset( $decoded_control['width'] ) || isset( $decoded_control['color'] ) ) :
         echo $selector, "{ ", $property, ": ", $decoded_control['width'], "px ", $decoded_control['type'], " ", news_event_get_color_format( $decoded_control[ 'color' ] ), ";}\n";
      endif;
   }
endif;

if( ! function_exists( 'news_event_category_colors_styles' ) ) :
   /**
    * Generates css code for font size
    *
    * @package News Event
    * @since 1.0.0
    */
   function news_event_category_colors_styles() {
      $totalCats = get_categories();
      if( $totalCats ) :
         foreach( $totalCats as $singleCat ) :
            $term_id = absint( $singleCat->term_id );
            $category_color = NEV\news_event_get_customizer_option( 'category_' .$term_id. '_color' );
            if( $category_color === NEV\news_event_get_customizer_default( 'category_' .$term_id. '_color' ) ) continue;
            $initial = $category_color[ 'initial' ];
            $hover = $category_color[ 'hover' ];
            echo "body #page .post-categories .cat-item.cat-" . $term_id . " a{ background : " .news_event_get_color_format( $initial[ $initial[ 'type' ] ] ). "}\n";
            echo "body #page .post-categories .cat-item.cat-" . $term_id . " a:hover { background : " .news_event_get_color_format( $hover[ $hover[ 'type' ] ] ). "}\n";
            echo "body #page .news-event-category-no-bk .post-categories .cat-item.cat-" . absint($singleCat->term_id) . " a { color : " .news_event_get_color_format( $initial[ $initial[ 'type' ] ] ). "}\n";
            echo "body #page .news-event-category-no-bk .post-categories .cat-item.cat-" . absint($singleCat->term_id) . " a:hover { color : " .news_event_get_color_format( $hover[ $hover[ 'type' ] ] ). ";}\n";
         endforeach;
      endif;
   }
endif;

// Image ratio change
if( ! function_exists( 'news_event_image_ratio' ) ) :
   /**
   * Generate css code for variable change with responsive
   *
   * @package News Event
   * @since 1.0.0 
   */
   function news_event_image_ratio( $selector, $control ) {
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      $value = '100%';
      if( ! $decoded_control ) return;
      if( isset( $decoded_control['desktop'] ) && $decoded_control['desktop'] > 0 ) :
         $desktop = $decoded_control['desktop'];
         echo $selector . "{ padding-bottom : calc(".esc_html( $desktop ).  " * ". esc_html( $value ) ."); }";
      endif;
      if( isset( $decoded_control['tablet'] ) && $decoded_control['tablet'] > 0 ) :
         $tablet = $decoded_control['tablet'];
         echo "@media(max-width: 940px) { " .$selector . "{ padding-bottom : calc(".esc_html( $tablet ).  "* ". esc_html( $value ) ."); } }\n";
      endif;
      if( isset( $decoded_control['smartphone'] ) && $decoded_control['smartphone'] > 0 ) :
         $smartphone = $decoded_control['smartphone'];
         echo "@media(max-width: 610px) { " .$selector . "{ padding-bottom : calc(".esc_html($smartphone).  " * ". esc_html( $value ) ."); } }\n";
      endif;
   }
endif;

if( ! function_exists( 'news_event_image_ratio_variable' ) ) :
   /**
    * Generate css code for variable change with responsive
    *
    * @package News Event
    * @since 1.0.0
    */
   function news_event_image_ratio_variable( $selector, $control ) {
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! $decoded_control ) return;
      echo "body.news-event-variables {\n";
         if( isset( $decoded_control['desktop'] ) && $decoded_control['desktop'] > 0 ) echo $selector, " : ", $decoded_control['desktop'], ";\n";
         if( isset( $decoded_control['tablet'] ) && $decoded_control['tablet'] > 0 ) echo $selector, "-tab : ", $decoded_control['tablet'], ";\n";
         if( isset( $decoded_control['smartphone'] ) && $decoded_control['smartphone'] > 0 ) echo $selector, "-mobile : ", $decoded_control['smartphone'], ";\n";
      echo '}';
   }
endif;

// box shadow
if( ! function_exists( 'news_event_box_shadow_styles' ) ) :
   /**
    * Generates css code for box shadow
    *
    * @package News Event
    * @since 1.0.0
    */
   function news_event_box_shadow_styles($selector,$value) {
      $news_event_box_shadow = NEV\news_event_get_customizer_option($value);
      if( $news_event_box_shadow === NEV\news_event_get_customizer_default( $value ) ) return;
      if( $news_event_box_shadow['option'] == 'none' ) {
         echo $selector."{ box-shadow: 0px 0px 0px 0px;
         }\n";
      } else {
         if( $news_event_box_shadow['type'] == 'outset') $news_event_box_shadow['type'] = '';
         $box_shadow_value = esc_html( $news_event_box_shadow['type'] ) ." ".esc_html( $news_event_box_shadow['hoffset'] ).  "px ". esc_html( $news_event_box_shadow['voffset'] ). "px ".esc_html( $news_event_box_shadow['blur'] ).  "px ".esc_html( $news_event_box_shadow['spread'] ).  "px ".news_event_get_color_format( $news_event_box_shadow['color'] );
         echo $selector."{ box-shadow : " . $box_shadow_value . "; -webkit-box-shadow: ". $box_shadow_value ."; -moz-box-shadow: " . $box_shadow_value . " }\n";
      }
   }
endif;

// Value change with responsive
if( ! function_exists( 'news_event_value_change_responsive' ) ) :
   /**
   * Generate css code for variable change with responsive
   *
   * @package News Event
   * @since 1.0.0 
   */
   function news_event_value_change_responsive ( $selector, $control, $property, $is_negative = false ) {
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! $decoded_control ) return;
      $minus = ( $is_negative ? '-' : '' );
      if( isset( $decoded_control['desktop'] ) ) :
         $desktop = $decoded_control['desktop'];
         echo $selector . "{ " . esc_html( $property ). ": ".esc_html( $minus . $desktop ).  "px; }";
      endif;

      if( isset( $decoded_control['tablet'] ) ) :
         $tablet = $decoded_control['tablet'];
         echo "@media(max-width: 940px) { " .$selector . "{ " . esc_html( $minus . $property ). ": ".esc_html( $tablet ).  "px; } }\n";
      endif;
      
      if( isset( $decoded_control['smartphone'] ) ) :
         $smartphone = $decoded_control['smartphone'];
         echo "@media(max-width: 610px) { " .$selector . "{ " . esc_html( $minus . $property ). ": ".esc_html($smartphone).  "px; } }\n";
   endif;
   }
endif;

// spacing control
if( ! function_exists( 'news_event_spacing_control' ) ) :
   /**
    * Generate css code for variable change with responsive for spacing controls
    *
    * @package News Event
    * @since 1.0.0
    */
    function news_event_spacing_control( $selector, $control, $property ) {
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! $decoded_control ) return;
      if( isset( $decoded_control['desktop'] ) ) :
         $desktop = $decoded_control['desktop'];
         echo $selector . '{ '. esc_html( $property ) .' : '. esc_html( $desktop['top'] ) .'px '. esc_html( $desktop['right'] ) .'px '. esc_html( $desktop['bottom'] ) .'px '. esc_html( $desktop['left'] ) .'px }';
      endif;

      if( isset( $decoded_control['tablet'] ) ) :
         $tablet = $decoded_control['tablet'];
         echo '@media(max-width: 940px) {' .$selector . '{ '. esc_html( $property ) .' : '. esc_html( $tablet['top'] ) .'px '. esc_html( $tablet['right'] ) .'px '. esc_html( $tablet['bottom'] ) .'px '. esc_html( $tablet['left'] ) .'px } }';
      endif;

      if( isset( $decoded_control['smartphone'] ) ) :
         $smartphone = $decoded_control['smartphone'];
         echo '@media(max-width: 610px) { ' . $selector . '{ '. esc_html( $property ) .' : '. esc_html( $smartphone['top'] ) .'px '. esc_html( $smartphone['right'] ) .'px '. esc_html( $smartphone['bottom'] ) .'px '. esc_html( $smartphone['left'] ) .'px } }';
      endif;
    }
endif;

// preset colors
if( ! function_exists( 'news_event_preset_color_styles' ) ) :
   /**
    * Generate css code for preset colors
    *
    * @since 1.0.0
    */
    function news_event_preset_color_styles( $control, $variable ) {
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( ! empty( $decoded_control ) && is_array( $decoded_control ) ) :
         echo 'body.news-event-variables{';
         foreach( $decoded_control as $index => $color ) :
            $count = ( $index + 1 );
            echo $variable . $count . ": ". news_event_get_color_format( $color ).  ";";
         endforeach;
         echo '}';
      endif;
    }
endif;

if( ! function_exists( 'news_event_color_css' ) ) :
   /**
    * Generate Css for color controls
    * 
    * @since 1.0.0
    */
    function news_event_color_css( $control, $selector, $property = '' ){
      $decoded_control = NEV\news_event_get_customizer_option( $control );
      if( $decoded_control === NEV\news_event_get_customizer_default( $control ) ) return;
      if( array_key_exists( 'initial', $decoded_control ) ) :
         $initial = $decoded_control[ 'initial' ]; $initial_color = news_event_get_color_format( $initial[ $initial[ 'type' ] ] );
         $hover = $decoded_control[ 'hover' ]; $hover_color = news_event_get_color_format( $hover[ $hover[ 'type' ] ] );
         echo "$selector {\n $property: $initial_color;\n $property-hover: $hover_color;\n}";
         return;
      endif;

      $type_key_exists = array_key_exists( 'type', $decoded_control );
      if( $type_key_exists && $decoded_control[ 'type' ] !== 'image' ):
         $color = $decoded_control[ $decoded_control[ 'type' ] ];
         $new_color = news_event_get_color_format( $color );
         echo "$selector {\n $property: $new_color;\n }";
         return;
      endif;

      if( $type_key_exists && $decoded_control[ 'type' ] === 'image' ):
         $image = $decoded_control[ 'image' ];
         echo $selector, " { \n";
         if( isset( $image[ 'url' ] ) ) echo "background-image: url(", esc_url( $image[ 'url' ] ), ");\n";
         if( isset( $decoded_control['repeat'] ) ) echo "background-repeat: ", esc_html( $decoded_control['repeat'] ), ";\n";
         if( isset( $decoded_control['position'] ) ) echo "background-position:", esc_html( $decoded_control['position'] ), ";\n";
         if( isset( $decoded_control['attachment'] ) ) echo "background-attachment: ", esc_html( $decoded_control['attachment'] ), ";\n";
         if( isset( $decoded_control['size'] ) ) echo "background-size: ", esc_html( $decoded_control['size'] ), ";\n";
         echo '}';
         return;
      endif;
    }
endif;