<?php
/**
 * Adds post meta fields in the post, page and custom post types
 * 
 * @package News Event
 * @since 1.0.0
 * 
 */
if ( ! function_exists( 'news_event_post_metaboxes' ) ) :
    /**
     * Add post metabox
     *
     * @since 1.0.0
     */
    function news_event_post_metaboxes() {
        add_meta_box(
            'news_event_post_meta',
            esc_html__( 'Meta Settings', 'news-event' ),
            'news_event_post_meta_callback',
            array( 'page', 'post' ),
            'normal',
            'default'
        );
    }
    add_action( 'add_meta_boxes', 'news_event_post_metaboxes', 10, 2 );
endif;

function news_event_post_meta_callback( $post ) {
    // sidebar option
    $meta_sidebar_options = [
        'customizer-setting'    => array(
            'label' => esc_html__( 'Customizer Setting', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/customizer-setting.jpg'
        ),
        'no-sidebar' => array(
            'label' => esc_html__( 'No Sidebar', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/no_sidebar.jpg'
        ),
        'left-sidebar' => array(
            'label' => esc_html__( 'Left Sidebar', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/left_sidebar.jpg'
        ),
        'right-sidebar' => array(
            'label' => esc_html__( 'Right Sidebar', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/right_sidebar.jpg'
        ),
        'both-sidebar' => array(
            'label' => esc_html__( 'Both Sidebar', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/both_sidebar.jpg'
        ),
        'left-both-sidebar' => array(
            'label' => esc_html__( 'Both Sidebar', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/left_both_sidebar.jpg'
        ),
        'right-both-sidebar' => array(
            'label' => esc_html__( 'Both Sidebar', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/right_both_sidebar.jpg'
        )
    ];

    // width layouts option
    $meta_width_layouts_options = [
        'customizer-setting'    => array(
            'label' => esc_html__( 'Customizer Setting', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/customizer-setting.jpg'
        ),
        'boxed--layout' => array(
            'label' => esc_html__( 'Boxed', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/boxed_content.jpg'
        ),
        'full-width--layout' => array(
            'label' => esc_html__( 'Full Width', 'news-event' ),
            'url'   => get_template_directory_uri() . '/assets/images/customizer/full_content.jpg'
        )
    ];

    // default value set for post sidebar layout.
    if( !metadata_exists( 'post', $post->ID, 'post_sidebar_layout' ) ) {
        // add post sidebar layout value "custmomizer-setting".
        update_post_meta( $post->ID, 'post_sidebar_layout', 'customizer-setting' );
    }
    $post_sidebar_layout = get_post_meta( $post->ID, 'post_sidebar_layout', true );
    $post_sidebar_layout = ( $post_sidebar_layout ) ? $post_sidebar_layout : 'customizer-setting';

    // default value set for post width layout.
    if( !metadata_exists( 'post', $post->ID, 'post_width_layout' ) ) {
        // add post width layout value "custmomizer-setting".
        update_post_meta( $post->ID, 'post_width_layout', 'customizer-setting' );
    }
    $post_width_layout = get_post_meta( $post->ID, 'post_width_layout', true );
    $post_width_layout = ( $post_width_layout ) ? $post_width_layout : 'customizer-setting';
    
    // Create our nonce field.
    wp_nonce_field( basename( __FILE__ ) , 'news_event_post_meta_nonce' );
    ?>
        <div id="news-event-post-metabox">
            <div class="single-meta-field radio-image-field">
                <label for="post_sidebar_layout"><?php esc_html_e( 'Sidebar Layout Settings', 'news-event' ); ?></label>
                <p class="meta-description"><?php esc_html_e( 'Choose sidebar layout for this post', 'news-event' ); ?></p>
                <div class="radio-image-fields-wrap">
                    <?php
                        foreach( $meta_sidebar_options as $key => $value ) :
                        ?>
                            <div class="radio-field <?php if( $post_sidebar_layout === $key ) echo 'selected'; ?>" data-value="<?php echo esc_attr( $key ); ?>"><img src="<?php echo esc_url( $value['url'] ); ?>" alt="<?php echo esc_attr( $value['label'] ); ?>"></div>
                    <?php
                        endforeach;
                    ?>
                </div>
                <input type="hidden" name="post_sidebar_layout" value="<?php echo esc_attr($post_sidebar_layout); ?>">
            </div><!-- .single-meta-field -->
            <div class="single-meta-field radio-image-field">
                <label for="post_width_layout"><?php esc_html_e( 'Width Layout Settings', 'news-event' ); ?></label>
                <p class="meta-description"><?php esc_html_e( 'Choose width layout for this post', 'news-event' ); ?></p>
                <div class="radio-image-fields-wrap">
                    <?php
                        foreach( $meta_width_layouts_options as $key => $value ) :
                    ?>
                            <div class="radio-field <?php if( $post_width_layout === $key ) echo 'selected'; ?>" data-value="<?php echo esc_attr( $key ); ?>"><img src="<?php echo esc_url( $value['url'] ); ?>" alt="<?php echo esc_attr( $value['label'] ); ?>"></div>
                    <?php
                        endforeach;
                    ?>
                </div>
                <input type="hidden" name="post_width_layout" value="<?php echo esc_attr($post_width_layout); ?>">
            </div><!-- .single-meta-field -->
        </div>
    <?php
}

function news_event_save_post_meta( $post_id ) {
    // Verify the nonce before proceeding.
    $news_event_post_meta_nonce   = isset( $_POST['news_event_post_meta_nonce'] ) ? $_POST['news_event_post_meta_nonce'] : '';
    $news_event_post_meta_nonce_action = basename( __FILE__ );

    //* Check if nonce is set...
    if ( ! isset( $news_event_post_meta_nonce ) ) {
        return;
    }

    //* Check if nonce is valid...
    if ( ! wp_verify_nonce( $news_event_post_meta_nonce, $news_event_post_meta_nonce_action ) ) {
        return;
    }

    //* Check if user has permissions to save data...
    if ( ! current_user_can( 'edit_page', $post_id ) ) {
        return;
    }

    // Check auto save
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    //* Check if not a revision...
    if ( wp_is_post_revision( $post_id ) ) {
        return;
    }

    if( isset( $_POST['post_sidebar_layout'] ) ) {
        update_post_meta( $post_id, 'post_sidebar_layout', sanitize_text_field( $_POST['post_sidebar_layout'] ) );
    }

    if( isset( $_POST['post_width_layout'] ) ) {
        update_post_meta( $post_id, 'post_width_layout', sanitize_text_field( $_POST['post_width_layout'] ) );
    }
}
add_action( 'save_post', 'news_event_save_post_meta' );

function news_event_save_attchment_meta( $post_id ) {
    // Verify the nonce before proceeding.
    $news_event_post_meta_nonce   = isset( $_POST['news_event_post_meta_nonce'] ) ? $_POST['news_event_post_meta_nonce'] : '';
    $news_event_post_meta_nonce_action = basename( __FILE__ );

    //* Check if nonce is set...
    if ( ! isset( $news_event_post_meta_nonce ) ) {
        return;
    }

    //* Check if nonce is valid...
    if ( ! wp_verify_nonce( $news_event_post_meta_nonce, $news_event_post_meta_nonce_action ) ) {
        return;
    }

    //* Check if user has permissions to save data...
    if ( ! current_user_can( 'edit_page', $post_id ) ) {
        return;
    }

    // Check auto save
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    //* Check if not a revision...
    if ( wp_is_post_revision( $post_id ) ) {
        return;
    }
}
add_action( 'edit_attachment', 'news_event_save_attchment_meta' );