<?php
/**
 * Top Header hooks and functions
 * 
 * @package News Event
 * @since 1.0.0
 */
use NewsEvent\CustomizerDefault as NEV;
   if( ! function_exists( 'news_event_top_header_date_time_part' ) ) :
      /**
       * Top header menu element
      * 
      * @since 1.0.0
      */
      function news_event_top_header_date_time_part() {
         if( ! NEV\news_event_get_customizer_option( 'top_header_date_time_option' ) ) return;
         ?>
            <div class="top-date-time">
               <div class="top-date-time-inner">
                  <span class="time"></span>
                  <span class="date"><?php echo date_i18n(get_option('date_format'), current_time('timestamp')); ?></span>
               </div>
            </div>
         <?php
      }
      add_action( 'news_event_top_header_hook', 'news_event_top_header_date_time_part', 10 );
   endif;

  if( ! function_exists( 'news_event_top_header_menu_part' ) ) :
   /**
    * Top header menu element
    * 
    * @since 1.0.0
    */
   function news_event_top_header_menu_part() {
     if( ! NEV\news_event_get_customizer_option( 'top_header_menu_option' ) ) return;
     ?>
        <div class="top-nav-menu">
            <?php
               wp_nav_menu(
                     array(
                        'theme_location' => 'menu-1',
                        'menu_id'        => 'top-menu',
                        'depth'  => 1
                     )
               );
            ?>
        </div>
     <?php
   }
   add_action( 'news_event_top_header_hook', 'news_event_top_header_menu_part', 10 );
endif;

 if( ! function_exists( 'news_event_top_header_social_part' ) ) :
   /**
    * Top header social element
    * 
    * @since 1.0.0
    */
   function news_event_top_header_social_part() {
     if( ! NEV\news_event_get_customizer_option( 'top_header_social_option' ) ) return;
     $elementClass = 'social-icons-wrap';
     ?>
        <div class="<?php echo esc_html( $elementClass ); ?>">
           <?php news_event_customizer_social_icons(); ?>
        </div>
     <?php
   }
   if( NEV\news_event_get_customizer_option( 'header_layout' ) === 'two' || NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) { 
      add_action( 'news_event_top_header_hook', 'news_event_top_header_social_part', 15 );
   }
endif;

if( ! function_exists( 'news_event_top_header_newsletter_part' ) && NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) :
   /**
    * Header newsletter element
    * 
    * @since 1.0.0
    */
    function news_event_top_header_newsletter_part() {
       if( ! NEV\news_event_get_customizer_option( 'header_newsletter_option' ) ) return;
       $newsletter_label = NEV\news_event_get_customizer_option( 'newsletter_label' );
       $header_newsletter_redirect_href_target = NEV\news_event_get_customizer_option( 'header_newsletter_redirect_href_target' );
       $header_newsletter_redirect_href_link = NEV\news_event_get_customizer_option( 'header_newsletter_redirect_href_link' );
        $elementClass = 'newsletter-element';
       ?>
           <div class="<?php echo esc_html( $elementClass ); ?>" <?php if( isset( $newsletter_label ) && !empty( $newsletter_label ) ) echo 'title="' . esc_attr( $newsletter_label ) . '"'; ?>>
               <a href="<?php echo esc_url( $header_newsletter_redirect_href_link ); ?>" target="<?php echo esc_attr( $header_newsletter_redirect_href_target ); ?>" >
                  <span class="title-icon"><i class="fa-solid fa-bell"></i></span>
                   <?php
                       if( isset( $newsletter_label ) && !empty( isset( $newsletter_label ) ) ) echo '<span class="title-text">' .esc_html( $newsletter_label ). '</span>';
                   ?>
               </a>
           </div><!-- .newsletter-element -->
       <?php
    }
    add_action( 'news_event_top_header_hook', 'news_event_top_header_newsletter_part', 20 );
endif;

if( ! function_exists( 'news_event_top_header_random_news_part' ) && NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) :
   /**
    * Header random news element
    * 
    * @since 1.0.0
    */
    function news_event_top_header_random_news_part() {
       if( ! NEV\news_event_get_customizer_option( 'header_random_news_option' ) ) return;
       $header_random_news_redirect_href_target = NEV\news_event_get_customizer_option( 'header_random_news_redirect_href_target' );
       $button_url = news_event_get_random_news_url();
       ?>
           <div class="random-news-element" title="<?php echo esc_attr__( 'Random News', 'news-event' ); ?>">
               <a href="<?php echo esc_url($button_url); ?>" target="<?php echo esc_attr( $header_random_news_redirect_href_target ); ?>">
                  <span class="title-icon"><i class="fas fa-random'"></i></span>
                  <span class="title-text"><?php echo esc_html__( 'Random News', 'news-event' ); ?></span>
               </a>
           </div><!-- .random-news-element -->
       <?php
    }
    add_action( 'news_event_top_header_hook', 'news_event_top_header_random_news_part', 20 );
endif;

add_action( 'news_event_top_header_hook', function() {
   if( ! NEV\news_event_get_customizer_option( 'header_newsletter_option' ) && ! NEV\news_event_get_customizer_option( 'header_random_news_option' ) ) return;
   $header_layout = NEV\news_event_get_customizer_option( 'header_layout' );
   if( in_array( $header_layout, [ 'one', 'two' ] ) ) return;
   echo '<div class="top-header-nrn-button-wrap">';
}, 18 ); // newsletter wrapper open
add_action( 'news_event_top_header_hook', function() {
   if( ! NEV\news_event_get_customizer_option( 'header_newsletter_option' ) && ! NEV\news_event_get_customizer_option( 'header_random_news_option' ) ) return;
   $header_layout = NEV\news_event_get_customizer_option( 'header_layout' );
   if( in_array( $header_layout, [ 'one', 'two' ] ) ) return;
   echo '</div><!-- .top-header-nrn-button-wrap -->';
}, 22 ); // newsletter wrapper end