<?php
/**
 * Header hooks and functions
 * 
 * @package News Event
 * @since 1.0.0
 */
use NewsEvent\CustomizerDefault as NEV;

if( ! function_exists( 'news_event_header_social_part' ) ) :
    /**
     * header social element
     * 
     * @since 1.0.0
     */
    function news_event_header_social_part() {
        if( NEV\news_event_get_customizer_option( 'header_layout' ) !== 'one' ) return;
        $elementClass = 'social-icons-wrap';
        ?>
            <div class="<?php echo esc_html( $elementClass ); ?>">
                <?php if( NEV\news_event_get_customizer_option( 'top_header_social_option' ) ) news_event_customizer_social_icons(); ?>
            </div>
        <?php
    }
    add_action( 'news_event_header__site_branding_section_hook', 'news_event_header_social_part', 5 );
 endif;

 if( ! function_exists( 'news_event_header_site_branding_part' ) ) :
    /**
     * Header site branding element
     * 
     * @since 1.0.0
     */
     function news_event_header_site_branding_part() {
         ?>
            <div class="site-branding">
                <?php

                    the_custom_logo();
                    if ( is_front_page() && is_home() ) :
                ?>
                        <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                <?php
                    else :
                ?>
                        <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                <?php
                    endif;
                    $news_event_description = get_bloginfo( 'description', 'display' );
                    if ( $news_event_description || is_customize_preview() ) :
                ?>
                    <p class="site-description"><?php echo $news_event_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
                <?php endif; ?>
            </div><!-- .site-branding -->
         <?php
     }
    add_action( 'news_event_header__site_branding_section_hook', 'news_event_header_site_branding_part', 10 );
 endif;

 if( ! function_exists( 'news_event_header_ads_banner_part' ) ) :
    /**
     * Header ads banner element
     * 
     * @since 1.0.0
     */
     function news_event_header_ads_banner_part() {
        if( ! NEV\news_event_get_customizer_option( 'header_ads_banner_responsive_option' ) ) return;
        $header_ads_banner_type = NEV\news_event_get_customizer_option( 'header_ads_banner_type' );
        if( $header_ads_banner_type == 'none' ) return;
        $header_ads_banner_custom_image = NEV\news_event_get_customizer_option( 'header_ads_banner_custom_image' );
        $header_ads_banner_custom_url = NEV\news_event_get_customizer_option( 'header_ads_banner_custom_url' );
        $header_ads_banner_custom_target = NEV\news_event_get_customizer_option( 'header_ads_banner_custom_target' );
        if( ! empty( $header_ads_banner_custom_image ) ) :
        ?>
            <div class="ads-banner">
                <a href="<?php echo esc_url( $header_ads_banner_custom_url ); ?>" target="<?php echo esc_html( $header_ads_banner_custom_target ); ?>"><img src="<?php echo wp_get_attachment_url( $header_ads_banner_custom_image ); ?>"></a>
            </div><!-- .ads-banner -->
        <?php
        endif;
     }
    if( NEV\news_event_get_customizer_option( 'header_layout' ) === 'two' ) { 
        add_action( 'news_event_header__site_branding_section_hook', 'news_event_header_ads_banner_part', 20 );
    } else {
        add_action( 'news_event_after_header_hook', 'news_event_header_ads_banner_part', 10 );
    }
 endif;

 if( ! function_exists( 'news_event_header_newsletter_part' ) ) :
    /**
     * Header newsletter element
     * 
     * @since 1.0.0
     */
     function news_event_header_newsletter_part() {
        if( ! NEV\news_event_get_customizer_option( 'header_newsletter_option' ) || NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) return;
        $newsletter_label = NEV\news_event_get_customizer_option( 'newsletter_label' );
        $header_newsletter_redirect_href_target = NEV\news_event_get_customizer_option( 'header_newsletter_redirect_href_target' );
        $header_newsletter_redirect_href_link = NEV\news_event_get_customizer_option( 'header_newsletter_redirect_href_link' );
        $elementClass = 'newsletter-element';
        ?>
            <div class="<?php echo esc_html( $elementClass ); ?>" <?php if( isset($newsletter_label) && !empty($newsletter_label) ) echo 'title="' . esc_attr( $newsletter_label ) . '"'; ?>>
                <a href="<?php echo esc_url( $header_newsletter_redirect_href_link ); ?>" target="<?php echo esc_attr( $header_newsletter_redirect_href_target ); ?>">
                    <span class="title-icon"><i class="fa-solid fa-bell"></i></span>
                    <?php
                        if( isset( $newsletter_label ) && !empty( isset( $newsletter_label ) ) ) echo '<span class="title-text">' .esc_html( $newsletter_label ). '</span>';
                    ?>
                </a>
            </div><!-- .newsletter-element -->
        <?php
     }
    if( NEV\news_event_get_customizer_option( 'header_layout' ) === 'one' ) {
        add_action( 'news_event_header__site_branding_section_hook', function() {
            if( ! NEV\news_event_get_customizer_option( 'header_newsletter_option' ) && ! NEV\news_event_get_customizer_option( 'header_random_news_option' ) ) return;
            echo '<div class="header-right-button-wrap">';
        }, 29 );
        add_action( 'news_event_header__site_branding_section_hook', 'news_event_header_newsletter_part', 30 );
    } else {
        add_action( 'news_event_header__menu_section_hook', 'news_event_header_newsletter_part', 45 );
    }
 endif;

 if( ! function_exists( 'news_event_header_random_news_part' ) ) :
    /**
     * Header random news element
     * 
     * @since 1.0.0
     */
     function news_event_header_random_news_part() {
        if( ! NEV\news_event_get_customizer_option( 'header_random_news_option' ) || NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) return;
        $header_random_news_redirect_href_target = NEV\news_event_get_customizer_option( 'header_random_news_redirect_href_target' );
        $button_url = news_event_get_random_news_url();
        ?>
            <div class="random-news-element" title="<?php echo esc_attr__( 'Random News', 'news-event' ); ?>">
                <a href="<?php echo esc_url($button_url); ?>" target="<?php echo esc_attr( $header_random_news_redirect_href_target ); ?>">
                    <span class="title-icon"><i class="fas fa-random"></i></span>
                    <span class="title-text"><?php echo esc_html__( 'Random News', 'news-event' ); ?></span>
                </a>
            </div><!-- .random-news-element -->
        <?php
     }
    if( NEV\news_event_get_customizer_option( 'header_layout' ) === 'one' ) { 
        add_action( 'news_event_header__site_branding_section_hook', 'news_event_header_random_news_part', 30 );
        add_action( 'news_event_header__site_branding_section_hook', function() {
            if( ! NEV\news_event_get_customizer_option( 'header_newsletter_option' ) && ! NEV\news_event_get_customizer_option( 'header_random_news_option' ) ) return;
            echo '</div><!-- .header-right-button-wrap -->';
        }, 31 );
    } else {
        add_action( 'news_event_header__menu_section_hook', 'news_event_header_random_news_part', 45 );
    }
 endif;

 if( ! function_exists( 'news_event_header_sidebar_toggle_part' ) ) :
    /**
     * Header off canvas element
     * 
     * @since 1.0.0
     */
     function news_event_header_sidebar_toggle_part() {
         if( ! NEV\news_event_get_customizer_option( 'header_off_canvas_option' ) ) return;
         ?>
            <div class="sidebar-toggle-wrap">
                <a class="off-canvas-trigger" href="javascript:void(0);">
                    <div class="news_event_sidetoggle_menu_burger">
                      <span></span>
                      <span></span>
                      <span></span>
                  </div>
                </a>
                <div class="sidebar-toggle hide">
                <span class="off-canvas-close"><i class="fas fa-times"></i></span>
                  <div class="news-event-container">
                    <div class="row">
                      <?php dynamic_sidebar( 'off-canvas-sidebar' ); ?>
                    </div>
                  </div>
                </div>
            </div>
         <?php
     }
     if( NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) {
        add_action( 'news_event_header__site_branding_section_hook', 'news_event_header_sidebar_toggle_part', 100 );
     } else {
        add_action( 'news_event_header__menu_section_hook', 'news_event_header_sidebar_toggle_part', ( ( NEV\news_event_get_customizer_option( 'header_layout' ) == 'one' ) ? 20 : 30 ) );
     }
 endif;

 if( ! function_exists( 'news_event_header_menu_part' ) ) :
    /**
     * Header menu element
     * 
     * @since 1.0.0
     */
    function news_event_header_menu_part() {
      ?>
        <nav id="site-navigation" class="main-navigation <?php echo esc_attr( 'hover-effect--' . NEV\news_event_get_customizer_option( 'header_menu_hover_effect' ) ); ?>">
            <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                <div id="news_event_menu_burger">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <span class="menu_txt"><?php esc_html_e( 'Menu', 'news-event' ); ?></span></button>
            <?php
                wp_nav_menu(
                    array(
                        'theme_location' => 'menu-2',
                        'menu_id'        => 'header-menu',
                    )
                );
            ?>
        </nav><!-- #site-navigation -->
      <?php
    }
    if( NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) {
        add_action( 'news_event_header__site_branding_section_hook', 'news_event_header_menu_part', 50 );
    } else {
        add_action( 'news_event_header__menu_section_hook', 'news_event_header_menu_part', ( ( NEV\news_event_get_customizer_option( 'header_layout' ) == 'one' ) ? 30 : 40 ) );
    }
 endif;

 if( ! function_exists( 'news_event_header_search_part' ) ) :
   /**
    * Header search element
    * 
    * @since 1.0.0
    */
    function news_event_header_search_part() {
        if( ! NEV\news_event_get_customizer_option( 'header_search_option' ) ) return;
        ?>
            <div class="search-wrap">
                <button class="search-trigger">
                    <i class="fas fa-search"></i>
                </button>
                <div class="search-form-wrap hide">
                    <?php echo get_search_form(); ?>
                </div>
                <div class="search_close_btn hide"><i class="fas fa-times"></i></div>
            </div>
        <?php
    }
    if( NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) {
        add_action( 'news_event_header__site_branding_section_hook', 'news_event_header_search_part', 60 );
    } else {
        add_action( 'news_event_header__menu_section_hook', 'news_event_header_search_part', 50 );
    }
endif;


if( NEV\news_event_get_customizer_option( 'header_layout' ) === 'three' ) {
    add_action( 'news_event_header__site_branding_section_hook', function() {
        echo '<div class="header-smh-button-wrap menu-section">';
    }, 45 ); // search wrapper open
    add_action( 'news_event_header__site_branding_section_hook', function() {
        echo '</div><!-- .header-smh-button-wrap -->';
    }, 120 ); // search wrapper end
}

 if( ! function_exists( 'news_event_ticker_news_part' ) ) :
    /**
     * Ticker news element
     * 
     * @since 1.0.0
     */
     function news_event_ticker_news_part() {
        $ticker_news_visible = NEV\news_event_get_customizer_option( 'ticker_news_visible' );
        if( $ticker_news_visible === 'none' ) return;
        if( $ticker_news_visible === 'front-page' && ! is_front_page() ) {
            return;
        } else if( $ticker_news_visible === 'innerpages' && is_front_page()  ) {
            return;
        }
        $ticker_news_title = NEV\news_event_get_customizer_option( 'ticker_news_title' );
        $ticker_news_order_by = NEV\news_event_get_customizer_option( 'ticker_news_order_by' );
        $ticker_news_posts = NEV\news_event_get_customizer_option( 'ticker_news_posts' );
        $ticker_news_categories = NEV\news_event_get_customizer_option( 'ticker_news_categories' );
        $ticker_news_date_filter = NEV\news_event_get_customizer_option( 'ticker_news_date_filter' );

        $orderArray = explode( '-', $ticker_news_order_by );
        $ticker_args = array(
            'order' => esc_html( $orderArray[1] ),
            'orderby' => esc_html( $orderArray[0] ),
            'ignore_sticky_posts'    => true,
            'fields'    =>  'ids'
        );
        $ticker_args['posts_per_page'] = 10;
        if( $ticker_news_date_filter != 'all' ) $ticker_args['date_query'] = news_event_get_date_format_array_args( $ticker_news_date_filter );
        if( $ticker_news_categories ) $ticker_args['cat'] = news_event_get_categories_for_args( $ticker_news_categories );
        if( $ticker_news_posts ) $ticker_args['post__in'] = news_event_get_post_id_for_args( $ticker_news_posts );

        $elementClass = 'ticker-news-wrap news-event-ticker layout--two';
        ?>
            <div class="<?php echo esc_attr( $elementClass ); ?>">

                <?php if( $ticker_news_title ) : ?>
                    <div class="ticker_label_title ticker-title news-event-ticker-label">
                        <span class="icon"></span>
                        <?php 
                            if( $ticker_news_title ) echo '<span class="ticker_label_title_string">', esc_html( $ticker_news_title ), '</span>';
                        ?>
                    </div>
                <?php endif; ?>

                <div class="news-event-ticker-box">
                    <?php
                        $news_event_direction = 'left';
                        $news_event_dir = 'ltr';
                        if( is_rtl() ){
                            $news_event_direction = 'right';
                            $news_event_dir = 'ltr';
                        }
                    ?>

                    <ul class="ticker-item-wrap" direction="<?php echo esc_attr($news_event_direction); ?>" dir="<?php echo esc_attr($news_event_dir); ?>">
                        <?php get_template_part( 'template-parts/ticker-news/template', 'two', $ticker_args ); ?>
                    </ul>
                </div>

                <div class="news-event-ticker-controls">
                    <button class="news-event-ticker-pause"><i class="fas fa-pause"></i></button>
                </div>

            </div>
        <?php
     }
    add_action( 'news_event_after_header_hook', 'news_event_ticker_news_part', 10 );
 endif;
