<?php
use NewsEvent\CustomizerDefault as NEV;
/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
add_action( 'customize_preview_init', function() {
    $enqueue_script_args = [ 'strategy' => 'defer', 'in_footer' => true ];
    wp_enqueue_script( 
        'news-event-customizer-preview',
        get_template_directory_uri() . '/inc/customizer/assets/customizer-preview.min.js',
        ['customize-preview'],
        NEWS_EVENT_VERSION,
        $enqueue_script_args
    );
    // localize scripts
	wp_localize_script( 
        'news-event-customizer-preview',
        'newsEventPreviewObject', array(
            'totalCats' => get_categories() ? get_categories([ 'fields' => 'ids' ]) : []
        )
    );
});

add_action( 'customize_controls_enqueue_scripts', function() {
    $enqueue_script_args = [ 'strategy' => 'defer', 'in_footer' => true ];
    $buildControlsDeps = apply_filters(  'news_event_customizer_build_controls_dependencies', array(
        'wp-element',
        'react',
        'wp-blocks',
        'wp-editor',
        'wp-i18n',
        'wp-polyfill',
        'jquery',
        'wp-components'
    ));
	wp_enqueue_style( 
        'news-event-customizer-control',
        get_template_directory_uri() . '/inc/customizer/assets/customizer-controls.min.css', 
        array('wp-components'),
        NEWS_EVENT_VERSION,
        'all'
    );
    wp_enqueue_script( 
        'news-event-customizer-control',
        get_template_directory_uri() . '/inc/customizer/assets/customizer-extends.min.js',
        $buildControlsDeps,
        NEWS_EVENT_VERSION,
        $enqueue_script_args
    );

    wp_enqueue_script( 
        'news-event-customizer-extras',
        get_template_directory_uri() . '/inc/customizer/assets/extras.min.js',
        [ 'jquery', 'customize-controls' ],
        NEWS_EVENT_VERSION,
        $enqueue_script_args
    );
    // localize scripts
    wp_localize_script( 
        'news-event-customizer-control', 
        'customizerControlsObject', array(
            'imageSizes'    => news_event_get_image_sizes_option_array(),
            'templateDirectoryUri'  =>  get_template_directory_uri(),
            'homeUrl'   =>  home_url()
        )
    );
    // localize scripts
    wp_localize_script( 
        'news-event-customizer-extras', 
        'customizerExtrasObject', array(
            '_wpnonce'	=> wp_create_nonce( 'news-event-customizer-controls-nonce' ),
            'ajaxUrl' => esc_url( admin_url( 'admin-ajax.php' ) ),
            'custom_callback'   =>  [],
            'custom'    =>  [
                'news_event_single_panel'   =>  news_event_wp_query( 'post' ),
                'news_event_page_section'   =>  news_event_wp_query( 'page' ),
                'news_event_blog_post_archive_panel'   =>  home_url() . '/',
                'news_event_404_section'   =>  home_url() . '/~~~hfieojfw',
                'news_event_search_page_section'  =>  home_url() . '?s=a',
            ],
        )
    );
});

if( ! function_exists( 'news_event_wp_query' ) ) :
    /**
     * Returns permalink
     * 
     * @param post_type
     * @since 1.0.0
     * @package Blogzee Pro
     */
    function news_event_wp_query( $type ) {
        $permalink = home_url();
        switch( $type ) :
            case ( in_array( $type, [ 'page', 'post' ] ) ):
                    $type_args = [
                        'post_type'	=>	$type,
                        'posts_per_page'	=>	1,
                        'orderby'	=>	'rand',
                        'fields'    =>  'ids'
                    ];
                    if( $type == 'search' ) $type_args['s'] = 'a';
                    $type_query = new \WP_Query( apply_filters( 'blogzee_query_args_filter', $type_args ) );
                    if( $type_query->have_posts() ) :
                        while( $type_query->have_posts() ):
                            $type_query->the_post();
                            $permalink = get_the_permalink();
                        endwhile;
                        wp_reset_postdata();
                    endif;
                    return $permalink;
                break;
            case ( in_array( $type, [ 'tag', 'category' ] ) ):
                    $nexus_collective = function( $args ){
                        return get_terms( $args );
                    };
                    $taxonomy = ( $type == 'category' ) ? 'category' : 'post_tag';
                    $total = count( $nexus_collective([ 'taxonomy'  =>  $taxonomy, 'number' => 0, 'fields'    =>  'ids' ]) );
                    $random_number = rand( 0, ( $total - 1 ) );
                    $taxonomy_args = [
                        'orderby'   =>  'rand',
                        'number'    =>  1,
                        'taxonomy'  =>  $taxonomy,
                        'offset'	=>	$random_number,
                        'fields'    =>  'ids'
                    ];
                    $get_taxonomies = $nexus_collective( $taxonomy_args );
                    if( ! empty( $get_taxonomies ) && is_array( $get_taxonomies ) ) :
                        foreach( $get_taxonomies as $taxonomy ) :
                            $permalink = get_term_link( $taxonomy );
                        endforeach;
                    endif;
                    return $permalink;
                break;
            case 'author':
                    $nexus_collective = function( $args ) {
                        return new \WP_User_Query( $args );
                    };
                    $total = $nexus_collective( [ 'number' => 0, 'fields'    =>  'ids' ] )->get_total();
                    $random_number = rand( 0, ( $total - 1 ) );
                    $author_args = [
                        'number'    =>  1,
                        'offset'    =>  $random_number
                    ];
                    $user_query = $nexus_collective( $author_args );
                    if ( ! empty( $user_query->get_results() ) ) :
                        foreach ( $user_query->get_results() as $user ) :
                            $permalink = get_author_posts_url( $user->data->ID );
                        endforeach;
                    endif;
                    wp_reset_postdata();
                    return $permalink;
                break;
        endswitch;
    }
endif;

if( !function_exists( 'news_event_customizer_about_theme_panel' ) ) :
    /**
     * Register blog archive section settings
     * 
     */
    function news_event_customizer_about_theme_panel( $wp_customize ) {
        /**
         * About theme section
         * 
         * @since 1.0.0
         */
        $wp_customize->add_section( NEWS_EVENT_PREFIX . 'about_section', array(
            'title' => esc_html__( 'About Theme', 'news-event' ),
            'priority'  => 1
        ));

        // theme documentation info box
        $wp_customize->add_setting( 'site_documentation_info', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Info_Box_Control( $wp_customize, 'site_documentation_info', array(
                'label'	      => esc_html__( 'Theme Documentation', 'news-event' ),
                'description' => esc_html__( 'We have well prepared documentation which includes overall instructions and recommendations that are required in this theme.', 'news-event' ),
                'section'     => NEWS_EVENT_PREFIX . 'about_section',
                'settings'    => 'site_documentation_info',
                'choices' => array(
                    array(
                        'label' => esc_html__( 'View Documentation', 'news-event' ),
                        'url'   => esc_url( '//doc.blazethemes.com/news-event' )
                    )
                )
            ))
        );

        // theme documentation info box
        $wp_customize->add_setting( 'site_support_info', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Info_Box_Control( $wp_customize, 'site_support_info', array(
                'label'	      => esc_html__( 'Theme Support', 'news-event' ),
                'description' => esc_html__( 'We provide 24/7 support regarding any theme issue. Our support team will help you to solve any kind of issue. Feel free to contact us.', 'news-event' ),
                'section'     => NEWS_EVENT_PREFIX . 'about_section',
                'settings'    => 'site_support_info',
                'choices' => array(
                    array(
                        'label' => esc_html__( 'Support Form', 'news-event' ),
                        'url'   => esc_url( '//blazethemes.com/support' )
                    )
                )
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_about_theme_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_global_panel' ) ) :
    /**
     * Register global options settings
     * 
     */
    function news_event_customizer_global_panel( $wp_customize ) {
        /**
         * Global panel
         * 
         * @package News Event
         * @since 1.0.0
         */
        $wp_customize->add_panel( 'news_event_global_panel', array(
            'title' => esc_html__( 'Global', 'news-event' ),
            'priority'  => 5
        ));

        // section- seo/misc settings section
        $wp_customize->add_section( 'news_event_seo_misc_section', array(
            'title' => esc_html__( 'SEO / Misc', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));

        // site schema ready option
        $wp_customize->add_setting( 'site_schema_ready', array(
            'default'   => NEV\news_event_get_customizer_default( 'site_schema_ready' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport'    => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Toggle_Control( $wp_customize, 'site_schema_ready', array(
                'label'	      => esc_html__( 'Make website schema ready', 'news-event' ),
                'section'     => 'news_event_seo_misc_section',
                'settings'    => 'site_schema_ready'
            ))
        );

        // site date to show
        $wp_customize->add_setting( 'site_date_to_show', array(
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'site_date_to_show' )
        ));
        $wp_customize->add_control( 'site_date_to_show', array(
            'type'      => 'select',
            'section'   => 'news_event_seo_misc_section',
            'label'     => esc_html__( 'Date to display', 'news-event' ),
            'description' => esc_html__( 'Whether to show date published or modified date.', 'news-event' ),
            'choices'   => array(
                'published'  => __( 'Published date', 'news-event' ),
                'modified'   => __( 'Modified date', 'news-event' )
            )
        ));

        // site date format
        $wp_customize->add_setting( 'site_date_format', array(
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'site_date_format' )
        ));
        $wp_customize->add_control( 'site_date_format', array(
            'type'      => 'select',
            'section'   => 'news_event_seo_misc_section',
            'label'     => esc_html__( 'Date format', 'news-event' ),
            'description' => esc_html__( 'Date format applied to single and archive pages.', 'news-event' ),
            'choices'   => array(
                'theme_format'  => __( 'Default by theme', 'news-event' ),
                'default'   => __( 'Wordpress default date', 'news-event' )
            )
        ));

        // solid preset
        $wp_customize->add_setting( 'solid_presets', array(
            'default'   => NEV\news_event_get_customizer_default( 'solid_presets' ),
            'sanitize_callback' => 'news_event_sanitize_array',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Preset_Colors_Control( $wp_customize, 'solid_presets', array(
                'label'	      => esc_html__( 'Solid Presets', 'news-event' ),
                'section'     => 'colors',
                'settings'    => 'solid_presets'
            ))
        );

        // gradient presets
        $wp_customize->add_setting( 'gradient_presets', array(
            'default'   => NEV\news_event_get_customizer_default( 'gradient_presets' ),
            'sanitize_callback' => 'news_event_sanitize_array',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Preset_Colors_Control( $wp_customize, 'gradient_presets', array(
                'label'	      => esc_html__( 'Gradient Presets', 'news-event' ),
                'section'     => 'colors',
                'settings'    => 'gradient_presets',
                'blend' =>  'gradient'
            ))
        );

        // section- category colors section
        $wp_customize->add_section( 'news_event_category_colors_section', array(
            'title' => esc_html__( 'Category Colors', 'news-event' ),
            'panel' => 'news_event_colors_panel',
            'priority'  => 40
        ));

        $totalCats = get_categories();
        if( $totalCats ) :
            foreach( $totalCats as $singleCat ) :
                $term_id = absint( $singleCat->term_id );
                // category colors control
                $wp_customize->add_setting( 'category_'. $term_id .'_color', array(
                    'default'   => NEV\news_event_get_customizer_default( 'category_'. $term_id .'_color' ),
                    'sanitize_callback' => 'news_event_sanitize_color_control',
                    'transport' =>  'postMessage'
                ));
                $wp_customize->add_control( 
                    new News_Event_WP_Color_Control( $wp_customize, 'category_'. $term_id .'_color', array(
                        'label'	      => esc_html( $singleCat->name ),
                        'section'     => 'news_event_category_colors_section',
                        'settings'    => 'category_'. $term_id .'_color',
                        'hover' =>  true,
                        'involve'   =>  [ 'solid', 'gradient' ]
                    ))
                );
            endforeach;
        endif;

        // section- preloader section
        $wp_customize->add_section( 'news_event_preloader_section', array(
            'title' => esc_html__( 'Preloader', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));
        
        // preloader option
        $wp_customize->add_setting( 'preloader_option', array(
            'default'   => NEV\news_event_get_customizer_default('preloader_option'),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'preloader_option', array(
                'label'	      => esc_html__( 'Enable site preloader', 'news-event' ),
                'section'     => 'news_event_preloader_section',
                'settings'    => 'preloader_option'
            ))
        );

        // post title animation effects 
        $wp_customize->add_setting( 'preloader_type', array(
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'preloader_type' ),
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 'preloader_type', array(
            'label'     => esc_html__( 'Preloader Type', 'news-event' ),
            'type'      => 'select',
            'section'   => 'news_event_preloader_section',
            'choices'   => array(
                '1' => __( 'One', 'news-event' ),
                '2' => __( 'Two', 'news-event' ),
                '3' => __( 'Three', 'news-event' )
            )
        ));

        // widget styles section
        $wp_customize->add_section( 'widget_styles_section', array(
            'title' => esc_html__( 'Widget Styles', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));

        // widget styles image settings heading
        $wp_customize->add_setting( 'widgets_styles_image_settings_heading', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'widgets_styles_image_settings_heading', array(
                'label'	      => esc_html__( 'Image Settings', 'news-event' ),
                'section'     => 'widget_styles_section',
                'settings'    => 'widgets_styles_image_settings_heading'
            ))
        );

        // widget styles image border
        $wp_customize->add_setting( 'widgets_styles_image_border', [
            'default'   =>  NEV\news_event_get_customizer_default( 'widgets_styles_image_border' ),
            'sanitize_callback' =>  'news_event_sanitize_array',
            'transport' =>  'postMessage'
        ]);

        $wp_customize->add_control(
            new News_Event_WP_Border_Control( $wp_customize, 'widgets_styles_image_border', [
                'label' =>  esc_html__( 'Border', 'news-event' ),
                'settings'  =>  'widgets_styles_image_border',
                'section'   =>  'widget_styles_section'
            ])
        );

        // // widget styles image border radius
        $wp_customize->add_setting( 'widgets_styles_image_border_radius', array(
            'default'   => NEV\news_event_get_customizer_default( 'widgets_styles_image_border_radius' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'widgets_styles_image_border_radius', array(
                'label'	      => esc_html__( 'Border Radius (px)', 'news-event' ),
                'section'     => 'widget_styles_section',
                'settings'    => 'widgets_styles_image_border_radius',
                'unit'        => 'px',
                'input_attrs' => array(
                    'max'         => 200,
                    'min'         => 0,
                    'step'        => 1,
                    'reset' => true
                )
            ))
        );

        // widget styles image box shadow
        $wp_customize->add_setting( 'widgets_styles_image_box_shadow', [
            'default'   => NEV\news_event_get_customizer_default( 'widgets_styles_image_box_shadow' ),
            'sanitize_callback' => 'news_event_sanitize_box_shadow_control',
            'transport' => 'postMessage'
        ]);
        $wp_customize->add_control( 
            new News_Event_WP_Box_Shadow_Control( $wp_customize, 'widgets_styles_image_box_shadow', [
                'label'	      => esc_html__( 'Box Shadow', 'news-event' ),
                'section'     => 'widget_styles_section',
                'settings'    => 'widgets_styles_image_box_shadow'
            ])
        );
        
        // section- website layout section
        $wp_customize->add_section( 'news_event_website_layout_section', array(
            'title' => esc_html__( 'Website Layout', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));
        
        // website layout heading
        $wp_customize->add_setting( 'website_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'website_layout_header', array(
                'label'	      => esc_html__( 'Website Layout', 'news-event' ),
                'section'     => 'news_event_website_layout_section',
                'settings'    => 'website_layout_header'
            ))
        );

        // website layout
        $wp_customize->add_setting( 'website_layout',
            array(
                'default'           => NEV\news_event_get_customizer_default( 'website_layout' ),
                'sanitize_callback' => 'news_event_sanitize_select_control',
                'transport' => 'postMessage'
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'website_layout',
            array(
                'section'  => 'news_event_website_layout_section',
                'choices'  => array(
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed-width.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full-width.jpg'
                    )
                )
            )
        ));

        // website content layout heading
        $wp_customize->add_setting( 'website_content_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'website_content_layout_header', array(
                'label'	      => esc_html__( 'Website Content Global Layout', 'news-event' ),
                'section'     => 'news_event_website_layout_section',
                'settings'    => 'website_content_layout_header'
            ))
        );

        // website content layout
        $wp_customize->add_setting( 'website_content_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'website_content_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'website_content_layout',
            array(
                'section'  => 'news_event_website_layout_section',
                'choices'  => array(
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // section- animation section
        $wp_customize->add_section( 'news_event_animation_section', array(
            'title' => esc_html__( 'Animation / Hover Effects', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));

        // post title animation effects 
        $wp_customize->add_setting( 'post_title_hover_effects', array(
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'post_title_hover_effects' ),
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 'post_title_hover_effects', array(
            'type'      => 'select',
            'section'   => 'news_event_animation_section',
            'label'     => esc_html__( 'Post title hover effects', 'news-event' ),
            'description' => esc_html__( 'Applied to post titles listed in archive pages.', 'news-event' ),
            'choices'   => array(
                'none'  => __( 'None', 'news-event' ),
                'one'   => __( 'Effect One', 'news-event' ),
                'two'   => __( 'Effect Two', 'news-event' )
            )
        ));

        // site image animation effects 
        $wp_customize->add_setting( 'site_image_hover_effects', array(
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'site_image_hover_effects' ),
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 'site_image_hover_effects', array(
            'type'      => 'select',
            'section'   => 'news_event_animation_section',
            'label'     => esc_html__( 'Image hover effects', 'news-event' ),
            'description' => esc_html__( 'Applied to post thumbanails listed in archive pages.', 'news-event' ),
            'choices'   => array(
                'none'  => __( 'None', 'news-event' ),
                'one'   => __( 'Effect One', 'news-event' ),
                'four'  => __( 'Effect Two', 'news-event' ),
            )
        ));

        // cursor animation effects
        $wp_customize->add_setting( 'cursor_animation', [
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'cursor_animation' )
        ]);
        $wp_customize->add_control( 'cursor_animation', [
            'type'      => 'select',
            'section'   => 'news_event_animation_section',
            'label'     => esc_html__( 'Cursor animation', 'news-event' ),
            'description' => esc_html__( 'Applied to mouse pointer.', 'news-event' ),
            'choices'   => [
                'none' => esc_html__( 'None', 'news-event' ),
                'one'  => esc_html__( 'Animation 1', 'news-event' )
            ]
        ]);

        // section- social icons section
        $wp_customize->add_section( 'news_event_social_icons_section', array(
            'title' => esc_html__( 'Social Icons', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));
        
        // social icons setting heading
        $wp_customize->add_setting( 'social_icons_settings_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'social_icons_settings_header', array(
                'label'	      => esc_html__( 'Social Icons Settings', 'news-event' ),
                'section'     => 'news_event_social_icons_section',
                'settings'    => 'social_icons_settings_header'
            ))
        );

        // social icons target attribute value
        $wp_customize->add_setting( 'social_icons_target', array(
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'social_icons_target' ),
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 'social_icons_target', array(
            'type'      => 'select',
            'section'   => 'news_event_social_icons_section',
            'label'     => esc_html__( 'Social Icon Link Open in', 'news-event' ),
            'description' => esc_html__( 'Sets the target attribute according to the value.', 'news-event' ),
            'choices'   => array(
                '_blank' => esc_html__( 'Open link in new tab', 'news-event' ),
                '_self'  => esc_html__( 'Open link in same tab', 'news-event' )
            )
        ));

        // social icons items
        $wp_customize->add_setting( 'social_icons', array(
            'default'   => NEV\news_event_get_customizer_default( 'social_icons' ),
            'sanitize_callback' => 'news_event_sanitize_repeater_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Custom_Repeater( $wp_customize, 'social_icons', array(
                'label'         => esc_html__( 'Social Icons', 'news-event' ),
                'description'   => esc_html__( 'Hold bar icon and drag vertically to re-order the icons', 'news-event' ),
                'section'       => 'news_event_social_icons_section',
                'settings'      => 'social_icons',
                'row_label'     => 'inherit-icon_class',
                'add_new_label' => esc_html__( 'Add New Icon', 'news-event' ),
                'fields'        => array(
                    'icon_class'   => array(
                        'type'          =>  'fontawesome-icon-picker',
                        'label'         =>  esc_html__( 'Social Icon', 'news-event' ),
                        'description'   =>  esc_html__( 'Select from dropdown.', 'news-event' ),
                        'default'       =>  esc_attr( 'fa-brands fa-instagram' ),
                        'families'      =>  'social'
                    ),
                    'icon_url'  => array(
                        'type'      => 'url',
                        'label'     => esc_html__( 'URL for icon', 'news-event' ),
                        'default'   => ''
                    ),
                    'item_option'             => 'show'
                )
            ))
        );

        // social icons enable title
        $wp_customize->add_setting( 'social_icons_enable_title', array(
            'default'   => NEV\news_event_get_customizer_default( 'social_icons_enable_title' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'social_icons_enable_title', array(
                'label'	      => esc_html__( 'Display Label', 'news-event' ),
                'section'     => 'news_event_social_icons_section'
            ))
        );

        // social icons enable title
        $wp_customize->add_setting( 'social_icons_columns', array(
            'default'   => NEV\news_event_get_customizer_default( 'social_icons_columns' ),
            'sanitize_callback' => 'absint'
        ));
        $wp_customize->add_control( 'social_icons_columns', array(
            'label'	      => esc_html__( 'Columns', 'news-event' ),
            'description'   =>  esc_html__( 'The effects of this field is only seen in widgets.', 'news-event' ),
            'section'     => 'news_event_social_icons_section',
            'type'  =>  'number',
            'input_attrs'   =>  [
                'min'   =>  1,
                'max'   =>  10
            ]
        ));

        // social icons background
        $wp_customize->add_setting( 'social_icons_border_radius', array(
            'default'   => NEV\news_event_get_customizer_default( 'social_icons_border_radius' ),
            'sanitize_callback' => 'absint',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 'social_icons_border_radius', array(
            'label'	      => esc_html__( 'Border Radius', 'news-event' ),
            'section'     => 'news_event_social_icons_section',
            'settings'    => 'social_icons_border_radius',
            'type'  =>  'number',
            'input_attrs'   =>  [
                'min'   =>  0,
                'max'   =>  100
            ]
        ));

        // section- buttons section
        $wp_customize->add_section( 'news_event_buttons_section', array(
            'title' => esc_html__( 'Buttons', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));

        // site title typo
        $wp_customize->add_setting( 'global_button_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'global_button_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'global_button_typo', array(
                'label'	      => esc_html__( 'Typography', 'news-event' ),
                'section'     => 'news_event_buttons_section',
                'settings'    => 'global_button_typo',
                'tab'   => 'design',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );

        // global button label
        $wp_customize->add_setting( 'global_button_label', [
            'default'   =>  NEV\news_event_get_customizer_default( 'global_button_label' ),
            'sanitize_callback' =>  'sanitize_text_field',
            'transport' => 'postMessage'
        ]);
        $wp_customize->add_control('global_button_label', [
            'label' =>  esc_html__( 'Button Label', 'news-event' ),
            'section'   =>  'news_event_buttons_section',
            'type'  =>  'text'
        ]);

        // section- sidebar options section
        $wp_customize->add_section( 'news_event_sidebar_options_section', array(
            'title' => esc_html__( 'Sidebar Options', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));

        // frontpage sidebar layout heading
        $wp_customize->add_setting( 'frontpage_sidebar_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'frontpage_sidebar_layout_header', array(
                'label'	      => esc_html__( 'Frontpage Sidebar Layouts', 'news-event' ),
                'section'     => 'news_event_sidebar_options_section',
                'settings'    => 'frontpage_sidebar_layout_header'
            ))
        );

        // frontpage sidebar layout
        $wp_customize->add_setting( 'frontpage_sidebar_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'frontpage_sidebar_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'frontpage_sidebar_layout',
            array(
                'section'  => 'news_event_sidebar_options_section',
                'choices'  => news_event_get_customizer_sidebar_array()
            )
        ));

        // frontpage sidebar sticky option
        $wp_customize->add_setting( 'frontpage_sidebar_sticky_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'frontpage_sidebar_sticky_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'frontpage_sidebar_sticky_option', array(
                'label'	      => esc_html__( 'Enable sidebar sticky', 'news-event' ),
                'section'     => 'news_event_sidebar_options_section',
                'settings'    => 'frontpage_sidebar_sticky_option'
            ))
        );

        // archive sidebar layouts heading
        $wp_customize->add_setting( 'archive_sidebar_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'archive_sidebar_layout_header', array(
                'label'	      => esc_html__( 'Archive Sidebar Layouts', 'news-event' ),
                'section'     => 'news_event_sidebar_options_section',
                'settings'    => 'archive_sidebar_layout_header'
            ))
        );

        // archive sidebar layout
        $wp_customize->add_setting( 'archive_sidebar_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'archive_sidebar_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'archive_sidebar_layout',
            array(
                'section'  => 'news_event_sidebar_options_section',
                'choices'  => news_event_get_customizer_sidebar_array()
            )
        ));

        // archive sidebar sticky option
        $wp_customize->add_setting( 'archive_sidebar_sticky_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'archive_sidebar_sticky_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'archive_sidebar_sticky_option', array(
                'label'	      => esc_html__( 'Enable sidebar sticky', 'news-event' ),
                'section'     => 'news_event_sidebar_options_section',
                'settings'    => 'archive_sidebar_sticky_option'
            ))
        );

        // single sidebar layouts heading
        $wp_customize->add_setting( 'single_sidebar_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'single_sidebar_layout_header', array(
                'label'	      => esc_html__( 'Post Sidebar Layouts', 'news-event' ),
                'section'     => 'news_event_sidebar_options_section',
                'settings'    => 'single_sidebar_layout_header'
            ))
        );

        // single sidebar layout
        $wp_customize->add_setting( 'single_sidebar_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'single_sidebar_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'single_sidebar_layout',
            array(
                'section'  => 'news_event_sidebar_options_section',
                'choices'  => news_event_get_customizer_sidebar_array()
            )
        ));

        // single sidebar sticky option
        $wp_customize->add_setting( 'single_sidebar_sticky_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_sidebar_sticky_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'single_sidebar_sticky_option', array(
                'label'	      => esc_html__( 'Enable sidebar sticky', 'news-event' ),
                'section'     => 'news_event_sidebar_options_section',
                'settings'    => 'single_sidebar_sticky_option'
            ))
        );

        // page sidebar layouts heading
        $wp_customize->add_setting( 'page_sidebar_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'page_sidebar_layout_header', array(
                'label'	      => esc_html__( 'Page Sidebar Layouts', 'news-event' ),
                'section'     => 'news_event_sidebar_options_section',
                'settings'    => 'page_sidebar_layout_header'
            ))
        );

        // page sidebar layout
        $wp_customize->add_setting( 'page_sidebar_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'page_sidebar_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'page_sidebar_layout',
            array(
                'section'  => 'news_event_sidebar_options_section',
                'choices'  => news_event_get_customizer_sidebar_array()
            )
        ));

        // page sidebar sticky option
        $wp_customize->add_setting( 'page_sidebar_sticky_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'page_sidebar_sticky_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'page_sidebar_sticky_option', array(
                'label'	      => esc_html__( 'Enable sidebar sticky', 'news-event' ),
                'section'     => 'news_event_sidebar_options_section',
                'settings'    => 'page_sidebar_sticky_option'
            ))
        );

        // section- breadcrumb options section
        $wp_customize->add_section( 'news_event_breadcrumb_options_section', array(
            'title' => esc_html__( 'Breadcrumb Options', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));

        // breadcrumb option
        $wp_customize->add_setting( 'site_breadcrumb_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'site_breadcrumb_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'site_breadcrumb_option', array(
                'label'	      => esc_html__( 'Show breadcrumb trails', 'news-event' ),
                'section'     => 'news_event_breadcrumb_options_section',
                'settings'    => 'site_breadcrumb_option'
            ))
        );

        // breadcrumb type 
        $wp_customize->add_setting( 'site_breadcrumb_type', array(
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'site_breadcrumb_type' )
        ));
        $wp_customize->add_control( 'site_breadcrumb_type', array(
            'type'      => 'select',
            'section'   => 'news_event_breadcrumb_options_section',
            'label'     => esc_html__( 'Breadcrumb type', 'news-event' ),
            'description' => esc_html__( 'If you use other than "default" one you will need to install and activate respective plugins Breadcrumb NavXT, Yoast SEO and Rank Math SEO', 'news-event' ),
            'choices'   => array(
                'default' => __( 'Default', 'news-event' ),
                'bcn'  => __( 'NavXT', 'news-event' ),
                'yoast'  => __( 'Yoast SEO', 'news-event' ),
                'rankmath'  => __( 'Rank Math', 'news-event' )
            )
        ));

        // section- scroll to top options
        $wp_customize->add_section( 'news_event_stt_options_section', array(
            'title' => esc_html__( 'Scroll To Top', 'news-event' ),
            'panel' => 'news_event_global_panel'
        ));

        // scroll to top section tab
        $wp_customize->add_setting( 'stt_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'stt_section_tab', array(
                'section'     => 'news_event_stt_options_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // Resposive vivibility option
        $wp_customize->add_setting( 'stt_responsive_option', array(
            'default' => NEV\news_event_get_customizer_default( 'stt_responsive_option' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_multiselect_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Responsive_Multiselect_Tab_Control( $wp_customize, 'stt_responsive_option', array(
                'label'	      => esc_html__( 'Scroll To Top Visibility', 'news-event' ),
                'section'     => 'news_event_stt_options_section',
                'settings'    => 'stt_responsive_option'
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_global_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_site_identity_panel' ) ) :
    /**
     * Register site identity settings
     * 
     */
    function news_event_customizer_site_identity_panel( $wp_customize ) {
        /**
         * Register "Site Identity Options" panel
         * 
         */
        $wp_customize->add_panel( 'news_event_site_identity_panel', array(
            'title' => esc_html__( 'Site Identity', 'news-event' ),
            'priority' => 5
        ));
        $wp_customize->get_section( 'title_tagline' )->panel = 'news_event_site_identity_panel'; // assing title tagline section to site identity panel
        $wp_customize->get_section( 'title_tagline' )->title = esc_html__( 'Logo & Site Icon', 'news-event' ); // modify site logo label

        /**
         * Site Title Section
         * 
         * panel - news_event_site_identity_panel
         */
        $wp_customize->add_section( 'news_event_site_title_section', array(
            'title' => esc_html__( 'Site Title & Tagline', 'news-event' ),
            'panel' => 'news_event_site_identity_panel',
            'priority'  => 30,
        ));
        $wp_customize->get_control( 'blogname' )->section = 'news_event_site_title_section';
        $wp_customize->get_control( 'display_header_text' )->section = 'news_event_site_title_section';
        $wp_customize->get_control( 'display_header_text' )->label = esc_html__( 'Display site title', 'news-event' );
        $wp_customize->get_control( 'blogdescription' )->section = 'news_event_site_title_section';
        
        // site logo width
        $wp_customize->add_setting( 'news_event_site_logo_width', array(
            'default'   => NEV\news_event_get_customizer_default( 'news_event_site_logo_width' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'news_event_site_logo_width', array(
                    'label'	      => esc_html__( 'Logo Width (px)', 'news-event' ),
                    'section'     => 'title_tagline',
                    'settings'    => 'news_event_site_logo_width',
                    'unit'        => 'px',
                    'input_attrs' => array(
                    'max'         => 400,
                    'min'         => 1,
                    'step'        => 1,
                    'reset' => true
                )
            ))
        );

        // site title section tab
        $wp_customize->add_setting( 'site_title_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'site_title_section_tab', array(
                'section'     => 'news_event_site_title_section',
                'priority'  => 1,
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // blog description option
        $wp_customize->add_setting( 'blogdescription_option', array(
            'default'        => true,
            'sanitize_callback' => 'sanitize_text_field',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 'blogdescription_option', array(
            'label'    => esc_html__( 'Display site description', 'news-event' ),
            'section'  => 'news_event_site_title_section',
            'type'     => 'checkbox',
            'priority' => 50
        ));

        $wp_customize->get_control( 'header_textcolor' )->section = 'news_event_site_title_section';
        $wp_customize->get_control( 'header_textcolor' )->priority = 60;
        $wp_customize->get_control( 'header_textcolor' )->label = esc_html__( 'Site Title Color', 'news-event' );

        // header text hover color
        $wp_customize->add_setting( 'site_title_hover_textcolor', array(
            'default' => NEV\news_event_get_customizer_default( 'site_title_hover_textcolor' ),
            'sanitize_callback' => 'sanitize_hex_color',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Default_Color_Control( $wp_customize, 'site_title_hover_textcolor', array(
                'label'      => esc_html__( 'Site Title Hover Color', 'news-event' ),
                'section'    => 'news_event_site_title_section',
                'settings'   => 'site_title_hover_textcolor',
                'priority'    => 70,
                'tab'   => 'design'
            ))
        );

        // site description color
        $wp_customize->add_setting( 'site_description_color', array(
            'default' => NEV\news_event_get_customizer_default( 'site_description_color' ),
            'sanitize_callback' => 'sanitize_hex_color',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Default_Color_Control( $wp_customize, 'site_description_color', array(
                'label'      => esc_html__( 'Site Description Color', 'news-event' ),
                'section'    => 'news_event_site_title_section',
                'settings'   => 'site_description_color',
                'priority'    => 70,
                'tab'   => 'design'
            ))
        );

        // site title typo
        $wp_customize->add_setting( 'site_title_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'site_title_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'site_title_typo', array(
                'label'	      => esc_html__( 'Site Title Typography', 'news-event' ),
                'section'     => 'news_event_site_title_section',
                'settings'    => 'site_title_typo',
                'tab'   => 'design',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );

        // site tagline typo
        $wp_customize->add_setting( 'site_tagline_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'site_tagline_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'site_tagline_typo', array(
                'label'	      => esc_html__( 'Site Tagline Typography', 'news-event' ),
                'section'     => 'news_event_site_title_section',
                'settings'    => 'site_tagline_typo',
                'tab'   => 'design',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_site_identity_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_top_header_panel' ) ) :
    /**
     * Register header options settings
     * 
     */
    function news_event_customizer_top_header_panel( $wp_customize ) {
        /**
         * Top header section
         * 
         */
        $wp_customize->add_section( 'news_event_top_header_section', array(
            'title' => esc_html__( 'Top Header', 'news-event' ),
            'priority'  => 68
        ));
        
        // section tab
        $wp_customize->add_setting( 'top_header_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'top_header_section_tab', array(
                'section'     => 'news_event_top_header_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );
        
        // Top header option
        $wp_customize->add_setting( 'top_header_option', array(
            'default'         => NEV\news_event_get_customizer_default( 'top_header_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
    
        $wp_customize->add_control( 
            new News_Event_WP_Toggle_Control( $wp_customize, 'top_header_option', array(
                'label'	      => esc_html__( 'Show top header', 'news-event' ),
                'description' => esc_html__( 'Toggle to enable or disable top header bar', 'news-event' ),
                'section'     => 'news_event_top_header_section',
                'settings'    => 'top_header_option'
            ))
        );

        // Top header date time option
        $wp_customize->add_setting( 'top_header_date_time_option', array(
            'default'         => NEV\news_event_get_customizer_default( 'top_header_date_time_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'top_header_date_time_option', array(
                'label'	      => esc_html__( 'Show date and time', 'news-event' ),
                'section'     => 'news_event_top_header_section',
                'settings'    => 'top_header_date_time_option',
            ))
        );

         // Top header ticker news option
        $wp_customize->add_setting( 'top_header_menu_option', array(
            'default'         => NEV\news_event_get_customizer_default( 'top_header_menu_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'top_header_menu_option', array(
                'label'	      => esc_html__( 'Show nav menu', 'news-event' ),
                'section'     => 'news_event_top_header_section',
                'settings'    => 'top_header_menu_option'
            ))
        );

        // top header social option
        $wp_customize->add_setting( 'top_header_social_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'top_header_social_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'top_header_social_option', array(
                'label'	      => esc_html__( 'Show social icons', 'news-event' ),
                'section'     => 'news_event_top_header_section',
                'settings'    => 'top_header_social_option',
            ))
        );

        // Redirect header social icons link
        $wp_customize->add_setting( 'top_header_social_icons_redirects', array(
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Redirect_Control( $wp_customize, 'top_header_social_icons_redirects', array(
                'section'     => 'news_event_top_header_section',
                'settings'    => 'top_header_social_icons_redirects',
                'choices'     => array(
                    'header-social-icons' => array(
                        'type'  => 'section',
                        'id'    => 'news_event_social_icons_section',
                        'label' => esc_html__( 'Manage social icons', 'news-event' )
                    )
                )
            ))
        );

        // Top header background colors group control
        $wp_customize->add_setting( 'top_header_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'top_header_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'top_header_background_color_group', array(
                'label'	      => esc_html__( 'Section Background', 'news-event' ),
                'section'     => 'news_event_top_header_section',
                'settings'    => 'top_header_background_color_group',
                'tab'   => 'design',
                'involve' =>  [ 'solid', 'gradient' ]
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_top_header_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_header_panel' ) ) :
    /**
     * Register header options settings
     * 
     */
    function news_event_customizer_header_panel( $wp_customize ) {
        /**
         * Header panel
         * 
         */
        $wp_customize->add_panel( 'news_event_header_panel', array(
            'title' => esc_html__( 'Theme Header', 'news-event' ),
            'priority'  => 69
        ));
        
        // Header ads banner section
        $wp_customize->add_section( 'news_event_header_ads_banner_section', array(
            'title' => esc_html__( 'Ads Banner', 'news-event' ),
            'panel' => 'news_event_header_panel',
            'priority'  => 10
        ));

        // Header Ads Banner setting heading
        $wp_customize->add_setting( 'news_event_header_ads_banner_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'news_event_header_ads_banner_header', array(
                'label'	      => esc_html__( 'Ads Banner Setting', 'news-event' ),
                'section'     => 'news_event_header_ads_banner_section',
                'settings'    => 'news_event_header_ads_banner_header'
            ))
        );

        // Resposive vivibility option
        $wp_customize->add_setting( 'header_ads_banner_responsive_option', array(
            'default' => NEV\news_event_get_customizer_default( 'header_ads_banner_responsive_option' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_multiselect_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Responsive_Multiselect_Tab_Control( $wp_customize, 'header_ads_banner_responsive_option', array(
                'label'	      => esc_html__( 'Ads Banner Visibility', 'news-event' ),
                'section'     => 'news_event_header_ads_banner_section',
                'settings'    => 'header_ads_banner_responsive_option'
            ))
        );

        // Header ads banner type
        $wp_customize->add_setting( 'header_ads_banner_type', array(
            'default' => NEV\news_event_get_customizer_default( 'header_ads_banner_type' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'header_ads_banner_type', array(
            'type'      => 'select',
            'section'   => 'news_event_header_ads_banner_section',
            'label'     => __( 'Ads banner type', 'news-event' ),
            'description' => __( 'Choose to display ads content from.', 'news-event' ),
            'choices'   => array(
                'none'  => esc_html__( 'None', 'news-event' ),
                'custom' => esc_html__( 'Custom', 'news-event' )
            ),
        ));

        // ads image field
        $wp_customize->add_setting( 'header_ads_banner_custom_image', array(
            'default' => NEV\news_event_get_customizer_default( 'header_ads_banner_custom_image' ),
            'sanitize_callback' => 'absint',
        ));
        $wp_customize->add_control(new WP_Customize_Media_Control($wp_customize, 'header_ads_banner_custom_image', array(
            'section' => 'news_event_header_ads_banner_section',
            'mime_type' => 'image',
            'label' => esc_html__( 'Ads Image', 'news-event' ),
            'description' => esc_html__( 'Recommended size for ad image is 900 (width) * 350 (height)', 'news-event' )
        )));

        // ads url field
        $wp_customize->add_setting( 'header_ads_banner_custom_url', array(
            'default' => NEV\news_event_get_customizer_default( 'header_ads_banner_custom_url' ),
            'sanitize_callback' => 'esc_url_raw',
        ));
        $wp_customize->add_control( 'header_ads_banner_custom_url', array(
            'type'  => 'url',
            'section'   => 'news_event_header_ads_banner_section',
            'label'     => esc_html__( 'Ads url', 'news-event' )
        ));

        // ads link show on
        $wp_customize->add_setting( 'header_ads_banner_custom_target', array(
            'default' => NEV\news_event_get_customizer_default( 'header_ads_banner_custom_target' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'header_ads_banner_custom_target', array(
            'type'      => 'select',
            'section'   => 'news_event_header_ads_banner_section',
            'label'     => __( 'Open Ads link on', 'news-event' ),
            'choices'   => array(
                '_self' => esc_html__( 'Open in same tab', 'news-event' ),
                '_blank' => esc_html__( 'Open in new tab', 'news-event' )
            )
        ));

        // header general settings section
        $wp_customize->add_section( 'news_event_header_general_settings_section', array(
            'title' => esc_html__( 'General Settings', 'news-event' ),
            'panel' => 'news_event_header_panel',
            'priority'  => 5
        ));

        // section tab
        $wp_customize->add_setting( 'main_header_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'main_header_section_tab', array(
                'section'     => 'news_event_header_general_settings_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // header width layout
        $wp_customize->add_setting( 'header_width_layout', array(
            'default' => NEV\news_event_get_customizer_default( 'header_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( new News_Event_WP_Radio_Image_Control(
            $wp_customize,
            'header_width_layout',
            array(
                'label'     => __( 'Width Layout', 'news-event' ),
                'section'  => 'news_event_header_general_settings_section',
                'priority' => 10,
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // redirect site logo section
        $wp_customize->add_setting( 'header_site_logo_redirects', array(
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Redirect_Control( $wp_customize, 'header_site_logo_redirects', array(
                'section'     => 'news_event_header_general_settings_section',
                'settings'    => 'header_site_logo_redirects',
                'choices'     => array(
                    'header-social-icons' => array(
                        'type'  => 'section',
                        'id'    => 'title_tagline',
                        'label' => esc_html__( 'Manage Site Logo', 'news-event' )
                    )
                )
            ))
        );

        // redirect site title section
        $wp_customize->add_setting( 'header_site_title_redirects', array(
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Redirect_Control( $wp_customize, 'header_site_title_redirects', array(
                'section'     => 'news_event_header_general_settings_section',
                'settings'    => 'header_site_title_redirects',
                'choices'     => array(
                    'header-social-icons' => array(
                        'type'  => 'section',
                        'id'    => 'news_event_site_title_section',
                        'label' => esc_html__( 'Manage Site & Tagline', 'news-event' )
                    )
                )
            ))
        );

        // header top and bottom padding
        $wp_customize->add_setting( 'header_vertical_padding', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_vertical_padding' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'header_vertical_padding', array(
                    'label'	      => esc_html__( 'Vertical Padding (px)', 'news-event' ),
                    'section'     => 'news_event_header_general_settings_section',
                    'settings'    => 'header_vertical_padding',
                    'unit'        => 'px',
                    'tab'   => 'design',
                    'input_attrs' => array(
                    'max'         => 500,
                    'min'         => 1,
                    'step'        => 1,
                    'reset' => true
                )
            ))
        );

        // Header background colors setting heading
        $wp_customize->add_setting( 'header_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_background_color_group' ),
            'sanitize_callback' => 'news_event_sanitize_color_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'header_background_color_group', array(
                'label'	      => esc_html__( 'Background', 'news-event' ),
                'section'     => 'news_event_header_general_settings_section',
                'settings'    => 'header_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient', 'image' ]
            ))
        );

        // Header newsletter section
        $wp_customize->add_section( 'news_event_header_newsletter_section', array(
            'title' => esc_html__( 'Newsletter / Subscribe Button', 'news-event' ),
            'panel' => 'news_event_header_panel',
            'priority'  => 15
        ));

        // section tab
        $wp_customize->add_setting( 'news_event_header_newsletter_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'news_event_header_newsletter_tab', array(
                'section'     => 'news_event_header_newsletter_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // header newsletter button option
        $wp_customize->add_setting( 'header_newsletter_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_newsletter_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'header_newsletter_option', array(
                'label'	      => esc_html__( 'Show newsletter button', 'news-event' ),
                'section'     => 'news_event_header_newsletter_section',
                'settings'    => 'header_newsletter_option'
            ))
        );

        // newsletter label
        $wp_customize->add_setting( 'newsletter_label', [
            'default'   =>  NEV\news_event_get_customizer_default( 'newsletter_label' ),
            'sanitize_callback' =>  'sanitize_text_field',
            'transport' => 'postMessage'
        ]);
        $wp_customize->add_control('newsletter_label', [
            'label' =>  esc_html__( 'Button Label', 'news-event' ),
            'section'   =>  'news_event_header_newsletter_section',
            'type'  =>  'text'
        ]);

        // newsletter redirect href target
        $wp_customize->add_setting( 'header_newsletter_redirect_href_target', array(
            'default' => NEV\news_event_get_customizer_default( 'header_newsletter_redirect_href_target' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'header_newsletter_redirect_href_target', array(
            'type'      => 'select',
            'section'   => 'news_event_header_newsletter_section',
            'label'     => __( 'Open link on', 'news-event' ),
            'choices'   => array(
                '_self' => esc_html__( 'Open in same tab', 'news-event' ),
                '_blank' => esc_html__( 'Open in new tab', 'news-event' )
            )
        ));

        // newsletter redirect url
        $wp_customize->add_setting( 'header_newsletter_redirect_href_link', array(
            'default' => NEV\news_event_get_customizer_default( 'header_newsletter_redirect_href_link' ),
            'sanitize_callback' => 'news_event_sanitize_url',
        ));
        $wp_customize->add_control( 'header_newsletter_redirect_href_link', array(
            'label' => esc_html__( 'Redirect URL.', 'news-event' ),
            'description'   => esc_html__( 'Add url for the button to redirect.', 'news-event' ),
            'section'   => 'news_event_header_newsletter_section',
            'type'  => 'url'
        ));

        // header menu active background
        $wp_customize->add_setting( 'header_newsletter_background_color', [
            'default'   => NEV\news_event_get_customizer_default( 'header_newsletter_background_color' ),
            'sanitize_callback' => 'news_event_sanitize_color_control',
            'transport' => 'postMessage'
        ]);
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'header_newsletter_background_color', [
                'label'	      => esc_html__( 'Background Color', 'news-event' ),
                'section'     => 'news_event_header_newsletter_section',
                'settings'    => 'header_newsletter_background_color',
                'tab'   =>  'design',
                'hover' =>  true,
                'involve'   =>  [ 'solid', 'gradient' ]
            ])
        );

        // Header random news section
        $wp_customize->add_section( 'news_event_header_random_news_section', array(
            'title' => esc_html__( 'Random News', 'news-event' ),
            'panel' => 'news_event_header_panel',
            'priority'  => 15
        ));

        // header random news button option
        $wp_customize->add_setting( 'header_random_news_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_random_news_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'header_random_news_option', array(
                'label'	      => esc_html__( 'Show random news button', 'news-event' ),
                'section'     => 'news_event_header_random_news_section',
                'settings'    => 'header_random_news_option'
            ))
        );

        // random news redirect href target
        $wp_customize->add_setting( 'header_random_news_redirect_href_target', array(
            'default' => NEV\news_event_get_customizer_default( 'header_random_news_redirect_href_target' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'header_random_news_redirect_href_target', array(
            'type'      => 'select',
            'section'   => 'news_event_header_random_news_section',
            'label'     => __( 'Open link on', 'news-event' ),
            'choices'   => array(
                '_self' => esc_html__( 'Open in same tab', 'news-event' ),
                '_blank' => esc_html__( 'Open in new tab', 'news-event' )
            )
        ));

        /**
         * Menu Options Section
         * 
         * panel - news_event_header_options_panel
         */
        $wp_customize->add_section( 'news_event_header_menu_option_section', array(
            'title' => esc_html__( 'Menu Options', 'news-event' ),
            'panel' => 'news_event_header_panel',
            'priority'  => 30,
        ));

        // menu section tab
        $wp_customize->add_setting( 'header_menu_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'header_menu_section_tab', array(
                'section'     => 'news_event_header_menu_option_section',
                'choices'  => array(
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    ),
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'Typography', 'news-event' )
                    )
                )
            ))
        );

        // live search target
        $wp_customize->add_setting( 'header_menu_hover_effect', array(
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'default'   => NEV\news_event_get_customizer_default( 'header_menu_hover_effect' ),
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 'header_menu_hover_effect', array(
            'type'  => 'select',
            'section'   => 'news_event_header_menu_option_section',
            'label' => esc_html__( 'Hover Effect', 'news-event' ),
            'tab'   => 'design',
            'choices'   => array(
                'none' => esc_html__( 'None', 'news-event' ),
                'one'  => esc_html__( 'One', 'news-event' )
            )
        ));
        
        // header menu background color group
        $wp_customize->add_setting( 'header_menu_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_menu_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'header_menu_background_color_group', array(
                'label'	      => esc_html__( 'Background', 'news-event' ),
                'section'     => 'news_event_header_menu_option_section',
                'settings'    => 'header_menu_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient' ]
            ))
        );

        // sub menu header
        $wp_customize->add_setting( 'header_sub_menu_color_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'header_sub_menu_color_header', array(
                'label'	      => esc_html__( 'Sub Menu', 'news-event' ),
                'section'     => 'news_event_header_menu_option_section',
                'settings'    => 'header_sub_menu_color_header',
                'tab'   => 'design'
            ))
        );

        // header sub menu background color group
        $wp_customize->add_setting( 'header_sub_menu_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_sub_menu_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'header_sub_menu_background_color_group', array(
                'label'	      => esc_html__( 'Background', 'news-event' ),
                'section'     => 'news_event_header_menu_option_section',
                'settings'    => 'header_sub_menu_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient' ]
            ))
        );

        // menu typo
        $wp_customize->add_setting( 'header_menu_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_menu_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'header_menu_typo', array(
                'label'	      => esc_html__( 'Main Menu', 'news-event' ),
                'section'     => 'news_event_header_menu_option_section',
                'settings'    => 'header_menu_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );

        // sub menu typo
        $wp_customize->add_setting( 'header_sub_menu_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_sub_menu_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'header_sub_menu_typo', array(
                'label'	      => esc_html__( 'Sub Menu', 'news-event' ),
                'section'     => 'news_event_header_menu_option_section',
                'settings'    => 'header_sub_menu_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );

        /**
         * Off Canvas Section
         * 
         * panel - news_event_header_options_panel
         */
        $wp_customize->add_section( 'news_event_header_off_canvas_section', array(
            'title' => esc_html__( 'Off Canvas', 'news-event' ),
            'panel' => 'news_event_header_panel',
            'priority'  => 40
        ));

        // header off canvas button option
        $wp_customize->add_setting( 'header_off_canvas_option', array(
            'default'         => NEV\news_event_get_customizer_default( 'header_off_canvas_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
    
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'header_off_canvas_option', array(
                'label'	      => esc_html__( 'Show off canvas', 'news-event' ),
                'section'     => 'news_event_header_off_canvas_section',
                'settings'    => 'header_off_canvas_option'
            ))
        );

        // header off canvas alignment
        $wp_customize->add_setting( 'off_canvas_position', array(
            'default' => NEV\news_event_get_customizer_default( 'off_canvas_position' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Tab_Control( $wp_customize, 'off_canvas_position', array(
                'label'	      => esc_html__( 'Canvas sidebar position', 'news-event' ),
                'section'     => 'news_event_header_off_canvas_section',
                'settings'    => 'off_canvas_position',
                'choices' => array(
                    array(
                        'value' => 'left',
                        'label' => esc_html__('Left', 'news-event' )
                    ),
                    array(
                        'value' => 'right',
                        'label' => esc_html__('Right', 'news-event' )
                    )
                )
            ))
        );

        // redirect off canvas button link
        $wp_customize->add_setting( 'header_sidebar_toggle_button_redirects', array(
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
        ));

        $wp_customize->add_control( 
            new News_Event_WP_Redirect_Control( $wp_customize, 'header_sidebar_toggle_button_redirects', array(
                'section'     => 'news_event_header_off_canvas_section',
                'settings'    => 'header_sidebar_toggle_button_redirects',
                'choices'     => array(
                    'header-social-icons' => array(
                        'type'  => 'section',
                        'id'    => 'sidebar-widgets-off-canvas-sidebar',
                        'label' => esc_html__( 'Manage sidebar from here', 'news-event' )
                    )
                )
            ))
        );

        /**
         * Live Search Section
         * 
         * panel - news_event_header_options_panel
         */
        $wp_customize->add_section( 'news_event_header_live_search_section', array(
            'title' => esc_html__( 'Live Search', 'news-event' ),
            'panel' => 'news_event_header_panel',
            'priority'  => 50
        ));

        // header search option
        $wp_customize->add_setting( 'header_search_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_search_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
    
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'header_search_option', array(
                'label'	      => esc_html__( 'Show search icon', 'news-event' ),
                'section'     => 'news_event_header_live_search_section',
                'settings'    => 'header_search_option'
            ))
        );

        /**
         * Theme Mode Section
         * 
         * panel - news_event_header_options_panel
         */
        $wp_customize->add_section( 'news_event_header_theme_mode_section', array(
            'title' => esc_html__( 'Theme Mode', 'news-event' ),
            'panel' => 'news_event_header_panel',
            'priority'  => 50
        ));

        // header theme mode toggle option
        $wp_customize->add_setting( 'header_theme_mode_toggle_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'header_theme_mode_toggle_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'header_theme_mode_toggle_option', array(
                'label'	      => esc_html__( 'Show dark/light toggle icon', 'news-event' ),
                'section'     => 'news_event_header_theme_mode_section',
                'settings'    => 'header_theme_mode_toggle_option'
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_header_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_ticker_news_panel' ) ) :
    // Register header options settings
    function news_event_customizer_ticker_news_panel( $wp_customize ) {
        // Header ads banner section
        $wp_customize->add_section( 'news_event_ticker_news_section', array(
            'title' => esc_html__( 'Ticker News', 'news-event' ),
            'priority'  => 70
        ));

        // Ticker News Width Layouts setting heading
        $wp_customize->add_setting( 'ticker_news_width_layouts_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'ticker_news_width_layouts_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_ticker_news_section',
                'settings'    => 'ticker_news_width_layouts_header'
            ))
        );

        // website content layout
        $wp_customize->add_setting( 'ticker_news_width_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'ticker_news_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'ticker_news_width_layout',
            array(
                'section'  => 'news_event_ticker_news_section',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // Header menu hover effect
        $wp_customize->add_setting( 'ticker_news_visible', array(
            'default' => NEV\news_event_get_customizer_default( 'ticker_news_visible' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'ticker_news_visible', array(
            'type'      => 'select',
            'section'   => 'news_event_ticker_news_section',
            'label'     => esc_html__( 'Show ticker on', 'news-event' ),
            'choices'   => array(
                'all' => esc_html__( 'Show in all', 'news-event' ),
                'front-page' => esc_html__( 'Frontpage', 'news-event' ),
                'innerpages' => esc_html__( 'Show only in innerpages', 'news-event' ),
                'none' => esc_html__( 'Hide in all pages', 'news-event' ),
            ),
        ));
        
        // Ticker News content setting heading
        $wp_customize->add_setting( 'ticker_news_content_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'ticker_news_content_header', array(
                'label'	      => esc_html__( 'Content Setting', 'news-event' ),
                'section'     => 'news_event_ticker_news_section',
                'settings'    => 'ticker_news_content_header',
                'type'        => 'section-heading',
            ))
        );

        // ticker News title
        $wp_customize->add_setting( 'ticker_news_title', array(
            'default' => NEV\news_event_get_customizer_default( 'ticker_news_title' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 'ticker_news_title', array(
                'label' => esc_html__( 'Ticker title', 'news-event' ),
                'type'  => 'text',
                'section'   => 'news_event_ticker_news_section'
            )
        );

        // Ticker News orderby
        $wp_customize->add_setting( 'ticker_news_order_by', array(
            'default' => NEV\news_event_get_customizer_default( 'ticker_news_order_by' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'ticker_news_order_by', array(
            'type'      => 'select',
            'section'   => 'news_event_ticker_news_section',
            'label'     => esc_html__( 'Orderby', 'news-event' ),
            'choices'   => news_event_customizer_orderby_options_array(),
        ));

        // Ticker News categories
        $wp_customize->add_setting( 'ticker_news_categories', array(
            'default' => NEV\news_event_get_customizer_default( 'ticker_news_categories' ),
            'sanitize_callback' => 'news_event_sanitize_array'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Async_Multiselect_Control( $wp_customize, 'ticker_news_categories', array(
                'label'     => esc_html__( 'Posts Categories', 'news-event' ),
                'section'   => 'news_event_ticker_news_section',
                'settings'  => 'ticker_news_categories',
                'endpoint' =>  'extend/get_taxonomy',
                'purpose'   =>  'category'
            ))
        );

        // Ticker News posts
        $wp_customize->add_setting( 'ticker_news_posts', array(
            'default' => NEV\news_event_get_customizer_default( 'ticker_news_posts' ),
            'sanitize_callback' => 'news_event_sanitize_array'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Async_Multiselect_Control( $wp_customize, 'ticker_news_posts', array(
                'label'     => esc_html__( 'Posts To Include', 'news-event' ),
                'section'   => 'news_event_ticker_news_section',
                'settings'  => 'ticker_news_posts'
            ))
        );

        // ticker news post query date range
        $wp_customize->add_setting( 'ticker_news_date_filter', array(
            'default' => NEV\news_event_get_customizer_default( 'ticker_news_date_filter' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'ticker_news_date_filter', array(
            'label'     => __( 'Date Range', 'news-event' ),
            'type'      => 'select',
            'section'   => 'news_event_ticker_news_section',
            'choices'   => news_event_get_date_filter_choices_array()
        ));
    }
    add_action( 'customize_register', 'news_event_customizer_ticker_news_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_main_banner_panel' ) ) :
    /**
     * Register main banner section settings
     * 
     */
    function news_event_customizer_main_banner_panel( $wp_customize ) {
        /**
         * Main Banner section
         * 
         */
        $wp_customize->add_section( 'news_event_main_banner_section', array(
            'title' => esc_html__( 'Main Banner', 'news-event' ),
            'priority'  => 70
        ));

        // main banner section tab
        $wp_customize->add_setting( 'main_banner_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'main_banner_section_tab', array(
                'section'     => 'news_event_main_banner_section',
                'priority'  => 1,
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // main banner option
        $wp_customize->add_setting( 'main_banner_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'main_banner_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Toggle_Control( $wp_customize, 'main_banner_option', array(
                'label'	      => esc_html__( 'Show main banner', 'news-event' ),
                'section'     => 'news_event_main_banner_section',
                'settings'    => 'main_banner_option'
            ))
        );
        
        // Main banner block posts setting heading
        $wp_customize->add_setting( 'main_banner_block_posts_settings_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'main_banner_block_posts_settings_header', array(
                'label'	      => esc_html__( 'Block Posts Setting', 'news-event' ),
                'section'     => 'news_event_main_banner_section',
                'settings'    => 'main_banner_block_posts_settings_header',
                'type'        => 'section-heading'
            ))
        );

        // Main Banner block posts slider orderby
        $wp_customize->add_setting( 'main_banner_block_posts_order_by', array(
            'default' => NEV\news_event_get_customizer_default( 'main_banner_block_posts_order_by' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'main_banner_block_posts_order_by', array(
            'type'      => 'select',
            'section'   => 'news_event_main_banner_section',
            'label'     => esc_html__( 'Orderby', 'news-event' ),
            'choices'   => news_event_customizer_orderby_options_array()
        ));

        // Main Banner block posts categories
        $wp_customize->add_setting( 'main_banner_block_posts_to_include', array(
            'default' => NEV\news_event_get_customizer_default( 'main_banner_block_posts_to_include' ),
            'sanitize_callback' => 'news_event_sanitize_array'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Async_Multiselect_Control( $wp_customize, 'main_banner_block_posts_to_include', array(
                'label'     => esc_html__( 'Block posts to include', 'news-event' ),
                'section'   => 'news_event_main_banner_section',
                'settings'  => 'main_banner_block_posts_to_include',
                'endpoint' =>  'extend/get_posts'
            ))
        );

        // Main Banner block posts categories
        $wp_customize->add_setting( 'main_banner_block_posts_categories', array(
            'default' => NEV\news_event_get_customizer_default( 'main_banner_block_posts_categories' ),
            'sanitize_callback' => 'news_event_sanitize_array'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Async_Multiselect_Control( $wp_customize, 'main_banner_block_posts_categories', array(
                'label'     => esc_html__( 'Block posts categories', 'news-event' ),
                'section'   => 'news_event_main_banner_section',
                'settings'  => 'main_banner_block_posts_categories',
                'endpoint' =>  'extend/get_taxonomy',
                'purpose'   =>  'category'
            ))
        );

        // Main Banner block posts categories option
        $wp_customize->add_setting( 'main_banner_block_posts_categories_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'main_banner_block_posts_categories_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'main_banner_block_posts_categories_option', array(
                'label'	      => esc_html__( 'Show post categories', 'news-event' ),
                'section'     => 'news_event_main_banner_section',
                'settings'    => 'main_banner_block_posts_categories_option'
            ))
        );

        // Main Banner block posts block option
        $wp_customize->add_setting( 'main_banner_block_posts_date_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'main_banner_block_posts_date_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'main_banner_block_posts_date_option', array(
                'label'	      => esc_html__( 'Show post date', 'news-event' ),
                'section'     => 'news_event_main_banner_section',
                'settings'    => 'main_banner_block_posts_date_option'
            ))
        );

        // main banner image border radius
        $wp_customize->add_setting( 'main_banner_image_border_radius', array(
            'default'   => NEV\news_event_get_customizer_default( 'main_banner_image_border_radius' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'main_banner_image_border_radius', array(
                'label'	      => esc_html__( 'Border Radius (px)', 'news-event' ),
                'section'     => 'news_event_main_banner_section',
                'settings'    => 'main_banner_image_border_radius',
                'unit'        => 'px',
                'input_attrs' => array(
                    'max'         => 200,
                    'min'         => 0,
                    'step'        => 1,
                    'reset' => true
                ),
                'tab'   =>  'design'
            ))
        );

        // banner Width Layouts setting heading
        $wp_customize->add_setting( 'main_banner_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'main_banner_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_main_banner_section',
                'settings'    => 'main_banner_width_layout_header',
                'tab'   => 'design'
            ))
        );

        // banner layout
        $wp_customize->add_setting( 'main_banner_width_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'main_banner_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'main_banner_width_layout',
            array(
                'section'  => 'news_event_main_banner_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));
    }
    add_action( 'customize_register', 'news_event_customizer_main_banner_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_footer_panel' ) ) :
    /**
     * Register footer options settings
     * 
     */
    function news_event_customizer_footer_panel( $wp_customize ) {
        /**
         * Theme Footer Section
         * 
         * panel - news_event_footer_panel
         */
        $wp_customize->add_section( 'news_event_footer_section', array(
            'title' => esc_html__( 'Theme Footer', 'news-event' ),
            'priority'  => 74
        ));
        
        // section tab
        $wp_customize->add_setting( 'footer_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'footer_section_tab', array(
                'section'     => 'news_event_footer_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // Footer Option
        $wp_customize->add_setting( 'footer_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'footer_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport'   => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Toggle_Control( $wp_customize, 'footer_option', array(
                'label'	      => esc_html__( 'Enable footer section', 'news-event' ),
                'section'     => 'news_event_footer_section',
                'settings'    => 'footer_option',
                'tab'   => 'general'
            ))
        );

        /// Add the footer layout control.
        $wp_customize->add_setting( 'footer_widget_column', array(
            'default'           => NEV\news_event_get_customizer_default( 'footer_widget_column' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport'   => 'postMessage'
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'footer_widget_column', array(
                'section'  => 'news_event_footer_section',
                'tab'   => 'general',
                'choices'  => array(
                    'column-one' => array(
                        'label' => esc_html__( 'Column One', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/footer_column_one.jpg'
                    ),
                    'column-two' => array(
                        'label' => esc_html__( 'Column Two', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/footer_column_two.jpg'
                    ),
                    'column-three' => array(
                        'label' => esc_html__( 'Column Three', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/footer_column_three.jpg'
                    ),
                    'column-four' => array(
                        'label' => esc_html__( 'Column Four', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/footer_column_four.jpg'
                    )
                )
            )
        ));

        // archive pagination type
        $wp_customize->add_setting( 'footer_section_width', array(
            'default' => NEV\news_event_get_customizer_default( 'footer_section_width' ),
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Tab_Control( $wp_customize, 'footer_section_width', array(
                'label'	      => esc_html__( 'Section Width', 'news-event' ),
                'section'     => 'news_event_footer_section',
                'settings'    => 'footer_section_width',
                'choices' => array(
                    array(
                        'value' => 'full-width',
                        'label' => esc_html__('Full Width', 'news-event' )
                    ),
                    array(
                        'value' => 'boxed-width',
                        'label' => esc_html__('Boxed Width', 'news-event' )
                    )
                )
            ))
        );
        
        // Redirect widgets link
        $wp_customize->add_setting( 'footer_widgets_redirects', array(
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Redirect_Control( $wp_customize, 'footer_widgets_redirects', array(
                'label'	      => esc_html__( 'Widgets', 'news-event' ),
                'section'     => 'news_event_footer_section',
                'settings'    => 'footer_widgets_redirects',
                'tab'   => 'general',
                'choices'     => array(
                    'footer-column-one' => array(
                        'type'  => 'section',
                        'id'    => 'sidebar-widgets-footer-sidebar--column-1',
                        'label' => esc_html__( 'Manage footer widget one', 'news-event' )
                    ),
                    'footer-column-two' => array(
                        'type'  => 'section',
                        'id'    => 'sidebar-widgets-footer-sidebar--column-2',
                        'label' => esc_html__( 'Manage footer widget two', 'news-event' )
                    ),
                    'footer-column-three' => array(
                        'type'  => 'section',
                        'id'    => 'sidebar-widgets-footer-sidebar--column-3',
                        'label' => esc_html__( 'Manage footer widget three', 'news-event' )
                    ),
                    'footer-column-four' => array(
                        'type'  => 'section',
                        'id'    => 'sidebar-widgets-footer-sidebar--column-4',
                        'label' => esc_html__( 'Manage footer widget four', 'news-event' )
                    )
                )
            ))
        );

        // footer border top
        $wp_customize->add_setting( 'footer_top_border', array( 
            'default' => NEV\news_event_get_customizer_default( 'footer_top_border' ),
            'sanitize_callback' => 'news_event_sanitize_array',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Border_Control( $wp_customize, 'footer_top_border', array(
                'label'       => esc_html__( 'Border Top', 'news-event' ),
                'section'     => 'news_event_footer_section',
                'settings'    => 'footer_top_border',
                'tab'   => 'design'
            ))
        );

        // footer background property
        $wp_customize->add_setting( 'footer_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'footer_background_color_group' ),
            'sanitize_callback' => 'news_event_sanitize_color_control',
            'transport' => 'postMessage'
        ));
        
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'footer_background_color_group', array(
                'label'	      => esc_html__( 'Background', 'news-event' ),
                'section'     => 'news_event_footer_section',
                'settings'    => 'footer_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient', 'image' ]
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_footer_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_bottom_footer_panel' ) ) :
    /**
     * Register bottom footer options settings
     * 
     */
    function news_event_customizer_bottom_footer_panel( $wp_customize ) {
        /**
         * Bottom Footer Section
         * 
         * panel - news_event_footer_panel
         */
        $wp_customize->add_section( 'news_event_bottom_footer_section', array(
            'title' => esc_html__( 'Bottom Footer', 'news-event' ),
            'priority'  => 75
        ));

        // section tab
        $wp_customize->add_setting( 'bottom_footer_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'bottom_footer_section_tab', array(
                'section'     => 'news_event_bottom_footer_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // Bottom Footer Option
        $wp_customize->add_setting( 'bottom_footer_option', array(
            'default'         => NEV\news_event_get_customizer_default( 'bottom_footer_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Toggle_Control( $wp_customize, 'bottom_footer_option', array(
                'label'	      => esc_html__( 'Enable bottom footer', 'news-event' ),
                'section'     => 'news_event_bottom_footer_section',
                'settings'    => 'bottom_footer_option'
            ))
        );

        // Main Banner slider categories option
        $wp_customize->add_setting( 'bottom_footer_social_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'bottom_footer_social_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'bottom_footer_social_option', array(
                'label'	      => esc_html__( 'Show bottom social icons', 'news-event' ),
                'section'     => 'news_event_bottom_footer_section',
                'settings'    => 'bottom_footer_social_option'
            ))
        );

        // Main Banner slider categories option
        $wp_customize->add_setting( 'bottom_footer_menu_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'bottom_footer_menu_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'bottom_footer_menu_option', array(
                'label'	      => esc_html__( 'Show bottom footer menu', 'news-event' ),
                'section'     => 'news_event_bottom_footer_section',
                'settings'    => 'bottom_footer_menu_option'
            ))
        );

        // Bottom footer site info
        $wp_customize->add_setting( 'bottom_footer_site_info', array(
            'default'    => NEV\news_event_get_customizer_default( 'bottom_footer_site_info' ),
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 'bottom_footer_site_info', array(
            'label'	      => esc_html__( 'Copyright Text', 'news-event' ),
            'description' => esc_html__( 'Add %year% to retrieve current year', 'news-event' ),
            'section'     => 'news_event_bottom_footer_section',
            'type'        => 'textarea'
        ));

        // bottom footer width layout heading
        $wp_customize->add_setting( 'bottom_footer_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'bottom_footer_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_bottom_footer_section',
                'settings'    => 'bottom_footer_width_layout_header',
                'tab'   => 'design'
            ))
        );

        // bottom footer width layout
        $wp_customize->add_setting( 'bottom_footer_width_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'bottom_footer_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'bottom_footer_width_layout',
            array(
                'section'  => 'news_event_bottom_footer_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // bottom footer background
        $wp_customize->add_setting( 'bottom_footer_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'bottom_footer_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'bottom_footer_background_color_group', array(
                'label'	      => esc_html__( 'Background', 'news-event' ),
                'section'     => 'news_event_bottom_footer_section',
                'settings'    => 'bottom_footer_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient' ]
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_bottom_footer_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_typography_panel' ) ) :
    /**
     * Register typography options settings
     * 
     */
    function news_event_customizer_typography_panel( $wp_customize ) {
        // typography options panel settings
        $wp_customize->add_section( 'news_event_typography_section', array(
            'title' => esc_html__( 'Typography', 'news-event' ),
            'priority'  => 55
        ));

        // block title typo
        $wp_customize->add_setting( 'site_section_block_title_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'site_section_block_title_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'site_section_block_title_typo', array(
                'label'	      => esc_html__( 'Block Title', 'news-event' ),
                'section'     => 'news_event_typography_section',
                'settings'    => 'site_section_block_title_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );

        // post title typo
        $wp_customize->add_setting( 'site_archive_post_title_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'site_archive_post_title_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'site_archive_post_title_typo', array(
                'label'	      => esc_html__( 'Post Title', 'news-event' ),
                'section'     => 'news_event_typography_section',
                'settings'    => 'site_archive_post_title_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );
        
        // post meta typo
        $wp_customize->add_setting( 'site_archive_post_meta_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'site_archive_post_meta_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'site_archive_post_meta_typo', array(
                'label'	      => esc_html__( 'Post Meta', 'news-event' ),
                'section'     => 'news_event_typography_section',
                'settings'    => 'site_archive_post_meta_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );

        // post content typo
        $wp_customize->add_setting( 'site_archive_post_content_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'site_archive_post_content_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'site_archive_post_content_typo', array(
                'label'	      => esc_html__( 'Post Content', 'news-event' ),
                'section'     => 'news_event_typography_section',
                'settings'    => 'site_archive_post_content_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration')
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_typography_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_front_sections_panel' ) ) :
    /**
     * Register front sections settings
     * 
     */
    function news_event_customizer_front_sections_panel( $wp_customize ) {
        // Front sections panel
        $wp_customize->add_panel( 'news_event_front_sections_panel', array(
            'title' => esc_html__( 'Front sections', 'news-event' ),
            'priority'  => 71
        ));

        // full width content section
        $wp_customize->add_section( 'news_event_full_width_section', array(
            'title' => esc_html__( 'Full Width', 'news-event' ),
            'panel' => 'news_event_front_sections_panel',
            'priority'  => 10
        ));

        // section tab
        $wp_customize->add_setting( 'full_width_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'full_width_section_tab', array(
                'section'     => 'news_event_full_width_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // full width repeater control
        $wp_customize->add_setting( 'full_width_blocks', array(
            'default'   => NEV\news_event_get_customizer_default( 'full_width_blocks' ),
            'sanitize_callback' => 'news_event_sanitize_repeater_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Block_Repeater_Control( $wp_customize, 'full_width_blocks', array(
                'label'	      => esc_html__( 'Blocks to show in this section', 'news-event' ),
                'description' => esc_html__( 'Hold bar icon at right of block item and drag vertically to re-order blocks', 'news-event' ),
                'section'     => 'news_event_full_width_section',
                'settings'    => 'full_width_blocks'
            ))
        );

        // Width Layouts setting heading
        $wp_customize->add_setting( 'full_width_blocks_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'full_width_blocks_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_full_width_section',
                'settings'    => 'full_width_blocks_width_layout_header',
                'tab'   => 'design'
            ))
        );

        // width layout
        $wp_customize->add_setting( 'full_width_blocks_width_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'full_width_blocks_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'full_width_blocks_width_layout',
            array(
                'section'  => 'news_event_full_width_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));
        // full width background setting
        $wp_customize->add_setting( 'full_width_blocks_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'full_width_blocks_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'full_width_blocks_background_color_group', array(
                'label'	      => esc_html__( 'Section background', 'news-event' ),
                'section'     => 'news_event_full_width_section',
                'settings'    => 'full_width_blocks_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient', 'image' ]
            ))
        );

        // Left content -right sidebar section
        $wp_customize->add_section( 'news_event_leftc_rights_section', array(
            'title' => esc_html__( 'Left Content  - Right Sidebar', 'news-event' ),
            'panel' => 'news_event_front_sections_panel',
            'priority'  => 10
        ));

        // section tab
        $wp_customize->add_setting( 'leftc_rights_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'leftc_rights_section_tab', array(
                'section'     => 'news_event_leftc_rights_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // redirect to manage sidebar
        $wp_customize->add_setting( 'leftc_rights_section_sidebar_redirect', array(
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Redirect_Control( $wp_customize, 'leftc_rights_section_sidebar_redirect', array(
                'label'	      => esc_html__( 'Widgets', 'news-event' ),
                'section'     => 'news_event_leftc_rights_section',
                'settings'    => 'leftc_rights_section_sidebar_redirect',
                'tab'   => 'general',
                'choices'     => array(
                    'footer-column-one' => array(
                        'type'  => 'section',
                        'id'    => 'sidebar-widgets-front-right-sidebar',
                        'label' => esc_html__( 'Manage right sidebar', 'news-event' )
                    )
                )
            ))
        );

        // Block Repeater control
        $wp_customize->add_setting( 'leftc_rights_blocks', array(
            'sanitize_callback' => 'news_event_sanitize_repeater_control',
            'default'   => NEV\news_event_get_customizer_default( 'leftc_rights_blocks' )
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Block_Repeater_Control( $wp_customize, 'leftc_rights_blocks', array(
                'label'	      => esc_html__( 'Blocks to show in this section', 'news-event' ),
                'description' => esc_html__( 'Hold bar icon at right of block item and drag vertically to re-order blocks', 'news-event' ),
                'section'     => 'news_event_leftc_rights_section',
                'settings'    => 'leftc_rights_blocks'
            ))
        );

        // Width Layouts setting heading
        $wp_customize->add_setting( 'leftc_rights_blocks_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'leftc_rights_blocks_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_leftc_rights_section',
                'settings'    => 'leftc_rights_blocks_width_layout_header',
                'tab'   => 'design'
            ))
        );

        // width layout
        $wp_customize->add_setting( 'leftc_rights_blocks_width_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'leftc_rights_blocks_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'leftc_rights_blocks_width_layout',
            array(
                'section'  => 'news_event_leftc_rights_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));
        
        // section background settings
        $wp_customize->add_setting( 'leftc_rights_blocks_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'leftc_rights_blocks_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'leftc_rights_blocks_background_color_group', array(
                'label'	      => esc_html__( 'Section background', 'news-event' ),
                'section'     => 'news_event_leftc_rights_section',
                'settings'    => 'leftc_rights_blocks_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient', 'image' ]
            ))
        );

        // Left sidebar - Right content section
        $wp_customize->add_section( 'news_event_lefts_rightc_section', array(
            'title' => esc_html__( 'Left Sidebar - Right Content', 'news-event' ),
            'panel' => 'news_event_front_sections_panel',
            'priority'  => 10
        ));

        // section tab
        $wp_customize->add_setting( 'lefts_rightc_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'lefts_rightc_section_tab', array(
                'section'     => 'news_event_lefts_rightc_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // redirect to manage sidebar
        $wp_customize->add_setting( 'lefts_rightc_section_sidebar_redirect', array(
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Redirect_Control( $wp_customize, 'lefts_rightc_section_sidebar_redirect', array(
                'label'	      => esc_html__( 'Widgets', 'news-event' ),
                'section'     => 'news_event_lefts_rightc_section',
                'settings'    => 'lefts_rightc_section_sidebar_redirect',
                'tab'   => 'general',
                'choices'     => array(
                    'footer-column-one' => array(
                        'type'  => 'section',
                        'id'    => 'sidebar-widgets-front-left-sidebar',
                        'label' => esc_html__( 'Manage left sidebar', 'news-event' )
                    )
                )
            ))
        );

        // Block Repeater control
        $wp_customize->add_setting( 'lefts_rightc_blocks', array(
            'sanitize_callback' => 'news_event_sanitize_repeater_control',
            'default'   => NEV\news_event_get_customizer_default( 'lefts_rightc_blocks' )
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Block_Repeater_Control( $wp_customize, 'lefts_rightc_blocks', array(
                'label'	      => esc_html__( 'Blocks to show in this section', 'news-event' ),
                'description' => esc_html__( 'Hold bar icon at right of block item and drag vertically to re-order blocks', 'news-event' ),
                'section'     => 'news_event_lefts_rightc_section',
                'settings'    => 'lefts_rightc_blocks'
            ))
        );

         // Width Layouts setting heading
        $wp_customize->add_setting( 'lefts_rightc_blocks_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'lefts_rightc_blocks_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_lefts_rightc_section',
                'settings'    => 'lefts_rightc_blocks_width_layout_header',
                'tab'   => 'design'
            ))
        );

        // width layout
        $wp_customize->add_setting( 'lefts_rightc_blocks_width_layout',
            array(
            'default'           => NEV\news_event_get_customizer_default( 'lefts_rightc_blocks_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
            )
        );
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'lefts_rightc_blocks_width_layout',
            array(
                'section'  => 'news_event_lefts_rightc_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // Left Sidebar Right background setting
        $wp_customize->add_setting( 'lefts_rightc_blocks_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'lefts_rightc_blocks_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'lefts_rightc_blocks_background_color_group', array(
                'label'	      => esc_html__( 'Section Background', 'news-event' ),
                'section'     => 'news_event_lefts_rightc_section',
                'settings'    => 'lefts_rightc_blocks_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient', 'image' ]
            ))
        );

        // bottom full width content section
        $wp_customize->add_section( 'news_event_bottom_full_width_section', array(
            'title' => esc_html__( 'Bottom Full Width', 'news-event' ),
            'panel' => 'news_event_front_sections_panel',
            'priority'  => 50
        ));

        // section tab
        $wp_customize->add_setting( 'bottom_full_width_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'bottom_full_width_section_tab', array(
                'section'     => 'news_event_bottom_full_width_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // bottom full width blocks control
        $wp_customize->add_setting( 'bottom_full_width_blocks', array(
            'sanitize_callback' => 'news_event_sanitize_repeater_control',
            'default'   => NEV\news_event_get_customizer_default( 'bottom_full_width_blocks' )
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Block_Repeater_Control( $wp_customize, 'bottom_full_width_blocks', array(
                'label'	      => esc_html__( 'Blocks to show in this section', 'news-event' ),
                'description' => esc_html__( 'Hold bar icon at right of block item and drag vertically to re-order blocks', 'news-event' ),
                'section'     => 'news_event_bottom_full_width_section',
                'settings'    => 'bottom_full_width_blocks'
            ))
        );

        // Width Layouts setting heading
        $wp_customize->add_setting( 'bottom_full_width_blocks_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'bottom_full_width_blocks_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_bottom_full_width_section',
                'settings'    => 'bottom_full_width_blocks_width_layout_header',
                'tab'   => 'design'
            ))
        );

        // width layout
        $wp_customize->add_setting( 'bottom_full_width_blocks_width_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'bottom_full_width_blocks_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'bottom_full_width_blocks_width_layout',
            array(
                'section'  => 'news_event_bottom_full_width_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // Bottom Full Width background setting
        $wp_customize->add_setting( 'bottom_full_width_blocks_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'bottom_full_width_blocks_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'bottom_full_width_blocks_background_color_group', array(
                'label'	      => esc_html__( 'Section Background', 'news-event' ),
                'section'     => 'news_event_bottom_full_width_section',
                'settings'    => 'bottom_full_width_blocks_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient', 'image' ]
            ))
        );

        // two column section
        $wp_customize->add_section( 'news_event_two_column_section', array(
            'title' => esc_html__( 'Two Column Section', 'news-event' ),
            'panel' => 'news_event_front_sections_panel',
            'priority'  => 60
        ));

        // section tab
        $wp_customize->add_setting( 'two_column_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'two_column_section_tab', array(
                'section'     => 'news_event_two_column_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // two column first column blocks heading
        $wp_customize->add_setting( 'two_column_first_column_blocks_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'two_column_first_column_blocks_header', array(
                'label'	      => esc_html__( 'First Column Blocks', 'news-event' ),
                'section'     => 'news_event_two_column_section',
                'settings'    => 'two_column_first_column_blocks_header'
            ))
        );

        // two column first column blocks control
        $wp_customize->add_setting( 'two_column_first_column_blocks', array(
            'sanitize_callback' => 'news_event_sanitize_repeater_control',
            'default'   => NEV\news_event_get_customizer_default( 'two_column_first_column_blocks' )
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Block_Repeater_Control( $wp_customize, 'two_column_first_column_blocks', array(
                'label'	      => esc_html__( 'Blocks to show in this column', 'news-event' ),
                'description' => esc_html__( 'Hold bar icon at right of block item and drag vertically to re-order blocks', 'news-event' ),
                'section'     => 'news_event_two_column_section',
                'fields_to_exclude'     => ['column']
            ))
        );

        // two column second column blocks heading
        $wp_customize->add_setting( 'two_column_second_column_blocks_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'two_column_second_column_blocks_header', array(
                'label'	      => esc_html__( 'Second Column Blocks', 'news-event' ),
                'section'     => 'news_event_two_column_section',
                'settings'    => 'two_column_second_column_blocks_header'
            ))
        );

        // two column second column blocks control
        $wp_customize->add_setting( 'two_column_second_column_blocks', array(
            'sanitize_callback' => 'news_event_sanitize_repeater_control',
            'default'   => NEV\news_event_get_customizer_default( 'two_column_second_column_blocks' )
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Block_Repeater_Control( $wp_customize, 'two_column_second_column_blocks', array(
                'label'	      => esc_html__( 'Blocks to show in this column', 'news-event' ),
                'description' => esc_html__( 'Hold bar icon at right of block item and drag vertically to re-order blocks', 'news-event' ),
                'section'     => 'news_event_two_column_section',
                'fields_to_exclude'     => ['column']
            ))
        );

        // Width Layouts setting heading
        $wp_customize->add_setting( 'two_column_section_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'two_column_section_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_two_column_section',
                'settings'    => 'two_column_section_layout_header',
                'tab'   => 'design'
            ))
        );

        // width layout
        $wp_customize->add_setting( 'two_column_section_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'two_column_section_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'two_column_section_layout',
            array(
                'section'  => 'news_event_two_column_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // two column background setting
        $wp_customize->add_setting( 'two_column_background_color_group', array(
            'default'   => NEV\news_event_get_customizer_default( 'two_column_background_color_group' ),
            'transport' => 'postMessage',
            'sanitize_callback' => 'news_event_sanitize_color_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Color_Control( $wp_customize, 'two_column_background_color_group', array(
                'label'	      => esc_html__( 'Section background', 'news-event' ),
                'section'     => 'news_event_two_column_section',
                'settings'    => 'two_column_background_color_group',
                'tab'   => 'design',
                'involve'   =>  [ 'solid', 'gradient', 'image' ]
            ))
        );

        // front sections reorder section
        $wp_customize->add_section( 'news_event_front_sections_reorder_section', array(
            'title' => esc_html__( 'Reorder sections', 'news-event' ),
            'panel' => 'news_event_front_sections_panel',
            'priority'  => 70
        ));

        /**
         * Frontpage sections options
         * 
         * @package News Event
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'homepage_content_order', array(
            'default'   => NEV\news_event_get_customizer_default( 'homepage_content_order' ),
            'sanitize_callback' => 'news_event_sanitize_sortable_control'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Item_Sortable_Control( $wp_customize, 'homepage_content_order', array(
                'label'         => esc_html__( 'Section Re-order', 'news-event' ),
                'description'   => esc_html__( 'Hold item and drag vertically to re-order the items', 'news-event' ),
                'section'       => 'news_event_front_sections_reorder_section',
                'settings'      => 'homepage_content_order',
                'fields'    => array(
                    'full_width_section'  => array(
                        'label' => esc_html__( 'Full width Section', 'news-event' )
                    ),
                    'leftc_rights_section'  => array(
                        'label' => esc_html__( 'Left Content - Right Sidebar', 'news-event' )
                    ),
                    'lefts_rightc_section'  => array(
                        'label' => esc_html__( 'Left Sidebar - Right Content', 'news-event' )
                    ),
                    'bottom_full_width_section'  => array(
                        'label' => esc_html__( 'Bottom Full width Section', 'news-event' )
                    ),
                    'two_column_section'  => array(
                        'label' => esc_html__( 'Two Column Section', 'news-event' )
                    ),
                    'latest_posts'  => array(
                        'label' => esc_html__( 'Latest Posts / Page Content', 'news-event' )
                    )
                )
            ))
        );
    }
    add_action( 'customize_register', 'news_event_customizer_front_sections_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_blog_post_archive_panel' ) ) :
    /**
     * Register global options settings
     * 
     */
    function news_event_customizer_blog_post_archive_panel( $wp_customize ) {
        // Blog/Archives panel
        $wp_customize->add_panel( 'news_event_blog_post_archive_panel', array(
            'title' => esc_html__( 'Blog / Archives', 'news-event' ),
            'priority'  => 72
        ));
        
        // blog / archive section
        $wp_customize->add_section( 'news_event_blog_archive_general_setting_section', array(
            'title' => esc_html__( 'General Settings', 'news-event' ),
            'panel' => 'news_event_blog_post_archive_panel',
            'priority'  => 10
        ));

        // archive tab section tab
        $wp_customize->add_setting( 'archive_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'archive_section_tab', array(
                'section'     => 'news_event_blog_archive_general_setting_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // archive layout settings heading
        $wp_customize->add_setting( 'archive_page_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Toggle_Control( $wp_customize, 'archive_page_layout_header', array(
                'label'	      => esc_html__( 'Layout Settings', 'news-event' ),
                'section'     => 'news_event_blog_archive_general_setting_section'
            ))
        );

        // archive title prefix option
        $wp_customize->add_setting( 'archive_page_title_prefix', array(
            'default' => NEV\news_event_get_customizer_default( 'archive_page_title_prefix' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'archive_page_title_prefix', array(
                'label'	      => esc_html__( 'Show archive title prefix', 'news-event' ),
                'section'     => 'news_event_blog_archive_general_setting_section',
                'settings'    => 'archive_page_title_prefix'
            ))
        );

        // archive post layouts
        $wp_customize->add_setting( 'archive_page_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'archive_page_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'archive_page_layout',
            array(
                'section'  => 'news_event_blog_archive_general_setting_section',
                'priority' => 10,
                'choices'  => array(
                    'one' => array(
                        'label' => esc_html__( 'Layout One', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/archive_one.jpg'
                    ),
                    'two' => array(
                        'label' => esc_html__( 'Layout Two', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/archive_two.jpg'
                    )
                )
            )
        ));

        // live search heading
        $wp_customize->add_setting( 'archive_page_elements_setting_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Toggle_Control( $wp_customize, 'archive_page_elements_setting_header', array(
                'label'	      => esc_html__( 'Elements Settings', 'news-event' ),
                'section'     => 'news_event_blog_archive_general_setting_section'
            ))
        );

        // archive categories option
        $wp_customize->add_setting( 'archive_page_category_option', array(
            'default' => NEV\news_event_get_customizer_default( 'archive_page_category_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'archive_page_category_option', array(
                'label'	      => esc_html__( 'Show archive categories', 'news-event' ),
                'section'     => 'news_event_blog_archive_general_setting_section',
                'settings'    => 'archive_page_category_option'
            ))
        );
        
        // archive elements sort
        $wp_customize->add_setting( 'archive_post_element_order', array(
            'default'   => NEV\news_event_get_customizer_default( 'archive_post_element_order' ),
            'sanitize_callback' => 'news_event_sanitize_sortable_control'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Item_Sortable_Control( $wp_customize, 'archive_post_element_order', array(
                'label'         => esc_html__( 'Elements Re-order', 'news-event' ),
                'section'       => 'news_event_blog_archive_general_setting_section',
                'settings'      => 'archive_post_element_order',
                'tab'   => 'general',
                'fields'    => array(
                    'title'  => array(
                        'label' => esc_html__( 'Title', 'news-event' )
                    ),
                    'meta'  => array(
                        'label' => esc_html__( 'Meta', 'news-event' )
                    ),
                    'excerpt'  => array(
                        'label' => esc_html__( 'Excerpt', 'news-event' )
                    ),
                    'button'  => array(
                        'label' => esc_html__( 'Button', 'news-event' )
                    ),
                )
            ))
        );

        // Redirect continue reading button
        $wp_customize->add_setting( 'archive_button_redirect', array(
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Redirect_Control( $wp_customize, 'archive_button_redirect', array(
                'section'     => 'news_event_blog_archive_general_setting_section',
                'settings'    => 'archive_button_redirect',
                'choices'     => array(
                    'header-social-icons' => array(
                        'type'  => 'section',
                        'id'    => 'news_event_buttons_section',
                        'label' => esc_html__( 'Edit button styles', 'news-event' )
                    )
                )
            ))
        );

        // archive image settings
        $wp_customize->add_setting( 'archive_image_settings_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Toggle_Control( $wp_customize, 'archive_image_settings_header', array(
                'label'	      => esc_html__( 'Image Settings', 'news-event' ),
                'section'     => 'news_event_blog_archive_general_setting_section'
            ))
        );

        // ticker news image ratio
        $wp_customize->add_setting( 'archive_image_ratio', array(
            'default'   => NEV\news_event_get_customizer_default( 'archive_image_ratio' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'archive_image_ratio', array(
                    'label'	      => esc_html__( 'Image Ratio', 'news-event' ),
                    'section'     => 'news_event_blog_archive_general_setting_section',
                    'settings'    => 'archive_image_ratio',
                    'unit'        => 'px',
                    'input_attrs' => array(
                    'max'         => 2,
                    'min'         => 0,
                    'step'        => 0.1,
                    'reset' => true
                )
            ))
        );
        
        // archive iamge size
        $wp_customize->add_setting( 'archive_image_size', array(
            'default' => NEV\news_event_get_customizer_default( 'archive_image_size' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'archive_image_size', array(
            'label'     => esc_html__( 'Image Size', 'news-event' ),
            'type'      => 'select',
            'section'   => 'news_event_blog_archive_general_setting_section',
            'choices'   => news_event_get_image_sizes()
        ));

        // Width Layouts setting heading
        $wp_customize->add_setting( 'archive_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'archive_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_blog_archive_general_setting_section',
                'settings'    => 'archive_width_layout_header',
                'tab'   => 'design'
            ))
        );

        // width layout
        $wp_customize->add_setting( 'archive_width_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'archive_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'archive_width_layout',
            array(
                'section'  => 'news_event_blog_archive_general_setting_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // archive vertical spacing top
        $wp_customize->add_setting( 'archive_vertical_spacing_top', array(
            'default'   => NEV\news_event_get_customizer_default( 'archive_vertical_spacing_top' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'archive_vertical_spacing_top', array(
                'label'	      => esc_html__( 'Vertical Spacing Top (px)', 'news-event' ),
                'section'     => 'news_event_blog_archive_general_setting_section',
                'settings'    => 'archive_vertical_spacing_top',
                'unit'        => 'px',
                'input_attrs' => array(
                    'max'         => 200,
                    'min'         => 0,
                    'step'        => 1,
                    'reset' => true
                ),
                'tab'   =>  'design'
            ))
        );

        // archive vertical spacing bottom
        $wp_customize->add_setting( 'archive_vertical_spacing_bottom', array(
            'default'   => NEV\news_event_get_customizer_default( 'archive_vertical_spacing_bottom' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'archive_vertical_spacing_bottom', array(
                'label'	      => esc_html__( 'Vertical Spacing Bottom (px)', 'news-event' ),
                'section'     => 'news_event_blog_archive_general_setting_section',
                'settings'    => 'archive_vertical_spacing_bottom',
                'unit'        => 'px',
                'input_attrs' => array(
                    'max'         => 200,
                    'min'         => 0,
                    'step'        => 1,
                    'reset' => true
                ),
                'tab'   =>  'design'
            ))
        );

        //  single post panel
        $wp_customize->add_panel( 'news_event_single_panel', array(
            'title' => esc_html__( 'Single Post', 'news-event' ),
            'priority'  => 73
        ));

        //  single general settings section
        $wp_customize->add_section( 'single_general_settings_section', array(
            'title' => esc_html__( 'General Settings', 'news-event' ),
            'panel' =>  'news_event_single_panel'
        ));

        // single tab section tab
        $wp_customize->add_setting( 'single_post_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, 'single_post_section_tab', array(
                'section'     => 'single_general_settings_section',
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // single post show original image
        $wp_customize->add_setting( 'single_post_show_original_image_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_show_original_image_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Checkbox_Control( $wp_customize, 'single_post_show_original_image_option', array(
                'label'	      => esc_html__( 'Show original image', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_show_original_image_option'
            ))
        );

        // Single Post Image caption
        $wp_customize->add_setting( 'single_post_image_caption', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_image_caption' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Checkbox_Control( $wp_customize, 'single_post_image_caption', array(
                'label'	      => esc_html__( 'Show image caption', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_image_caption'
            ))
        );

        // single post related news heading
        $wp_customize->add_setting( 'single_post_image_settings_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'single_post_image_settings_header', array(
                'label'	      => esc_html__( 'Image Settings', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_image_settings_header'
            ))
        );

        // ticker news image ratio
        $wp_customize->add_setting( 'single_post_image_ratio', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_image_ratio' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'single_post_image_ratio', array(
                    'label'	      => esc_html__( 'Image Ratio', 'news-event' ),
                    'section'     => 'single_general_settings_section',
                    'settings'    => 'single_post_image_ratio',
                    'unit'        => 'px',
                    'input_attrs' => array(
                    'max'         => 2,
                    'min'         => 0,
                    'step'        => 0.1,
                    'reset' => true
                )
            ))
        );

        // Width Layouts setting heading
        $wp_customize->add_setting( 'single_post_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'single_post_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_width_layout_header',
                'tab'   => 'design'
            ))
        );

        // width layout
        $wp_customize->add_setting( 'single_post_width_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'single_post_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'single_post_width_layout',
            array(
                'section'  => 'single_general_settings_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // single post typography heading
        $wp_customize->add_setting( 'single_post_typo_heading', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Toggle_Control( $wp_customize, 'single_post_typo_heading', array(
                'label' => esc_html__( 'Typography', 'news-event' ),
                'section'   => 'single_general_settings_section',
                'tab'   => 'design'
            ))
        );

        // single post title typo
        $wp_customize->add_setting( 'single_post_title_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_title_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_title_typo', array(
                'label'	      => esc_html__( 'Post Title', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_title_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );

        // single post meta typo
        $wp_customize->add_setting( 'single_post_meta_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_meta_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_meta_typo', array(
                'label'	      => esc_html__( 'Post Meta', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_meta_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );
        
        // single post content typo
        $wp_customize->add_setting( 'single_post_content_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_content_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_content_typo', array(
                'label'	      => esc_html__( 'Post Content', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_content_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );

        // h1 typo
        $wp_customize->add_setting( 'single_post_content_h1_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_content_h1_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_content_h1_typo', array(
                'label'	      => esc_html__( 'H1 Typography', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_content_h1_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );

        // h2 typo
        $wp_customize->add_setting( 'single_post_content_h2_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_content_h2_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_content_h2_typo', array(
                'label'	      => esc_html__( 'H2 Typography', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_content_h2_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );

        // h3 typo
        $wp_customize->add_setting( 'single_post_content_h3_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_content_h3_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_content_h3_typo', array(
                'label'	      => esc_html__( 'H3 Typography', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_content_h3_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );

        // h4 typo
        $wp_customize->add_setting( 'single_post_content_h4_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_content_h4_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_content_h4_typo', array(
                'label'	      => esc_html__( 'H4 Typography', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_content_h4_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );

        // h5 typo
        $wp_customize->add_setting( 'single_post_content_h5_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_content_h5_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_content_h5_typo', array(
                'label'	      => esc_html__( 'H5 Typography', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_content_h5_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );

        // h6 typo
        $wp_customize->add_setting( 'single_post_content_h6_typo', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_content_h6_typo' ),
            'sanitize_callback' => 'news_event_sanitize_typo_control',
            'transport' => 'postMessage',
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Typography_Control( $wp_customize, 'single_post_content_h6_typo', array(
                'label'	      => esc_html__( 'H6 Typography', 'news-event' ),
                'section'     => 'single_general_settings_section',
                'settings'    => 'single_post_content_h6_typo',
                'fields'    => array( 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration'),
                'tab'   => 'design'
            ))
        );

        // single related posts
        $wp_customize->add_section( 'single_related_posts_section', array(
            'title' => esc_html__( 'Related Posts', 'news-event' ),
            'panel' =>  'news_event_single_panel'
        ));

        // related news option
        $wp_customize->add_setting( 'single_post_related_posts_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_post_related_posts_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Simple_Toggle_Control( $wp_customize, 'single_post_related_posts_option', array(
                'label'	      => esc_html__( 'Show related news', 'news-event' ),
                'section'     => 'single_related_posts_section',
                'settings'    => 'single_post_related_posts_option'
            ))
        );

        // related news title
        $wp_customize->add_setting( 'single_post_related_posts_title', array(
            'default' => NEV\news_event_get_customizer_default( 'single_post_related_posts_title' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 'single_post_related_posts_title', array(
            'type'      => 'text',
            'section'   => 'single_related_posts_section',
            'label'     => esc_html__( 'Related news title', 'news-event' )
        ));

        // blog archive pagination section
        $wp_customize->add_section( 'news_event_blog_archive_pagination_section', array(
            'title' => esc_html__( 'Pagination', 'news-event' ),
            'panel' => 'news_event_blog_post_archive_panel',
            'priority'  => 10
        ));
        
        // archive pagination type
        $wp_customize->add_setting( 'archive_pagination_type', array(
            'default' => NEV\news_event_get_customizer_default( 'archive_pagination_type' ),
            'sanitize_callback' => 'news_event_sanitize_select_control'
        ));
        $wp_customize->add_control( 'archive_pagination_type', array(
            'label'     => esc_html__( 'Pagination Type', 'news-event' ),
            'type'      => 'select',
            'section'   => 'news_event_blog_archive_pagination_section',
            'choices'   => array(
                'default'   => esc_html__( 'Default', 'news-event' ),
                'number'    => esc_html__( 'Number', 'news-event' )
            ),
        ));
    }
    add_action( 'customize_register', 'news_event_customizer_blog_post_archive_panel', 10 );
endif;

if( !function_exists( 'news_event_customizer_page_panel' ) ) :
    /**
     * Register global options settings
     * 
     */
    function news_event_customizer_page_panel( $wp_customize ) {
        // page panel
        $wp_customize->add_panel( 'news_event_page_panel', array(
            'title' => esc_html__( 'Page Settings', 'news-event' ),
            'priority'  => 74
        ));

        // 404 section
        $wp_customize->add_section( 'news_event_page_section', array(
            'title' => esc_html__( 'Page Setting', 'news-event' ),
            'panel' => 'news_event_page_panel',
            'priority'  => 10
        ));

        // Width Layouts setting heading
        $wp_customize->add_setting( 'single_page_width_layout_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'single_page_width_layout_header', array(
                'label'	      => esc_html__( 'Width Layouts', 'news-event' ),
                'section'     => 'news_event_page_section',
                'settings'    => 'single_page_width_layout_header'
            ))
        );

        // width layout
        $wp_customize->add_setting( 'single_page_width_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'single_page_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'single_page_width_layout',
            array(
                'section'  => 'news_event_page_section',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // show original image
        $wp_customize->add_setting( 'single_page_show_original_image_option', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_page_show_original_image_option' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Checkbox_Control( $wp_customize, 'single_page_show_original_image_option', array(
                'label'	      => esc_html__( 'Show original image', 'news-event' ),
                'section'     => 'news_event_page_section',
                'settings'    => 'single_page_show_original_image_option'
            ))
        );

        // single page image caption
        $wp_customize->add_setting( 'single_page_image_caption', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_page_image_caption' ),
            'sanitize_callback' => 'news_event_sanitize_toggle_control'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Checkbox_Control( $wp_customize, 'single_page_image_caption', array(
                'label'	      => esc_html__( 'Show image caption', 'news-event' ),
                'section'     => 'news_event_page_section',
                'settings'    => 'single_page_image_caption'
            ))
        );

        // single post related news heading
        $wp_customize->add_setting( 'single_page_image_settings_header', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Heading_Control( $wp_customize, 'single_page_image_settings_header', array(
                'label'	      => esc_html__( 'Image Settings', 'news-event' ),
                'section'     => 'news_event_page_section',
                'settings'    => 'single_page_image_settings_header'
            ))
        );

        // ticker news image ratio
        $wp_customize->add_setting( 'single_page_image_ratio', array(
            'default'   => NEV\news_event_get_customizer_default( 'single_page_image_ratio' ),
            'sanitize_callback' => 'news_event_sanitize_responsive_range',
            'transport' => 'postMessage'
        ));
        $wp_customize->add_control(
            new News_Event_WP_Responsive_Range_Control( $wp_customize, 'single_page_image_ratio', array(
                    'label'	      => esc_html__( 'Image Ratio', 'news-event' ),
                    'section'     => 'news_event_page_section',
                    'settings'    => 'single_page_image_ratio',
                    'unit'        => 'px',
                    'input_attrs' => array(
                    'max'         => 2,
                    'min'         => 0,
                    'step'        => 0.1,
                    'reset' => true
                )
            ))
        );

        // 404 section
        $wp_customize->add_section( 'news_event_404_section', array(
            'title' => esc_html__( '404', 'news-event' ),
            'panel' => 'news_event_page_panel',
            'priority'  => 20
        ));

        // 404 section tab
        $wp_customize->add_setting( '404_section_tab', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default'   => 'general'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Section_Tab_Control( $wp_customize, '404_section_tab', array(
                'section'     => 'news_event_404_section',
                'priority'  => 1,
                'choices'  => array(
                    array(
                        'name'  => 'general',
                        'title'  => esc_html__( 'General', 'news-event' )
                    ),
                    array(
                        'name'  => 'design',
                        'title'  => esc_html__( 'Design', 'news-event' )
                    )
                )
            ))
        );

        // 404 image field
        $wp_customize->add_setting( 'error_page_image', array(
            'default' => NEV\news_event_get_customizer_default( 'error_page_image' ),
            'sanitize_callback' => 'absint',
        ));
        $wp_customize->add_control(new WP_Customize_Media_Control($wp_customize, 'error_page_image', array(
            'section' => 'news_event_404_section',
            'mime_type' => 'image',
            'label' => esc_html__( '404 Image', 'news-event' ),
            'description' => esc_html__( 'Upload image that shows you are on 404 error page', 'news-event' )
        )));

        // width layout
        $wp_customize->add_setting( 'error_page_width_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'error_page_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'error_page_width_layout',
            array(
                'section'  => 'news_event_404_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));

        // search page section
        $wp_customize->add_section( 'news_event_search_page_section', array(
            'title' => esc_html__( 'Search Page', 'news-event' ),
            'panel' => 'news_event_page_panel',
            'priority'  => 30
        ));

        // width layout
        $wp_customize->add_setting( 'search_page_width_layout', array(
            'default'           => NEV\news_event_get_customizer_default( 'search_page_width_layout' ),
            'sanitize_callback' => 'news_event_sanitize_select_control',
            'transport' =>  'postMessage'
        ));
        $wp_customize->add_control( 
            new News_Event_WP_Radio_Image_Control( $wp_customize, 'search_page_width_layout',
            array(
                'section'  => 'news_event_search_page_section',
                'tab'   => 'design',
                'choices'  => array(
                    'global' => array(
                        'label' => esc_html__( 'Global', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/global.jpg'
                    ),
                    'boxed--layout' => array(
                        'label' => esc_html__( 'Boxed', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/boxed_content.jpg'
                    ),
                    'full-width--layout' => array(
                        'label' => esc_html__( 'Full Width', 'news-event' ),
                        'url'   => '%s/assets/images/customizer/full_content.jpg'
                    )
                )
            )
        ));
    }
    add_action( 'customize_register', 'news_event_customizer_page_panel', 10 );
endif;