/* global wp, jQuery */
/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

 ( function( $ ) {
	const themeContstants = {
		prefix: 'news_event_'
	}
	const themeCalls = {
		newsEventGenerateStyleTag: function( code, id ) {
			if( code ) {
				if( $( "head #" + id ).length > 0 ) {
					$( "head #" + id ).html( code )
				} else {
					$( "head" ).append( '<style id="' + id + '">' + code + '</style>' )
				}
			}
		},
		newsEventGenerateTypoCss: function( obj = {} ) {
			const { selector = 'body.news-event-variables', value, property } = obj,
				{ preset = '-1', font_family, font_weight, text_transform, text_decoration, font_size, line_height, letter_spacing } = value,
				isVariable = ( selector === 'body.news-event-variables' ),
				selPro = isVariable ? property : selector;

			typographyFunctions.typoFontsEnqueue( value )
			var cssCode = ''
			if( isVariable ) {
				cssCode += 'body.news-event-variables {\n'
			} else {
				cssCode = selPro + '{\n'
			}
			if( font_family ) cssCode += `${( isVariable ? `${ selPro }-family` : 'font-family' )}: ${ this.newsEventGetTypographyFormat( preset, font_family.value, '-family' ) };\n`

			if( font_weight ) cssCode += `${( isVariable ? `${ selPro }-weight` : 'font-weight' )}: ${ this.newsEventGetTypographyFormat( preset, font_weight.value, '-weight' ) };\n${( isVariable ? `${ selPro }-style` : 'font-style' )}: ${ this.newsEventGetTypographyFormat( preset, font_weight.variant, '-style' ) };\n`
			
			if( text_transform ) cssCode += `${( isVariable ? `${ selPro }-texttransform` : 'text-transform' )}: ${ this.newsEventGetTypographyFormat( preset, text_transform, '-texttransform' )};\n`

			if( text_decoration ) cssCode += `${( isVariable ? `${ selPro }-textdecoration` : 'text-decoration' )}: ${ this.newsEventGetTypographyFormat( preset, text_decoration, '-textdecoration' )};\n`

			if( font_size.desktop ) cssCode += `${( isVariable ? `${ selPro }-size` : 'font-size' )}: ${ this.newsEventGetTypographyFormat( preset, font_size.desktop, '-size' ) };\n`

			if( line_height.desktop ) cssCode += `${( isVariable ? `${ selPro }-lineheight` : 'line-height' )}: ${ this.newsEventGetTypographyFormat( preset, line_height.desktop, '-lineheight' ) };\n`

			if( letter_spacing.desktop ) cssCode += `${( isVariable ? `${ selPro }-letterspacing` : 'letter-spacing' )}: ${ this.newsEventGetTypographyFormat( preset, letter_spacing.desktop, '-letterspacing' ) };\n`
			if( ! isVariable ) cssCode += '}'

			if( ! isVariable ) cssCode += `@media(max-width: 940px) {\n${ isVariable ? 'body.news-event-variables ' : `${ selPro } ` } {\n`
			if( line_height.tablet ) cssCode += `${( isVariable ? `${ selPro }-lineheight-tab` : 'line-height' )}: ${ this.newsEventGetTypographyFormat( preset, line_height.tablet, '-lineheight-tab' ) };\n`
			if( letter_spacing.tablet ) cssCode += `${( isVariable ? `${ selPro }-letterspacing-tab` : 'letter-spacing' )}: ${ this.newsEventGetTypographyFormat( preset, letter_spacing.tablet, '-letterspacing-tab' ) };\n`
			if( font_size.tablet ) cssCode += `${( isVariable ? `${ selPro }-size-tab` : 'font-size' )}: ${ this.newsEventGetTypographyFormat( preset, font_size.tablet, '-size-tab' ) };\n`
			if( ! isVariable ) cssCode += '}}'
			
			if( ! isVariable ) cssCode += `@media(max-width: 610px) {\n${ isVariable ? 'body.news-event-variables ' : `${ selPro } ` } {\n`
			if( line_height.smartphone ) cssCode += `${( isVariable ? `${ selPro }-lineheight-mobile` : 'line-height' )}: ${ this.newsEventGetTypographyFormat( preset, line_height.smartphone, '-lineheight-mobile' ) };\n`
			if( letter_spacing.smartphone ) cssCode += `${( isVariable ? `${ selPro }-letterspacing-mobile` : 'letter-spacing' )}: ${ this.newsEventGetTypographyFormat( preset, letter_spacing.smartphone, '-letterspacing-mobile' ) };\n`
			if( font_size.smartphone ) cssCode += `${( isVariable ? `${ selPro }-size-mobile` : 'font-size' )}: ${ this.newsEventGetTypographyFormat( preset, font_size.smartphone, '-size-mobile' ) };\n`
			if( ! isVariable ) cssCode += '}}'

			if( isVariable ) cssCode += '}'

			return cssCode
		},
		newsEventGetTypographyFormat: function( preset, value, suffix ) {
			if( preset === '-1' ) {
				let unitsArray = [ '-size', '-lineheight', '-letterspacing', '-lineheight-tab', '-letterspacing-tab', '-size-tab', '-lineheight-mobile', '-letterspacing-mobile', '-size-mobile' ]
				return ( unitsArray.includes( suffix ) ) ? value + 'px' : value;
			} else {
				let variable = 'var(--news-event-global-preset-typography-' + ( parseInt( preset ) + 1 ) + '-font' + suffix + ')';
				return variable
			}
		}
	}

	/**
	 * Controls
	 * 
	 * @since 1.0.0
	 */
	const NEVControls = {
		generateId( controlId ) {
			return controlId.replaceAll( '_', '-' );
		},
		color( obj = {} ){
			const THIS = this;
			let { controlId, selector = 'body.news-event-variables', property = 'background' } = obj,
				styleId = this.generateId( controlId ),
				isVariable = ( selector === 'body.news-event-variables' );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let cssCode = '',
						isObject = ( typeof to === 'object' ),
						isHover = ( isObject && ( 'hover' in to ) );
					if( isHover ) {
						let hoverProperty =  `${ property }${ isVariable ? '-' : ':' }hover`,
							{ initial, hover } = to;
						cssCode += `${ selector } { ${ property }: ${ THIS.getColorCSS( initial ) }; }\n`
						cssCode += `${ selector } { ${ hoverProperty }: ${ THIS.getColorCSS( hover ) }; }\n`
					} else {
						if( isObject && ( 'image' in to ) ) {
							cssCode += `${ selector } { ${ isObject ? THIS.getColorCSS( to ) : to }; }`
						} else {
							cssCode += `${ selector } { ${ property }: ${ isObject ? THIS.getColorCSS( to ) : to }; }`
						}
					}

					themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-' + styleId )
				});
			});
		},
		getColorCSS( color ){
			let cssCode = '';
			switch( color.type ) {
				case 'image' : 
						let { repeat = 'no-repeat', position = 'left top', attachment = 'fixed', size = 'auto'  } = color
						if( 'id' in color.image ) cssCode += 'background-image: url(' + color.image.url + ');\n'
						cssCode += " background-repeat: "+ repeat + ';\n'
						cssCode += " background-position: "+ position + ';\n'
						cssCode += " background-attachment: "+ attachment + ';\n'
						cssCode += " background-size: "+ size + ';\n'
					break;
				default: 
						cssCode = helperFunctions.getFormatedColor( color[color.type] )
					break;
			}
			return cssCode;
		},
		typography( obj = {} ){
			let { controlId, selector = 'body.news-event-variables', property } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let cssCode = themeCalls.newsEventGenerateTypoCss({ value: to, selector, property })
					themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-' + styleId )
				})
			})
		},
		number( obj = {} ) {
			let { controlId, selector, property } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let cssCode = `${ selector }{ ${ property }: ${ to }px }`;
					themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-' + styleId )
				});
			});
		},
		responsiveSlider( obj = {} ) {
			let { controlId, selector = 'body.news-event-variables', property = 'border-radius', unit = 'px' } = obj,
				styleId = this.generateId( controlId ),
				isVariable = ( selector === 'body.news-event-variables' );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let { desktop, tablet, smartphone } = to,
						cssCode = '';

					if( isVariable ) {
						cssCode += `${ selector } {\n`
						if( desktop ) cssCode += `${ property } : ${ desktop }${ unit };\n`;
						if( tablet ) cssCode += `${ property }-tab: ${ tablet }${ unit };\n`
						if( smartphone ) cssCode += `${ property }-mobile: ${ smartphone }${ unit };\n`
						cssCode += '}'
					} else {
						if( desktop ) cssCode += `${ selector } { ${ property }: ${ desktop }${ unit } }`
						if( tablet ) cssCode += `@media(max-width: 940px) { ${ selector } { ${ property }: ${ tablet }${ unit } } }`
						if( smartphone ) cssCode += `@media(max-width: 610px) { ${ selector } { ${ property }: ${ smartphone }${ unit } } }`
					}
					themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-' + styleId )
				});
			});
		},
		globalContentLayout( obj = {} ) {
			let { controlId, selector, prefix = 'width-' } = obj
			wp.customize( controlId, function( value ) {
				value.bind( function(to) {
					let container = $( selector )
					container.removeClass( `${ prefix }boxed--layout ${ prefix }full-width--layout` )
					if( to === 'global' ) {
						if( $( 'body' ).hasClass( 'global-content-layout--boxed--layout' ) ) {
							container.addClass( `${ prefix }boxed--layout` )
						} else {
							container.addClass( `${ prefix }full-width--layout` )
						}
					} else {
						container.addClass( prefix + to )
					}
				});
			});
		},
		toggleClassWithPrefix( obj = {} ) {
			let { controlId, selector = 'body', prefix = '' } = obj
			wp.customize( controlId, function( value ) {
				value.bind( function(to) {
					$( selector ).removeClass(function( index, currentClass ){
						return currentClass.split( /\s+/ ).filter( className => className.startsWith( prefix )).join( ' ' );
					}).addClass( prefix + to )
				});
			});
		},
		toggleClass( obj = {} ) {
			let { controlId, selector = 'body', classToToggle = '' } = obj
			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					if( to ) {
						$( selector ).addClass( classToToggle )
					} else {
						$( selector ).removeClass( classToToggle )
					}
				});
			});
		},
		border( obj = {} ) {
			let { controlId, selector = 'body', property = 'border' } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let { type, color, width } = to
						cssCode = `${ selector } {\n`;

					if( type === 'none' ) {
						cssCode += `${ property }: none;`
					} else {
						cssCode += `${ property }: ${ width }px ${ type } ${ helperFunctions.getFormatedColor( color ) };`
					}
					cssCode += '}'
					themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-' + styleId )
				});
			});
		},
		dimension( obj = {} ) {
			let { controlId, selector = 'body', property = 'padding' } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let { desktop, tablet, smartphone } = to
						cssCode = '';

					if( desktop ) {
						cssCode += `${ selector } { ${ property }: ${ desktop.top }px ${ desktop.right }px ${ desktop.bottom }px ${ desktop.left }px; }`
					}
					if( tablet ) {
						cssCode += `@media(max-width: 940px) { ${ selector } { ${ property }: ${ tablet.top }px ${ tablet.right }px ${ tablet.bottom }px ${ tablet.left }px; } }`
					}
					if( smartphone ) {
						cssCode += `@media(max-width: 610px) { ${ selector } { ${ property }: ${ smartphone.top }px ${ smartphone.right }px ${ smartphone.bottom }px ${ smartphone.left }px; } }`
					}
					themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-' + styleId )
				});
			});
		},
		boxShadow( obj = {} ) {
			let { controlId, selector = 'body' } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					var cssCode = ''
					if( to && to.option != 'none' ) {
						let boxShadowValue = `${ ( to.type === 'outset' ) ? '' : to.type } ${ to.hoffset }px ${ to.voffset }px ${ to.blur }px ${ to.spread }px ${ news_event_get_color_format( to.color ) }`
						cssCode += `${ selector } { box-shadow: ${ boxShadowValue }; -webkit-box-shadow: ${ boxShadowValue }; -moz-box-shadow ${ boxShadowValue } }`
					} else {
						cssCode += `${ selector } { box-shadow: 0px 0px 0px 0px; }`
					}
					themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-' + styleId )
				});
			});
		}
	}

	// post title hover class
	NEVControls.toggleClassWithPrefix({ controlId: 'post_title_hover_effects', prefix: 'news-event-title-' })

	// website layout class
	NEVControls.toggleClassWithPrefix({ controlId: 'website_layout', removeClass: 'site-boxed--layout site-full-width--layout', prefix: 'site-' })

	// image hover class
	NEVControls.toggleClassWithPrefix({ controlId: 'site_image_hover_effects', prefix: 'news-event-image-hover--effect-' })
	
	// main banner five trailing layout styles 
	NEVControls.toggleClassWithPrefix({ controlId: 'main_banner_six_trailing_posts_layout', prefix: 'layout--', selector: '#main-banner-section.banner-layout--six' })

	// theme color bind changes
	NEVControls.color({ controlId: 'theme_color', property: '--news-event-global-preset-theme-color' });

	// solid presets
	wp.customize( 'solid_presets', function( value ) {
		value.bind( function( to ) {
			if( Array.isArray( to ) ) {
				let cssCode = "body.news-event-variables{\n"
				to.map(( color, index ) => {
					let count = ( index + 1 )
					cssCode += `--news-event-global-preset-color-${ count }: ${ helperFunctions.getFormatedColor( color ) };\n`
				})
				cssCode += "\n}"
				themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-solid-presets' )
			}
		});
	});

	// gradient presets
	wp.customize( 'gradient_presets', function( value ) {
		value.bind( function( to ) {
			if( Array.isArray( to ) ) {
				let cssCode = "body.news-event-variables{\n"
				to.map(( color, index ) => {
					let count = ( index + 1 )
					cssCode += `--news-event-global-preset-gradient-color-${ count }: ${ helperFunctions.getFormatedColor( color ) };\n`
				})
				cssCode += "\n}"
				themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-gradient-presets' )
			}
		});
	});

	// header menu hover effect 
	NEVControls.toggleClassWithPrefix({ controlId: 'header_menu_hover_effect', prefix: 'hover-effect--', selector: '#site-navigation' })

	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	});
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	});

	// blog description
	wp.customize( 'blogdescription_option', function( value ) {
		value.bind(function(to) {
			if( to ) {
				$( '.site-description' ).css( {
					clip: 'auto',
					position: 'relative',
				} );
			} else {
				$( '.site-description' ).css( {
					clip: 'rect(1px, 1px, 1px, 1px)',
					position: 'absolute',
				} );
			}
		})
	});

	// site title color
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title' ).css( {
					clip: 'rect(1px, 1px, 1px, 1px)',
					position: 'absolute',
				} );
			} else {
				$( '.site-title' ).css( {
					clip: 'auto',
					position: 'relative',
				} );
			}
		} );
	});
	NEVControls.color({ controlId: 'header_textcolor', selector: 'body header.site-header .main-header .site-title a', property: 'color' });

	// site description color
	NEVControls.color({ controlId: 'site_description_color', selector: '.site-description', property: 'color' });

	// site title typo
	NEVControls.typography({ controlId: 'site_title_typo', property: '--site-title' });
	
	// site tagline typo
	NEVControls.typography({ controlId: 'site_tagline_typo', property: '--site-tagline' });

	// side background color
	NEVControls.color({ controlId: 'site_background_color', property: '--site-bk-color' });

	// category colors text colors
	var parsedCats = newsEventPreviewObject.totalCats
	if( parsedCats ) {
		Object.values( parsedCats ).forEach(function(item) {
			wp.customize( 'category_' + item + '_color', function( value ) {
				value.bind( function(to) {
					let cssCode = '',
						{ initial, hover } = to
					if( initial ) {
						cssCode += "body #page .post-categories .cat-item.cat-" + item + " a{ background : " + news_event_get_color_format( initial[ initial.type ] ) + " } "
						cssCode += "body #page .news-event-category-no-bk .post-categories .cat-item.cat-" + item.term_id + " a { color : " + news_event_get_color_format( initial[ initial.type ] ) + " } "
					}
					if( hover ) {
						cssCode += "body #page .post-categories .cat-item.cat-" + item + " a:hover { background : " + news_event_get_color_format( hover[ hover.type ] ) + " } "
						cssCode += "body #page .news-event-category-no-bk .post-categories .cat-item.cat-" + item.term_id + " a:hover { color : " + news_event_get_color_format( hover[ hover.type ] ) + " } "
					}
					themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-category-' + item + '-style' )
				})
			})
		})
	}

	// global typography block title
	NEVControls.typography({ controlId: 'site_section_block_title_typo', property: '--block-title' });
	
	// global typography post title
	NEVControls.typography({ controlId: 'site_archive_post_title_typo', property: '--post-title' });

	// global typography post meta
	NEVControls.typography({ controlId: 'site_archive_post_meta_typo', property: '--meta' });

	// global typography post content
	NEVControls.typography({ controlId: 'site_archive_post_content_typo', property: '--content' });
	
	// global buttons typography
	NEVControls.typography({ controlId: 'global_button_typo', property: '--post-link-btn' });

	// top header background
	NEVControls.color({ controlId: 'top_header_background_color_group', selector: '.news_event_main_body .site-header.layout--default .top-header' });

	// theme header general settings vertical padding
	NEVControls.responsiveSlider({ controlId: 'header_vertical_padding', property: '--header-padding' })

	// theme header general settings background
	NEVControls.color({ controlId: 'header_background_color_group', selector: 'body.news_event_main_body .site-header.layout--default .site-branding-section, .search-popup--style-three .site-header.layout--three .search-form-wrap' });

	// newsletter background color
	NEVControls.color({ controlId: 'header_newsletter_background_color', property: '--newsletter-bk-color' });
	
	// menu options background
	NEVControls.color({ controlId: 'header_menu_background_color_group', selector: '.news_event_main_body .site-header.layout--default .menu-section, .news_event_main_body .site-header.layout--three .header-smh-button-wrap, .search-popup--style-three .site-header.layout--one .search-form-wrap, .search-popup--style-three .site-header.layout--two .search-form-wrap' });

	// menu options background
	NEVControls.color({ controlId: 'header_sub_menu_background_color_group', selector: '.news_event_main_body .main-navigation ul.menu ul, .news_event_main_body .main-navigation ul.nav-menu ul' });

	// main menu typo
	NEVControls.typography({ controlId: 'header_menu_typo', property: '--menu' });

	// main menu typo
	NEVControls.typography({ controlId: 'header_sub_menu_typo', property: '--submenu' });

	// off canvas sidebar position
	NEVControls.toggleClassWithPrefix({ controlId: 'off_canvas_position', prefix: 'off-canvas-sidebar-appear--', selector: 'body.news_event_main_body' })

	// banner border radius
	NEVControls.responsiveSlider({ 
		controlId: 'main_banner_image_border_radius', 
		property: 'border-radius',
		selector: 'body #main-banner-section article'
	})

	// front sections full width section background
	NEVControls.color({ controlId: 'full_width_blocks_background_color_group', selector: '.news_event_main_body #full-width-section, body #full-width-section .layout--four .news-list-post-wrap .list-item .post-title, #full-width-section .news-grid.layout--four .post-element, #full-width-section .news-carousel.layout--four .post-element' });

	// front sections left content right sidebar section background
	NEVControls.color({ controlId: 'leftc_rights_blocks_background_color_group', selector: '.news_event_main_body #leftc-rights-section, body #leftc-rights-section .layout--four .news-list-post-wrap .list-item .post-title, #leftc-rights-section .news-grid.layout--four .post-element, #leftc-rights-section .widget .posts-grid-wrap .post-content-wrap, #leftc-rights-section .news-carousel.layout--four .post-element' });

	// front sections left sidebar right content section background
	NEVControls.color({ controlId: 'lefts_rightc_blocks_background_color_group', selector: '.news_event_main_body #lefts-rightc-section, body #lefts-rightc-section .layout--four .news-list-post-wrap .list-item .post-title, #lefts-rightc-section .news-grid.layout--four .post-element, #lefts-rightc-section .widget .posts-grid-wrap.layout-two .post-content-wrap, #lefts-rightc-section .news-carousel.layout--four .post-element' });

	// front sections bottom full width section background
	NEVControls.color({ controlId: 'bottom_full_width_blocks_background_color_group', selector: '.news_event_main_body #bottom-full-width-section, body #bottom-full-width-section .layout--four .news-list-post-wrap .list-item .post-title, #bottom-full-width-section .news-grid.layout--four .post-element, #bottom-full-width-section .news-carousel.layout--four .post-element' });
	
	// front sections two column section background
	NEVControls.color({ controlId: 'two_column_background_color_group', selector: '.news_event_main_body .two-column-section, body .two-column-section .layout--four .news-list-post-wrap .list-item .post-title, .two-column-section .news-grid.layout--four .post-element, .two-column-section .news-carousel.layout--four .post-element' });
	
	// blogs / archive image ratio
	NEVControls.responsiveSlider({ controlId: 'archive_image_ratio', property: '--news-event-archive-image-ratio', unit: '' })

	// opinions vertical spacing top
	NEVControls.responsiveSlider({ controlId: 'archive_vertical_spacing_top', property: '--archive-padding-top' })
	
	// archive vertical spacing bottom
	NEVControls.responsiveSlider({ controlId: 'archive_vertical_spacing_bottom', property: '--archive-padding-bottom' })

	// single post show original image
	wp.customize('single_post_show_original_image_option', function( value ) {
		value.bind(function( to ) {
			if( to ) {
				$('body.news_event_main_body.single main#primary .post-inner-wrapper .post-thumbnail').addClass('show-original-image')
			} else {
				$('body.news_event_main_body.single main#primary .post-inner-wrapper .post-thumbnail').removeClass('show-original-image')
			}
		})
	})

	// single post related news title
	wp.customize('single_post_related_posts_title', function( value ) {
		value.bind(function( to ) {
			var parentElement = $('body.news_event_main_body #theme-content .post-inner-wrapper .single-related-posts-section')
			if( parentElement.find( '.news-event-block-title' ).length > 0 ) {
				parentElement.find( '.news-event-block-title span' ).text( to )
			} else {
				parentElement.find( '.related_post_close' ).after('<h2 class="news-event-block-title"><span>'+ to +'</span></h2>')
			}
		})
	})

	// single post image ratio
	NEVControls.responsiveSlider({ controlId: 'single_post_image_ratio', property: '--news-event-single-image-ratio', unit: '' })

	// single post post title typo
	NEVControls.typography({ controlId: 'single_post_title_typo', property: '--single-title' });

	// single post post meta typo
	NEVControls.typography({ controlId: 'single_post_meta_typo', property: '--single-meta' });

	// single post post content typo
	NEVControls.typography({ controlId: 'single_post_content_typo', property: '--single-content' });

	// single post h1 typo
	NEVControls.typography({ controlId: 'single_post_content_h1_typo', property: '--single-content-h1' });

	// single post h2 typo
	NEVControls.typography({ controlId: 'single_post_content_h2_typo', property: '--single-content-h2' });

	// single post h3 typo
	NEVControls.typography({ controlId: 'single_post_content_h3_typo', property: '--single-content-h3' });

	// single post h4 typo
	NEVControls.typography({ controlId: 'single_post_content_h4_typo', property: '--single-content-h4' });

	// single post h5 typo
	NEVControls.typography({ controlId: 'single_post_content_h5_typo', property: '--single-content-h5' });

	// single post h6 typo
	NEVControls.typography({ controlId: 'single_post_content_h6_typo', property: '--single-content-h6' });

	// single page show original image
	wp.customize('single_page_show_original_image_option', function( value ) {
		value.bind(function( to ) {
			if( to ) {
				$('body.news_event_main_body.page main#primary .post-inner-wrapper .post-thumbnail').addClass('show-original-image')
			} else {
				$('body.news_event_main_body.page main#primary .post-inner-wrapper .post-thumbnail').removeClass('show-original-image')
			}
		})
	})

	// page settings image ratio
	NEVControls.responsiveSlider({ controlId: 'single_page_image_ratio', property: '--news-event-page-image-ratio', unit: '' })

	// theme footer border top
	NEVControls.border({ controlId: 'footer_top_border', selector: 'body .site-footer.dark_bk', property: 'border-top' });

	// theme footer background
	NEVControls.color({ controlId: 'footer_background_color_group', selector: 'body.news_event_main_body .site-footer .main-footer, body .dark_bk .posts-grid-wrap.layout-two .post-content-wrap' });
	
	// bottom footer background
	NEVControls.color({ controlId: 'bottom_footer_background_color_group', selector: 'body.news_event_main_body .site-footer .bottom-footer' });

	// bottom footer menu option
	wp.customize( 'bottom_footer_menu_option', function( value ) {
		value.bind( function( to ) {
			if( to ) {
				$( '.bottom-footer .bottom-menu' ).show()
			} else {
				$( '.bottom-footer .bottom-menu' ).hide()
			}
		});
	});

	// news_event_preloader_section

	// prloader handler
	wp.customize( 'preloader_type', function( value ) {
		value.bind( function( to ) {
			var loaderItem = $( 'body .news_event_loading_box .loader-item' )
			$( "body .news_event_loading_box" ).show()
			setTimeout( function() {
				$( "body .news_event_loading_box" ).hide()
			}, 2000)
			loaderItem.removeClass();
			loaderItem.addClass( "loader-item loader-" + to )
		});
	});

	// single post related posts title
	wp.customize( 'single_post_related_posts_title', function( value ) {
		value.bind( function( to ) {
			$( '.single-related-posts-section .news-event-block-title span' ).text( to );
		} );
	});

	// footer width option
	wp.customize( 'footer_section_width', function( value ) {
		value.bind( function( to ) {
			if( to == 'boxed-width' ) {
				$( 'footer .main-footer' ).removeClass( 'full-width' ).addClass( 'boxed-width' );
				$( 'footer .main-footer .footer-inner' ).removeClass( 'news-event-container-fluid' ).addClass( 'news-event-container' );
			} else {
				$( 'footer .main-footer' ).removeClass( 'boxed-width' ).addClass( 'full-width' );
				$( 'footer .main-footer .footer-inner' ).removeClass( 'news-event-container' ).addClass( 'news-event-container-fluid' );
			}
		});
	});

	// archive page layout
	NEVControls.toggleClassWithPrefix({ controlId: 'archive_page_layout', prefix: 'post-layout--' })
	
	// site title hover color
	NEVControls.color({ controlId: 'site_title_hover_textcolor', selector: 'body header.site-header .main-header .site-title a:hover', property: 'color' });
	
	// widget settings border
	NEVControls.border({ 
		controlId: 'widgets_styles_image_border', 
		selector: '.widget .post_thumb_image, .widget .widget-tabs-content .post-thumb, .widget .popular-posts-wrap article .post-thumb, .widget.widget_news_event_news_filter_tabbed_widget .tabs-content-wrap .post-thumb, .widget .news-event-widget-carousel-posts .post-thumb-wrap, .author-wrap.layout-two .post-thumb, .widget_news_event_category_collection_widget .categories-wrap .category-item, .news-event-advertisement-block img'
	});

	// widget border radius
	NEVControls.responsiveSlider({ 
		controlId: 'widgets_styles_image_border_radius', 
		selector: '.widget .post_thumb_image, .widget .widget-tabs-content .post-thumb, .widget .popular-posts-wrap article .post-thumb, .widget.widget_news_event_news_filter_tabbed_widget .tabs-content-wrap .post-thumb, .widget .news-event-widget-carousel-posts .post-thumb-wrap, .author-wrap.layout-two .post-thumb, .widget .news-event-widget-carousel-posts.layout--two .slick-list, .widget_news_event_category_collection_widget .categories-wrap .category-item, .news-event-advertisement-block img'
	})

	// widgets settings box shadow
	NEVControls.boxShadow({
		controlId: 'widgets_styles_image_box_shadow',
		selector: '.widget .post_thumb_image, .widget .widget-tabs-content .post-thumb, .widget .popular-posts-wrap article .post-thumb, .widget.widget_news_event_news_filter_tabbed_widget .tabs-content-wrap .post-thumb, .widget .news-event-widget-carousel-posts.layout--two .slick-list, .author-wrap.layout-two .post-thumb, .widget_news_event_category_collection_widget .categories-wrap .category-item'
	})

	// site logo width
	NEVControls.responsiveSlider({ controlId: 'news_event_site_logo_width', selector: 'body .site-branding img', property: 'width' })

	// author icon
	wp.customize( 'website_author_before_icon', function( value ) {
		value.bind( function(to) {
			let iconClass = ( ( to.type == 'icon' ) ? ' ' + to.value : '' )
			$('body .byline .url.fn.n.author_name').attr( 'class', 'url fn n author_name' + iconClass )
		});
	});

	// post title hover class
	wp.customize( 'frontpage_sidebar_sticky_option', function( value ) {
		value.bind( function(to) {
			if( to ) {
				if( $('body').hasClass( 'home' ) && $('body').hasClass( 'page-template-default' ) ) $( "body" ).addClass( "sidebar-sticky" )
			} else {
				if( $('body').hasClass( 'home' ) && $('body').hasClass( 'page-template-default' ) )  $( "body" ).removeClass( "sidebar-sticky" )
			}
		});
	});

	// post title hover class
	wp.customize( 'archive_sidebar_sticky_option', function( value ) {
		value.bind( function(to) {
			if( to ) {
				if( ( $('body').hasClass( 'home' ) && $('body').hasClass( 'blog' ) ) || $('body').hasClass( 'archive' ) ) $( "body" ).addClass( "sidebar-sticky" )
			} else {
				if( ( $('body').hasClass( 'home' ) && $('body').hasClass( 'blog' ) ) || $('body').hasClass( 'archive' ) ) $( "body" ).removeClass( "sidebar-sticky" )
			}
		});
	});

	// post title hover class
	wp.customize( 'single_sidebar_sticky_option', function( value ) {
		value.bind( function(to) {
			if( to ) {
				if( $('body').hasClass( 'single' ) ) $( "body" ).addClass( "sidebar-sticky" )
			} else {
				if( $('body').hasClass( 'single' ) ) $( "body" ).removeClass( "sidebar-sticky" )
			}
		});
	});

	// post title hover class
	wp.customize( 'page_sidebar_sticky_option', function( value ) {
		value.bind( function(to) {
			if( to ) {
				if( $('body').hasClass( 'page' ) ) $( "body" ).addClass( "sidebar-sticky" )
			} else {
				if( $('body').hasClass( 'page' ) ) $( "body" ).removeClass( "sidebar-sticky" )
			}
		});
	});
	
	// background animation
	wp.customize( 'site_background_animation', function( value ) {
		value.bind( function( to ) {
			let body = $( 'body' )
			body.removeClass( 'background-animation--one background-animation--two background-animation--three background-animation--none' ).addClass( `background-animation--${ to }` )
			if( ! $( 'body .news-event-background-animation' ).length ) {
				let newDiv = '<div class="news-event-background-animation">'
				for( let i = 0; i < 14; i++ ) {
					newDiv += '<span class="item"></span>'
				}
				newDiv += '</div>'
				$( 'body #page.site' ).append( newDiv )
			}
		})
	})

	// animation object color
	NEVControls.color({ controlId: 'animation_object_color', property: '--news-event-animation-object-color' });

	// sst responsive option
	wp.customize( 'stt_responsive_option', function( value ) {
		value.bind( function(to) {
			var cssCode = ''
			if( ! to.desktop ) {
				cssCode += 'body #news-event-scroll-to-top.show { display: none }';
			}
			if( ! to.tablet ) {
				cssCode += '@media(max-width: 940px) { body #news-event-scroll-to-top.show { display : none } }'
			} else {
				cssCode += '@media(max-width: 940px) { body #news-event-scroll-to-top.show { display : block } }'
			}
			if( to.mobile ) {
				cssCode += '@media(max-width: 610px) { body #news-event-scroll-to-top.show { display : block } }'
			} else {
				cssCode += '@media(max-width: 610px) { body #news-event-scroll-to-top.show { display : none } }'
			}
			themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-scroll-to-top-responsive-option' )
		})
	})

	// Global => Website Layout => Website Content Global Layout
	wp.customize( 'website_content_layout', function( value ) {
		value.bind( function(to) {
			$( 'body' ).removeClass( 'global-content-layout--boxed--layout global-content-layout--full-width--layout' ).addClass( 'global-content-layout--' + to )
			// Ticker News
			if( wp.customize( 'ticker_news_width_layout' ).get() === 'global' ) $( 'body .after-header' ).removeClass( 'ticker-news-section--boxed--layout ticker-news-section--full-width--layout' ).addClass( 'ticker-news-section--' + to )
			// Main Banner
			if( wp.customize( 'main_banner_width_layout' ).get() === 'global' ) $( '#main-banner-section' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Front Section => Full Width
			if( wp.customize( 'full_width_blocks_width_layout' ).get() === 'global' ) $( '#full-width-section' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Front Section => Left Content -Right Sidebar => Width Layouts
			if( wp.customize( 'leftc_rights_blocks_width_layout' ).get() === 'global' ) $( '#leftc-rights-section' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Front Section => Left Sidebar -Right Content => Width Layouts
			if( wp.customize( 'lefts_rightc_blocks_width_layout' ).get() === 'global' ) $( '#lefts-rightc-section' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Front Section => Bottom Full Width => Width Layouts
			if( wp.customize( 'bottom_full_width_blocks_width_layout' ).get() === 'global' ) $( '#bottom-full-width-section' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Bottom Footer => Width Layouts
			if( wp.customize( 'bottom_footer_width_layout' ).get() === 'global' ) $( 'body .bottom-footer' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Blog / Archive / Single => Blog / Archive => Width Layouts
			if( wp.customize( 'archive_width_layout' ).get() === 'global' ) $( '.archive #primary.site-main, .home #primary.site-main' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Blog / Archive / Single => Single Post => Width Layouts
			if( wp.customize( 'single_post_width_layout' ).get() === 'global' ) $( '.single #primary.site-main' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Pages => Page => Width Layouts
			if( wp.customize( 'single_page_width_layout' ).get() === 'global' ) $( '.page #primary.site-main' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Pages => 404 => Width Layouts
			if( wp.customize( 'error_page_width_layout' ).get() === 'global' ) $( '.error404 #primary.site-main' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Pages => Search Page => Width Layouts
			if( wp.customize( 'search_page_width_layout' ).get() === 'global' ) $( '.search #primary.site-main' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Front Sections => Two Column Section => Width Layouts
			if( wp.customize( 'two_column_section_layout' ).get() === 'global' ) $( '#two-column-section' ).removeClass( 'width-boxed--layout width-full-width--layout' ).addClass( 'width-' + to )
			// Theme Header => General Settings => Width Layouts
			if( wp.customize( 'header_width_layout' ).get() === 'global' ) $( 'body' ).removeClass( 'header-width--boxed--layout header-width--full-width--layout' ).addClass( 'header-width--' + to )
		});
	});

	// Global => Website Layout => Website Content Global Layout
	NEVControls.globalContentLayout({ controlId: 'ticker_news_width_layout', selector: 'body .after-header', prefix: 'ticker-news-section--' })
	// Main Banner => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'main_banner_width_layout', selector: '#main-banner-section' })
	// Front Section => Full Width => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'full_width_blocks_width_layout', selector: '#full-width-section' })
	// Front Section => Left Content -Right Sidebar => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'leftc_rights_blocks_width_layout', selector: '#leftc-rights-section' })
	// Front Section => Left Sidebar -Right Content => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'lefts_rightc_blocks_width_layout', selector: '#lefts-rightc-section' })
	// Front Section => Bottom Full Width => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'bottom_full_width_blocks_width_layout', selector: '#bottom-full-width-section' })
	// Bottom Footer => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'bottom_footer_width_layout', selector: 'body .bottom-footer' })
	// Blog / Archive / Single => Blog / Archive => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'archive_width_layout', selector: '.archive #primary.site-main, .home #primary.site-main' })
	// Blog / Archive / Single => Single Post => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'single_post_width_layout', selector: '.single #primary.site-main' })
	// Pages => Page => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'single_page_width_layout', selector: '.page #primary.site-main' })
	// Pages => 404 => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'error_page_width_layout', selector: '.error404 #primary.site-main' })
	// Pages => Search Page => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'search_page_width_layout', selector: '.search #primary.site-main' })
	// Front Sections => Two Column Section => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'two_column_section_layout', selector: '#two-column-section' })
	// Theme Header => General Settings => Width Layouts
	NEVControls.globalContentLayout({ controlId: 'header_width_layout', selector: 'body', prefix: 'header-width--' })

	// Social Icons
	NEVControls.number({ selector: 'body .social-icons .social-icon', controlId: 'social_icons_border_radius', property: 'border-radius' })

	// Ads Banner Visibility
	wp.customize( 'header_ads_banner_responsive_option', function( value ) {
		value.bind( function(to) {
			var cssCode = ''
			if( ! to.desktop ) {
				cssCode += 'body .after-header .ads-banner { display: none }';
			}
			if( ! to.tablet ) {
				cssCode += '@media(max-width: 940px) { body .after-header .ads-banner { display : none } }'
			} else {
				cssCode += '@media(max-width: 940px) { body .after-header .ads-banner { display : block } }'
			}
			if( to.mobile ) {
				cssCode += '@media(max-width: 610px) { body .after-header .ads-banner { display : block } }'
			} else {
				cssCode += '@media(max-width: 610px) { body .after-header .ads-banner { display : none } }'
			}
			themeCalls.newsEventGenerateStyleTag( cssCode, 'news-event-header-ads-banner-responsive-option' )
		})
	})
	

	// converts integer to string for attibutes value 
	function news_event_get_numeric_string(int) {
		switch( int ) {
			case 2:
				return "two";
				break;
			case 3:
				return "three";
				break;
			case 4:
				return "four";
				break;
			case 5:
				return "five";
				break;
			case 6:
				return "six";
				break;
			case 7:
				return "seven";
				break;
			case 8:
				return "eight";
				break;
			case 9:
				return "nine";
				break;
			case 10:
				return "ten";
				break;
			default:
				return "one";
		}
	}

	// check if string is variable and formats 
	function news_event_get_color_format(color) {
		if( color == null ) return color
		if( color.indexOf( '--news-event-global-preset' ) >= 0 ) {
			return( 'var( ' + color + ' )' );
		} else {
			return color;
		}
	}

	// constants
	const typographyFunctions = {
		typoFontsEnqueue: function( typography ) {
			const { font_family, font_weight } = typography
			let linkTag = document.getElementById('news-event-generated-typo-fonts')
			let googleFontsUrl = 'https://fonts.googleapis.com/css2?'
			let googleFontsUrlQuery
			let fontStyle = ( font_weight.variant === 'italic' ) ? 'ital,wght@' : 'wght@'
			if( linkTag !== null ) {
				let parser = new URL( linkTag.href )
				let query = parser.search
				let toAppend = this.parseTheFontsQuery( query, typography )
				linkTag.href = googleFontsUrl + toAppend
			} else {
				let newLinkTag = document.createElement('link')
				newLinkTag.rel = 'stylesheet'
				newLinkTag.id = 'news-event-generated-typo-fonts'
				googleFontsUrlQuery = 'family=' + font_family.value + ':' + fontStyle + font_weight.value
				newLinkTag.href = googleFontsUrl + googleFontsUrlQuery
				document.head.appendChild( newLinkTag );
			}
		},
		parseTheFontsQuery: function( query, typography ) {
			const { font_weight:WEIGHT, font_family:FAMILY } = typography
			let toParse = query
			let removeQuestionMark = toParse.replaceAll( '?', '' )
			let filteredQuery = removeQuestionMark.replaceAll( '&', '' )
			let fontFamilyQuery = filteredQuery.split( 'family=' )
			let fontStyleProperty = WEIGHT.variant === 'italic' ? 'ital' : 'wght'
			var fontFamily = [ FAMILY.value ], fontWeight = { [FAMILY.value]: [ WEIGHT.value ] }, fontStyle = { [FAMILY.value]: [ fontStyleProperty ]}
			let filteredFamily = fontFamily.map(( current ) => {
				return current.replaceAll( '%20', ' ' )
			})
			fontFamilyQuery.forEach(( current ) => {
				if( current !== '' ) {
					let splitFamily = current.split( ':' )
					let family = splitFamily[0]
					if ( ! filteredFamily.includes( family ) ) filteredFamily.push( family );
					let splitWeightAndStyle = splitFamily[1].split('@')
					let weight = splitWeightAndStyle[1].replaceAll( '0,', '' ).replaceAll( '1,', '' ).replaceAll( ',', '' )
					let style = splitWeightAndStyle[0]
					if ( ! fontWeight[family] ) fontWeight[family] = []
					if ( ! fontStyle[family] ) fontStyle[family] = []
					if ( ! fontStyle[family].includes( style ) ) fontStyle[family].push( ...style.split(',') );
					
					if ( ! fontWeight[family].includes( weight ) ) fontWeight[family].push( ...weight.split(';') );
				}
			})
			let toAppend = filteredFamily.map(( family ) => {
				let sortedWeights = fontWeight[family].sort(( first, second ) => { return first - second })
				let duplicateRemovedWeights =  [ ...new Set( sortedWeights ) ]	//weights
				let duplicateRemovedStyles =  [ ...new Set( fontStyle[family] ) ]	// styles
				var structuredFontStyles, temporaryStyles = []
				if( duplicateRemovedStyles.includes( 'ital' ) ) {
					duplicateRemovedWeights.forEach(( current ) => { 
						if( current !== undefined && current !== '' ) temporaryStyles.push( '0,' + current + ';' )
					})
					duplicateRemovedWeights.forEach(( current, index ) => { 
						if( current !== undefined && current !== '' ) temporaryStyles.push( '1,' + current + ( index + 1 === duplicateRemovedWeights.length ? '' : ';' ) )
					})
					structuredFontStyles = temporaryStyles.join('')
				} else {
					structuredFontStyles = duplicateRemovedWeights.join(';')
				}
				return 'family=' + family + ':' + duplicateRemovedStyles.sort() + '@' + structuredFontStyles
			}).join('&')
			return toAppend;
		}
	}

	// constants
	const helperFunctions = {
		getFormatedColor: function(color) {
			if( color == null ) return
			if( color.includes('preset') ) {
				return 'var(' + color + ')'
			} else {
				return color
			}
		}
	}
}( jQuery ) );