jQuery(document).ready(function( $ ){
    var ajaxUrl = newsEventNoticeOject.ajaxUrl, _wpnonce = newsEventNoticeOject._wpnonce
    var welcomeOption = newsEventNoticeOject.welcomeOption

    var noticeContainer = $('.news-event-admin-notice')
    if( noticeContainer.length > 0 ) {
        // dismiss notice
        noticeContainer.on('click', '.alert-dismiss, .action-button.review-never, .action-button.already-reviewed', function(){
            var _this = $(this), notice
            if( _this.parents('.news-event-admin-notice').hasClass( 'news-event-welcome-notice' ) ) notice = welcomeOption
            $.ajax({
                url: ajaxUrl,
                method: "POST",
                data: {
                    "action": 'news_event_admin_notice_ajax_call',
                    "_wpnonce": _wpnonce,
                    "dismiss_option": notice
                },
                beforeSend: function(){
                    _this.text( 'Dismissing...' )
                },
                success: function( result ) {
                    var parsedResult = JSON.parse( result )
                    if( parsedResult.status ) _this.parents( '.news-event-admin-notice' ).fadeOut()
                },
                complete: function() {
                    _this.text( 'Dismissed' )
                }
            })
        })
    }
})