<?php

if ( ! isset( $content_width ) ) $content_width = 670;

function newpersonal_wp_title( $title ) {
	global $page, $paged;

	if ( is_feed() )
		return $title;

	$site_description = get_bloginfo( 'description' );

	$filtered_title = $title . get_bloginfo( 'name' );
	$filtered_title .= ( ! empty( $site_description ) && ( is_home() || is_front_page() ) ) ? ' | ' . $site_description: '';
	$filtered_title .= ( 2 <= $paged || 2 <= $page ) ? ' | ' . sprintf( __( 'Page %s', 'newpersonal' ), max( $paged, $page ) ) : '';

	return $filtered_title;
}
add_filter( 'wp_title', 'newpersonal_wp_title' );

function newpersonal_widgets_init() {

	register_sidebar( array(
		'name' => 'Single Post Widgets',
		'id' => 'home_right_1',
		'description' => 'Widgets added here will appear when viewing single posts only.',
		'before_widget' => '',
		'after_widget' => '<br />',
		'before_title' => '<h5 class="sidebarhd">',
		'after_title' => '</h5>',
	) );
	register_sidebar( array(
		'name' => 'Footer Widgets',
		'id' => 'footer-sidebar',
		'description' => 'Appears in the footer area. 3 widgets recommended.',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="sidebarhd2">',
		'after_title' => '</h3>',
	) );

}
add_action( 'widgets_init', 'newpersonal_widgets_init' );

function newpersonal_font_url() {
	$font_url = '';
	/*
	 * Translators: If there are characters in your language that are not supported
	 * by this font, translate this to 'off'. Do not translate into your own language.
	 */
	if ( 'off' !== _x( 'on', 'Open Sans font: on or off', 'newpersonal' ) ) {
		$font_url = add_query_arg( 'family', urlencode( 'Open Sans' ), "//fonts.googleapis.com/css" );
	}

	return $font_url;
}

function newpersonal_scripts() {

// Add font, used in the main stylesheet.
wp_enqueue_style( 'newpersonal-font', newpersonal_font_url(), array(), null );

wp_enqueue_style( 'newpersonal-style', get_stylesheet_uri() );

if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'newpersonal_scripts' );

// Register Theme Features
function newpersonal_setup()  {

// Add theme support for Semantic Markup
$markup = array( 'search-form', 'comment-form', 'comment-list', );
add_theme_support( 'html5', $markup );	

add_theme_support( 'automatic-feed-links' );

add_theme_support( 'post-thumbnails' );
set_post_thumbnail_size( 670, 377, true );
add_image_size( 'category-thumb',  670, 377, true );
add_image_size( 'category-thumb2',  950, 534, true );

register_nav_menu( 'header-menu',__( 'Header Menu', 'newpersonal' ) );

add_editor_style( array( 'editor-style.css', newpersonal_font_url() ) );

}

// Hook into the 'after_setup_theme' action
add_action( 'after_setup_theme', 'newpersonal_setup' );

function newpersonal_custom_header_setup() {
	$args = array(

		// Set height and width, with a maximum value for the width.
		'height'                 => 80,
		'width'                  => 80,
		'max-width'              => 80,
		'default-image' 	 => get_template_directory_uri() . '/images/logo.png',
                'header-text'            => false,

		// Support flexible height and width.
		'flex-height'            => false,
		'flex-width'             => false,

		// Random image rotation off by default.
		'random-default'         => false,

	        'uploads'                => true,
	        'wp-head-callback'       => '',
	        'admin-head-callback'    => '',
	        'admin-preview-callback' => '',
	);

	add_theme_support( 'custom-header', $args );
}
add_action( 'after_setup_theme', 'newpersonal_custom_header_setup' );

function newpersonal_excerpt_more($more) {
       global $post;
    return ' <a class="more-link" href="'. get_permalink($post->ID) . '">Read More...</a>';
}
add_filter('excerpt_more', 'newpersonal_excerpt_more');

function newpersonal_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'newpersonal_excerpt_length', 999 );

?>