<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package nepali
 */
 global $words_theme_options;
  $copyright= wp_kses_post($words_theme_options['words-footer-copyright']);
?>

	</div><!-- #content -->

	<footer id="colophon" class="site-footer" role="contentinfo">
		<div class="container">
			<div class="top-bottom wrapper">
			    <div id="footer-top">
			        <div class="footer-columns">
			            <?php if( is_active_sidebar( 'footer-1' ) ) : ?>
			                <div class="footer-sidebar-1">
			                    <?php dynamic_sidebar( 'footer-1' ); ?>
			                </div>
			            <?php endif; ?>
			            <?php if( is_active_sidebar( 'footer-2') ) : ?>
			                <div class="footer-sidebar-1">
			                    <?php dynamic_sidebar( 'footer-2' ); ?>
			                </div>
			            <?php endif; ?>

			            <?php if( is_active_sidebar( 'footer-3') ) : ?>
			                <div class="footer-sidebar-1">
			                    <?php dynamic_sidebar( 'footer-3'); ?>
			                </div>
			            <?php endif; ?>
			        </div>
			    </div><!-- #foter-top -->
			</div><!-- top-bottom-->
		</div>
		<div class="site-info">
			<div class="container">
				<div class="row">
					<div class="col-sm-8 col-xs-12">
						<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'nepali' ) ); ?>"><?php printf( esc_html__( 'Proudly powered by %s', 'nepali' ), 'WordPress' ); ?></a>
						<span class="sep"> | <?php printf( esc_html__( 'Theme: %1$s by %2$s.', 'nepali' ), 'nepali', '<a href="http://nerdplatoon.com/" rel="Web Design and App Development">Nerdplatoon</a>' ); ?> </span>
					</div>
					<div class="col-sm-4 col-xs-12">
						<span class="copy-right-text"><?php echo $copyright; ?></span>
					</div>
				</div>
			</div>
		</div><!-- .site-info -->
	</footer><!-- #colophon -->
	</div><!-- #row -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
