<?php
/*
*   @Package Natalie WP
*
*   Header Navigation template
*/
?>

<!-- Search model Begin -->
<?php $natalie_wp_unique_id = wp_unique_id( 'natalie-search-form-' );?>
<div class="search-model-box">
    <div class="d-flex align-items-center h-100 justify-content-center">
        <div class="search-close-btn">+</div>
        <form class="search-model-form" action="<?php echo esc_url(home_url('/'));?>" method="get">
            <input type="text" id="<?php echo esc_attr( $natalie_wp_unique_id ) ?>"
                placeholder="<?php esc_attr_e(' Type a keyword and hit enter to search', 'natalie-wp')?>" name="s">
            <button><i class="fas fa-search"></i></button>
        </form>
    </div>
</div>
<!-- Search model end -->
<div class="top-header">
    <div class="container">
        <div class="row">
            <div class="col-md-6 top_header_left d-none d-lg-block">
                <ul>
                    <?php if(get_theme_mod('set_facebook')):?>
                    <li>
                        <a target="_blank" href="<?php echo esc_url(get_theme_mod('set_facebook'));?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                                <path id="Icon_simple-facebook" data-name="Icon simple-facebook"
                                    d="M20,10.061A10,10,0,1,0,8.438,20V12.969H5.9V10.061H8.438V7.845c0-2.522,1.493-3.914,3.777-3.914a15.288,15.288,0,0,1,2.239.2V6.6H13.192a1.45,1.45,0,0,0-1.63,1.571v1.887h2.773l-.443,2.908h-2.33V20A10.045,10.045,0,0,0,20,10.061Z"
                                    fill="#fff" />
                            </svg>
                        </a>
                    </li>
                    <?php endif;?>
                    <?php if(get_theme_mod('set_instagram')):?>
                    <li>
                        <a target="_blank" href="<?php echo esc_url(get_theme_mod('set_instagram'));?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                                <path id="icons8-instagram-circle"
                                    d="M12,2A10,10,0,1,0,22,12,10.012,10.012,0,0,0,12,2ZM9.435,5.077h5.128a4.364,4.364,0,0,1,4.36,4.358v5.128a4.364,4.364,0,0,1-4.358,4.36H9.437a4.364,4.364,0,0,1-4.36-4.358V9.437A4.364,4.364,0,0,1,9.435,5.077Zm0,1.538a2.824,2.824,0,0,0-2.82,2.822v5.128a2.824,2.824,0,0,0,2.822,2.82h5.128a2.824,2.824,0,0,0,2.82-2.822V9.435a2.824,2.824,0,0,0-2.822-2.82ZM15.591,7.9a.513.513,0,1,1-.514.512A.512.512,0,0,1,15.591,7.9ZM12,8.154A3.846,3.846,0,1,1,8.154,12,3.851,3.851,0,0,1,12,8.154Zm0,1.538A2.308,2.308,0,1,0,14.308,12,2.308,2.308,0,0,0,12,9.692Z"
                                    transform="translate(-2 -2)" fill="#fff" />
                            </svg>
                        </a>
                    </li>
                    <?php endif;?>
                    <?php if(get_theme_mod('set_twitter')):?>
                    <li>
                        <a target="_blank" href="<?php echo esc_url(get_theme_mod('set_twitter'));?>">
                            <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="25" height="25"
                                viewBox="0 0 64 64" style=" fill:#fff;">
                                <path
                                    d="M32,6C17.641,6,6,17.641,6,32c0,14.359,11.641,26,26,26s26-11.641,26-26C58,17.641,46.359,6,32,6z M44.927,26.226 c0.012,0.271,0.017,0.543,0.017,0.816c0,8.34-6.189,17.958-17.51,17.958c-3.476,0-6.711-1.045-9.435-2.835 c0.482,0.059,0.973,0.089,1.469,0.089c2.884,0,5.538-1.009,7.644-2.702c-2.693-0.051-4.966-1.877-5.749-4.384 c0.375,0.072,0.761,0.112,1.157,0.112c0.562,0,1.107-0.077,1.622-0.221c-2.816-0.579-4.937-3.13-4.937-6.188 c0-0.027,0-0.052,0-0.079c0.83,0.472,1.779,0.756,2.788,0.789c-1.651-1.131-2.737-3.063-2.737-5.252 c0-1.158,0.303-2.242,0.832-3.175c3.037,3.819,7.571,6.333,12.686,6.595c-0.104-0.46-0.159-0.943-0.159-1.438 c0-3.485,2.755-6.311,6.154-6.311c1.77,0,3.369,0.767,4.492,1.994c1.403-0.284,2.721-0.809,3.909-1.532 c-0.459,1.474-1.434,2.711-2.706,3.492C45.71,23.8,46.896,23.462,48,22.959C47.175,24.224,46.131,25.335,44.927,26.226z">
                                </path>
                            </svg>
                        </a>
                    </li>
                    <?php endif;?>
                    <?php if(get_theme_mod('set_pinterest')) :?>
                    <li>
                        <a href="<?php echo esc_url(get_theme_mod('set_pinterest'));?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                                <path id="Icon_simple-pinterest" data-name="Icon simple-pinterest"
                                    d="M10.058,0A9.985,9.985,0,0,0,6.407,19.291a9.58,9.58,0,0,1,.034-2.866c.183-.781,1.175-4.964,1.175-4.964a3.607,3.607,0,0,1-.3-1.484c0-1.386.808-2.426,1.811-2.426A1.257,1.257,0,0,1,10.4,8.958a19.98,19.98,0,0,1-.829,3.327,1.45,1.45,0,0,0,1.483,1.8c1.778,0,3.148-1.871,3.148-4.573a3.948,3.948,0,0,0-4.184-4.058A4.328,4.328,0,0,0,5.5,9.791a3.883,3.883,0,0,0,.743,2.284.3.3,0,0,1,.071.288c-.075.313-.245,1-.279,1.136-.044.188-.144.226-.335.137-1.249-.575-2.032-2.4-2.032-3.872,0-3.147,2.3-6.043,6.616-6.043A5.874,5.874,0,0,1,16.454,9.49c0,3.446-2.178,6.218-5.207,6.218a2.707,2.707,0,0,1-2.3-1.149l-.626,2.373a10.871,10.871,0,0,1-1.251,2.622A9.994,9.994,0,1,0,10.031.022Z"
                                    transform="translate(-0.043)" fill="#fff" />
                            </svg>
                        </a>
                    </li>
                    <?php endif;?>
                </ul>
            </div>
            <div class="col-md-6 top_header_right">
                <?php $show_search_icon = get_theme_mod('natalie_search_icon', 1);
              if($show_search_icon == 1):?>
                <span class="search-icon">
                    <a href="javascript:void(0)" class="nav-search search-switch mr-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                            <path id="Icon_metro-search" data-name="Icon metro-search"
                                d="M21.951,18.948l-4.737-4.029a2.114,2.114,0,0,0-1.437-.624,7.5,7.5,0,1,0-.839.839,2.114,2.114,0,0,0,.624,1.437l4.029,4.737a1.68,1.68,0,1,0,2.361-2.361Zm-11.88-4.519a5,5,0,1,1,5-5,5,5,0,0,1-5,5Z"
                                transform="translate(-2.571 -1.928)" fill="#fff" />
                        </svg>
                    </a>
                </span>
                <?php endif;?>

                <?php if( class_exists( 'WooCommerce' ) ): ?>
                <?php if ( is_user_logged_in() ) : ?>
                <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>"><?php esc_html_e( 'My Account', 'natalie-wp' ) ?>
                </a> &nbsp;&nbsp;
                <a
                    href="<?php echo esc_url( wp_logout_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ) );?>"><?php esc_html_e( 'Logout', 'natalie-wp'); ?></a>
                <?php else: ?>
                <a
                    href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>"><?php esc_html_e( 'Login / Register', 'natalie-wp' ) ?></a>
                <?php endif; ?>
                &nbsp;&nbsp;<a class="shopping-cart-icon" href="<?php echo wc_get_cart_url();?>"
                    class="text-white shopping-cart"><i class="fas fa-shopping-bag"></i> <span class="items">
                        <?php echo WC()->cart->get_cart_contents_count();?></span></a>
                <?php endif;?>
            </div>
        </div>
    </div>
</div>

<header class="site-navbar header-section shadow">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <nav class="navbar navbar-expand-md navbar-light start-style">
                    <?php if ( has_custom_logo() ) : ?>
                    <div class="site-logo"><?php the_custom_logo(); ?></div>
                    <?php endif; ?>

                    <?php $blog_info = get_bloginfo( 'name' ); ?>
                    <?php if ( ! empty( $blog_info ) ) : ?>
                    <?php if ( is_front_page() && is_home() )  : ?>
                    <div class="front-page-logo">
                        <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"
                                rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                        <?php
                            $description = get_bloginfo( 'description', 'display' );
                            if ( $description || is_customize_preview() ) :
                                ?>
                        <p class="site-description">
                            <?php echo esc_html($description); ?>
                        </p>
                        <?php endif; ?>
                    </div>
                    <?php else : ?>
                    <div class="logo-text">
                        <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"
                                rel="home"><?php bloginfo( 'name' ); ?></a></p>

                        <?php
                              $description = get_bloginfo( 'description', 'display' );
                              if ( $description || is_customize_preview() ) :
                            ?>
                        <p class="site-description">
                            <?php echo esc_html($description); ?>
                        </p>
                        <?php endif; ?>
                    </div>
                    <?php endif;  endif; ?>
                    <button class="navbar-toggler" type="button" data-toggle="collapse"
                        data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <?php
                      wp_nav_menu( $args = array(
                        'theme_location'    => 'natalie-wp-primary-menu',
                        'depth'             => 2,
                        'container_class'   => 'collapse navbar-collapse',
                        'container_id'      => 'navbarSupportedContent',
                        'menu_class'        => 'navbar-nav ml-auto py-4 py-md-0',
                        'add_li_class'      => 'pl-4 pl-md-0 ml-0 ml-md-4',
                        'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
				        'walker'            => new WP_Bootstrap_Navwalker(),
                      ) );
                ?>
                </nav>
            </div>
        </div>
</header>