<?php

get_header(); $the_post_id = get_the_ID();?>

<div class="entry-header entry-header-style-2 pb-80 pt-80 mb-50 text-white"
    style="background-image: url('<?php echo get_post_thumbnail_url($the_post_id, 'featured-image'); ?>')">
    <div class="container entry-header-content">
        <h1 class="entry-title mb-50 font-weight-900">
            <?php the_title();?>
        </h1>
        <?php if( function_exists("is_shop") ) :?>
        <?php else:?>
        <div class="entry-meta align-items-center meta-2 font-small color-white">
            <p class="mb-5 text-white">
                <a class="author-avatar"
                    href="<?php natalie_wp_posted_author_url();?>"><?php natalie_wp_posted_author_image();?>
                </a>
                <?php esc_attr_e('By', 'natalie-wp');?> <a href="<?php natalie_wp_posted_author_url();?>"><span
                        class="author-name font-weight-bold text-white"><?php natalie_wp_posted_author_name()?></span></a>
            </p>
        </div>
        <?php endif;?>
    </div>
</div>

<main class="bg-grey pb-30" id="content">
    <?php if(have_posts()) : while(have_posts()) : the_post();?>
    <div class="container single-content">
        <!--end single header-->
        <!--figure-->
        <div class="row">
            <div class="col-lg-8">
                <article class="entry-wraper mb-50">
                    <div class="entry-main-content"><?php the_content();?></div>
                </article>

                <?php
              wp_link_pages( array(
                  'before' => '<div class="page-links">' . __( 'Pages:', 'natalie-wp' ),
                  'after'  => '</div>',
              ) );
          ?>

            </div>

            <?php get_sidebar();?>
        </div>
    </div>
    <?php endwhile; endif;?>
</main>


<?php get_footer()?>