<?php

function natalie_wp_add_additional_class_on_li($classes, $item, $args) {
    if(isset($args->add_li_class)) {
        $classes[] = $args->add_li_class;
    }
    return $classes;
}
add_filter('nav_menu_css_class', 'natalie_wp_add_additional_class_on_li', 1, 3);


function natalie_wp_custom_excerpt_length( $length ) {
    if ( is_admin() ) {
            return $length;
          }
    return 25;
  }
  add_filter( 'excerpt_length', 'natalie_wp_custom_excerpt_length', 999 );

if(! function_exists('natalie_wp_get_the_post_custom_thumbnail')) :

    function natalie_wp_get_the_post_custom_thumbnail($post_id, $size, $additional_attributes =[]){
    
        $custom_thumbnail = '';
    
        if(null === $post_id){
            $post_id = get_the_ID();
        }
    
        if(has_post_thumbnail($post_id)){
        
            $attributes = array_merge($additional_attributes);
    
            $custom_thumbnail = wp_get_attachment_image(
                get_post_thumbnail_id($post_id),
                $size,
                false,
                $additional_attributes
            );
        }
    
        return $custom_thumbnail;
    
    }
    endif;

    function get_post_thumbnail_url( $post_id, $size) {

        $custom_thumbnail = ''; 
        
        if(null === $post_id){
            $post_id = get_the_ID();
        }
    
        if(the_post_thumbnail_url($post_id)){
            $custom_thumbnail = wp_get_attachment_image_url(
                get_the_post_thumbnail_url($post_id), $size
            );
        }
    
        return $custom_thumbnail;
    }


    if(! function_exists('the_post_custom_thumbnail')) :

        function the_post_custom_thumbnail($post_id, $size, $additional_attributes =[]){
            echo natalie_wp_get_the_post_custom_thumbnail($post_id, $size, $additional_attributes);
        }
        endif;

        if(!function_exists('natalie_wp_the_excerpt')) :
            function natalie_wp_the_excerpt($trim_character_count = 0){
                if(!has_excerpt() || 0 === $trim_character_count){
                    the_excerpt();
                    return;
                }
        
                $excerpt = wp_strip_all_tags( get_the_excerpt() );
                $excerpt = substr($excerpt, 0, $trim_character_count);
                $excerpt = substr($excerpt, 0, strrpos($excerpt, '') );
        
                echo $excerpt . '[...]';
            }
        endif;

        if(!function_exists('natalie_wp_posted_on')) :
            function natalie_wp_posted_on(){
                $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
            
                // if post is modified
                if(get_the_time('U') !== get_the_modified_time( 'U' )){
                    $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
                }
            
                $time_string = sprintf(
                    $time_string, esc_attr(get_the_date(DATE_W3C)),
                    esc_attr( get_the_date() ),
                    esc_attr( get_the_modified_date(DATE_W3C) ),
                    esc_attr( get_the_modified_date() )
                );
            
                $posted_on = sprintf(
                    esc_html_x('%s', 'post date', 'natalie-wp'), $time_string
                );
            
                echo $posted_on ;
            }
            endif;



            if(! function_exists('natalie_wp_posted_by')) :
                function natalie_wp_posted_by() {
                    $byline = sprintf(
                        esc_html_x( '%s', 'post author', 'natalie-wp' ),
                        '<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a>'
                    );
                
                    echo  $byline;
                }
                endif;

             

                if(! function_exists('natalie_wp_posted_author_image')) :
                    function natalie_wp_posted_author_image() {
                        global $post;
                        echo get_avatar( $post->post_author, 90, '', false, [  ] );
                    }
                    endif;
                

                    if(! function_exists('natalie_wp_posted_author_name')) :
                        function natalie_wp_posted_author_name() {
                            if(is_single()){
                            $byline = sprintf(
                                esc_html( get_the_author() )
                            );
                            echo  $byline;
                            }
                            
                        }
                        endif;


                        if(! function_exists('natalie_wp_posted_author_url')) :
                            function natalie_wp_posted_author_url() {
                                $byline = sprintf(
                                    esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) )
                                );
                            
                                echo  $byline;
                            }
                            endif;



function natalie_wp_pagination(){?>
<div class="col-lg-4 float-left text-left"><?php previous_post_link('<span class="left">&laquo; %link</span>');?></div>
<div class="col-lg-4 float-right text-right"><?php next_post_link();?></div>
<?php }
        
        function natalie_wp_pagination_number(){
            $allowed_tags = [
                'span' => [
                    'class' => []
                ],
                'a' => [
                    'class' => [],
                    'href' => [],
                ]
            ];
        
            $args = [
                'before_page_number' => '<span class="">',
                'after_page_number' => '</span>',
            ];
        
            printf( '<nav class="natalie-wp-pagination clearfix">%s</nav>', wp_kses( paginate_links( $args ), $allowed_tags ) );
        }

    // related post

if( !function_exists('natalie_wp_related_post') ): 
    function natalie_wp_related_post($post){
        global $post;
       $categories             =   get_the_category();
       if(!empty($categories)) :
       $rp_query               =   new WP_Query([
           'posts_per_page'    =>  3,
           'post__not_in'      =>  [ $post->ID ],
           'cat'               =>  !empty($categories) ?  $categories[0]->term_id : null
       ]);
    ?>

<div class="related-posts">
    <div class="post-module-3">
        <?php if( $rp_query->have_posts() ) :?>

        <div class="widget-header-2 position-relative mb-30">
            <h5 class="mt-5 mb-30"><?php esc_html_e('Related posts', 'natalie-wp')?></h5>
        </div>

        <?php while( $rp_query->have_posts() ): 
         $rp_query->the_post(); $the_post_id = get_the_ID();?>

        <div class="loop-list loop-list-style-1">
            <article class="hover-up-2 transition-normal">
                <div class="row mb-40 list-style-2">
                    <div class="col-md-4">
                        <div class="post-thumb position-relative border-radius-5">

                            <?php if(has_post_thumbnail(  )) :?>
                            <div class="img-hover-slide border-radius-5 position-relative"
                                style="background-image: url('<?php echo get_post_thumbnail_url($the_post_id, 'related-post-image'); ?>')">
                                <a class="img-link" href="<?php the_permalink();?>"></a>
                            </div>
                            <?php else:?>
                            <div class="img-hover-slide border-radius-5 position-relative"
                                style="background-image: url('<?php echo NATALIE_THEME_URI?>/assets/img/related-post-image.jpg');">
                                <a class="img-link" href="<?php the_permalink();?>"></a>
                            </div>
                            <?php endif;?>
                            <?php do_action('natalie_wp_social_icon_action');?>

                        </div>
                    </div>
                    <div class="col-md-8 align-self-center">
                        <div class="post-content">
                            <div class="entry-meta meta-0 font-small mb-10">
                                <span class="post-cat text-success"> <?php the_category();?></span>
                            </div>
                            <h5 class="post-title mb-20">
                                <a href="<?php the_permalink();?>"><?php the_title();?></a>
                            </h5>
                            <div class="entry-meta meta-1 float-left font-x-small text-uppercase">
                                <span class="post-on"> <?php natalie_wp_posted_on();?></span>
                                <span class="post-by"><?php natalie_wp_posted_by();?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </article>
        </div>
        <?php endwhile; endif;  wp_reset_postdata();?>

    </div>

    <?php endif;} 

   
   add_action( 'natalie_wp_related_post_action','natalie_wp_related_post');
   
   endif;


    // social share   
if( !function_exists('natalie_wp_social_share_action') ): 
    function natalie_wp_social_share_action(){ ?>
    <?php
        $natalie_wp_show_blog_share_meta = get_theme_mod('natalie_wp_show_blog_share_meta', 1);
        $natalie_wp_blog_share_f = get_theme_mod('natalie_wp_blog_share_f', 1);
        $natalie_wp_blog_share_t = get_theme_mod('natalie_wp_blog_share_t', 1);
        $natalie_wp_blog_share_l = get_theme_mod('natalie_wp_blog_share_l', 1);
        $natalie_wp_blog_share_p = get_theme_mod('natalie_wp_blog_share_p', 1);
    ?>
    <?php if($natalie_wp_show_blog_share_meta == 1):?>
    <ul class="social-share">
        <?php if($natalie_wp_blog_share_f == 1) :?>
        <li><a href=""><i class="elegant-icon social_share"></i></a></li>
        <li><a class="fb" href="https://facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"
                title="Share on Facebook" target="_blank"><i class="elegant-icon social_facebook"></i></a></li>
        <?php endif;?>
        <?php if($natalie_wp_blog_share_t == 1) :?>
        <li><a class="tw" href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>" target="_blank"
                title="Tweet now"><i class="elegant-icon social_twitter"></i></a></li>
        <?php endif;?>
        <?php if($natalie_wp_blog_share_p == 1) :?>
        <li><a class="pt"
                href="http://pinterest.com/pin/create/button/?url='+url+'&media='+image+'','_blank','width=800,height=600"
                target="_blank" title="Pin it"><i class="elegant-icon social_pinterest"></i></a></li>
        <?php endif;?>
        <?php if($natalie_wp_blog_share_l == 1) :?>
        <li><a class="lk" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink() ?>"
                target="_blank" title="Share on LinkedIn"><i class="elegant-icon social_linkedin"></i></a></li>
        <?php endif;?>
    </ul>
    <?php endif;?>

    <?php } 
     add_action( 'natalie_wp_social_icon_action','natalie_wp_social_share_action'); 
    endif;



            // social share   
if( !function_exists('natalie_wp__blog_social_share_action') ): 
    function natalie_wp__blog_social_share_action(){ ?>
    <?php
        $natalie_wp_show_blog_share_meta = get_theme_mod('natalie_wp_show_blog_share_meta', 1);
        $natalie_wp_blog_share_f = get_theme_mod('natalie_wp_blog_share_f', 1);
        $natalie_wp_blog_share_t = get_theme_mod('natalie_wp_blog_share_t', 1);
        $natalie_wp_blog_share_l = get_theme_mod('natalie_wp_blog_share_l', 1);
        $natalie_wp_blog_share_p = get_theme_mod('natalie_wp_blog_share_p', 1);
    ?>
    <?php if($natalie_wp_show_blog_share_meta == 1):?>
        <ul class="header-social-network d-inline-block list-inline float-md-right mt-md-0 mt-4">
        <li class="list-inline-item text-muted"><span>Share this: </span></li>
            <?php if($natalie_wp_blog_share_f == 1) :?>
                    <li class="list-inline-item">
                        <a class="social-icon fb text-xs-center" 
                            target="_blank" href="https://facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>">
                                <i class="elegant-icon social_facebook"></i>
                        </a>
                    </li>
                    <?php endif;?>
                    <?php if($natalie_wp_blog_share_t == 1) :?>
                    <li class="list-inline-item">
                        <a class="social-icon tw text-xs-center" target="_blank" href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>">
                        <i class="elegant-icon social_twitter "></i></a>
                    </li>
                    <?php endif;?>
                    <?php if($natalie_wp_blog_share_p == 1) :?>
                    <li class="list-inline-item">
                        <a class="social-icon pt text-xs-center" target="_blank" href="http://pinterest.com/pin/create/button/?url='+url+'&media='+image+'','_blank','width=800,height=600">
                            <i class="elegant-icon social_pinterest "></i>
                        </a>
                    </li>
                    <?php endif;?>
                    <?php if($natalie_wp_blog_share_l == 1) :?>
                    <li class="list-inline-item">
                        <a class="social-icon lk text-xs-center" target="_blank" href="http://pinterest.com/pin/create/button/?url='+url+'&media='+image+'','_blank','width=800,height=600">
                            <i class="elegant-icon social_linkedin "></i>
                        </a>
                    </li>
                    <?php endif;?>

            
    </ul>
    <?php endif;?>

    <?php } 
     add_action( 'natalie_wp_blog_social_icon_action','natalie_wp__blog_social_share_action'); 
    
    endif;



   
    function theme_comment($comment, $args, $depth)
{

    

    $GLOBALS['comment'] = $comment; ?>
    <ol class="commentlist clearfix" id="comment-<?php comment_ID() ?>">

        <li class="comment even thread-even depth-1" id="li-comment-1">

            <?php
if ($comment->comment_approved == '0') : ?>
            <em>Your comment is awaiting moderation.</em>
            <?php endif; ?>

            <?php edit_comment_link('Edit Comment', '&nbsp;', ''); ?>
            <div class="comment-list fadeIn animated">
                <div class="single-comment justify-content-between d-flex">
                    <div class="user justify-content-between d-flex">

                        <?php echo get_avatar('$comment', 70, '', '', ['class' => 'avatar avatar-70 photo avatar-default thumb']);?>

                        <div class="desc">

                            <?php comment_text();?>

                            <div class="d-flex justify-content-between">
                                <div class="d-flex align-items-center">
                                    <h5>
                                        <?php comment_author();?>
                                    </h5>
                                    <p class="date"><?php comment_date();?> </p>
                                </div>
                                <div class="reply-btn">
                                    <?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </li>

    </ol>
    <?php
}

  
/**
 * Show cart contents / total Ajax
 */
add_filter( 'woocommerce_add_to_cart_fragments', 'natalie_wp_header_add_to_cart_fragment' );

function natalie_wp_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();
	?>
    <span class="items"><?php echo WC()->cart->get_cart_contents_count();?></span>
    <?php
	$fragments['span.items'] = ob_get_clean();
	return $fragments;
}


if(!function_exists('featured_category')) : 
function featured_category(){ ?>
    <?php if(get_theme_mod('show_featured_category')): ?>
    <div class="site-bottom pt-50 pb-50 bg-white">
        <div class="container">
            <div class="row">
                <?php  
            $show_featured_category = get_theme_mod('show_featured_category',0);
            $natalie_wp_featured_category_1 = get_theme_mod('natalie_wp_featured_category_1');
            $natalie_wp_featured_category_2 = get_theme_mod('natalie_wp_featured_category_2');
            $natalie_wp_featured_category_3 = get_theme_mod('natalie_wp_featured_category_3');
            ?>

                <?php if( $show_featured_category && ( $natalie_wp_featured_category_1  || $natalie_wp_featured_category_1 || 
            $natalie_wp_featured_category_1 ) ) :?>

                <?php
            for( $x = 1; $x <= 3; $x++ ) :
            $recent_post_category = get_theme_mod('natalie_wp_featured_category_'.$x);
                if( $recent_post_category ) :
                    $cat_info = get_category_by_slug( $recent_post_category );
                    $cat_link = get_category_link(  $cat_info->term_id );
                ?>

                <div class="col-lg-4 col-md-6">
                    <div class="sidebar-widget widget-latest-posts mb-30">
                        <?php if( isset( $cat_info->name ) && $cat_info->name ) : ?>
                        <div class="widget-header-2 position-relative mb-30">
                            <h5 class="mt-5 mb-30"><?php echo esc_html( $cat_info->name ); ?></h5>
                        </div>
                        <?php endif; ?>
                        <div class="post-block-list post-module-1">
                            <ul class="list-post">

                                <?php $args = array(
                        'post_type' => 'post',
                        'post_status' => 'publish',
                        'category_name' => $recent_post_category,
                        'posts_per_page' => 3, );
                        $arr_posts = new WP_Query( $args );
                        if ( $arr_posts->have_posts() ) :
    
                            while ( $arr_posts->have_posts() ) :
                                $arr_posts->the_post();
                                ?>

                                <li class="mb-30">
                                    <div class="d-flex hover-up-2 transition-normal">
                                        <div
                                            class="post-thumb post-thumb-80 d-flex mr-15 border-radius-5 img-hover-scale overflow-hidden">
                                            <a class="color-white" href="<?php the_permalink();?>">
                                                <?php if(has_post_thumbnail()):?>
                                                <?php the_post_thumbnail('featured-category-blog-post');?>
                                                <?php else:?>
                                                <img src="<?php echo NATALIE_THEME_URI . "/assets/img/featured-category-post-thumbnail.jpg"; ?>"
                                                    alt="<?php the_title();?>">
                                                <?php endif;?>
                                            </a>
                                        </div>
                                        <div class="post-content media-body">
                                            <h6 class="post-title mb-15 text-limit-2-row font-medium"><a
                                                    href="<?php the_permalink();?>"><?php the_title();?></a></h6>
                                            <div class="entry-meta meta-1 float-left font-x-small text-uppercase">
                                                <span class="post-on"><?php natalie_wp_posted_on();?></span>
                                                <span class="post-by"> <?php natalie_wp_posted_by();?></span>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <?php endwhile; endif;?>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php endif; endfor; endif; ?>

            </div>

        </div>

    </div>
    <?php endif; } endif;


  /**
 * Extend Recent Posts Widget 
 *
 * Adds different formatting to the default WordPress Recent Posts Widget
 */

Class Natalie_WP_Recent_Posts_Widget extends WP_Widget_Recent_Posts {

    function widget($args, $instance) {

            if ( ! isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }

        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts', 'natalie-wp' );

        /** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
        if ( ! $number )
            $number = 5;
        $show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;

        /**
         * Filter the arguments for the Recent Posts widget.
         *
         * @since 3.4.0
         *
         * @see WP_Query::get_posts()
         *
         * @param array $args An array of arguments used to retrieve the recent posts.
         */
        $r = new WP_Query( apply_filters( 'widget_posts_args', array(
            'posts_per_page'      => $number,
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true
        ) ) );

        if ($r->have_posts()) :
        ?>
    <?php echo $args['before_widget']; ?>
    <?php if ( $title ) {
            echo $args['before_title'] . $title . $args['after_title'];
        } ?>

    <?php while ( $r->have_posts() ) : $r->the_post(); 
          $recent_post_image = get_the_post_thumbnail_url(get_the_ID(), 'small-thumb');
         ?>

    <div class="post-block-list post-module-1">
        <ul class="list-post">
            <li class="mb-30 wow fadeInUp animated">
                <div class="d-flex bg-white has-border p-25 hover-up transition-normal border-radius-5">
                    <div class="post-content media-body">
                        <h6 class="post-title mb-15 text-limit-2-row font-medium"><a
                                href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a>
                        </h6>
                        <div class="entry-meta meta-1 float-left font-x-small text-uppercase">
                            <?php if ( $show_date ) : ?>
                            <span class="post-on-dot"><?php echo get_the_date();?></span>
                            <?php endif;?>
                        </div>
                    </div>
                    <div class="post-thumb post-thumb-80 d-flex ml-15 border-radius-5 img-hover-scale overflow-hidden">
                        <a class="color-white" href="<?php the_permalink(); ?>">
                            <?php if(!empty($recent_post_image)) : ?>
                            <img src="<?php echo $recent_post_image; ?>">
                            <?php else:?>
                            <img src="https://place-hold.it/200x200">
                            <?php endif;?>
                        </a>
                    </div>
                </div>
            </li>
        </ul>
    </div>
    <?php endwhile; ?>

    <?php echo $args['after_widget']; ?>
    <?php
        // Reset the global $the_post as this query will have stomped on it
        wp_reset_postdata();

        endif;
    }
}
function natalie_wp_recent_widget_registration() {
unregister_widget('WP_Widget_Recent_Posts');
register_widget('Natalie_WP_Recent_Posts_Widget');
}
add_action('widgets_init', 'natalie_wp_recent_widget_registration');


// Return an alternate title, without prefix, for every type used in the get_the_archive_title().
add_filter('get_the_archive_title', function ($title) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title =   get_the_author();
    } elseif ( is_year() ) {
        $title = get_the_date( _x( 'Y', 'yearly archives date format', 'natalie-wp' ) );
    } elseif ( is_month() ) {
        $title = get_the_date( _x( 'F Y', 'monthly archives date format', 'natalie-wp' ) );
    } elseif ( is_day() ) {
        $title = get_the_date( _x( 'F j, Y', 'daily archives date format', 'natalie-wp' ) );
    } elseif ( is_tax( 'post_format' ) ) {
        if ( is_tax( 'post_format', 'post-format-aside' ) ) {
            $title = _x( 'Asides', 'post format archive title', 'natalie-wp' );
        } elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) {
            $title = _x( 'Galleries', 'post format archive title', 'natalie-wp' );
        } elseif ( is_tax( 'post_format', 'post-format-image' ) ) {
            $title = _x( 'Images', 'post format archive title', 'natalie-wp' );
        } elseif ( is_tax( 'post_format', 'post-format-video' ) ) {
            $title = _x( 'Videos', 'post format archive title', 'natalie-wp' );
        } elseif ( is_tax( 'post_format', 'post-format-quote' ) ) {
            $title = _x( 'Quotes', 'post format archive title', 'natalie-wp' );
        } elseif ( is_tax( 'post_format', 'post-format-link' ) ) {
            $title = _x( 'Links', 'post format archive title', 'natalie-wp' );
        } elseif ( is_tax( 'post_format', 'post-format-status' ) ) {
            $title = _x( 'Statuses', 'post format archive title', 'natalie-wp' );
        } elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {
            $title = _x( 'Audio', 'post format archive title', 'natalie-wp' );
        } elseif ( is_tax( 'post_format', 'post-format-chat' ) ) {
            $title = _x( 'Chats', 'post format archive title', 'natalie-wp' );
        }
    } elseif ( is_post_type_archive() ) {
        $title = post_type_archive_title( '', false );
    } elseif ( is_tax() ) {
        $title = single_term_title( '', false );
    } else {
        $title = __( 'Archives', 'natalie-wp' );
    }
    return $title;
});




//estimated reading time
function reading_time() {
    global $post;
    $content = get_post_field( 'post_content', $post->ID );
    $word_count = str_word_count( strip_tags( $content ) );
    $readingtime = ceil($word_count / 200);
    
    if ($readingtime == 1) {
    $timer = " Minute Read";
    } else {
    $timer = " Minutes Read";
    }
    $totalreadingtime = $readingtime . $timer;
    
    return $totalreadingtime;
    }