<?php

function natalie_wp_theme_setup(){
    add_theme_support('title-tag');
    add_theme_support('custom-logo');

    add_theme_support('custom-background', [
        'default'  			=> '#fff',
        'default-image'		=> '',
        'default-repeat'	=> 'no-repeat'
    ]);

    add_theme_support('post-thumbnails' );
    add_theme_support('customize-selective-refresh-widgets');
    add_theme_support( 'automatic-feed-links' );
    add_theme_support('responsive-embeds');
    add_theme_support('html5', ['comment-list','comment-form','search-form', 'gallery', 'caption' ] );
    add_image_size( 'featured-large', '350', '220', 'center' );
    add_image_size( 'blog-post-image', '730', '438', 'center' );
    add_image_size( 'featured-thumbnail', '350', '220', 'center' );
    add_image_size( 'related-post-image', '230', '150', 'center' );
    add_image_size( 'slider-1', '375', '375', 'center' );
    add_image_size( 'featured-category-blog-post', '90', '90', 'center' );
    add_image_size( 'list-post-style', '250', '150', 'center' );
    add_image_size( 'small-thumb', '90', '80', 'center' );

    // WooCommerce

    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');

    add_theme_support( 'woocommerce', array(
		'thumbnail_image_width' => 255,
		'single_image_width'	=> 255,
		'product_grid' 			=> array(
			'default_rows'    => 10,
			'min_rows'        => 5,
			'max_rows'        => 10,
			'default_columns' => 3,
			'min_columns'     => 3,
			'max_columns'     => 3,				
		)
	) );

    register_nav_menu( 'natalie-wp-primary-menu', __('Primary Menu', 'natalie-wp' ));
    // register_nav_menu( 'natalie-wp-footer-menu', __('Footer Menu', 'natalie-wp' ));

    add_editor_style();

    add_theme_support( 'wp-block-styles' );
    add_theme_support('align-wide');

    if ( ! isset( $content_width ) ) {
        $content_width = 1200;
    }
    
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

    $text_domain = 'natalie-wp';
    load_theme_textdomain( $text_domain, get_stylesheet_directory() . '/languages' );
    load_theme_textdomain( $text_domain, get_template_directory() . '/languages' );
}