<?php

function natalie_wp_load_scripts(){
    wp_enqueue_style('bootstrap-css', NATALIE_THEME_URI . '/assets/css/bootstrap.min.css');
    wp_enqueue_style('elegant-icons', NATALIE_THEME_URI . '/assets/css/elegant-icons.css');
    wp_enqueue_style('owl-carousel-css', NATALIE_THEME_URI . '/assets/css/owl.carousel.css');
    wp_enqueue_style('fontawesome', NATALIE_THEME_URI . '/assets/css/all.min.css');
    wp_enqueue_style('slick-css', NATALIE_THEME_URI . '/assets/css/slick.css');
    
    wp_enqueue_style('natalie-wp-fonts-nunito',  NATALIE_THEME_URI . '/assets/fonts/fonts.css', [], false, 'all');

    wp_enqueue_style('main-theme-style', NATALIE_THEME_URI . '/assets/css/main-theme-style.css');
    wp_enqueue_style('stylesheet', get_stylesheet_uri(), [], filemtime(NATALIE_THEME_PATH . '/style.css'), 'all');

    $natalie_btn_colour = get_theme_mod('natalie_btn_colour');
    wp_add_inline_style('stn-custom-css', 'a.more-link{color: '.$natalie_btn_colour.';}');

    if(has_custom_logo()){
      wp_enqueue_style('natalie-wp-custom-logo-style', NATALIE_THEME_URI . '/assets/css/custom-logo.css');
      
  }

  

      // Js files
      wp_enqueue_script('bootstrap-js', NATALIE_THEME_URI . '/assets/js/bootstrap.min.js', ['jquery'], '4.6.0', true);
      wp_enqueue_script('owl-carousel', NATALIE_THEME_URI . '/assets/js/owl.carousel.min.js', [], '1.3.0', true);
      wp_enqueue_script('slick', NATALIE_THEME_URI . '/assets/js/slick.min.js', [], '1.0.0', true);
      wp_enqueue_script('wow-js', NATALIE_THEME_URI . '/assets/js/wow.min.js', [], '1.1.3', true);
      wp_enqueue_script('main-js', NATALIE_THEME_URI . '/assets/js/main-script.js', [], '1.0.0', true);
}


function natalie_admin_enqueue(){

    $currentscreen = get_current_screen();
    if( $currentscreen->id == 'widgets' ){
        wp_enqueue_media();
    	wp_enqueue_script( 'natalie-widget', get_template_directory_uri() . '/assets/js/widget.js', array( 'jquery'), '1.0', true );
    	 $array = array(
	        'remove'     => esc_html__('Remove','natalie-wp'),
	        'uploadimage'     => esc_html__('Author Image','natalie-wp'),
	    );
	    wp_localize_script( 'natalie-widget', 'natalie_widget_date', $array );
     }

}
add_action('admin_enqueue_scripts','natalie_admin_enqueue');

