<?php

function natalie_wp_newsletter($wp_customize){
    $wp_customize->add_section(
        'natalie_wp_newsletter_section', array(
          'title' 		=> __( 'Newsletter Section', 'natalie-wp'),
          'description' 	=> __( 'Newsletter  Section', 'natalie-wp' ),
          'panel'   => 'natalie_wp'
        ));

        // Check if newsletter is active
        $wp_customize->add_setting(
            'natalie_wp_show_newsletter', array(
                'type' 				=> 'theme_mod',
                'default' 			=> '',
                'sanitize_callback' => 'natalie_wp_sanitize_checkbox' 
            )
        );

        $wp_customize->add_control(
            'natalie_wp_show_newsletter', array(
                'label' 	=> __( 'Check to show newsletter', 'natalie-wp' ),
                'section' 	=> 'natalie_wp_newsletter_section',
                'type' 		=> 'checkbox'			
            )
        );


        $wp_customize->add_setting('natalie_wp_subscribe_form_title',
            array(
                'default' => esc_html__('Subscribe to our newsletter', 'natalie-wp'),
                'sanitize_callback' => 'sanitize_text_field',
            )
        );
        $wp_customize->add_control('natalie_wp_subscribe_form_title',
            array(
                'label' => esc_html__('Subscribe Section Title', 'natalie-wp'),
                'section' => 'natalie_wp_newsletter_section',
                'type' => 'text',
            )
        );

        $wp_customize->add_setting('natalie_wp_subscribe_form_description',
        array(
            'default' => esc_html__('Subscribe to our newsletter and get latest news directly to your inbox', 'natalie-wp'),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control('natalie_wp_subscribe_form_description',
        array(
            'label' => esc_html__('Subscribe Section Description', 'natalie-wp'),
            'section' => 'natalie_wp_newsletter_section',
            'type' => 'text',
        )
    );


    $wp_customize->add_setting('natalie_wp_subscribe_form_shortcode',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control('natalie_wp_subscribe_form_shortcode',
        array(
            'label' => esc_html__('Subscribe Form Shortcode', 'natalie-wp'),
            'description' => esc_html__('Please install "MC4WP Plugin:, and paste your generated shortcode below', 'natalie-wp'),
            'section' => 'natalie_wp_newsletter_section',
            'type' => 'text',
        )
    );

}