<?php
/**
 * Natalie WP Theme Customizer
 *
 * @package Natalie WP
 */



function natalie_wp_misc_customizer( $wp_customize ){
    $wp_customize->add_section(
        'natalie_header', array(
          'title' 		=> __( 'Natalie Misc Section', 'natalie-wp'),
          'description' 	=> __( 'Natalie WP Theme Misc Settings', 'natalie-wp' ),
          'panel'         => 'natalie_wp'
        )
      );

            $wp_customize->add_setting(
                'natalie_search_icon', array(
                    'type' 				=> 'theme_mod',
                    'default' 			=>  1,
                    'sanitize_callback' => 'natalie_wp_sanitize_checkbox'
                )
            );
            
            $wp_customize->add_control(
                'natalie_search_icon', array(
                    'label' 	=> __( 'Show Search Icon', 'natalie-wp' ),
                    'section' 	=> 'natalie_header',
                    'type' 		=> 'checkbox',
                )
            );


                        // copyright information start here for customizer
            $wp_customize->add_setting('natalie_wp_footer_copyright_text',[
                'default'           => '2022',
                'sanitize_callback' => 'esc_html'
            ]);

            $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            'news_footer_copyright_input',
            array(
                'label'          => __( 'CopyRight Information', 'natalie-wp' ),
                'section'        => 'natalie_header',
                'settings'       => 'natalie_wp_footer_copyright_text',
                'type' 			 => 'text'
                
            )
            ));
        // Blog Share
 
}


// checkbox validation

function natalie_wp_sanitize_checkbox( $checked ){
    //returns true if checkbox is checked
    return ( ( isset( $checked ) && true == $checked ) ? true : false );
}

// 

function natalie_wp_custom_sanitization_callback( $value ) {
	// This pattern will check and match 3/6/8-character hex, rgb, rgba, hsl, & hsla colors.
	$pattern = '/^(\#[\da-f]{3}|\#[\da-f]{6}|\#[\da-f]{8}|rgba\(((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*,\s*){2}((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*)(,\s*(0\.\d+|1))\)|hsla\(\s*((\d{1,2}|[1-2]\d{2}|3([0-5]\d|60)))\s*,\s*((\d{1,2}|100)\s*%)\s*,\s*((\d{1,2}|100)\s*%)(,\s*(0\.\d+|1))\)|rgb\(((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*,\s*){2}((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*)|hsl\(\s*((\d{1,2}|[1-2]\d{2}|3([0-5]\d|60)))\s*,\s*((\d{1,2}|100)\s*%)\s*,\s*((\d{1,2}|100)\s*%)\))$/';
	\preg_match( $pattern, $value, $matches );
	// Return the 1st match found.
	if ( isset( $matches[0] ) ) {
		if ( is_string( $matches[0] ) ) {
			return $matches[0];
		}
		if ( is_array( $matches[0] ) && isset( $matches[0][0] ) ) {
			return $matches[0][0];
		}
	}
	// If no match was found, return an empty string.
	return '';
}









