<?php

function natalie_wp_featured_categories($wp_customize){

      // Featured Category
      $natalie_wp_cat_list = natalie_wp_category_list();

      $wp_customize->add_section(
        'natalie_wp_featured_category', array(
          'title' 		=> __( 'Featured Category', 'natalie-wp'),
          'description' 	=> __( 'Featured Category Section', 'natalie-wp' ),
          'panel'   => 'natalie_wp'
        )
      );


       // Check if Featured category is active
 $wp_customize->add_setting(
    'show_featured_category', array(
        'type' 				=> 'theme_mod',
        'default' 			=> '0',
        'sanitize_callback' => 'natalie_wp_sanitize_checkbox'
    )
);

$wp_customize->add_control(
    'show_featured_category', array(
        'label' 	=> __( 'Check to show featured category', 'natalie-wp' ),
        'section' 	=> 'natalie_wp_featured_category',
        'type' 		=> 'checkbox'
    )
);


$wp_customize->add_setting('natalie_wp_featured_category_1',
    array(
        'default' => '0',
        'sanitize_callback' => 'natalie_wp_sanitize_category',
    )
);
$wp_customize->add_control('natalie_wp_featured_category_1',
    array(
        'label' => esc_html__('Featured Category One', 'natalie-wp'),
        'section' => 'natalie_wp_featured_category',
        'type' => 'select',
        'choices' => $natalie_wp_cat_list,
    )
);


$wp_customize->add_setting('natalie_wp_featured_category_2',
    array(
        'default' => '0',
        'sanitize_callback' => 'natalie_wp_sanitize_category',
    )
);
$wp_customize->add_control('natalie_wp_featured_category_2',
    array(
        'label' => esc_html__('Featured Category Two', 'natalie-wp'),
        'section' => 'natalie_wp_featured_category',
        'type' => 'select',
        'choices' => $natalie_wp_cat_list,
    )
);

$wp_customize->add_setting('natalie_wp_featured_category_3',
    array(
        'default' => '0',
        'sanitize_callback' => 'natalie_wp_sanitize_category',
    )
);
$wp_customize->add_control('natalie_wp_featured_category_3',
    array(
        'label' => esc_html__('Featured Category Three', 'natalie-wp'),
        'section' => 'natalie_wp_featured_category',
        'type' => 'select',
        'choices' => $natalie_wp_cat_list,
    )
);


}



if( !function_exists('natalie_wp_category_list') ):

	/** Post Category List **/
	function natalie_wp_category_list(){
	    $cat_lists = get_categories(
	        array(
	            'hide_empty' => '0',
	            'exclude' => '1',
	        )
	    );
	    $cat_array = array();
	    $cat_array[] = esc_html__('--Choose Category--','natalie-wp');
	    foreach( $cat_lists as $cat_list ){
	        $cat_array[$cat_list->slug] = $cat_list->name;
	    }
	    return $cat_array;
	}

endif;


if( !function_exists('natalie_wp_sanitize_category') ):

	/**
	* Customizer Category Sanitize
	**/

	function natalie_wp_sanitize_category($input){

	    $natalie_Wp_Category_list = natalie_wp_category_list();

	    if(array_key_exists($input,$natalie_Wp_Category_list)){
	        return $input;
	    }
	    else{
	        return '';
	    }
	}

endif;
