<?php
/**
 * @package Natalie WP
 */

add_action('widgets_init', 'natalie_author_register');

function natalie_author_register() {
    register_widget('natalie_Author_Widget');
}

class natalie_Author_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
                'natalie_Author_Widget', esc_html__('Nathalie WP Author Box', 'natalie-wp'), array(
                'description' => esc_html__('Show Author Profile', 'natalie-wp')
                )
        );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {

        $fields = array(

            'natalie_widget_title' => array(
                'natalie_widgets_name' => 'natalie_widget_title',
                'natalie_widgets_title' => esc_html__('Title', 'natalie-wp'),
                'natalie_widgets_field_type' => 'text',
            ),

            'natalie_author_name' => array(
                'natalie_widgets_name' => 'natalie_author_name',
                'natalie_widgets_title' => esc_html__('Author Name', 'natalie-wp'),
                'natalie_widgets_field_type' => 'text',
            ),
            'natalie_author_desc' => array(
                'natalie_widgets_name' => 'natalie_author_desc',
                'natalie_widgets_title' => esc_html__('Author Description', 'natalie-wp'),
                'natalie_widgets_field_type' => 'textarea',
            ),
            'natalie_author_image' => array(
                'natalie_widgets_name' => 'natalie_author_image',
                'natalie_widgets_title' => esc_html__('Author Image', 'natalie-wp'),
                'natalie_widgets_field_type' => 'upload',
            ),
            'natalie_author_facebook' => array(
                'natalie_widgets_name' => 'natalie_author_facebook',
                'natalie_widgets_title' => esc_html__('Facebook Link', 'natalie-wp'),
                'natalie_widgets_field_type' => 'text',
            ),
            'natalie_author_twitter' => array(
                'natalie_widgets_name' => 'natalie_author_twitter',
                'natalie_widgets_title' => esc_html__('Twitter Link', 'natalie-wp'),
                'natalie_widgets_field_type' => 'text',
            ),
            'natalie_author_pinterest' => array(
                'natalie_widgets_name' => 'natalie_author_pinterest',
                'natalie_widgets_title' => esc_html__('Pinterest Link', 'natalie-wp'),
                'natalie_widgets_field_type' => 'text',
            ),
            'natalie_author_instagram' => array(
                'natalie_widgets_name' => 'natalie_author_instagram',
                'natalie_widgets_title' => esc_html__('Instagram Link', 'natalie-wp'),
                'natalie_widgets_field_type' => 'text',
            ),
            'natalie_author_linkedin' => array(
                'natalie_widgets_name' => 'natalie_author_linkedin',
                'natalie_widgets_title' => esc_html__('LinkedIn Link', 'natalie-wp'),
                'natalie_widgets_field_type' => 'text',
            ),
        );

        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {
        extract($args);
        //$natalie_widget_title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts', 'natalie-wp' );
        $natalie_widget_title = isset( $instance['natalie_widget_title'] ) ? $instance['natalie_widget_title'] : __( 'Recent Posts', 'natalie-wp' );
        $title = apply_filters( 'widget_title', $widget_name, $instance, $this->id_base );
        $natalie_author_name = apply_filters( 'widget_title', empty( $instance['natalie_author_name'] ) ? '' : $instance['natalie_author_name'], $instance, $this->id_base );       
        $natalie_author_desc = isset( $instance['natalie_author_desc'] ) ? $instance['natalie_author_desc'] : '' ;
        $natalie_author_image = isset( $instance['natalie_author_image'] ) ? $instance['natalie_author_image'] : '' ;
        $natalie_author_facebook = isset( $instance['natalie_author_facebook'] ) ? $instance['natalie_author_facebook'] : '' ;
        $natalie_author_twitter = isset( $instance['natalie_author_twitter'] ) ? $instance['natalie_author_twitter'] : '' ;
        $natalie_author_pinterest = isset( $instance['natalie_author_pinterest'] ) ? $instance['natalie_author_pinterest'] : '' ;
        $natalie_author_instagram = isset( $instance['natalie_author_instagram'] ) ? $instance['natalie_author_instagram'] : '' ;
        $natalie_author_linkedin = isset( $instance['natalie_author_linkedin'] ) ? $instance['natalie_author_linkedin'] : '' ;
        echo $before_widget;
        ?>



<div class="sidebar-widget widget-about mb-50 pt-30 pr-30 pb-30 pl-30 bg-white border-radius-5 has-border  wow fadeInUp  animated" style="visibility: visible; animation-name: fadeInUp;">
    <?php  if( $natalie_author_image ): ?>
        <img class="about-author-img mb-25" src="<?php echo esc_url($natalie_author_image)?>" alt="<?php echo esc_html($natalie_author_name); ?>">
    <?php endif;?>
    <?php if($natalie_author_name): ?>
    <h5 class="mb-20"><?php esc_html_e("Hello, I'm", 'natalie-wp');?> <?php echo esc_html($natalie_author_name); ?></h5>
    <?php endif;?>
    <?php if($natalie_author_desc): ?>
    <p class="font-medium text-muted"><?php echo esc_html($natalie_author_desc); ?></p>
    <?php endif;?>
   
    <ul class="header-social-network d-inline-block list-inline color-white mb-20">
    <?php if( $natalie_author_facebook ): ?>
        <li class="list-inline-item"><a class="fb" href="<?php echo esc_url( $natalie_author_facebook ); ?>" target="_blank" title="Facebook"><i class="elegant-icon social_facebook"></i></a></li>
    <?php endif;?>
    <?php if( $natalie_author_twitter ): ?>
        <li class="list-inline-item"><a class="tw" href="<?php echo esc_url( $natalie_author_twitter ); ?>" target="_blank" title="Tweet now"><i class="elegant-icon social_twitter"></i></a></li>
    <?php endif;?>
    <?php if( $natalie_author_instagram ): ?>
        <li class="list-inline-item"><a class="ig" href="<?php echo esc_url( $natalie_author_instagram ); ?>" target="_blank" title="Instagram"><i class="elegant-icon social_instagram"></i></a></li>
     <?php endif;?>

     <?php if( $natalie_author_linkedin ): ?>
        <li class="list-inline-item"><a class="lk" href="<?php echo esc_url( $natalie_author_linkedin ); ?>" target="_blank" title="Linked In"><i class="elegant-icon social_linkedin"></i></a></li>
     <?php endif;?>

     <?php if( $natalie_author_pinterest ): ?>
        <li class="list-inline-item"><a class="pt" href="<?php echo esc_url( $natalie_author_pinterest ); ?>" target="_blank" title="Pinterest"><i class="elegant-icon social_pinterest"></i></a></li>
     <?php endif;?>

    </ul>
</div>


<?php
        echo $after_widget;
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param   array   $new_instance   Values just sent to be saved.
     * @param   array   $old_instance   Previously saved values from database.
     *
     * @uses    natalie_widgets_updated_field_value()        defined in widget-fields.php
     *
     * @return  array Updated safe values to be saved.
     */
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ($widget_fields as $widget_field) {

            extract($widget_field);

            // Use helper function to get updated field values
            $instance[$natalie_widgets_name] = natalie_widgets_updated_field_value($widget_field, $new_instance[$natalie_widgets_name]);
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param   array $instance Previously saved values from database.
     *
     * @uses    natalie_widgets_show_widget_field()      defined in widget-fields.php
     */
    public function form($instance) {
        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ($widget_fields as $widget_field) {

            // Make array elements available as variables
            extract($widget_field);
            $natalie_widgets_field_value = !empty($instance[$natalie_widgets_name]) ? esc_attr($instance[$natalie_widgets_name]) : '';
            natalie_widgets_show_widget_field($this, $widget_field, $natalie_widgets_field_value);
        }
    }

}