<?php
/*
*   @Package Natalie WP
*
*   Footer template
*/
?>

<?php if(get_theme_mod('natalie_wp_show_newsletter')):?>
<?php $newsletter =  get_theme_mod( 'natalie_wp_subscribe_form_shortcode' );?>
<section class="newsletter">
<div class="container-fluid">
<?php if(!empty($newsletter)):?>    
            <div class="newsletter-width text-center">
                <div class="newsletter-info">
                    <?php $natalie_wp_subscribe_form_title = get_theme_mod('natalie_wp_subscribe_form_title');?>
                    <?php $natalie_wp_subscribe_form_description = get_theme_mod('natalie_wp_subscribe_form_description');?>
                    <?php if(!empty($natalie_wp_subscribe_form_title)):?>
                    <h5><?php echo $natalie_wp_subscribe_form_title;?></h5>
                    <?php endif;?>
                    <?php $natalie_wp_subscribe_form_description = get_theme_mod('natalie_wp_subscribe_form_description');?>
                    <?php if(!empty($natalie_wp_subscribe_form_description)):?>
                    <p><?php echo $natalie_wp_subscribe_form_description;?> </p>
                    <?php endif;?>
                    <?php echo do_shortcode($newsletter); ?>
                </div>
            </div>
        <?php endif;?>
        </div>
    </section>
<?php endif;?>

<?php if(function_exists('featured_category')) : echo featured_category(); endif; ?>
<footer class="pt-50 pb-50 footer-bg">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-6">
                <?php if(is_active_sidebar('footer-1')){
                    dynamic_sidebar('footer-1');
                }?>
            </div>
            <div class="col-lg-4 col-md-6">
                <?php if(is_active_sidebar('footer-2')){
                    dynamic_sidebar('footer-2');
                }?>
            </div>
            <div class="col-lg-4 col-md-6">
                <?php if(is_active_sidebar('footer-3')){
                    dynamic_sidebar('footer-3');
                }?>
            </div>
        </div>
        <div class="footer-copy-right pt-30 mt-20">
            <p class="float-md-left font-small text-white">&copy;
                <?php echo esc_html(get_theme_mod('natalie_wp_footer_copyright_text'));?>
                <?php esc_html_e('All Rights Reserved.', 'natalie-wp')?> |
                <?php esc_html_e('Natalie WP', 'natalie-wp')?> -
                <?php esc_html_e('A Free WordPress Theme For Bloggers', 'natalie-wp')?> </p>
            <p class="float-md-right font-small text-white"> |
                Design by <a target="_blank"
                    href="<?php echo esc_url( __( 'https://95media.co.uk', 'natalie-wp' ) ); ?>">
                    <?php esc_attr_e( '95media Themes', 'natalie-wp' ); ?>
                </a>
            </p>
            <p class="float-md-right font-small text-white mr-1">
                <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'natalie-wp' ) ); ?>">
                    <?php
							/* translators: %s: CMS name, i.e. WordPress. */
					printf( esc_html__( 'Proudly powered by %s', 'natalie-wp' ), 'WordPress' );?>
                </a>
            </p>
        </div>
    </div>
</footer>
<div id="back-top">
    <a title="Go to Top" href="#"> <i class="fas fa-arrow-up"></i></a>
</div>
<?php wp_footer();?>
</body>
</html>