# NARGA

NARGA is an extremely versatile HTML5 & CSS3 WordPress theme using ZURB's [Foundation](http://foundation.zurb.com), a powerful tool for building prototypes on any kind of devices. It'll help you do amazing things faster & easier than ever before. Along with the elegant design the theme is easily customizable with numerous theme options through Theme Customization.

NARGA follows [HTML5 Boilerplate](http://html5boilerplate.com) standard with the layout grid inspired by ZURB Foundation Templates and is [hNews microformat](https://www.readability.com/publishers/guidelines) ready. It is optimized for Search Engine while at the same time improves readability.

Because it's a percentage based grid system, it means that it will perfectly adapt to all screen resolutions (mobile, tablets and big screens). It is extremely easy to create your blog, CMS, brochure and any other kind of sites with NARGA WordPress Theme.

I've tested and found that NARGA works well with [bbPress 2.0](http://bbpress.org/) and [BuddyPress 1.5](http://buddypress.org/) but this time it's not official compatible with them.

If you have any questions that are beyond the scope of this help file, 
please visit narga.net. Thanks so much!

It is completely optional, but if you like the Theme I would appreciate it if you keep the credit link at the bottom.

### Links of NARGA
* Homepage          [http://www.narga.net/narga-core][5]
* Demo              [http://demo.narga.net/][3]
* Download (Stable) [http://wordpress.org/extend/themes/narga/][7]
* BitBucket (Dev)   [https://bitbucket.org/narga/narga-core/][6]
* GitHub (Dev)      [https://github.com/narga/narga-core][1]

_Notes:_ BitBucket & GitHub repositories are development version.

### Learn more about ZURB's Foundation CSS Framework

* [Foundation Homepage](http://foundation.zurb.com)
* [Foundation Documentation](http://foundation.zurb.com/docs)
* [Foundation GitHub](https://github.com/zurb/foundation)

## What are the Features?

NARGA inherits all the cool features from ZURB's Foundation CSS Framework, and packs with several other interesting features to optimize the experience for WordPress and HTML5. 

### Support Features
* HTML5 Boilerplate standard and is hNews microformat ready.
* Optimized for SEO.
* Inspired from ZURB Foundation Templates for better WordPress practice.
* Basic CSS included, you can also use it as a finished theme.
* Foundation files are separate, you can update Foundation without any problems. Of course, is is always a good idea to have some backups.
* Support child themes, all parent functions can replace in functions.php.

### WordPress Features
* Fully compatible with WordPress v3.4+ Theme Customizer features.
* Clean image HTML output for TinyMCE, only class and alt are returned. Post title will be automatically used for alt.
* Custom menu output from ZURB's Foundation Top Bar
* Custom caption output for HTML5 figure and figcaption tags.
* Custom filter for images, will automatically wrap images with figure tag.
* Two Widget: sidebar and footer.
* Several custom page templates are included in the package. A folder named custom is used for storing all your custom page templates. You can share your custom templates in the forum.
* Looks good but what if you don't need these features? Sure, you can turn them off.

## Usage

   1. Automatic Installation
      Go to WP-Admin > Appearance > Themes > Install Themes > Upload and choose the theme zip folder.

   2. Manual Installation
   Download **NARGA** WordPress theme then install it on your local WordPress or real website.
   
   This is meant to be a base theme for WordPress custom theme development. A knowledge of WordPress theme development practices as well as understanding of HTML, CSS/LESS, jQuery and PHP are required.
   
   If you want testing the development version, let's clone it from GitHub or BitBucket repositories.
   
   * Extract narga-core.zip and upload the theme folder via FTP to your `wp-content/themes/` directory.
   * Go to your `WordPress Admin Dashboard > Appearance > Themes` then select the NARGA screenshot.
   * Use **Live Preview** of **NARGA** to change the options before active.
   * Because NARGA supported child-theme, You can make your own child theme with highly customizable functions from it.

## License

NARGA had been crafted by [Nguyễn Đình Quân][2], it is licensed under a [GNU General Public License v2.0][4].

 [1]: https://github.com/narga/narga-core
 [2]: http://www.narga.net/
 [3]: http://demo.narga.net/
 [4]: http://www.gnu.org/licenses/gpl-2.0.html
 [5]: http://www.narga.net/narga-core/
 [6]: https://bitbucket.org/narga/narga-core
 [7]: http://wordpress.org/extend/themes/narga/
