<?php
/**
 * Sets all of our theme defaults.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'narayana_get_defaults' ) ) {
	/**
	 * Set default options
	 *
	 */
	function narayana_get_defaults() {
		$narayana_defaults = array(
			'hide_title' => '',
			'hide_tagline' => true,
			'top_bar_width' => 'full',
			'top_bar_inner_width' => 'full',
			'top_bar_alignment' => 'left',
			'container_width' => '1170',
			'header_layout_setting' => 'fluid-header',
			'header_inner_width' => 'full-width',
			'nav_alignment_setting' => 'right',
			'header_alignment_setting' => 'left',
			'nav_layout_setting' => 'fluid-nav',
			'nav_inner_width' => 'full-width',
			'nav_position_setting' => 'nav-float-right',
			'nav_dropdown_type' => 'hover',
			'nav_search' => 'enable',
			'content_layout_setting' => 'one-container',
			'layout_setting' => 'no-sidebar',
			'blog_layout_setting' => 'right-sidebar',
			'single_layout_setting' => 'right-sidebar',
			'fixed_side_content' => '',
			'blog_header_image' => '',
			'blog_header_title' => '',
			'blog_header_text' => '',
			'blog_header_button_text' => '',
			'blog_header_button_url' => '',
			'post_content' => 'excerpt',
			'footer_layout_setting' => 'fluid-footer',
			'footer_widgets_inner_width' => 'full-width',
			'footer_inner_width' => 'full-width',
			'footer_widget_setting' => '3',
			'footer_bar_alignment' => 'right',
			'back_to_top' => 'enable',
			'side_inside_color' => '#f4f0e3',
			'text_color' => '#333333',
			'link_color' => '#111111',
			'link_color_hover' => '#333333',
			'link_color_visited' => '',
			'font_awesome_essentials' => true,
		);

		return apply_filters( 'narayana_option_defaults', $narayana_defaults );
	}
}

if ( ! function_exists( 'narayana_get_color_defaults' ) ) {
	/**
	 * Set default options
	 */
	function narayana_get_color_defaults() {
		$narayana_color_defaults = array(
			'top_bar_background_color' => '#f4f0e3',
			'top_bar_text_color' => '#111111',
			'top_bar_link_color' => '#111111',
			'top_bar_link_color_hover' => '#c0ac67',
			'header_background_color' => '#f4f0e3',
			'header_text_color' => '',
			'header_link_color' => '',
			'header_link_hover_color' => '',
			'site_title_color' => '#111111',
			'site_tagline_color' => '#c0ac67',
			'navigation_background_color' => '#ce403d',
			'navigation_text_color' => '#f4f0e3',
			'navigation_background_hover_color' => '',
			'navigation_text_hover_color' => '#c0ac67',
			'navigation_background_current_color' => '',
			'navigation_text_current_color' => '',
			'subnavigation_background_color' => '#c0ac67',
			'subnavigation_text_color' => '#f4f0e3',
			'subnavigation_background_hover_color' => '',
			'subnavigation_text_hover_color' => '#111111',
			'subnavigation_background_current_color' => '',
			'subnavigation_text_current_color' => '',
			'fixed_side_content_background_color' => '#ce403d',
			'fixed_side_content_text_color' => '#f4f0e3',
			'fixed_side_content_link_color' => '#f4f0e3',
			'fixed_side_content_link_hover_color' => '#c0ac67',
			'content_background_color' => '',
			'content_text_color' => '',
			'content_link_color' => '',
			'content_link_hover_color' => '',
			'content_title_color' => '',
			'blog_header_title_color' => '#f4f0e3',
			'blog_header_text_color' => '#f4f0e3',
			'blog_header_button' => '#f4f0e3',
			'blog_header_button_bg' => '',
			'blog_header_button_hover' => '#ce403d',
			'blog_header_button_hover_bg' => '#f4f0e3',
			'blog_post_title_color' => '',
			'blog_post_title_hover_color' => '',
			'entry_meta_text_color' => '',
			'entry_meta_link_color' => '',
			'entry_meta_link_color_hover' => '',
			'h1_color' => '#111111',
			'h2_color' => '#111111',
			'h3_color' => '#111111',
			'h4_color' => '',
			'h5_color' => '',
			'h6_color' => '',
			'sidebar_widget_background_color' => '',
			'sidebar_widget_text_color' => '',
			'sidebar_widget_link_color' => '',
			'sidebar_widget_link_hover_color' => '',
			'sidebar_widget_title_color' => '',
			'footer_widget_background_color' => '#c0ac67',
			'footer_widget_text_color' => '#f4f0e3',
			'footer_widget_link_color' => '#111111',
			'footer_widget_link_hover_color' => '#f4f0e3',
			'footer_widget_title_color' => '#ce403d',
			'footer_background_color' => '#ce403d',
			'footer_text_color' => '#f4f0e3',
			'footer_link_color' => '#f4f0e3',
			'footer_link_hover_color' => '#c0ac67',
			'form_background_color' => '#fafafa',
			'form_text_color' => '#555555',
			'form_background_color_focus' => '#ffffff',
			'form_text_color_focus' => '#555555',
			'form_border_color' => '#cccccc',
			'form_border_color_focus' => '#bfbfbf',
			'form_button_background_color' => 'rgba(255,255,255,0)',
			'form_button_background_color_hover' => '#ffffff',
			'form_button_text_color' => '#ce403d',
			'form_button_text_color_hover' => '#ce403d',
			'back_to_top_background_color' => 'rgba(206,64,61,0.7)',
			'back_to_top_background_color_hover' => '#ce403d',
			'back_to_top_text_color' => '#f4f0e3',
			'back_to_top_text_color_hover' => '#f4f0e3',
		);

		return apply_filters( 'narayana_color_option_defaults', $narayana_color_defaults );
	}
}

if ( ! function_exists( 'narayana_get_default_fonts' ) ) {
	/**
	 * Set default options.
	 *
	 *
	 * @param bool $filter Whether to return the filtered values or original values.
	 * @return array Option defaults.
	 */
	function narayana_get_default_fonts( $filter = true ) {
		$narayana_font_defaults = array(
			'font_body' => 'Gaegu',
			'font_body_category' => '',
			'font_body_variants' => '300,regular,700',
			'body_font_weight' => '300',
			'body_font_transform' => 'none',
			'body_font_size' => '22',
			'body_line_height' => '1.3', // no unit
			'paragraph_margin' => '1.3', // em
			'font_top_bar' => 'inherit',
			'font_top_bar_category' => '',
			'font_top_bar_variants' => '',
			'top_bar_font_weight' => '500',
			'top_bar_font_transform' => 'none',
			'top_bar_font_size' => '16',
			'font_site_title' => 'Schoolbell',
			'font_site_title_category' => '',
			'font_site_title_variants' => 'regular',
			'site_title_font_weight' => '400',
			'site_title_font_transform' => 'uppercase',
			'site_title_font_size' => '45',
			'mobile_site_title_font_size' => '25',
			'font_site_tagline' => 'inherit',
			'font_site_tagline_category' => '',
			'font_site_tagline_variants' => '',
			'site_tagline_font_weight' => 'normal',
			'site_tagline_font_transform' => 'none',
			'site_tagline_font_size' => '19',
			'font_blog_header_title' => 'Schoolbell',
			'font_blog_header_title_category' => '',
			'font_blog_header_title_variants' => 'regular',
			'blog_header_title_font_weight' => 'normal',
			'blog_header_title_font_transform' => 'none',
			'font_blog_header_text' => 'inherit',
			'font_blog_header_text_category' => '',
			'font_blog_header_text_variants' => '',
			'blog_header_text_font_weight' => '700',
			'blog_header_text_font_transform' => 'none',
			'font_navigation' => 'Schoolbell',
			'font_navigation_category' => '',
			'font_navigation_variants' => 'regular',
			'navigation_font_weight' => '500',
			'navigation_font_transform' => 'uppercase',
			'navigation_font_size' => '18',
			'font_widget_title' => 'Schoolbell',
			'font_widget_title_category' => '',
			'font_widget_title_variants' => 'regular',
			'widget_title_font_weight' => 'normal',
			'widget_title_font_transform' => 'none',
			'widget_title_font_size' => '30',
			'widget_title_separator' => '18',
			'widget_content_font_size' => '20',
			'font_buttons' => 'inherit',
			'font_buttons_category' => '',
			'font_buttons_variants' => '',
			'buttons_font_weight' => '600',
			'buttons_font_transform' => 'none',
			'buttons_font_size' => '19',
			'font_heading_1' => 'inherit',
			'font_heading_1_category' => '',
			'font_heading_1_variants' => '',
			'heading_1_weight' => '600',
			'heading_1_transform' => 'none',
			'heading_1_font_size' => '80',
			'heading_1_line_height' => '1.2', // em
			'mobile_heading_1_font_size' => '30',
			'font_heading_2' => 'inherit',
			'font_heading_2_category' => '',
			'font_heading_2_variants' => '',
			'heading_2_weight' => '600',
			'heading_2_transform' => 'none',
			'heading_2_font_size' => '32',
			'heading_2_line_height' => '1.2', // em
			'mobile_heading_2_font_size' => '25',
			'font_heading_3' => 'inherit',
			'font_heading_3_category' => '',
			'font_heading_3_variants' => '',
			'heading_3_weight' => '600',
			'heading_3_transform' => 'none',
			'heading_3_font_size' => '25',
			'heading_3_line_height' => '1.2', // em
			'font_heading_4' => 'inherit',
			'font_heading_4_category' => '',
			'font_heading_4_variants' => '',
			'heading_4_weight' => 'normal',
			'heading_4_transform' => 'none',
			'heading_4_font_size' => '',
			'heading_4_line_height' => '', // em
			'font_heading_5' => 'inherit',
			'font_heading_5_category' => '',
			'font_heading_5_variants' => '',
			'heading_5_weight' => 'normal',
			'heading_5_transform' => 'none',
			'heading_5_font_size' => '',
			'heading_5_line_height' => '', // em
			'font_heading_6' => 'inherit',
			'font_heading_6_category' => '',
			'font_heading_6_variants' => '',
			'heading_6_weight' => 'normal',
			'heading_6_transform' => 'none',
			'heading_6_font_size' => '',
			'heading_6_line_height' => '', // em
			'font_footer' => 'Schoolbell',
			'font_footer_category' => '',
			'font_footer_variants' => 'regular',
			'footer_weight' => 'normal',
			'footer_transform' => 'none',
			'footer_font_size' => '20',
			'font_fixed_side' => 'Schoolbell',
			'font_fixed_side_category' => '',
			'font_fixed_side_variants' => 'regular',
			'fixed_side_font_weight' => 'normal',
			'fixed_side_font_transform' => 'none',
			'fixed_side_font_size' => '22',
		);

		if ( $filter ) {
			return apply_filters( 'narayana_font_option_defaults', $narayana_font_defaults );
		}

		return $narayana_font_defaults;
	}
}

if ( ! function_exists( 'narayana_spacing_get_defaults' ) ) {
	/**
	 * Set the default options.
	 *
	 *
	 * @param bool $filter Whether to return the filtered values or original values.
	 * @return array Option defaults.
	 */
	function narayana_spacing_get_defaults( $filter = true ) {
		$narayana_spacing_defaults = array(
			'top_bar_top' => '5',
			'top_bar_right' => '20',
			'top_bar_bottom' => '3',
			'top_bar_left' => '32',
			'header_top' => '0',
			'header_right' => '0',
			'header_bottom' => '0',
			'header_left' => '30',
			'fixed_side_margin_top' => '150',
			'fixed_side_margin_right' => '0',
			'fixed_side_margin_bottom' => '0',
			'fixed_side_margin_left' => '0',
			'fixed_side_top' => '3',
			'fixed_side_right' => '40',
			'fixed_side_bottom' => '0',
			'fixed_side_left' => '40',
			'menu_item' => '8',
			'menu_item_height' => '55',
			'sub_menu_item_height' => '10',
			'content_top' => '25',
			'content_right' => '15',
			'content_bottom' => '20',
			'content_left' => '15',
			'mobile_content_top' => '15',
			'mobile_content_right' => '15',
			'mobile_content_bottom' => '15',
			'mobile_content_left' => '15',
			'side_top' => '0',
			'side_right' => '0',
			'side_bottom' => '0',
			'side_left' => '30',
			'mobile_side_top' => '0',
			'mobile_side_right' => '0',
			'mobile_side_bottom' => '0',
			'mobile_side_left' => '0',
			'separator' => '15',
			'left_sidebar_width' => '25',
			'right_sidebar_width' => '25',
			'widget_top' => '0',
			'widget_right' => '15',
			'widget_bottom' => '40',
			'widget_left' => '15',
			'footer_widget_container_top' => '60',
			'footer_widget_container_right' => '60',
			'footer_widget_container_bottom' => '40',
			'footer_widget_container_left' => '60',
			'footer_widget_separator' => '30',
			'footer_top' => '8',
			'footer_right' => '30',
			'footer_bottom' => '5',
			'footer_left' => '30',
		);

		if ( $filter ) {
			return apply_filters( 'narayana_spacing_option_defaults', $narayana_spacing_defaults );
		}

		return $narayana_spacing_defaults;
	}
}

if ( ! function_exists( 'narayana_get_default_color_palettes' ) ) {
	/**
	 * Set up our colors for the color picker palettes and filter them so you can change them.
	 *
	 */
	function narayana_get_default_color_palettes() {
		$palettes = array(
			'#ce403d',
			'#c0ac67',
			'#f4f0e3',
			'#111111',
			'#333333',
			'#ffffff'
		);

		return apply_filters( 'narayana_default_color_palettes', $palettes );
	}
}

if ( ! function_exists( 'narayana_typography_default_fonts' ) ) {
	/**
	 * Set the default system fonts.
	 *
	 */
	function narayana_typography_default_fonts() {
		$fonts = array(
			'inherit',
			'System Stack',
			'Arial, Helvetica, sans-serif',
			'Courier New',
			'Georgia, Times New Roman, Times, serif',
			'Trebuchet MS, Helvetica, sans-serif',
			'Verdana, Geneva, sans-serif',
			'Schoolbell',
			'Gaegu'
		);

		return apply_filters( 'narayana_typography_default_fonts', $fonts );
	}
}

define('NARAYANA_DEFAULT_FONTS','//fonts.googleapis.com/css?family=Gaegu:300,regular,700|Schoolbell:regular');
