<?php
/**
 * Builds our admin page.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'narayana_create_menu' ) ) {
	add_action( 'admin_menu', 'narayana_create_menu' );
	/**
	 * Adds our "Narayana" dashboard menu item
	 *
	 */
	function narayana_create_menu() {
		$narayana_page = add_theme_page( 'Narayana', 'Narayana', apply_filters( 'narayana_dashboard_page_capability', 'edit_theme_options' ), 'narayana-options', 'narayana_settings_page' );
		add_action( "admin_print_styles-$narayana_page", 'narayana_options_styles' );
	}
}

if ( ! function_exists( 'narayana_options_styles' ) ) {
	/**
	 * Adds any necessary scripts to the Narayana dashboard page
	 *
	 */
	function narayana_options_styles() {
		wp_enqueue_style( 'narayana-options', get_template_directory_uri() . '/css/admin/admin-style.css', array(), NARAYANA_VERSION );
	}
}

if ( ! function_exists( 'narayana_settings_page' ) ) {
	/**
	 * Builds the content of our Narayana dashboard page
	 *
	 */
	function narayana_settings_page() {
		?>
		<div class="wrap">
			<div class="metabox-holder">
				<div class="narayana-masthead clearfix">
					<div class="narayana-container">
						<div class="narayana-title">
							<a href="<?php echo esc_url(NARAYANA_THEME_URL); ?>" target="_blank"><?php esc_html_e( 'Narayana', 'narayana' ); ?></a> <span class="narayana-version"><?php echo NARAYANA_VERSION; ?></span>
						</div>
						<div class="narayana-masthead-links">
							<?php if ( ! defined( 'NARAYANA_PREMIUM_VERSION' ) ) : ?>
								<a class="narayana-masthead-links-bold" href="<?php echo esc_url(NARAYANA_THEME_URL); ?>" target="_blank"><?php esc_html_e( 'Premium', 'narayana' );?></a>
							<?php endif; ?>
							<a href="<?php echo esc_url(NARAYANA_WPKOI_AUTHOR_URL); ?>" target="_blank"><?php esc_html_e( 'WPKoi', 'narayana' ); ?></a>
                            <a href="<?php echo esc_url(NARAYANA_DOCUMENTATION); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'narayana' ); ?></a>
						</div>
					</div>
				</div>

				<?php
				/**
				 * narayana_dashboard_after_header hook.
				 *
				 */
				 do_action( 'narayana_dashboard_after_header' );
				 ?>

				<div class="narayana-container">
					<div class="postbox-container clearfix" style="float: none;">
						<div class="grid-container grid-parent">

							<?php
							/**
							 * narayana_dashboard_inside_container hook.
							 *
							 */
							 do_action( 'narayana_dashboard_inside_container' );
							 ?>

							<div class="form-metabox grid-70" style="padding-left: 0;">
								<h2 style="height:0;margin:0;"><!-- admin notices below this element --></h2>
								<form method="post" action="options.php">
									<?php settings_fields( 'narayana-settings-group' ); ?>
									<?php do_settings_sections( 'narayana-settings-group' ); ?>
									<div class="customize-button hide-on-desktop">
										<?php
										printf( '<a id="narayana_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
											esc_url( admin_url( 'customize.php' ) ),
											esc_html__( 'Customize', 'narayana' )
										);
										?>
									</div>

									<?php
									/**
									 * narayana_inside_options_form hook.
									 *
									 */
									 do_action( 'narayana_inside_options_form' );
									 ?>
								</form>

								<?php
								$modules = array(
									'Backgrounds' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Blog' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Colors' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Copyright' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Disable Elements' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Demo Import' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Hooks' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Import / Export' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Menu Plus' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Page Header' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Secondary Nav' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Spacing' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Typography' => array(
											'url' => NARAYANA_THEME_URL,
									),
									'Elementor Addon' => array(
											'url' => NARAYANA_THEME_URL,
									)
								);

								if ( ! defined( 'NARAYANA_PREMIUM_VERSION' ) ) : ?>
									<div class="postbox narayana-metabox">
										<h3 class="hndle"><?php esc_html_e( 'Premium Modules', 'narayana' ); ?></h3>
										<div class="inside" style="margin:0;padding:0;">
											<div class="premium-addons">
												<?php foreach( $modules as $module => $info ) { ?>
												<div class="add-on activated narayana-clear addon-container grid-parent">
													<div class="addon-name column-addon-name" style="">
														<a href="<?php echo esc_url( $info[ 'url' ] ); ?>" target="_blank"><?php echo esc_html( $module ); ?></a>
													</div>
													<div class="addon-action addon-addon-action" style="text-align:right;">
														<a href="<?php echo esc_url( $info[ 'url' ] ); ?>" target="_blank"><?php esc_html_e( 'More info', 'narayana' ); ?></a>
													</div>
												</div>
												<div class="narayana-clear"></div>
												<?php } ?>
											</div>
										</div>
									</div>
								<?php
								endif;

								/**
								 * narayana_options_items hook.
								 *
								 */
								do_action( 'narayana_options_items' );
								?>
							</div>

							<div class="narayana-right-sidebar grid-30" style="padding-right: 0;">
								<div class="customize-button hide-on-mobile">
									<?php
									printf( '<a id="narayana_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
										esc_url( admin_url( 'customize.php' ) ),
										esc_html__( 'Customize', 'narayana' )
									);
									?>
								</div>

								<?php
								/**
								 * narayana_admin_right_panel hook.
								 *
								 */
								 do_action( 'narayana_admin_right_panel' );

								  ?>
                                
                                <div class="wpkoi-doc">
                                	<h3><?php esc_html_e( 'Narayana documentation', 'narayana' ); ?></h3>
                                	<p><?php esc_html_e( 'If You`ve stuck, the documentation may help on WPKoi.com', 'narayana' ); ?></p>
                                    <a href="<?php echo esc_url(NARAYANA_DOCUMENTATION); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Narayana documentation', 'narayana' ); ?></a>
                                </div>
                                
                                <div class="wpkoi-social">
                                	<h3><?php esc_html_e( 'WPKoi on Facebook', 'narayana' ); ?></h3>
                                	<p><?php esc_html_e( 'If You want to get useful info about WordPress and the theme, follow WPKoi on Facebook.', 'narayana' ); ?></p>
                                    <a href="<?php echo esc_url(NARAYANA_WPKOI_SOCIAL_URL); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Go to Facebook', 'narayana' ); ?></a>
                                </div>
                                
                                <div class="wpkoi-review">
                                	<h3><?php esc_html_e( 'Help with You review', 'narayana' ); ?></h3>
                                	<p><?php esc_html_e( 'If You like Narayana theme, show it to the world with Your review. Your feedback helps a lot.', 'narayana' ); ?></p>
                                    <a href="<?php echo esc_url(NARAYANA_WORDPRESS_REVIEW); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Add my review', 'narayana' ); ?></a>
                                </div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'narayana_admin_errors' ) ) {
	add_action( 'admin_notices', 'narayana_admin_errors' );
	/**
	 * Add our admin notices
	 *
	 */
	function narayana_admin_errors() {
		$screen = get_current_screen();

		if ( 'appearance_page_narayana-options' !== $screen->base ) {
			return;
		}

		if ( isset( $_GET['settings-updated'] ) && 'true' == $_GET['settings-updated'] ) {
			 add_settings_error( 'narayana-notices', 'true', esc_html__( 'Settings saved.', 'narayana' ), 'updated' );
		}

		if ( isset( $_GET['status'] ) && 'imported' == $_GET['status'] ) {
			 add_settings_error( 'narayana-notices', 'imported', esc_html__( 'Import successful.', 'narayana' ), 'updated' );
		}

		if ( isset( $_GET['status'] ) && 'reset' == $_GET['status'] ) {
			 add_settings_error( 'narayana-notices', 'reset', esc_html__( 'Settings removed.', 'narayana' ), 'updated' );
		}

		settings_errors( 'narayana-notices' );
	}
}
