<?php
/**
 * Builds our Customizer controls.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'customize_register', 'narayana_set_customizer_helpers', 1 );
/**
 * Set up helpers early so they're always available.
 * Other modules might need access to them at some point.
 *
 */
function narayana_set_customizer_helpers( $wp_customize ) {
	// Load helpers
	require_once trailingslashit( get_template_directory() ) . 'inc/customizer/customizer-helpers.php';
}

if ( ! function_exists( 'narayana_customize_register' ) ) {
	add_action( 'customize_register', 'narayana_customize_register' );
	/**
	 * Add our base options to the Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	function narayana_customize_register( $wp_customize ) {
		// Get our default values
		$defaults = narayana_get_defaults();

		// Load helpers
		require_once trailingslashit( get_template_directory() ) . 'inc/customizer/customizer-helpers.php';

		if ( $wp_customize->get_control( 'blogdescription' ) ) {
			$wp_customize->get_control('blogdescription')->priority = 3;
			$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
		}

		if ( $wp_customize->get_control( 'blogname' ) ) {
			$wp_customize->get_control('blogname')->priority = 1;
			$wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
		}

		if ( $wp_customize->get_control( 'custom_logo' ) ) {
			$wp_customize->get_setting( 'custom_logo' )->transport = 'refresh';
		}

		// Add control types so controls can be built using JS
		if ( method_exists( $wp_customize, 'register_control_type' ) ) {
			$wp_customize->register_control_type( 'Narayana_Customize_Misc_Control' );
			$wp_customize->register_control_type( 'Narayana_Range_Slider_Control' );
		}

		// Add upsell section type
		if ( method_exists( $wp_customize, 'register_section_type' ) ) {
			$wp_customize->register_section_type( 'Narayana_Upsell_Section' );
		}

		// Add selective refresh to site title and description
		if ( isset( $wp_customize->selective_refresh ) ) {
			$wp_customize->selective_refresh->add_partial( 'blogname', array(
				'selector' => '.main-title a',
				'render_callback' => 'narayana_customize_partial_blogname',
			) );

			$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
				'selector' => '.site-description',
				'render_callback' => 'narayana_customize_partial_blogdescription',
			) );
		}

		// Remove title
		$wp_customize->add_setting(
			'narayana_settings[hide_title]',
			array(
				'default' => $defaults['hide_title'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_checkbox'
			)
		);

		$wp_customize->add_control(
			'narayana_settings[hide_title]',
			array(
				'type' => 'checkbox',
				'label' => __( 'Hide site title', 'narayana' ),
				'section' => 'title_tagline',
				'priority' => 2
			)
		);

		// Remove tagline
		$wp_customize->add_setting(
			'narayana_settings[hide_tagline]',
			array(
				'default' => $defaults['hide_tagline'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_checkbox'
			)
		);

		$wp_customize->add_control(
			'narayana_settings[hide_tagline]',
			array(
				'type' => 'checkbox',
				'label' => __( 'Hide site tagline', 'narayana' ),
				'section' => 'title_tagline',
				'priority' => 4
			)
		);

		$wp_customize->add_setting(
			'narayana_settings[retina_logo]',
			array(
				'type' => 'option',
				'sanitize_callback' => 'esc_url_raw'
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'narayana_settings[retina_logo]',
				array(
					'label' => __( 'Retina Logo', 'narayana' ),
					'section' => 'title_tagline',
					'settings' => 'narayana_settings[retina_logo]',
					'active_callback' => 'narayana_has_custom_logo_callback'
				)
			)
		);

		$wp_customize->add_setting(
			'narayana_settings[side_inside_color]', array(
				'default' => $defaults['side_inside_color'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_hex_color',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'narayana_settings[side_inside_color]',
				array(
					'label' => __( 'Inside padding', 'narayana' ),
					'section' => 'colors',
					'settings' => 'narayana_settings[side_inside_color]',
					'active_callback' => 'narayana_is_side_padding_active',
				)
			)
		);

		$wp_customize->add_setting(
			'narayana_settings[text_color]', array(
				'default' => $defaults['text_color'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_hex_color',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'narayana_settings[text_color]',
				array(
					'label' => __( 'Text Color', 'narayana' ),
					'section' => 'colors',
					'settings' => 'narayana_settings[text_color]'
				)
			)
		);

		$wp_customize->add_setting(
			'narayana_settings[link_color]', array(
				'default' => $defaults['link_color'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_hex_color',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'narayana_settings[link_color]',
				array(
					'label' => __( 'Link Color', 'narayana' ),
					'section' => 'colors',
					'settings' => 'narayana_settings[link_color]'
				)
			)
		);

		$wp_customize->add_setting(
			'narayana_settings[link_color_hover]', array(
				'default' => $defaults['link_color_hover'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_hex_color',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'narayana_settings[link_color_hover]',
				array(
					'label' => __( 'Link Color Hover', 'narayana' ),
					'section' => 'colors',
					'settings' => 'narayana_settings[link_color_hover]'
				)
			)
		);

		$wp_customize->add_setting(
			'narayana_settings[link_color_visited]', array(
				'default' => $defaults['link_color_visited'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_hex_color',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'narayana_settings[link_color_visited]',
				array(
					'label' => __( 'Link Color Visited', 'narayana' ),
					'section' => 'colors',
					'settings' => 'narayana_settings[link_color_visited]'
				)
			)
		);

		if ( ! function_exists( 'narayana_colors_customize_register' ) && ! defined( 'NARAYANA_PREMIUM_VERSION' ) ) {
			$wp_customize->add_control(
				new Narayana_Customize_Misc_Control(
					$wp_customize,
					'colors_get_addon_desc',
					array(
						'section' => 'colors',
						'type' => 'addon',
						'label' => __( 'More info', 'narayana' ),
						'description' => __( 'More colors are available in Narayana premium version. Visit wpkoi.com for more info.', 'narayana' ),
						'url' => esc_url( NARAYANA_THEME_URL ),
						'priority' => 30,
						'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname'
					)
				)
			);
		}

		if ( class_exists( 'WP_Customize_Panel' ) ) {
			if ( ! $wp_customize->get_panel( 'narayana_layout_panel' ) ) {
				$wp_customize->add_panel( 'narayana_layout_panel', array(
					'priority' => 25,
					'title' => __( 'Layout', 'narayana' ),
				) );
			}
		}

		// Add Layout section
		$wp_customize->add_section(
			'narayana_layout_container',
			array(
				'title' => __( 'Container', 'narayana' ),
				'priority' => 10,
				'panel' => 'narayana_layout_panel'
			)
		);

		// Container width
		$wp_customize->add_setting(
			'narayana_settings[container_width]',
			array(
				'default' => $defaults['container_width'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_integer',
				'transport' => 'postMessage'
			)
		);

		$wp_customize->add_control(
			new Narayana_Range_Slider_Control(
				$wp_customize,
				'narayana_settings[container_width]',
				array(
					'type' => 'narayana-range-slider',
					'label' => __( 'Container Width', 'narayana' ),
					'section' => 'narayana_layout_container',
					'settings' => array(
						'desktop' => 'narayana_settings[container_width]',
					),
					'choices' => array(
						'desktop' => array(
							'min' => 700,
							'max' => 2000,
							'step' => 5,
							'edit' => true,
							'unit' => 'px',
						),
					),
					'priority' => 0,
				)
			)
		);

		// Add Top Bar section
		$wp_customize->add_section(
			'narayana_top_bar',
			array(
				'title' => __( 'Top Bar', 'narayana' ),
				'priority' => 15,
				'panel' => 'narayana_layout_panel',
			)
		);

		// Add Top Bar width
		$wp_customize->add_setting(
			'narayana_settings[top_bar_width]',
			array(
				'default' => $defaults['top_bar_width'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add Top Bar width control
		$wp_customize->add_control(
			'narayana_settings[top_bar_width]',
			array(
				'type' => 'select',
				'label' => __( 'Top Bar Width', 'narayana' ),
				'section' => 'narayana_top_bar',
				'choices' => array(
					'full' => __( 'Full', 'narayana' ),
					'contained' => __( 'Contained', 'narayana' )
				),
				'settings' => 'narayana_settings[top_bar_width]',
				'priority' => 5,
				'active_callback' => 'narayana_is_top_bar_active',
			)
		);

		// Add Top Bar inner width
		$wp_customize->add_setting(
			'narayana_settings[top_bar_inner_width]',
			array(
				'default' => $defaults['top_bar_inner_width'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add Top Bar width control
		$wp_customize->add_control(
			'narayana_settings[top_bar_inner_width]',
			array(
				'type' => 'select',
				'label' => __( 'Top Bar Inner Width', 'narayana' ),
				'section' => 'narayana_top_bar',
				'choices' => array(
					'full' => __( 'Full', 'narayana' ),
					'contained' => __( 'Contained', 'narayana' )
				),
				'settings' => 'narayana_settings[top_bar_inner_width]',
				'priority' => 10,
				'active_callback' => 'narayana_is_top_bar_active',
			)
		);

		// Add top bar alignment
		$wp_customize->add_setting(
			'narayana_settings[top_bar_alignment]',
			array(
				'default' => $defaults['top_bar_alignment'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add navigation control
		$wp_customize->add_control(
			'narayana_settings[top_bar_alignment]',
			array(
				'type' => 'select',
				'label' => __( 'Top Bar Alignment', 'narayana' ),
				'section' => 'narayana_top_bar',
				'choices' => array(
					'left' => __( 'Left', 'narayana' ),
					'center' => __( 'Center', 'narayana' ),
					'right' => __( 'Right', 'narayana' )
				),
				'settings' => 'narayana_settings[top_bar_alignment]',
				'priority' => 15,
				'active_callback' => 'narayana_is_top_bar_active',
			)
		);

		// Add Header section
		$wp_customize->add_section(
			'narayana_layout_header',
			array(
				'title' => __( 'Header', 'narayana' ),
				'priority' => 20,
				'panel' => 'narayana_layout_panel'
			)
		);

		// Add Header Layout setting
		$wp_customize->add_setting(
			'narayana_settings[header_layout_setting]',
			array(
				'default' => $defaults['header_layout_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add Header Layout control
		$wp_customize->add_control(
			'narayana_settings[header_layout_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Header Width', 'narayana' ),
				'section' => 'narayana_layout_header',
				'choices' => array(
					'fluid-header' => __( 'Full', 'narayana' ),
					'contained-header' => __( 'Contained', 'narayana' )
				),
				'settings' => 'narayana_settings[header_layout_setting]',
				'priority' => 5
			)
		);

		// Add Inside Header Layout setting
		$wp_customize->add_setting(
			'narayana_settings[header_inner_width]',
			array(
				'default' => $defaults['header_inner_width'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add Header Layout control
		$wp_customize->add_control(
			'narayana_settings[header_inner_width]',
			array(
				'type' => 'select',
				'label' => __( 'Inner Header Width', 'narayana' ),
				'section' => 'narayana_layout_header',
				'choices' => array(
					'contained' => __( 'Contained', 'narayana' ),
					'full-width' => __( 'Full', 'narayana' )
				),
				'settings' => 'narayana_settings[header_inner_width]',
				'priority' => 6
			)
		);

		// Add navigation setting
		$wp_customize->add_setting(
			'narayana_settings[header_alignment_setting]',
			array(
				'default' => $defaults['header_alignment_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add navigation control
		$wp_customize->add_control(
			'narayana_settings[header_alignment_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Header Alignment', 'narayana' ),
				'section' => 'narayana_layout_header',
				'choices' => array(
					'left' => __( 'Left', 'narayana' ),
					'center' => __( 'Center', 'narayana' ),
					'right' => __( 'Right', 'narayana' )
				),
				'settings' => 'narayana_settings[header_alignment_setting]',
				'priority' => 10
			)
		);

		$wp_customize->add_section(
			'narayana_layout_navigation',
			array(
				'title' => __( 'Primary Navigation', 'narayana' ),
				'priority' => 30,
				'panel' => 'narayana_layout_panel'
			)
		);

		// Add navigation setting
		$wp_customize->add_setting(
			'narayana_settings[nav_layout_setting]',
			array(
				'default' => $defaults['nav_layout_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add navigation control
		$wp_customize->add_control(
			'narayana_settings[nav_layout_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Navigation Width', 'narayana' ),
				'section' => 'narayana_layout_navigation',
				'choices' => array(
					'fluid-nav' => __( 'Full', 'narayana' ),
					'contained-nav' => __( 'Contained', 'narayana' )
				),
				'settings' => 'narayana_settings[nav_layout_setting]',
				'priority' => 15
			)
		);

		// Add navigation setting
		$wp_customize->add_setting(
			'narayana_settings[nav_inner_width]',
			array(
				'default' => $defaults['nav_inner_width'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add navigation control
		$wp_customize->add_control(
			'narayana_settings[nav_inner_width]',
			array(
				'type' => 'select',
				'label' => __( 'Inner Navigation Width', 'narayana' ),
				'section' => 'narayana_layout_navigation',
				'choices' => array(
					'contained' => __( 'Contained', 'narayana' ),
					'full-width' => __( 'Full', 'narayana' )
				),
				'settings' => 'narayana_settings[nav_inner_width]',
				'priority' => 16
			)
		);

		// Add navigation setting
		$wp_customize->add_setting(
			'narayana_settings[nav_alignment_setting]',
			array(
				'default' => $defaults['nav_alignment_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add navigation control
		$wp_customize->add_control(
			'narayana_settings[nav_alignment_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Navigation Alignment', 'narayana' ),
				'section' => 'narayana_layout_navigation',
				'choices' => array(
					'left' => __( 'Left', 'narayana' ),
					'center' => __( 'Center', 'narayana' ),
					'right' => __( 'Right', 'narayana' )
				),
				'settings' => 'narayana_settings[nav_alignment_setting]',
				'priority' => 20
			)
		);

		// Add navigation setting
		$wp_customize->add_setting(
			'narayana_settings[nav_position_setting]',
			array(
				'default' => $defaults['nav_position_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => ( '' !== narayana_get_setting( 'nav_position_setting' ) ) ? 'postMessage' : 'refresh'
			)
		);

		// Add navigation control
		$wp_customize->add_control(
			'narayana_settings[nav_position_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Navigation Location', 'narayana' ),
				'section' => 'narayana_layout_navigation',
				'choices' => array(
					'nav-below-header' => __( 'Below Header', 'narayana' ),
					'nav-above-header' => __( 'Above Header', 'narayana' ),
					'nav-float-right' => __( 'Float Right', 'narayana' ),
					'nav-float-left' => __( 'Float Left', 'narayana' ),
					'nav-left-sidebar' => __( 'Left Sidebar', 'narayana' ),
					'nav-right-sidebar' => __( 'Right Sidebar', 'narayana' ),
					'' => __( 'No Navigation', 'narayana' )
				),
				'settings' => 'narayana_settings[nav_position_setting]',
				'priority' => 22
			)
		);

		// Add navigation setting
		$wp_customize->add_setting(
			'narayana_settings[nav_dropdown_type]',
			array(
				'default' => $defaults['nav_dropdown_type'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices'
			)
		);

		// Add navigation control
		$wp_customize->add_control(
			'narayana_settings[nav_dropdown_type]',
			array(
				'type' => 'select',
				'label' => __( 'Navigation Dropdown', 'narayana' ),
				'section' => 'narayana_layout_navigation',
				'choices' => array(
					'hover' => __( 'Hover', 'narayana' ),
					'click' => __( 'Click - Menu Item', 'narayana' ),
					'click-arrow' => __( 'Click - Arrow', 'narayana' )
				),
				'settings' => 'narayana_settings[nav_dropdown_type]',
				'priority' => 22
			)
		);

		// Add navigation setting
		$wp_customize->add_setting(
			'narayana_settings[nav_search]',
			array(
				'default' => $defaults['nav_search'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices'
			)
		);

		// Add navigation control
		$wp_customize->add_control(
			'narayana_settings[nav_search]',
			array(
				'type' => 'select',
				'label' => __( 'Navigation Search', 'narayana' ),
				'section' => 'narayana_layout_navigation',
				'choices' => array(
					'enable' => __( 'Enable', 'narayana' ),
					'disable' => __( 'Disable', 'narayana' )
				),
				'settings' => 'narayana_settings[nav_search]',
				'priority' => 23
			)
		);

		// Add content setting
		$wp_customize->add_setting(
			'narayana_settings[content_layout_setting]',
			array(
				'default' => $defaults['content_layout_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add content control
		$wp_customize->add_control(
			'narayana_settings[content_layout_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Content Layout', 'narayana' ),
				'section' => 'narayana_layout_container',
				'choices' => array(
					'separate-containers' => __( 'Separate Containers', 'narayana' ),
					'one-container' => __( 'One Container', 'narayana' )
				),
				'settings' => 'narayana_settings[content_layout_setting]',
				'priority' => 25
			)
		);

		$wp_customize->add_section(
			'narayana_layout_sidecontent',
			array(
				'title' => __( 'Fixed Side Content', 'narayana' ),
				'priority' => 39,
				'panel' => 'narayana_layout_panel'
			)
		);
		
		$wp_customize->add_setting(
			'narayana_settings[fixed_side_content]',
			array(
				'default' => $defaults['fixed_side_content'],
				'type' => 'option',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			'narayana_settings[fixed_side_content]',
			array(
				'type' 		 => 'textarea',
				'label'      => __( 'Fixed Side Content', 'narayana' ),
				'description'=> __( 'Content that You want to display fixed on the left.', 'narayana' ),
				'section'    => 'narayana_layout_sidecontent',
				'settings'   => 'narayana_settings[fixed_side_content]',
			)
		);

		$wp_customize->add_section(
			'narayana_layout_sidebars',
			array(
				'title' => __( 'Sidebars', 'narayana' ),
				'priority' => 40,
				'panel' => 'narayana_layout_panel'
			)
		);

		// Add Layout setting
		$wp_customize->add_setting(
			'narayana_settings[layout_setting]',
			array(
				'default' => $defaults['layout_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices'
			)
		);

		// Add Layout control
		$wp_customize->add_control(
			'narayana_settings[layout_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Sidebar Layout', 'narayana' ),
				'section' => 'narayana_layout_sidebars',
				'choices' => array(
					'left-sidebar' => __( 'Sidebar / Content', 'narayana' ),
					'right-sidebar' => __( 'Content / Sidebar', 'narayana' ),
					'no-sidebar' => __( 'Content (no sidebars)', 'narayana' ),
					'both-sidebars' => __( 'Sidebar / Content / Sidebar', 'narayana' ),
					'both-left' => __( 'Sidebar / Sidebar / Content', 'narayana' ),
					'both-right' => __( 'Content / Sidebar / Sidebar', 'narayana' )
				),
				'settings' => 'narayana_settings[layout_setting]',
				'priority' => 30
			)
		);

		// Add Layout setting
		$wp_customize->add_setting(
			'narayana_settings[blog_layout_setting]',
			array(
				'default' => $defaults['blog_layout_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices'
			)
		);

		// Add Layout control
		$wp_customize->add_control(
			'narayana_settings[blog_layout_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Blog Sidebar Layout', 'narayana' ),
				'section' => 'narayana_layout_sidebars',
				'choices' => array(
					'left-sidebar' => __( 'Sidebar / Content', 'narayana' ),
					'right-sidebar' => __( 'Content / Sidebar', 'narayana' ),
					'no-sidebar' => __( 'Content (no sidebars)', 'narayana' ),
					'both-sidebars' => __( 'Sidebar / Content / Sidebar', 'narayana' ),
					'both-left' => __( 'Sidebar / Sidebar / Content', 'narayana' ),
					'both-right' => __( 'Content / Sidebar / Sidebar', 'narayana' )
				),
				'settings' => 'narayana_settings[blog_layout_setting]',
				'priority' => 35
			)
		);

		// Add Layout setting
		$wp_customize->add_setting(
			'narayana_settings[single_layout_setting]',
			array(
				'default' => $defaults['single_layout_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices'
			)
		);

		// Add Layout control
		$wp_customize->add_control(
			'narayana_settings[single_layout_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Single Post Sidebar Layout', 'narayana' ),
				'section' => 'narayana_layout_sidebars',
				'choices' => array(
					'left-sidebar' => __( 'Sidebar / Content', 'narayana' ),
					'right-sidebar' => __( 'Content / Sidebar', 'narayana' ),
					'no-sidebar' => __( 'Content (no sidebars)', 'narayana' ),
					'both-sidebars' => __( 'Sidebar / Content / Sidebar', 'narayana' ),
					'both-left' => __( 'Sidebar / Sidebar / Content', 'narayana' ),
					'both-right' => __( 'Content / Sidebar / Sidebar', 'narayana' )
				),
				'settings' => 'narayana_settings[single_layout_setting]',
				'priority' => 36
			)
		);

		$wp_customize->add_section(
			'narayana_layout_footer',
			array(
				'title' => __( 'Footer', 'narayana' ),
				'priority' => 50,
				'panel' => 'narayana_layout_panel'
			)
		);

		// Add footer setting
		$wp_customize->add_setting(
			'narayana_settings[footer_layout_setting]',
			array(
				'default' => $defaults['footer_layout_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add content control
		$wp_customize->add_control(
			'narayana_settings[footer_layout_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Footer Width', 'narayana' ),
				'section' => 'narayana_layout_footer',
				'choices' => array(
					'fluid-footer' => __( 'Full', 'narayana' ),
					'contained-footer' => __( 'Contained', 'narayana' )
				),
				'settings' => 'narayana_settings[footer_layout_setting]',
				'priority' => 40
			)
		);

		// Add footer setting
		$wp_customize->add_setting(
			'narayana_settings[footer_widgets_inner_width]',
			array(
				'default' => $defaults['footer_widgets_inner_width'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
			)
		);

		// Add content control
		$wp_customize->add_control(
			'narayana_settings[footer_widgets_inner_width]',
			array(
				'type' => 'select',
				'label' => __( 'Inner Footer Widgets Width', 'narayana' ),
				'section' => 'narayana_layout_footer',
				'choices' => array(
					'contained' => __( 'Contained', 'narayana' ),
					'full-width' => __( 'Full', 'narayana' )
				),
				'settings' => 'narayana_settings[footer_widgets_inner_width]',
				'priority' => 41
			)
		);

		// Add footer setting
		$wp_customize->add_setting(
			'narayana_settings[footer_inner_width]',
			array(
				'default' => $defaults['footer_inner_width'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add content control
		$wp_customize->add_control(
			'narayana_settings[footer_inner_width]',
			array(
				'type' => 'select',
				'label' => __( 'Inner Footer Width', 'narayana' ),
				'section' => 'narayana_layout_footer',
				'choices' => array(
					'contained' => __( 'Contained', 'narayana' ),
					'full-width' => __( 'Full', 'narayana' )
				),
				'settings' => 'narayana_settings[footer_inner_width]',
				'priority' => 41
			)
		);

		// Add footer widget setting
		$wp_customize->add_setting(
			'narayana_settings[footer_widget_setting]',
			array(
				'default' => $defaults['footer_widget_setting'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add footer widget control
		$wp_customize->add_control(
			'narayana_settings[footer_widget_setting]',
			array(
				'type' => 'select',
				'label' => __( 'Footer Widgets', 'narayana' ),
				'section' => 'narayana_layout_footer',
				'choices' => array(
					'0' => '0',
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5'
				),
				'settings' => 'narayana_settings[footer_widget_setting]',
				'priority' => 45
			)
		);

		// Add footer widget setting
		$wp_customize->add_setting(
			'narayana_settings[footer_bar_alignment]',
			array(
				'default' => $defaults['footer_bar_alignment'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices',
				'transport' => 'postMessage'
			)
		);

		// Add footer widget control
		$wp_customize->add_control(
			'narayana_settings[footer_bar_alignment]',
			array(
				'type' => 'select',
				'label' => __( 'Footer Bar Alignment', 'narayana' ),
				'section' => 'narayana_layout_footer',
				'choices' => array(
					'left' => __( 'Left','narayana' ),
					'center' => __( 'Center','narayana' ),
					'right' => __( 'Right','narayana' )
				),
				'settings' => 'narayana_settings[footer_bar_alignment]',
				'priority' => 47,
				'active_callback' => 'narayana_is_footer_bar_active'
			)
		);

		// Add back to top setting
		$wp_customize->add_setting(
			'narayana_settings[back_to_top]',
			array(
				'default' => $defaults['back_to_top'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_choices'
			)
		);

		// Add content control
		$wp_customize->add_control(
			'narayana_settings[back_to_top]',
			array(
				'type' => 'select',
				'label' => __( 'Back to Top Button', 'narayana' ),
				'section' => 'narayana_layout_footer',
				'choices' => array(
					'enable' => __( 'Enable', 'narayana' ),
					'' => __( 'Disable', 'narayana' )
				),
				'settings' => 'narayana_settings[back_to_top]',
				'priority' => 50
			)
		);

		// Add Layout section
		$wp_customize->add_section(
			'narayana_blog_section',
			array(
				'title' => __( 'Blog', 'narayana' ),
				'priority' => 55,
				'panel' => 'narayana_layout_panel'
			)
		);

		$wp_customize->add_setting(
			'narayana_settings[blog_header_image]',
			array(
				'default' => $defaults['blog_header_image'],
				'type' => 'option',
				'sanitize_callback' => 'esc_url_raw'
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'narayana_settings[blog_header_image]',
				array(
					'label' => __( 'Blog Header image', 'narayana' ),
					'section' => 'narayana_blog_section',
					'settings' => 'narayana_settings[blog_header_image]',
					'description' => __( 'Recommended size: 1920*935px', 'narayana' )
				)
			)
		);

		// Blog header texts
		$wp_customize->add_setting(
			'narayana_settings[blog_header_title]',
			array(
				'default' => $defaults['blog_header_title'],
				'type' => 'option',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			'narayana_settings[blog_header_title]',
			array(
				'type' 		 => 'textarea',
				'label'      => __( 'Blog Header title', 'narayana' ),
				'section'    => 'narayana_blog_section',
				'settings'   => 'narayana_settings[blog_header_title]',
			)
		);
		
		$wp_customize->add_setting(
			'narayana_settings[blog_header_text]',
			array(
				'default' => $defaults['blog_header_text'],
				'type' => 'option',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			'narayana_settings[blog_header_text]',
			array(
				'type' 		 => 'textarea',
				'label'      => __( 'Blog Header text', 'narayana' ),
				'section'    => 'narayana_blog_section',
				'settings'   => 'narayana_settings[blog_header_text]',
			)
		);
		
		$wp_customize->add_setting(
			'narayana_settings[blog_header_button_text]',
			array(
				'default' => $defaults['blog_header_button_text'],
				'type' => 'option',
				'sanitize_callback' => 'esc_html',
			)
		);

		$wp_customize->add_control(
			'narayana_settings[blog_header_button_text]',
			array(
				'type' 		 => 'text',
				'label'      => __( 'Blog Header button text', 'narayana' ),
				'section'    => 'narayana_blog_section',
				'settings'   => 'narayana_settings[blog_header_button_text]',
			)
		);
		
		$wp_customize->add_setting(
			'narayana_settings[blog_header_button_url]',
			array(
				'default' => $defaults['blog_header_button_url'],
				'type' => 'option',
				'sanitize_callback' => 'esc_url',
			)
		);

		$wp_customize->add_control(
			'narayana_settings[blog_header_button_url]',
			array(
				'type' 		 => 'text',
				'label'      => __( 'Blog Header button url', 'narayana' ),
				'section'    => 'narayana_blog_section',
				'settings'   => 'narayana_settings[blog_header_button_url]',
			)
		);

		// Add Layout setting
		$wp_customize->add_setting(
			'narayana_settings[post_content]',
			array(
				'default' => $defaults['post_content'],
				'type' => 'option',
				'sanitize_callback' => 'narayana_sanitize_blog_excerpt'
			)
		);

		// Add Layout control
		$wp_customize->add_control(
			'blog_content_control',
			array(
				'type' => 'select',
				'label' => __( 'Content Type', 'narayana' ),
				'section' => 'narayana_blog_section',
				'choices' => array(
					'full' => __( 'Full', 'narayana' ),
					'excerpt' => __( 'Excerpt', 'narayana' )
				),
				'settings' => 'narayana_settings[post_content]',
				'priority' => 10
			)
		);

		if ( ! function_exists( 'narayana_blog_customize_register' ) && ! defined( 'NARAYANA_PREMIUM_VERSION' ) ) {
			$wp_customize->add_control(
				new Narayana_Customize_Misc_Control(
					$wp_customize,
					'blog_get_addon_desc',
					array(
						'section' => 'narayana_blog_section',
						'type' => 'addon',
						'label' => __( 'Learn more', 'narayana' ),
						'description' => __( 'More options are available for this section in our premium version.', 'narayana' ),
						'url' => esc_url( NARAYANA_THEME_URL ),
						'priority' => 30,
						'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname'
					)
				)
			);
		}

		// Add Performance section
		$wp_customize->add_section(
			'narayana_general_section',
			array(
				'title' => __( 'General', 'narayana' ),
				'priority' => 99
			)
		);

		if ( ! apply_filters( 'narayana_fontawesome_essentials', false ) ) {
			$wp_customize->add_setting(
				'narayana_settings[font_awesome_essentials]',
				array(
					'default' => $defaults['font_awesome_essentials'],
					'type' => 'option',
					'sanitize_callback' => 'narayana_sanitize_checkbox'
				)
			);

			$wp_customize->add_control(
				'narayana_settings[font_awesome_essentials]',
				array(
					'type' => 'checkbox',
					'label' => __( 'Load essential icons only', 'narayana' ),
					'description' => __( 'Load essential Font Awesome icons instead of the full library.', 'narayana' ),
					'section' => 'narayana_general_section',
					'settings' => 'narayana_settings[font_awesome_essentials]',
				)
			);
		}

		// Add Narayana Premium section
		if ( ! defined( 'NARAYANA_PREMIUM_VERSION' ) ) {
			$wp_customize->add_section(
				new Narayana_Upsell_Section( $wp_customize, 'narayana_upsell_section',
					array(
						'pro_text' => __( 'Get Premium for more!', 'narayana' ),
						'pro_url' => esc_url( NARAYANA_THEME_URL ),
						'capability' => 'edit_theme_options',
						'priority' => 555,
						'type' => 'narayana-upsell-section',
					)
				)
			);
		}
	}
}

if ( ! function_exists( 'narayana_customizer_live_preview' ) ) {
	add_action( 'customize_preview_init', 'narayana_customizer_live_preview', 100 );
	/**
	 * Add our live preview scripts
	 *
	 */
	function narayana_customizer_live_preview() {
		wp_enqueue_script( 'narayana-themecustomizer', trailingslashit( get_template_directory_uri() ) . 'inc/customizer/controls/js/customizer-live-preview.js', array( 'customize-preview' ), NARAYANA_VERSION, true );
	}
}
