<?php
/**
 * Template part for displaying a message that posts cannot be found.
 *
 * @package Napoli
 */

?>

<section class="no-results not-found type-page">

	<div class="post-content clearfix">

		<header class="entry-header">

			<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'napoli' ); ?></h1>

		</header><!-- .entry-header -->

		<div class="entry-content clearfix">

			<?php
			if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

				<p><?php printf( wp_kses( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'napoli' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

			<?php elseif ( is_search() ) : ?>

				<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'napoli' ); ?></p>
				<?php
					get_search_form();

			else : ?>

				<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'napoli' ); ?></p>
				<?php
					get_search_form();

			endif; ?>

		</div><!-- .entry-content -->

	</div>

</section><!-- .no-results -->
