<?php
/**
 * Customizer functionality
 *
 * @package My Music Band
 */

/**
 * Sets up the WordPress core custom header and custom background features.
 *
 * @since My Music Band 0.1

 *
 * @see my_music_band_header_style()
 */
if ( ! function_exists( 'my_music_band_custom_header_and_background' ) ):
function my_music_band_custom_header_and_background() {
	$default_background_color = '#f0f0f0';
	$default_text_color       = '#373737';

	/**
	 * Filter the arguments used when adding 'custom-background' support in My Music Band.
	 *
	 * @since My Music Band 0.1

	 *
	 * @param array $args {
	 *     An array of custom-background support arguments.
	 *
	 *     @type string $default-color Default color of the background.
	 * }
	 */
	add_theme_support( 'custom-background', apply_filters( 'my_music_band_custom_background_args', array(
		'default-color' => $default_background_color,
	) ) );

	/**
	 * Filter the arguments used when adding 'custom-header' support in My Music Band.
	 *
	 * @since My Music Band 0.1

	 *
	 * @param array $args {
	 *     An array of custom-header support arguments.
	 *
	 *     @type string $default-text-color Default color of the header text.
	 *     @type int      $width            Width in pixels of the custom header image. Default 1200.
	 *     @type int      $height           Height in pixels of the custom header image. Default 280.
	 *     @type bool     $flex-height      Whether to allow flexible-height header images. Default true.
	 *     @type callable $wp-head-callback Callback function used to style the header image and text
	 *                                      displayed on the blog.
	 * }
	 */
	add_theme_support( 'custom-header', apply_filters( 'my_music_band_custom_header_args', array(
		'default-image'      	 => get_parent_theme_file_uri( '/assets/images/header-image.jpg' ),
		'default-text-color'     => $default_text_color,
		'width'                  => 1920,
		'height'                 => 1080,
		'flex-height'            => true,
		'flex-width'            => true,
		'wp-head-callback'       => 'my_music_band_header_style',
		'video'                  => true,
	) ) );

	register_default_headers( array(
		'default-image' => array(
			'url'           => '%s/assets/images/header-image.jpg',
			'thumbnail_url' => '%s/assets/images/header-image-275x155.jpg',
			'description'   => esc_html__( 'Default Header Image', 'my-music-band' ),
		),
		'second-image' => array(
			'url'           => '%s/assets/images/header-image-1.jpg',
			'thumbnail_url' => '%s/assets/images/header-image-1-275x155.jpg',
			'description'   => esc_html__( 'Boxed Header Image', 'my-music-band' ),
		),
		'thrid-image' => array(
			'url'           => '%s/assets/images/header-image-2.jpg',
			'thumbnail_url' => '%s/assets/images/header-image-2-275x155.jpg',
			'description'   => esc_html__( 'Dark Header Image', 'my-music-band' ),
		),
	) );
}
endif;
add_action( 'after_setup_theme', 'my_music_band_custom_header_and_background' );
/**
 * Customize video play/pause button in the custom header.
 *
 * @param array $settings header video settings.
 */
function my_music_band_video_controls( $settings ) {
	$settings['l10n']['play'] = '<span class="screen-reader-text">' . esc_html__( 'Play background video', 'my-music-band' ) . '</span>';
	$settings['l10n']['pause'] = '<span class="screen-reader-text">' . esc_html__( 'Pause background video', 'my-music-band' ) . '</span>';
	return $settings;
}
add_filter( 'header_video_settings', 'my_music_band_video_controls' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @since My Music Band 1.2
 * @see my_music_band_customize_register()
 *
 * @return void
 */
function my_music_band_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since My Music Band 1.2
 * @see my_music_band_customize_register()
 *
 * @return void
 */
function my_music_band_customize_partial_blogdescription() {
	bloginfo( 'description' );
}
