<?php
/**
 * @package WordPress
 * @subpackage MxS
 */
 
/** -----------------------------------------------
	 * Theme Translate
*/ 
add_action( 'after_setup_theme', 'MxS_init' );
function MxS_init(){
/** -----------------------------------------------
	 * Theme support
*/
if ( ! isset( $content_width ) ) $content_width = 640;
add_theme_support( 'post-thumbnails' );
set_post_thumbnail_size( 130, 130, false );
add_theme_support('automatic-feed-links');
add_theme_support( 'post-formats', array( 'video', 'quote' ) );
add_theme_support( 'custom-background');
load_theme_textdomain( 'MxS', get_template_directory() . '/languages' );
define('HEADER_TEXTCOLOR', '111111');
// Don't support text inside the header image.
if ( ! defined( 'NO_HEADER_TEXT' ) ){
	define( 'NO_HEADER_TEXT', true );
	}
}
function MxS_enqueue_comment_reply() {
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'MxS_enqueue_comment_reply' );
/** -----------------------------------------------
 * custom background
*/ 
function MxS_header_style() {
    ?><style type="text/css">
        #header {
            background:#fff url(<?php header_image(); ?>);
        }
		.siteName a,.description{color:#<?php header_textcolor() ?>}
    </style><?php
}
	/** -----------------------------------------------
		 * gets included in the admin header
	*/ 
function MxS_admin_header_style() {
    ?><style type="text/css">
        #headimg {
            width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
            height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
        }
    </style><?php
}
$args = array(
	'width'         => 1000,
	'height'        => 185,
	'wp-head-callback'      => 'MxS_header_style',
	'admin-head-callback'   => 'MxS_admin_header_style',
	'uploads'       => true,
);
add_theme_support( 'custom-header', $args );

/** -----------------------------------------------
	 * Theme uses wp_nav_menu() in one location. Chack if function exist
*/ 
register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'MxS'),
) );
/** -----------------------------------------------
	 * widget setting
*/ 
function MxS_widgets_init() {

	register_sidebar( array(
		'name' => __( 'Primary Widget Area', 'MxS'),
		'id' => 'primary-widget-area',
		'description' => __( 'The primary widget area', 'MxS') ,
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );
	register_sidebar( array(
		'name' => __( 'First Footer Widget Area', 'MxS'),
		'id' => 'first-footer-widget-area',
		'description' => __( 'The first footer widget area', 'MxS' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );
	register_sidebar( array(
		'name' =>  __( 'Second Footer Widget Area', 'MxS'),
		'id' => 'second-footer-widget-area',
		'description' => __( 'The second footer widget area', 'MxS' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );
	register_sidebar( array(
		'name' =>  __( 'Third Footer Widget Area', 'MxS'),
		'id' => 'third-footer-widget-area',
		'description' => __( 'The third footer widget area', 'MxS' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );
	register_sidebar( array(
		'name' =>  __( 'Fourth Footer Widget Area', 'MxS'),
		'id' => 'fourth-footer-widget-area',
		'description' =>  __( 'The fourth footer widget area', 'MxS' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );
}
add_action( 'widgets_init', 'MxS_widgets_init' );
/** -----------------------------------------------
	 * Page navi Previous 1 2 3 4 5 6 Next
*/ 
	function MxS_pagenavi($range = 7){
		global $paged, $wp_query, $max_page;
		if ( !$max_page ) {$max_page = $wp_query->max_num_pages;}
		if($max_page > 1){if(!$paged){$paged = 1;}
			echo '<span> '.$paged.' / '.$max_page.'</span>';
		if($paged != 1){echo "<a rel='nofollow' href='" . get_pagenum_link(1) . "' class='extend' title=".__('First Page','MxS').">". __('First','MxS')."</a>";}
		previous_posts_link(__('previous','MxS'));
		if($max_page > $range){
			if($paged < $range){for($i = 1; $i <= ($range + 1); $i++){echo "<a rel='nofollow' href='" . get_pagenum_link($i) ."'";
			if($i==$paged)echo " class='current'";echo ">$i</a>";}}
		elseif($paged >= ($max_page - ceil(($range/2)))){
			for($i = $max_page - $range; $i <= $max_page; $i++){echo "<a rel='nofollow' href='" . get_pagenum_link($i) ."'";
			if($i==$paged)echo " class='current'";echo ">$i</a>";}}
		elseif($paged >= $range && $paged < ($max_page - ceil(($range/2)))){
			for($i = ($paged - ceil($range/2)); $i <= ($paged + ceil(($range/2))); $i++){echo "<a rel='nofollow' href='" . get_pagenum_link($i) ."'";if($i==$paged) echo " class='current'";echo ">$i</a>";}}}
		else{for($i = 1; $i <= $max_page; $i++){echo "<a rel='nofollow' href='" . get_pagenum_link($i) ."'";
		if($i==$paged)echo " class='current'";echo ">$i</a>";}}
		next_posts_link(__('next','MxS'));
		if($paged != $max_page){echo "<a rel='nofollow' href='" . get_pagenum_link($max_page) . "' class='extend' title=".__('Last Page','MxS').">". __('Last','MxS')."</a>";}}
		}
/**
 *modified commentform
**/
function MxS_fields($fields) {
if(isset($_COOKIE['comment_author_'.COOKIEHASH])) {
$lastCommenter = $_COOKIE['comment_author_'.COOKIEHASH];
$lastEmail = $_COOKIE['comment_author_email_'.COOKIEHASH];
$lastUrl = $_COOKIE['comment_author_url_'.COOKIEHASH];
$fields =  array(
	'author' => '<div id="author_info"><p class="comment-form-author">' .
	            '<input id="author" name="author" type="text" value="' . $lastCommenter . '" size="30" /><span class="required">*</span>' .
				'<label for="author">' . __( 'Name', 'MxS' ) . '</label></p>',
	'email'  => '<p class="comment-form-email"><input id="email" name="email" type="text" value="' . $lastEmail . '" size="30" />
				<span class="required">*</span><label for="email">' . __( 'Email', 'MxS' ) . '</label></p>',
	'url'    => '<p class="comment-form-url">' .
	            '<input id="url" name="url" type="text" value="' . $lastUrl . '" size="30" /><label for="url">' . __( 'Website', 'MxS' ) . '</label></p></div>'
);}
else{
$fields =  array(
	'author' => '<p class="comment-form-author">' .
	            '<input id="author" name="author" type="text" size="30" />
				<span class="required">*</span><label for="author">' . __( 'Name', 'MxS' ) . '</label></p>',
	'email'  => '<p class="comment-form-email">' .
	            '<input id="email" name="email" type="text" size="30" />
				<span class="required">*</span><label for="email">' . __( 'Email', 'MxS' ) . '</label></p>',
	'url'    => '<p class="comment-form-url">' .
	            '<input id="url" name="url" type="text" size="30" />
				<label for="url">' . __( 'Website', 'MxS' ) . '</label></p>',
	);
}
 return $fields;
 }
 add_filter('comment_form_default_fields','MxS_fields');
/** -----------------------------------------------
	 * custom comments
*/ 
function MxS_custom_comments($comment, $args, $depth) {
$GLOBALS['comment'] = $comment;
?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
<div id="comment-<?php comment_ID(); ?>">
<div class="message_head">
<span class="avatarx"><?php echo get_avatar($comment,$size='40',$default='' ); ?></span>
<span class="name"><?php comment_author_link() ?></span> <?php edit_comment_link( __( '(Edit)', 'mxs_theme' ), ' ' ); ?>
<span class="reply"><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => get_option('thread_comments_depth') ) ) ); ?></span>
</div>
<span class="date"><?php comment_date('y/m/d') ?></span>
<div class="clear"></div>
<div class="cmt_text"><?php comment_text(); ?></div>
</div><!-- #comment-##  -->	
<?php }
/** -----------------------------------------------
	 * custom pingbacks
*/ 
function MxS_custom_pingbacks($pingback, $args, $depth) {
$GLOBALS['pingback'] = $pingback;
?>
	<dt id="ping-<?php comment_ID() ?>"><span class="name"><?php printf(__('%s from %s','MxS'), get_comment_type(), get_comment_author_link()); ?></span> <span class="date"><?php comment_date( get_option( 'date_format' )); ?></span></dt>

<?php }
/* Theme Options*/
function MxS_theme_options(){
	$items = array (
		array(
			'id' => 'logo_src',
			'name' => __( 'Logo image', 'MxS' ),
			'desc' => __('Put your logo image address here (max size: 280px*100px). If empty, display blog title with text.', 'MxS')
		),
		array(
			'id' => 'desc',
			'name' => __('Disable the site description','MxS'),
			'desc' => __('Disabling this will remove the site description.', 'MxS')
		),
		array(
			'id' => 'arch_excerpt_check',
			'name' => __('Archive Excerpt?', 'MxS'),
			'desc' => __('If the archive pages to display excerpt of post, check.', 'MxS')
		),
		array(
			'id' => 'home_excerpt_check',
			'name' => __('Home Excerpt?', 'MxS'),
			'desc' => __('If the home page to display excerpt of post, check.', 'MxS')
		)
	);
	return $items;
}

add_action( 'admin_init', 'MxS_theme_options_init' );
add_action( 'admin_menu', 'MxS_theme_options_add_page' );
function MxS_theme_options_init(){
	register_setting( 'MxS_options', 'MxS_theme_options', 'MxS_options_validate' );
}
function MxS_theme_options_add_page() {
	add_theme_page( __( 'Theme Options', 'MxS' ), __( 'Theme Options', 'MxS'), 'edit_theme_options', 'theme_options', 'MxS_theme_options_do_page' );
}

function MxS_default_options() {
	$mxs_options = get_option( 'MxS_theme_options' );
	foreach ( MxS_theme_options() as $item ) {
		if ( ! isset( $mxs_options[$item['id']] ) ) {
			$mxs_options[$item['id']] = '';
		}
	}
	update_option( 'MxS_theme_options', $mxs_options );
}
add_action( 'init', 'MxS_default_options' );

function MxS_theme_options_do_page() {
	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false;
?>
	<div class="wrap">
		<?php screen_icon(); echo "<h2>" . sprintf( __( '%1$s Theme Options', 'MxS' ), wp_get_theme() )	 . "</h2>"; ?>
		<?php if ( false !== $_REQUEST['updated'] ) : ?>
		<div class="updated fade"><p><strong><?php _e( 'Options saved', 'MxS' ); ?></strong></p></div>
		<?php endif; ?>
		<form method="post" action="options.php">
			<?php settings_fields( 'MxS_options' ); ?>
			<?php $mxs_options = get_option( 'MxS_theme_options' ); ?>
			<table class="form-table">
			<?php foreach (MxS_theme_options() as $item) { ?>
				<?php if ($item['id'] == 'logo_src') { ?>
				<tr valign="top" style="margin:0 10px;">
					<th scope="row"><?php echo $item['name']; ?></th>
					<td>
						<input id="<?php echo 'MxS_theme_options['.$item['id'].']'; ?>" name="<?php echo 'MxS_theme_options['.$item['id'].']'; ?>" type="text" value="<?php if ( $mxs_options[$item['id']] != "") { echo $mxs_options[$item['id']]; } else { echo ''; } ?>" size="80" />
						<br/>
						<label class="description" for="<?php echo 'MxS_theme_options['.$item['id'].']'; ?>"><?php echo $item['desc']; ?></label>
					</td>
				</tr>
				<?php } else { ?>
				<tr valign="top" style="margin:0 10px;">
					<th scope="row"><?php echo $item['name']; ?></th>
					<td>
						<input id="<?php echo 'MxS_theme_options['.$item['id'].']'; ?>" name="<?php echo 'MxS_theme_options['.$item['id'].']'; ?>" type="checkbox" value="1" <?php checked($mxs_options[$item['id']], 1); ?> />
						<label class="description" for="<?php echo 'MxS_theme_options['.$item['id'].']'; ?>"><?php echo $item['desc']; ?></label>
					</td>
				</tr>
				<?php } ?>
			<?php } ?>
			</table>
				<?php submit_button( __( 'Save Options', 'MxS' ), 'submit') ?>
		
		</form>
	</div>
<?php
}
function MxS_options_validate($input) {
		// If the checkbox has not been checked, void it
		$input['logo_src'] = esc_url_raw($input['logo_src']);

		foreach ( array('desc', 'arch_excerpt_check', 'home_excerpt_check') as $key ) {
			$input[$key] = ($input[$key]) ? true : false;
		}		
	return $input;
}