<?php
 
/** -----------------------------------------------
	 * Theme Translate
*/ 
add_action( 'after_setup_theme', 'mxs_init' );
function mxs_init(){
/** -----------------------------------------------
	 * Theme support
*/
if ( ! isset( $content_width ) ) $content_width = 640;
$args = array(
	'width'         => 1000,
	'height'        => 140,
	'wp-head-callback'       => 'mxs_header_style',
);
add_theme_support( 'post-thumbnails' );
add_theme_support( 'custom-header', $args ); 
add_theme_support('automatic-feed-links');
add_theme_support( 'custom-background');
set_post_thumbnail_size( 360, 130 );
load_theme_textdomain( 'mxs', get_template_directory() . '/languages' );
// Don't support text inside the header image.
if ( ! defined( 'NO_HEADER_TEXT' ) )
	define( 'NO_HEADER_TEXT', true );
}

function mxs_theme_styles()
{	$mxs_options = get_option('mxs_theme_options');
	$mxs_theme_style=$mxs_options['theme_style'];
	if ($mxs_theme_style=='black'){
    wp_register_style('custom-style-black', get_template_directory_uri().'/css/style-black.css' );
	wp_enqueue_style( 'custom-style-black' );}
	else{
    wp_register_style('custom-style-default', get_template_directory_uri().'/css/style-default.css' );	
	wp_enqueue_style( 'custom-style-default' );}

}
add_action('wp_enqueue_scripts', 'mxs_theme_styles');

function mxs_enqueue_comment_reply() {
        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
                wp_enqueue_script( 'comment-reply' );
        }
}
add_action( 'wp_enqueue_scripts', 'mxs_enqueue_comment_reply' );
/** -----------------------------------------------
 * custom background
*/ 
function mxs_header_style() {
    ?><style type="text/css">
        #header {
            background: url(<?php header_image(); ?>);
        }
    }
    </style><?php
}


/** -----------------------------------------------
	 * Theme uses wp_nav_menu() in one location. Chack if function exist
*/ 
register_nav_menus( array(
		'primary' => __( 'Primary Navigation','mxs'),
) );
/** -----------------------------------------------
	 * widget setting
*/ 
function mxs_widgets_init() {
	// Area 1, located at the top of the sidebar.
	register_sidebar( array(
		'name' => 'Primary Widget Area',
		'id' => 'primary-widget-area',
		'description' => 'The primary widget area' ,
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );
	// Area 3, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => 'First Footer Widget Area',
		'id' => 'first-footer-widget-area',
		'description' => 'The first footer widget area',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );

	// Area 4, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => 'Second Footer Widget Area',
		'id' => 'second-footer-widget-area',
		'description' => 'The second footer widget area',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );

	// Area 5, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => 'Third Footer Widget Area',
		'id' => 'third-footer-widget-area',
		'description' => 'The third footer widget area',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );

	// Area 6, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => 'Fourth Footer Widget Area',
		'id' => 'fourth-footer-widget-area',
		'description' =>  'The fourth footer widget area',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widgettitle">',
		'after_title' => '</span>',
	) );
}
add_action( 'widgets_init', 'mxs_widgets_init' );
/** -----------------------------------------------
	 * Page navi Previous 1 2 3 4 5 6 Next
*/ 
	function mxs_pagenavi( $range = 7) {
		global $paged, $wp_query, $max_page;
		if ( !$max_page ) {$max_page = $wp_query->max_num_pages;}
		if($max_page > 1){if(!$paged){$paged = 1;}
			echo '<span> '.$paged.' / '.$max_page.'</span>';
		if($paged != 1){echo "<a rel='nofollow' href='" . get_pagenum_link(1) . "' class='extend' title=".__('First Page','mxs').">". __('First','mxs')."</a>";}
		previous_posts_link(__('previous','mxs'));
		if($max_page > $range){
			if($paged < $range){for($i = 1; $i <= ($range + 1); $i++){echo "<a rel='nofollow' href='" . get_pagenum_link($i) ."'";
			if($i==$paged)echo " class='current'";echo ">$i</a>";}}
		elseif($paged >= ($max_page - ceil(($range/2)))){
			for($i = $max_page - $range; $i <= $max_page; $i++){echo "<a rel='nofollow' href='" . get_pagenum_link($i) ."'";
			if($i==$paged)echo " class='current'";echo ">$i</a>";}}
		elseif($paged >= $range && $paged < ($max_page - ceil(($range/2)))){
			for($i = ($paged - ceil($range/2)); $i <= ($paged + ceil(($range/2))); $i++){echo "<a rel='nofollow' href='" . get_pagenum_link($i) ."'";if($i==$paged) echo " class='current'";echo ">$i</a>";}}}
		else{for($i = 1; $i <= $max_page; $i++){echo "<a rel='nofollow' href='" . get_pagenum_link($i) ."'";
		if($i==$paged)echo " class='current'";echo ">$i</a>";}}
		next_posts_link(__('next','mxs'));
		if($paged != $max_page){echo "<a rel='nofollow' href='" . get_pagenum_link($max_page) . "' class='extend' title=".__('Last Page','mxs').">". __('Last','mxs')."</a>";}}
		}
/** -----------------------------------------------
	 * custom comments
*/ 
function mxs_custom_comments($comment, $args, $depth) {
$GLOBALS['comment'] = $comment;
?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
<div id="comment-<?php comment_ID(); ?>">
<div class="message_head">
<span class="avatarx"><?php echo get_avatar($comment,$size='40',$default='<path_to_url>' ); ?></span>
<span class="name"><?php comment_author_link() ?></span> <?php edit_comment_link( __( '(Edit)', 'mxs_theme' ), ' ' ); ?>
<span class="reply"><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => get_option('thread_comments_depth') ) ) ); ?></span>
</div>
<span class="date"><?php comment_date('y/m/d') ?></span>
<div class="clear"></div>
<div class="cmt_text"><?php comment_text(); ?></div>
</div><!-- #comment-##  -->	
<?php }
/* Theme Options*/
function mxs_theme_options(){
	$mxs_items = array (
		array(
			'id' => 'theme_style',
			'name' => __('Theme style Selected','mxs'),
			'desc' => ''
		),	
		array(
			'id' => 'logo_src',
			'name' => __( 'Logo image', 'mxs' ),
			'desc' => __('Put your logo image address here (max size: 280px*80px). If empty, display blog title with text.', 'mxs')
		),
		array(
			'id' => 'desc',
			'name' => __('Disable the site description','mxs'),
			'desc' => __('Disabling this will remove the site description.', 'mxs')
		),
		array(
			'id' => 'arch_excerpt_check',
			'name' => __('Archive Excerpt?', 'mxs'),
			'desc' => __('If the archive pages to display excerpt of post, check.', 'mxs')
		),
		array(
			'id' => 'home_excerpt_check',
			'name' => __('Home Excerpt?', 'mxs'),
			'desc' => __('If the home page to display excerpt of post, check.', 'mxs')
		)
	);
	return $mxs_items;
}
/*Return array for theme style*/
function mxs_style_selected() {
	$mxs_style_selected = array(
		array(
			'value' =>	'default',
			'label' =>  __('Default style: Grey','mxs')
		),
		array(
			'value' =>	'black',
			'label' =>  __('Black style','mxs')
		)
	);
	return $mxs_style_selected;
}
add_action( 'admin_init', 'mxs_theme_options_init' );
add_action( 'admin_menu', 'mxs_theme_options_add_page' );
function mxs_theme_options_init(){
	register_setting( 'mxs_options', 'mxs_theme_options', 'mxs_options_validate' );
}
function mxs_theme_options_add_page() {
	add_theme_page(__( 'Theme Options', 'mxs' ), __( 'Theme Options', 'mxs'), 'edit_theme_options', 'theme_options', 'mxs_theme_options_do_page' );
}

function mxs_default_options() {
	$mxs_options = get_option( 'mxs_theme_options' );
	foreach ( mxs_theme_options() as $item ) {
		if ( ! isset( $mxs_options[$item['id']] ) ) {
			if ( $mxs_options[$item['id']] == 'theme_style' ) {
				$mxs_options[$item['id']] = 'default';
			} else {
			$mxs_options[$item['id']] = '';
			}
		}
	}
	update_option( 'mxs_theme_options', $mxs_options );
}
add_action( 'init', 'mxs_default_options' );

function mxs_theme_options_do_page() {
	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false;
?>
	<div class="wrap">
		<?php screen_icon(); echo "<h2>" . sprintf( __( '%1$s Theme Options', 'mxs' ), get_current_theme() )	 . "</h2>"; ?>
		<?php if ( false !== $_REQUEST['updated'] ) : ?>
		<div class="updated fade"><p><strong><?php _e( 'Options saved', 'mxs' ); ?></strong></p></div>
		<?php endif; ?>
		<form method="post" action="options.php">
			<?php settings_fields( 'mxs_options' ); ?>
			<?php $mxs_options = get_option( 'mxs_theme_options' ); ?>
			<table class="form-table">
			<?php foreach (mxs_theme_options() as $item) { ?>
				<?php if ($item['id'] == 'logo_src') { ?>
				<tr valign="top" style="margin:0 10px;">
					<th scope="row"><?php echo $item['name']; ?></th>
					<td>
						<input id="<?php echo 'mxs_theme_options['.$item['id'].']'; ?>" name="<?php echo 'mxs_theme_options['.$item['id'].']'; ?>" type="text" value="<?php if ( $mxs_options[$item['id']] != "") { echo $mxs_options[$item['id']]; } else { echo ''; } ?>" size="80" />
						<br/>
						<label class="description" for="<?php echo 'mxs_theme_options['.$item['id'].']'; ?>"><?php echo $item['desc']; ?></label>
					</td>
				</tr>
				<?php } elseif ($item['id'] == 'theme_style') { ?>
				<tr valign="top" style="margin-bottom:5px;border-bottom:1px solid #e1e1e1;">
					<th scope="row"><?php echo $item['name']; ?></th>
					<td>
						<select name="<?php echo 'mxs_theme_options['.$item['id'].']'; ?>">
							<?php
								$selected = $mxs_options[$item['id']];
								$p = '';
								$r = '';
								foreach ( mxs_style_selected() as $option ) {
									$label = $option['label'];
									if ( $selected == $option['value'] ) // Make default first in list
										$p = "\n\t<option selected='selected' value='" . esc_attr( $option['value'] ) . "'>$label</option>";
									else
										$r .= "\n\t<option value='" . esc_attr( $option['value'] ) . "'>$label</option>";
								}
								echo $p . $r;
							?>
						</select>
						<label class="description" for="<?php echo 'mxs_theme_options['.$item['id'].']'; ?>"><?php echo $item['desc']; ?></label>
					</td>
				</tr>
				<?php } else { ?>
				<tr valign="top" style="margin:0 10px;">
					<th scope="row"><?php echo $item['name']; ?></th>
					<td>
						<input id="<?php echo 'mxs_theme_options['.$item['id'].']'; ?>" name="<?php echo 'mxs_theme_options['.$item['id'].']'; ?>" type="checkbox" value="1" <?php checked($mxs_options[$item['id']], 1); ?> />
						<label class="description" for="<?php echo 'mxs_theme_options['.$item['id'].']'; ?>"><?php echo $item['desc']; ?></label>
					</td>
				</tr>
				<?php } ?>
			<?php } ?>
			</table>
				<?php submit_button( __( 'Save Options', 'mxs' ), 'submit') ?>
		
		</form>
	</div>
<?php
}
function mxs_options_validate($input) {
	global $mxs_select_options;
		// If the checkbox has not been checked, void it
		$input['logo_src'] = esc_url_raw($input['logo_src']);
	// Our select option must actually be in our array of select options
	if ( ! array_key_exists( $input['selectinput'], $mxs_select_options ) )
		$input['selectinput'] = null;
		
		foreach ( array('desc', 'arch_excerpt_check', 'home_excerpt_check') as $key ) {
			$input[$key] = ($input[$key]) ? true : false;
		}		
	return $input;
}