<?php
/**
 * The template for displaying the footer.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Musik
 */

if ( is_active_sidebar( 'sidebar-2' ) || get_theme_mod( 'musik_social_menu_position' ) === 'footer' || get_theme_mod( 'musik_footer_title' ) ) {
	?>
	<footer id="footer" role="contentinfo" itemscope="itemscope" itemtype="http://schema.org/WPFooter">
		<h2 class="screen-reader-text"><?php esc_html_e( 'Footer', 'musik' ); ?></h2>
		<?php
		if ( ! is_page_template( 'templates/no-widgets-or-comments.php' ) ) {
			// This template should not show the widgets in the footer.
			if ( is_active_sidebar( 'sidebar-2' ) ) {
				dynamic_sidebar( 'sidebar-2' );
			}
		}

		musik_footer_title();

		if ( get_theme_mod( 'musik_social_menu_position' ) === 'footer' ) {
			musik_social_menu();
		}
		?>
	</footer>
	<?php
}
?>
</div>
<?php wp_footer(); ?>
</body>
</html>
