<?php
/**
 * The template for displaying comments.
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Musik
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}

if ( comments_open() || have_comments() ) {
	?>
	<div id="comments" class="comments-area">
	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) {
		?>
		<h2 class="comments-title">
			<?php
			$comment_count = get_comments_number();
			if ( 1 === $comment_count ) {
				printf(
					/* translators: 1: title. */
					esc_html_e( 'One thought on &ldquo;%1$s&rdquo;', 'musik' ),
					'<span>' . get_the_title() . '</span>'
				);
			} else {
				printf( // WPCS: XSS OK.
					/* translators: 1: comment count number, 2: title. */
					esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $comment_count, 'comments title', 'musik' ) ),
					number_format_i18n( $comment_count ),
					'<span>' . get_the_title() . '</span>'
				);
			}
			?>
		</h2>
		<?php
		the_comments_navigation(
			array(
				'prev_text' => __( '&larr; Older comments', 'musik' ),
				'next_text' => __( 'Newer comments &rarr;', 'musik' ),
			)
		);
		?>
		<ol class="comment-list">
			<?php
			wp_list_comments(
				array(
					'style'      => 'ol',
					'short_ping' => true,
				)
			);
			?>
		</ol><!-- .comment-list -->
		<?php
		the_comments_navigation(
			array(
				'prev_text' => __( '&larr; Older comments', 'musik' ),
				'next_text' => __( 'Newer comments &rarr;', 'musik' ),
			)
		);

	} else {
		/**
		 * If comments are open, but there are no comments,
		 * add a H2 heading to the comment area so that heading levels are not skipped.
		 */
		if ( comments_open() ) {
			echo '<h2 class="comments-title">' . esc_html__( 'Be the first to leave a reply', 'musik' ) . '</h2>';
		}
	}
	comment_form();
	?>
	</div><!-- #comments -->
	<?php
}
