<?php
/**
 * The template for displaying author archive pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Musik
 */

get_header();
?>
	<div class="archive-header">
		<h1 class="post-title" itemprop="headline">
		<?php /* translators: %s: author name or nickname */ printf( esc_html__( 'About %s', 'musik' ), get_the_author_meta( 'display_name' ) ); ?></h1>

		<div class="author-info">
			<div class="author-avatar">
				<?php echo get_avatar( get_the_author_meta( 'user_email' ), 60 ); ?></div>
				<div class="author-description">
					<?php echo nl2br( get_the_author_meta( 'description' ) ); ?>
				</div>
			</div>
		</div>
		<?php
		while ( have_posts() ) {
			the_post();
			?>
			<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<h2 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
					<?php
					if ( has_post_thumbnail() ) {
						the_post_thumbnail();
					}

					the_content();
					wp_link_pages(
						array(
							'before' => '<div class="page-link">' . __( 'Pages: ', 'musik' ),
							'after'  => '</div>',
						)
					);
					musik_meta();
					?>
			</div>
			<?php
		}

		the_posts_navigation(
			array(
				'prev_text' => __( '&larr; Previous page', 'musik' ),
				'next_text' => __( 'Next page &rarr;', 'musik' ),
			)
		);
		?>
	</div>
<?php
get_sidebar();
get_footer();
