<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Define our MusicVibe Elementor Blog Widget.
 */
class musicvibe_elementor_blog extends Widget_Base {
    
    /**
     * Define our get_name settings.
     */
    public function get_name() {
        return 'musicvibe-blog';
    }
    
    /**
     * Define our get_title settings.
     */
    public function get_title() {
        return __('Blog Posts', 'musicvibe');
    }
    
    /**
     * Define our get_icon settings.
     */
    public function get_icon() {
        return 'eicon-posts-grid';
    }
    
    /**
     * Define our get_categories settings.
     */
    public function get_categories() {
        return ['musicvibe-elementor-widget'];
    }
    
    /**
     * Define our _register_controls settings.
     */
    protected function register_controls() {
        // Content Tab
        $this->start_controls_section(
            'musicvibe_blog_content_section',
            [
                'label' => esc_html__('Content Options', 'musicvibe'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'musicvibe_blog_get_category',
            [
                'label' => __('Select Category', 'musicvibe'),
                'type' => Controls_Manager::SELECT2,
                'default' => array(),
                'options' => musicvibe_blog_get_category(),
                'multiple' => true
            ]
        );
        
        $this->add_control(
            'musicvibe_blog_post_count',
            [
                'label' => __('Number of Posts', 'musicvibe'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 1,
                'max' => 24,
            ]
        );
        
        $this->add_control(
            'musicvibe_blog_columns',
            [
                'label' => __('Columns', 'musicvibe'),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1' => __('1 Column', 'musicvibe'),
                    '2' => __('2 Columns', 'musicvibe'),
                    '3' => __('3 Columns', 'musicvibe'),
                    '4' => __('4 Columns', 'musicvibe'),
                ],
            ]
        );
        
        $this->add_control(
            'musicvibe_blog_orderby',
            [
                'label' => __('Order By', 'musicvibe'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => __('Date', 'musicvibe'),
                    'title' => __('Title', 'musicvibe'),
                    'name' => __('Slug', 'musicvibe'),
                    'modified' => __('Last Modified', 'musicvibe'),
                    'comment_count' => __('Comment Count', 'musicvibe'),
                    'rand' => __('Random', 'musicvibe'),
                ],
            ]
        );
        
        $this->add_control(
            'musicvibe_blog_order',
            [
                'label' => __('Order', 'musicvibe'),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => __('Ascending', 'musicvibe'),
                    'DESC' => __('Descending', 'musicvibe'),
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // Display Options Section
        $this->start_controls_section(
            'musicvibe_blog_display_section',
            [
                'label' => esc_html__('Display Options', 'musicvibe'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'show_featured_image',
            [
                'label' => __('Show Featured Image', 'musicvibe'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'musicvibe'),
                'label_off' => __('Hide', 'musicvibe'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'image_size',
            [
                'label' => __('Image Size', 'musicvibe'),
                'type' => Controls_Manager::SELECT,
                'default' => 'medium',
                'options' => [
                    'thumbnail' => __('Thumbnail', 'musicvibe'),
                    'medium' => __('Medium', 'musicvibe'),
                    'large' => __('Large', 'musicvibe'),
                    'full' => __('Full', 'musicvibe'),
                ],
                'condition' => [
                    'show_featured_image' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'show_title',
            [
                'label' => __('Show Title', 'musicvibe'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'musicvibe'),
                'label_off' => __('Hide', 'musicvibe'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title HTML Tag', 'musicvibe'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h3',
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'show_excerpt',
            [
                'label' => __('Show Excerpt', 'musicvibe'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'musicvibe'),
                'label_off' => __('Hide', 'musicvibe'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'excerpt_length',
            [
                'label' => __('Excerpt Length', 'musicvibe'),
                'type' => Controls_Manager::NUMBER,
                'default' => 120,
                'min' => 0,
                'max' => 300,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'show_read_more',
            [
                'label' => __('Show Read More', 'musicvibe'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'musicvibe'),
                'label_off' => __('Hide', 'musicvibe'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'read_more_text',
            [
                'label' => __('Read More Text', 'musicvibe'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Read More', 'musicvibe'),
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'show_meta',
            [
                'label' => __('Show Post Meta', 'musicvibe'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'musicvibe'),
                'label_off' => __('Hide', 'musicvibe'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'show_author',
            [
                'label' => __('Show Author', 'musicvibe'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'musicvibe'),
                'label_off' => __('Hide', 'musicvibe'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'show_meta' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'show_date',
            [
                'label' => __('Show Date', 'musicvibe'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'musicvibe'),
                'label_off' => __('Hide', 'musicvibe'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'show_meta' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'show_comments',
            [
                'label' => __('Show Comments', 'musicvibe'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'musicvibe'),
                'label_off' => __('Hide', 'musicvibe'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'show_meta' => 'yes',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // Style Tab: General
        $this->start_controls_section(
            'musicvibe_blog_style_section',
            [
                'label' => esc_html__('General', 'musicvibe'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'column_gap',
            [
                'label' => __('Column Gap', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 30,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ele-custom-blog-widget' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'row_gap',
            [
                'label' => __('Row Gap', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 30,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ele-custom-blog-widget' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'content_alignment',
            [
                'label' => __('Content Alignment', 'musicvibe'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'musicvibe'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'musicvibe'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'musicvibe'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .blog-post .post-content' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // Style Tab: Box
        $this->start_controls_section(
            'musicvibe_blog_box_style_section',
            [
                'label' => esc_html__('Box', 'musicvibe'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background',
                'label' => __('Background', 'musicvibe'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .blog-post',
            ]
        );
        
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => __('Border', 'musicvibe'),
                'selector' => '{{WRAPPER}} .blog-post',
            ]
        );
        
        $this->add_control(
            'box_border_radius',
            [
                'label' => __('Border Radius', 'musicvibe'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .blog-post' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .blog-post',
            ]
        );
        
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __('Padding', 'musicvibe'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .blog-post' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __('Margin', 'musicvibe'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .blog-post' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // Style Tab: Image
        $this->start_controls_section(
            'musicvibe_blog_image_style_section',
            [
                'label' => esc_html__('Image', 'musicvibe'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_featured_image' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'image_spacing',
            [
                'label' => __('Spacing', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 0,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'image_border_radius',
            [
                'label' => __('Border Radius', 'musicvibe'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .blog-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'selector' => '{{WRAPPER}} .blog-img img',
            ]
        );
        
        $this->end_controls_section();
        
        // Style Tab: Title
        $this->start_controls_section(
            'musicvibe_blog_title_style_section',
            [
                'label' => esc_html__('Title', 'musicvibe'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'title_color',
            [
                'label' => __('Color', 'musicvibe'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .entry-title a' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'title_hover_color',
            [
                'label' => __('Hover Color', 'musicvibe'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .entry-title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Typography', 'musicvibe'),
                'selector' => '{{WRAPPER}} .entry-title',
            ]
        );
        
        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __('Spacing', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 15,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .entry-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // Style Tab: Excerpt
        $this->start_controls_section(
            'musicvibe_blog_excerpt_style_section',
            [
                'label' => esc_html__('Excerpt', 'musicvibe'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'excerpt_color',
            [
                'label' => __('Color', 'musicvibe'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-excerpt' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'label' => __('Typography', 'musicvibe'),
                'selector' => '{{WRAPPER}} .post-excerpt',
            ]
        );
        
        $this->add_responsive_control(
            'excerpt_spacing',
            [
                'label' => __('Spacing', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 15,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-excerpt' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // Style Tab: Read More
        $this->start_controls_section(
            'musicvibe_blog_read_more_style_section',
            [
                'label' => esc_html__('Read More', 'musicvibe'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'read_more_color',
            [
                'label' => __('Color', 'musicvibe'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'read_more_hover_color',
            [
                'label' => __('Hover Color', 'musicvibe'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'read_more_typography',
                'label' => __('Typography', 'musicvibe'),
                'selector' => '{{WRAPPER}} .read-more',
            ]
        );
        
        $this->add_responsive_control(
            'read_more_spacing',
            [
                'label' => __('Spacing', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 10,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .read-more' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // Style Tab: Meta
        $this->start_controls_section(
            'musicvibe_blog_meta_style_section',
            [
                'label' => esc_html__('Meta', 'musicvibe'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_meta' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'meta_color',
            [
                'label' => __('Color', 'musicvibe'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .entry-meta, {{WRAPPER}} .entry-meta a' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'meta_hover_color',
            [
                'label' => __('Hover Color', 'musicvibe'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .entry-meta a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'label' => __('Typography', 'musicvibe'),
                'selector' => '{{WRAPPER}} .entry-meta',
            ]
        );
        
        $this->add_responsive_control(
            'meta_icon_size',
            [
                'label' => __('Icon Size', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 16,
                ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .entry-meta svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'meta_spacing',
            [
                'label' => __('Spacing', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 15,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .entry-meta' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'meta_item_spacing',
            [
                'label' => __('Item Spacing', 'musicvibe'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 15,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .entry-meta > div' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
    }
    
    /**
     * Define our Content Display settings.
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $taxs = $settings['musicvibe_blog_get_category'];
        $posts_count = $settings['musicvibe_blog_post_count'];
        $columns = $settings['musicvibe_blog_columns'];
        $orderby = $settings['musicvibe_blog_orderby'];
        $order = $settings['musicvibe_blog_order'];
        
        $loop = ($posts_count <= 0) ? 30 : $posts_count;
        
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => esc_attr($loop),
            'post_status' => 'publish',
            'orderby' => $orderby,
            'order' => $order,
        );
        
        if ($taxs) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'id',
                    'terms' => $taxs,
                ),
            );
        }
        
        $query = new \WP_Query($args);
        
        if ($query->have_posts()):
            $column_class = 'grid-' . $columns;
            ?>
            <div class="ele-custom-blog-widget <?php echo esc_attr($column_class); ?>">
                <?php
                while ($query->have_posts()) : $query->the_post();
                    global $post;
                    $post_thumbnail_id = get_post_thumbnail_id(get_the_ID());
                    $image = wp_get_attachment_image_src($post_thumbnail_id, $settings['image_size']);
                    
                    ?>
                    <article class="blog-post">
                        <?php if ($settings['show_featured_image'] === 'yes' && !empty($image)) : ?>
                            <div class="blog-img">
                                <a href="<?php echo esc_url(get_the_permalink()); ?>">
                                    <img src="<?php echo esc_url($image[0]); ?>" alt="<?php the_title_attribute(); ?>" />
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <div class="post-content">
                            
                            <?php if ($settings['show_meta'] === 'yes') : ?>
                                <div class="entry-meta">
                                    <?php if ($settings['show_author'] === 'yes') : ?>
                                        <div class="author">
                                            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" title="<?php echo esc_attr(get_the_author()); ?>">
                                                <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                                    <path fill-rule="evenodd" d="M12 20a7.966 7.966 0 0 1-5.002-1.756l.002.001v-.683c0-1.794 1.492-3.25 3.333-3.25h3.334c1.84 0 3.333 1.456 3.333 3.25v.683A7.966 7.966 0 0 1 12 20ZM2 12C2 6.477 6.477 2 12 2s10 4.477 10 10c0 5.5-4.44 9.963-9.932 10h-.138C6.438 21.962 2 17.5 2 12Zm10-5c-1.84 0-3.333 1.455-3.333 3.25S10.159 13.5 12 13.5c1.84 0 3.333-1.455 3.333-3.25S13.841 7 12 7Z" clip-rule="evenodd"/>
                                                </svg>
                                                <span><?php echo get_the_author(); ?></span>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($settings['show_date'] === 'yes') : ?>
                                        <div class="date">
                                            <a href="<?php echo esc_url(get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d'))); ?>">
                                                <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m11.5 11.5 2.071 1.994M4 10h5m11 0h-1.5M12 7V4M7 7V4m10 3V4m-7 13H8v-2l5.227-5.292a1.46 1.46 0 0 1 2.065 2.065L10 17Zm-5 3h14a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1Z"/>
                                                </svg>
                                                <span><?php echo esc_html(get_the_date()); ?></span>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($settings['show_comments'] === 'yes') : ?>
                                        <div class="comments">
                                            <a href="<?php echo esc_url(get_comments_link()); ?>">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                                                </svg>
                                                <span><?php echo get_comments_number(); ?></span>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <?php if ($settings['show_title'] === 'yes') : ?>
                                <<?php echo $settings['title_tag']; ?> class="entry-title">
                                    <a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a>
                                </<?php echo $settings['title_tag']; ?>>
                            <?php endif; ?>
                            
                            <?php if ($settings['show_excerpt'] === 'yes') : ?>
                                <div class="post-excerpt">
                                    <?php echo wp_kses_post(musicvibe_get_excerpt(get_the_ID(), $settings['excerpt_length'])); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($settings['show_read_more'] === 'yes') : ?>
                                <a href="<?php echo esc_url(get_the_permalink()); ?>" class="read-more">
                                    <?php echo esc_html($settings['read_more_text']); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </article>
                <?php endwhile;
                wp_reset_postdata(); ?>
            </div>
            <?php
        endif;
    }
}

// Register the widget
Plugin::instance()->widgets_manager->register_widget_type(new musicvibe_elementor_blog());