<?php
$artimusic_options = artimusic_theme_options();

$about_sec_title = $artimusic_options['about_sec_title'];
$about_sec_sub_title = $artimusic_options['about_sec_sub_title'];
$about_image = $artimusic_options['about_image'];
$about_front_image = $artimusic_options['about_front_image'];
$about_btn_text	 = $artimusic_options['about_btn_text'];
$about_button_url		 = $artimusic_options['about_button_url'];
$countdown_title = $artimusic_options['countdown_title'];
$date_value = get_theme_mod('countdown_date', '');
if(!empty($about_image)){
  $background_img = "style='background-image:url(".esc_url($about_image).")'";
}
else{
  $background_img = '';
}

?>

<?php if(!empty($about_image)){?>
<div class="cta-section section-overlay" <?php echo wp_kses_post($background_img); ?>>
<?php } else{ ?>
	<div class="cta-section section-overlay no-bg-image">
<?php } ?>



	<div class="container">
		<div class="row">
				
				<div class="col-md-5" data-aos="fade-up">
					  <img src="<?php echo esc_url($about_front_image); ?>" alt="" />

				</div>

				<div class="col-md-6 col-md-offset-1" data-aos="fade-up" data-aos-delay="300">
        		<?php
              if ($about_sec_title)
                  echo '<h2>' . esc_html($about_sec_title) . '</h2>';

              if ($about_sec_sub_title)
                  echo '<span>' . esc_html($about_sec_sub_title) . '</span>';
				  if( $about_btn_text && $about_button_url):?>
                  <a href="<?php echo esc_url($about_button_url); ?>" class="btn-default"><em class="qodef-m-text"><?php echo esc_html($about_btn_text); ?></em></a>
              <?php endif; ?>
        </div>
                       
		</div>
	</div>
</div>



<?php if($date_value || $countdown_title):?>
    <div class="counter-section" data-aos="fade-up">
    	    	<?php if($countdown_title):?><h2 data-aos="fade-up" class="counter-text"><?php echo esc_html($countdown_title); ?></h2><?php endif; ?>

    	<?php if($date_value):?>
  		<div class="myCountdown" data-date="<?php echo esc_html($date_value); ?>">
		  <div data-aos="fade-up" class="counter-item"><h3 class="counter-days"></h3> <?php esc_html_e( 'Days', 'musicana' ); ?></div>
		  <div data-aos="fade-up" class="counter-item"><h3 class="counter-hours"></h3>  <?php esc_html_e( 'Hours', 'musicana' ); ?></div>
		  <div data-aos="fade-up" class="counter-item"><h3 class="counter-minutes"></h3>  <?php esc_html_e( 'Minutes', 'musicana' ); ?></div>
		  <div data-aos="fade-up" class="counter-item"><h3 class="counter-seconds"></h3> <?php esc_html_e( 'Seconds', 'musicana' ); ?></div>
		</div>
		<?php endif; ?>


  	</div>
  	<?php endif; ?>
