<?php
$artimusic_options = artimusic_theme_options();

$banner_title = $artimusic_options['banner_title'];

$banner_image = $artimusic_options['banner_image'];


$banner_subtext = $artimusic_options['banner_subtext'];
$soundcloud_url = $artimusic_options['soundcloud_url'];
$itunes_url = $artimusic_options['itunes_url'];


if(!empty($banner_image)){
  $background_img = "style='background-image:url(".esc_url($banner_image).")'";
}
else{
  $background_img = '';
}

?>
<div class="banner-section section-overlay" <?php echo wp_kses_post($background_img); ?>>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
          		<?php
                if ($banner_title):
                    echo '<h1 data-aos="fade-up">' . esc_html($banner_title) . '</h1>';
                endif;  

      			?>

      			<div data-aos="fade-up" data-aos-delay="300" class="follow-banner">
      				<?php if($banner_subtext):?><span><?php echo esc_html($banner_subtext); ?></span><?php endif; ?>
      			 <?php if($soundcloud_url):?> <a target="_blank" href="<?php echo esc_html($soundcloud_url); ?>"><i class="fa-brands fa-soundcloud"></i></a><?php endif; ?>
      			<?php if($itunes_url):?>	<a target="_blank" href="<?php echo esc_html($itunes_url); ?>"><i class="fa-brands fa-itunes"></i></a><?php endif; ?>

      			</div>
			</div>
		</div>
	</div>
</div>

