<?php
$artimusic_options = artimusic_theme_options();

$album_sec_title = $artimusic_options['album_sec_title'];
$album_cat = $artimusic_options['album_cat'];

?>
<div class="album-section section-spacing">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
                <?php
                    if ($album_sec_title): ?>
                    <div class="section-headings" data-aos="fade-up" >
                        <?php    echo '<h2>' . esc_html($album_sec_title) . '</h2>';
                            ?>
                    </div>
                <?php endif; ?>
			</div>

			<div class="col-md-12">
				<div class="album-list">

					<?php

					if ($album_cat == 'none') {
			            $args = array(
			                'post_type' => 'post',
			                'posts_per_page' => 6,
			                'post_status' => 'publish',
			                'order' => 'desc',

			            );
			        } 
			        else {
			            $args = array(
			                'post_type' => 'post',
			                'posts_per_page' => 6,
			                'post_status' => 'publish',
			                'order' => 'desc',
			                'tax_query' => array(
			                    'relation' => 'AND',
			                    array(
			                        'taxonomy' => 'category',
			                        'field'    => 'slug',
			                        'terms'    => array( $album_cat ),
			                    ),
			                ),
			            );
			        } 
			        

			         $query = new WP_Query($args);
			         	if ($query->have_posts()) :
                        while ($query->have_posts()) : $query->the_post();
                            global $post;
                            $post_format = get_post_format($post->ID);
                            $post_thumbnail_id = get_post_thumbnail_id(get_the_ID());
                            $image = wp_get_attachment_image_src($post_thumbnail_id, 'full');

                            
                                ?>
                            <div class="album-column">
                                <article class="album-item" data-aos="fade-up" data-aos-delay="300">
                                    <a href="<?php echo esc_url(get_the_permalink()); ?>">
                                    	<div class="tilt__item">
                                    		<img src="<?php echo esc_url($image[0]); ?>" alt="" />
                                    	</div>

                                    	<div class="photo-info">
                                    		<h3 class="entry-title"><?php the_title(); ?></h3>
                                    	</div>
                                    </a>
                                </article>
                            </div>
                        <?php  

                    endwhile;
                        wp_reset_postdata();
                         endif; ?>
    
				</div>
			</div>

		</div>
	</div>
</div>
