<?php
/**
 *
 */  

add_action( 'wp_enqueue_scripts', 'musicana_fix_parent_styles', 1 ); // Very early hook
function musicana_fix_parent_styles() {
    // Remove the parent theme's enqueue action
    remove_action( 'wp_enqueue_scripts', 'artimusic_scripts', 99 );
    
    // Re-enqueue all parent styles properly
    add_action( 'wp_enqueue_scripts', 'musicana_parent_styles', 10 );
}

function musicana_parent_styles() {
    // Enqueue all parent styles with correct paths
    wp_enqueue_style( 'artimusic-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'artimusic-font', artimusic_fonts(), array(), null);
    wp_enqueue_style( 'artimusic-bootstrapcss', get_template_directory_uri() . '/assets/css/bootstrap.css', array(), '1.0' );
    wp_enqueue_style( 'artimusic-fontawesome', get_template_directory_uri() . '/assets/fontawesome/css/all.css', array(), '1.0' );
    wp_enqueue_style( 'artimusic-aos', get_template_directory_uri() . '/assets/css/aos.css', array(), '1.0' );
    wp_enqueue_style( 'artimusic-css', get_template_directory_uri() . '/assets/css/artimusic.css', array(), '1.0' );
    wp_enqueue_style( 'artimusic-media-queries', get_template_directory_uri() . '/assets/css/media-queries.css', array(), '1.0' );

    // Parent scripts
    wp_enqueue_script( 'artimusic-navigation', get_template_directory_uri() . '/js/navigation.js', array('jquery'), '1.0', true);
    wp_enqueue_script( 'artimusic-aos-js', get_template_directory_uri() . '/assets/js/aos.js', array('jquery'), '1.0', true);
    wp_enqueue_script( 'artimusic-counter-js', get_template_directory_uri() . '/assets/js/loopcounter.js', array('jquery'), '1.0', true);
    wp_enqueue_script( 'artimusic-custom-script', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'), '1.0', true);

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}

add_action( 'wp_enqueue_scripts', 'musicana_child_styles', 100 );
function musicana_child_styles() {
    // Enqueue child theme styles last
    wp_enqueue_style( 'musicana-font', musicana_font_url(), array(), null);
    wp_enqueue_style( 
        'child-style', 
        get_stylesheet_directory_uri() . '/style.css', 
        array('artimusic-media-queries') // Dependency ensures it loads last
    );
}

function musicana_sanitize_checkbox( $input ) {
    if ( true === $input ) {
        return 1;
     } else {
        return 0;
     }
}


function musicana_customize_register( $wp_customize ) {

	$musicana_options = musicana_theme_options();
	
    $wp_customize->add_section(
        'newsletter_section',
        array(
            'title' => esc_html__( 'Newsletter Section','musicana' ),
            'panel'=>'theme_options',
            'capability'=>'edit_theme_options',
        )
    );


    $wp_customize->add_setting('musicana_theme_options[newsletter_show]',
        array(
            'type' => 'option',
            'default'        => true,
            'default' => $musicana_options['newsletter_show'],
            'sanitize_callback' => 'musicana_sanitize_checkbox',
        )
    );

    $wp_customize->add_control('musicana_theme_options[newsletter_show]',
        array(
            'label' => esc_html__('Show Newsletter Section', 'musicana'),
            'type' => 'Checkbox',

            'section' => 'newsletter_section',

        )
    );
	$wp_customize->add_setting('musicana_theme_options[newsletter_title]',
	    array(
	        'type' => 'option',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control('newsletter_title',
	    array(
	        'label' => esc_html__('Title', 'musicana'),
	        'type' => 'text',
	        'section' => 'newsletter_section',
	        'settings' => 'musicana_theme_options[newsletter_title]',
	    )
	);

	$wp_customize->add_setting('musicana_theme_options[newsletter_shortcode]',
	    array(
	        'type' => 'option',
	        'default' => $musicana_options['newsletter_shortcode'],
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control('musicana_theme_options[newsletter_shortcode]',
	    array(
	        'label' => esc_html__('newsletter Shortcode (Mailchimp Preferred)', 'musicana'),
	        'type' => 'text',
	        'section' => 'newsletter_section',
	        'settings' => 'musicana_theme_options[newsletter_shortcode]',
	    )
	);

  }
  add_action( 'customize_register', 'musicana_customize_register' );


  if (!function_exists('musicana_theme_options')) :
      function musicana_theme_options()
      {
          $defaults = array(
  

  
              'newsletter_show' => 0,
              'newsletter_title' => '',
   
              'newsletter_shortcode' => '',
              
  
          );
  
          $options = get_option('musicana_theme_options', $defaults);
  
          //Parse defaults again - see comments
          $options = wp_parse_args($options, $defaults);
  
          return $options;
      }
  endif;


if (!function_exists('musicana_font_url')) :
    function musicana_font_url()
    {
        $fonts_url = '';
        $fonts = array();


        if ('off' !== _x('on', 'Passion One font: on or off', 'musicana')) {
            $fonts[] = 'Passion One:700';
        }
        if ($fonts) {
            $fonts_url = add_query_arg(array(
                'family' => urlencode(implode('|', $fonts)),
            ), '//fonts.googleapis.com/css');
        }

        return $fonts_url;
    }
endif;