<?php get_header(); ?>

<div class="main demo">
  <div class="left demo">
    <?php if (have_posts()) : ?>
    <?php while (have_posts()) : the_post(); ?>
    <div <?php post_class() ?> id="post-<?php the_ID(); ?>">
      <div class="titr demo">
        <h3><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>">
          <?php the_title(); ?>
          </a></h3>
      </div>
      <div class="date">
        <?php the_time('F jS, Y') ?>
        <!-- by <?php the_author() ?> -->
      </div>
      <div class="entry">
        <?php the_content('Read the rest of this entry &raquo;'); ?>
      </div>
      <p class="postmetadata">
        <?php the_tags('Tags: ', ', ', '<br />'); ?>
        Posted in
        <?php the_category(' &gt; ','multiple'); ?>
        |
        <?php edit_post_link('Edit', '', ' | '); ?>
        <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?>
      </p>
    </div>
    <div class="writer">
      <?php wp_list_authors('show_fullname=1&optioncount=1&exclude_admin=0'); ?>
    </div>
    <?php endwhile; ?>
    <div class="navigation">
      <div class="alignleft">
        <?php next_posts_link('&laquo; Older Entries') ?>
      </div>
      <div class="alignright">
        <?php previous_posts_link('Newer Entries &raquo;') ?>
      </div>
    </div>
    <?php else : ?>
    <h2 class="center">Not Found</h2>
    <p class="center">Sorry, but you are looking for something that isn't here.</p>
    <?php get_search_form(); ?>
    <?php endif; ?>
    <?php comments_template(); ?>
    <?php do_enclose( $content, $post_ID ) ?>
    <?php wp_link_pages( $args ); ?>
  </div>
  <?php get_sidebar(); ?>
</div>
<?php get_footer(); ?>
</div>
</body></html>