/**
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */
( function( $ ) {

	wp.customize( 'munding_img_logo', function( value ) {
		value.bind( function( newval ) {
			if( newval !== '' ) {
				$( '#header .header-logo' ).empty();
				$( '#header .header-logo' ).prepend( '<img src="" alt="'+ wp.customize._value.kerinci_text_logo +'" title="'+ wp.customize._value.kerinci_text_logo +'" />' );
				$( '#header .header-logo img' ).attr( 'src', newval );
			} else {
				$( '#header .header-logo' ).text( wp.customize._value.kerinci_text_logo() );
			}
		} );
	} );

	/* Footer Copyright */
	wp.customize( 'munding_lite_footer_copyright', function( value ) {
		value.bind( function( newval ) {
			$( '#footer .copyright-footer' ).html( newval );
		} );
	} );

	wp.customize( 'munding_lite_general_footer_display_copyright', function( value ) {
		value.bind( function( newval ) {
			if( newval == true ) {
				$( '#footer .copyright-footer span[data-customizer="copyright-credit"]' ).removeClass( 'customizer-display-none' );
			} else if( newval == false ) {
				$( '#footer .copyright-footer span[data-customizer="copyright-credit"]' ).addClass( 'customizer-display-none' );
			}
		} );
	} );

} )( jQuery );