<?php 

/*
*
*	Theme Customizer Options
*	------------------------------------------------
*	Munding Framework
* 	Copyright Themes Awesome 2013 - http://www.themesawesome.com
*
*	munding_lite_customize_register()
*	munding_lite_customize_preview()
*
*/
	
if (!function_exists('munding_lite_customize_register')) {
	function munding_lite_customize_register($wp_customize) {
		
		$wp_customize->get_setting('blogname')->transport='postMessage';
		$wp_customize->get_setting('blogdescription')->transport='postMessage';
		$wp_customize->get_setting('header_textcolor')->transport='postMessage';

		//$wp_customize->get_control( 'custom_logo' )->section = 'munding_lite_panel_general';

		// General Controls
		require_once MUNDING_LITE_TEMPLATE_DIR . '/inc/panels/general-options.php';

		// Socials Controls
		//require_once MUNDING_LITE_TEMPLATE_DIR . '/inc/panels/author-options.php';

		// Extend Controls
		require_once MUNDING_LITE_TEMPLATE_DIR . '/inc/panels/extend-options.php';

	}
	add_action( 'customize_register', 'munding_lite_customize_register' );
}

/**
*  Customizer Live Preview
*/
	function munding_lite_customizer_live_preview() {
	wp_enqueue_script( 'munding-lite-customizer',	MUNDING_LITE_DIR.'/js/customizer.js', array( 'jquery','customize-preview' ), NULL, true);
	}
	add_action( 'customize_preview_init', 'munding_lite_customizer_live_preview' );

/**
 *  Sanitize HTML
 */
if ( ! function_exists( 'munding_lite_sanitize_html' ) ) {
	function munding_lite_sanitize_html( $input ) {
		$input = force_balance_tags( $input );

		$allowed_html = array(
			'a'      => array(
				'href'  => array(),
				'title' => array(),
			),
			'br'     => array(),
			'em'     => array(),
			'img'    => array(
				'alt'    => array(),
				'src'    => array(),
				'srcset' => array(),
				'title'  => array(),
			),
			'strong' => array(),
		);
		$output       = wp_kses( $input, $allowed_html );

		return $output;
	}
}

if ( ! function_exists( 'munding_lite_sanitize_select' ) ) {
	function munding_lite_sanitize_select( $input ) {
		if ( is_numeric( $input ) ) {
			return intval( $input );
		}
	}
}