<?php 

function custom_excerpt_length( $length ) {
	return 20;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function new_excerpt_more( $more ) {
	return '...';
}
add_filter('excerpt_more', 'new_excerpt_more');

function munding_lite_excerpt(){
 global $post;
  ?> <div class="akmanda-excerpt entry-content" itemprop="text"> <?php
 	the_excerpt(); 
 	?>
	<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="more"><?php esc_html_e( 'Continue', 'munding-lite' ); ?></a></div>
	<?php
}

function loop_post_thumbnail(){

  if ( has_post_thumbnail()) {
    $real_image = get_post_thumbnail_id();
    $image_url = wp_get_attachment_image_src( $real_image, 'full'); 
    $image_meta = wp_get_attachment_metadata( $real_image );
    $image_width = $image_meta["width"];
    $image_height = $image_meta["height"];
  ?>
  <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" >
    <div class="post-thumb">
      <div itemprop="image" itemscope itemtype="https://schema.org/ImageObject">
        <img class="singleimg" src="<?php echo esc_url($image_url[0]) ?>">
        <meta itemprop="url" content="<?php echo esc_url( $image_url[0] ); ?>">
        <?php echo '<meta itemprop="width" content="'.$image_width.'"><meta itemprop="height" content="'.$image_height.'">'; ?>
      </div>
    </div><!-- post thumb -->
  </a>
  <?php }

  else { ?>

  <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" >
    <div class="post-thumb">
      <div itemprop="image" itemscope itemtype="https://schema.org/ImageObject">
        <?php echo '<img src="'.MUNDING_LITE_DIR.'/img/dummy-content.jpg" />'; ?>
        <meta itemprop="url" content="<?php echo MUNDING_LITE_DIR . '/img/dummy-content.jpg'; ?>">
      </div>
    </div><!-- post thumb -->
  </a>
  <?php }  ?>
<?php } 


function munding_lite_direct_content() {
	global $post;
				?>
              <div class="inner-content">
                    <?php the_content(); ?>
              </div>

				<?php  if (!is_singular()) { ?>

              <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="text-center more"><?php esc_html_e( 'Continue Reading', 'munding-lite' ); ?></a>
			<?php }

}


function munding_lite_content() {
	global $post;

		if (is_singular() && $post->post_content !== '') { 
                    
                    the_content();
                    wp_link_pages(); 
                  }

}

function munding_lite_author_info() {
		global $post;
		$hide_author = get_field('hide_author');	
			if ( is_singular() ) {                   
                    if(!$hide_author) {
                        get_template_part('/inc/part/author-info');
                    }    
                }
}

// akmanda author plug and play
function munding_lite_author(){
    global $post;
    echo '<div class="author-wrapper">'; ?>
    <span class="author-icon"><?php esc_html_e( 'by', 'munding-lite' ); ?>: </span>
    <?php echo '<a href="'.get_author_posts_url( get_the_author_meta( 'ID' ) ).'">'. get_the_author_meta( 'display_name' ) .'</a>';
    echo '</div>';
}


function munding_lite_comments(){
    global $post;

    comments_number( '0 Comments', '1 Comments', '% Comments' );

}


function munding_lite_comment_checker() {
	global $post;

	if ( is_singular() ) wp_enqueue_script( "comment-reply" ); 
	if ( comments_open() || '0' != get_comments_number() ) comments_template(); 
}

function excerpt_or_author() {
global $post; ?>
    <div class="bord"></div>
   <?php if(!is_singular()) {
                    munding_lite_excerpt();
                }
                else {
                    munding_lite_author_info();
                } ?>
    <div class="bord"></div> <?php
}
