<?php
/**
 * Getting started template
 */

$customizer_url = wp_customize_url() ;
?>

<div id="getting_started" class="munding-tab-pane active">

<div class="content-info-about">

	<div class="intro-head">
		<h1 class="munding-welcome-title"><?php _e('Welcome to Munding!', 'munding-lite'); ?> <?php if( !empty($munding_lite_lite['Version']) ): ?> <sup id="munding-theme-version"><?php echo esc_attr( $munding_lite_lite['Version'] ); ?> </sup><?php endif; ?></h1>
		<p><?php esc_html_e( 'We want to make sure you have the best experience using munding and that is why we gathered here all the necessary information for you. We hope you will enjoy using munding, as much as we enjoy creating great products.', 'munding-lite' ); ?>
	</div>

	<div class="munding-tab-pane-center column column-3">
		<div class="inner-info">
			<h1><?php esc_html_e( 'Getting started', 'munding-lite' ); ?></h1>

			<h4><?php esc_html_e( 'Customize everything in a single place.' ,'munding-lite' ); ?></h4>
			<p><?php esc_html_e( 'Using the WordPress Customizer you can easily customize every aspect of the theme.', 'munding-lite' ); ?></p>
			<p><a href="<?php echo esc_url( $customizer_url ); ?>" class="button button-primary"><?php esc_html_e( 'Go to Customizer', 'munding-lite' ); ?></a></p>
		</div>
	</div>

	<div class="munding-tab-pane-center column column-3">
		<div class="inner-info">
			<h1><?php esc_html_e( 'Need more features?', 'munding-lite' ); ?></h1>

			<h4><?php esc_html_e( 'Check our premium version for this theme.' ,'munding-lite' ); ?></h4>
			<p><?php esc_html_e( 'Check out the Premium version of this theme which comes with additional features and advanced customization.', 'munding-lite' ); ?></p>
			<p><a href="<?php $my_theme = wp_get_theme(); echo $my_theme->get( 'AuthorURI' ); ?>/products/wordpress-themes/munding/" class="button button-primary"><?php esc_html_e( 'Learn Premium Version', 'munding-lite' ); ?></a></p>
		</div>
	</div>

	<div class="munding-tab-pane-center column column-3">
		<div class="inner-info">
			<h1><?php esc_html_e( 'Documentation', 'munding-lite' ); ?></h1>

			<h4><?php esc_html_e( 'How to install this theme with a minutes.' ,'munding-lite' ); ?></h4>
			<p><?php esc_html_e( 'Please read our online documentation page to setup this theme. Install from clean WordPress within a minutes.', 'munding-lite' ); ?></p>
			<p><a href="https://themesawesome.zendesk.com/hc/en-us/categories/200178010-Munding" class="button button-primary"><?php esc_html_e( 'Read Documentation', 'munding-lite' ); ?></a></p>
		</div>
	</div>
</div>
</div>
