<?php

define('MUNDING_LITE_DIR', get_template_directory_uri());
define('MUNDING_LITE_TEMPLATE_DIR', get_template_directory());

//Set the content width based on the theme's design and stylesheet.
if ( ! isset( $content_width ) )
	$content_width = 1200; /* pixels */

/*-----------------------------------------------------------------------------------*/
/*  SETUP THEME
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'munding_lite_setup' ) ) :

    function munding_lite_setup() {
        // several theme support
        add_theme_support( 'automatic-feed-links' );
        add_theme_support( 'custom-background' );
        add_theme_support( 'post-thumbnails' );
        add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form' ) );   
        add_theme_support( 'html5', array( 'gallery', 'caption' ) );
        load_theme_textdomain( 'munding-lite', MUNDING_LITE_TEMPLATE_DIR .'/languages' );
        add_theme_support( "title-tag" );
        add_theme_support( 'custom-logo', array(
            'flex-width'  => true,
            'flex-height' => true,
        ) );

        /*******************************************/
        /*************  Welcome screen *************/
        /*******************************************/

        if ( is_admin() ) {
            require MUNDING_LITE_TEMPLATE_DIR . '/inc/admin/about-theme/about-theme.php';
        }
}
endif;
add_action( 'after_setup_theme', 'munding_lite_setup' );

/*-----------------------------------------------------------------------------------*/
/*  ACF
/*-----------------------------------------------------------------------------------*/

add_filter('acf/settings/show_admin', '__return_false');


/*-----------------------------------------------------------------------------------*/
/*  SCRIPTS & STYLES
/*-----------------------------------------------------------------------------------*/

function munding_lite_scripts() {
//All necessary CSS
wp_enqueue_style( 'munding-lite-bootstrap', MUNDING_LITE_DIR .'/css/bootstrap.min.css', array(), null );
wp_enqueue_style( 'munding-lite-plugin-css', MUNDING_LITE_DIR .'/css/plugin.css', array(), null );
wp_enqueue_style( 'munding-lite-style', get_stylesheet_uri(), array( 'munding-lite-bootstrap','munding-lite-plugin-css' ) );
wp_enqueue_style( 'munding-lite-font', MUNDING_LITE_DIR .'/css/font.css', array(), null );

//All Necessary Script

wp_enqueue_script( 'munding-lite-modernizr', MUNDING_LITE_DIR. '/js/modernizr.js', array( 'jquery' ), '', false );
wp_enqueue_script( 'munding-lite-respond', MUNDING_LITE_DIR. '/js/respond.js', array( 'jquery' ), '', false );
wp_enqueue_script( 'munding-lite-waypoints', MUNDING_LITE_DIR. '/js/waypoints.js', array( 'jquery' ), '', false );
wp_enqueue_script( 'munding-lite-fitvids', MUNDING_LITE_DIR. '/js/fitvids.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'munding-lite-nicescroll', MUNDING_LITE_DIR. '/js/nicescroll.js', array( 'jquery' ), '', false );
wp_enqueue_script( 'munding-lite-main-js', MUNDING_LITE_DIR. '/js/main.js', array( 'jquery' ), '', true );
}

add_action( 'wp_enqueue_scripts', 'munding_lite_scripts' );

/*-----------------------------------------------------------------------------------*/
/*  FONT SCRIPTS
/*-----------------------------------------------------------------------------------*/

function munding_lite_font_setup() {
    $fonts_url = '';
 
    /* Translators: If there are characters in your language that are not
    * supported by Abril Fatface, translate this to 'off'. Do not translate
    * into your own language.
    */
    $montserrat = _x( 'on', 'Abril Fatface font: on or off', 'munding-lite' );
 
    /* Translators: If there are characters in your language that are not
    * supported by Open Sans, translate this to 'off'. Do not translate
    * into your own language.
    */
    $open_sans = _x( 'on', 'Open Sans font: on or off', 'munding-lite' );
 
    if ( 'off' !== $montserrat || 'off' !== $open_sans ) {
        $font_families = array();
 
        if ( 'off' !== $montserrat ) {
            $font_families[] = 'Abril Fatface:400,700';
        }
 
        if ( 'off' !== $open_sans ) {
            $font_families[] = 'Open Sans:400,400italic,700,700italic';
        }
 
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
 
    return esc_url_raw( $fonts_url );
}

function munding_lite_font_scripts() {
    wp_enqueue_style( 'munding-slug-fonts', munding_lite_font_setup(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'munding_lite_font_scripts' );

/*-----------------------------------------------------------------------------------*/
/*  MENU
/*-----------------------------------------------------------------------------------*/

//Register Menus
add_action( 'after_setup_theme', 'munding_lite_register_my_menu' );
function munding_lite_register_my_menu() {
  register_nav_menu( 'header-menu', __( 'Header Menu', 'munding-lite' ) );
}

// AKMANDA TOP MENU
function munding_lite_top_nav_menu(){
  wp_nav_menu( array(
    'theme_location' => 'header-menu',
    'container'       => 'ul',
   'menu_class'      => 'sf-menu',
    'fallback_cb'  => 'munding_lite_header_menu_cb'
  ));
}

// AKMANDA MOBILE MENU
function munding_lite_mobile_nav_menu(){
  wp_nav_menu( array(
    'theme_location' => 'header-menu',
    'container'       => 'ul',
   'menu_class'      => 'nav nav-pills nav-stacked',
    'fallback_cb'  => 'munding_lite_header_menu_cb'
  ));
}

// FALLBACK IF PRIMARY MENU HAVEN'T SET YET
function munding_lite_header_menu_cb() {
  echo '<ul id="menu-top-menu" class="sf-menu">';
  wp_list_pages('title_li=');
  echo '</ul>';
}


/*-----------------------------------------------------------------------------------*/
/*  PAGINATION
/*-----------------------------------------------------------------------------------*/

function munding_lite_pagination($pages = '', $range = 2)
{  
         $showitems = ($range * 2)+1;  

         global $paged;
         if(empty($paged)) $paged = 1;

         if($pages == '')
         {
                 global $wp_query;
                 $pages = $wp_query->max_num_pages;
                 if(!$pages)
                 {
                         $pages = 1;
                 }
         }   

         if(1 != $pages)
         {
                 echo "<div class='pagination col-md-12 text-center'>";
                 if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>First</a>";
                 if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

                 for ($i=1; $i <= $pages; $i++)
                 {
                         if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
                         {
                                 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
                         }
                 }

                 if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'>&rsaquo;</a>";  
                 if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>Last</a>";
                 echo "</div>\n";
         }
}


/*-----------------------------------------------------------------------------------*/
/*  CUSTOM FUNCTIONS
/*-----------------------------------------------------------------------------------*/

// INCLUDE SUPPORT FILE
require_once( MUNDING_LITE_TEMPLATE_DIR . '/inc/function/custom.php' );
require_once( MUNDING_LITE_TEMPLATE_DIR . '/inc/function/navigation.php' );
require_once( MUNDING_LITE_TEMPLATE_DIR . '/inc/function/comment.php' );
require_once( MUNDING_LITE_TEMPLATE_DIR . '/inc/function/customizer.php');