<?php

/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package multivas
 */
$classes = [
	'bg-light',
	'clearfix',
	'pt-4',
	'pb-5',
	'px-5',
];
?>

<article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>
	<header class="entry-header py-2">
		<?php the_title('<h1 class="entry-title text-capitalize">', '</h1>'); ?>
	</header><!-- .entry-header -->

	<?php the_post_thumbnail("full", ["class" => "img-fluid mt-2 mb-4"]); ?>

	<div class="entry-content">
		<?php
		the_content();

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__('Pages:', 'multivas'),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->

	<?php if (get_edit_post_link()) : ?>
		<footer class="entry-footer mt-2">
			<?php
			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__('Edit <span class="screen-reader-text">%s</span>', 'multivas'),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post(get_the_title())
				),
				'<span class="edit-link">',
				'</span>'
			);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->