<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package multivas
 */

get_header();

//Theme defaults and customizer selected values
$default = multivas_get_defaults();

$selected_blog_grid = get_theme_mod('multivas_blog_grid_settings', $default['multivas_blog_grid_settings']);
?>
<div class="container search-container mt-5">
	<div class="row g-5">
		<div class="<?php if ($selected_blog_grid == 'no') : ?>col-lg-12<?php else : ?>col-lg-9<?php endif; ?>">
			<main id="primary" class="site-main">
				<div class="row gx-5">
					<?php if (have_posts()) : ?>
						<div class="col-lg-12">
							<header class="page-header bg-light px-5 py-4 mb-4">
								<h1 class="page-title  text-center">
									<?php
									/* translators: %s: search query. */
									printf(esc_html__('Search Results for: %s', 'multivas'), '<span>' . get_search_query() . '</span>');
									?>
								</h1>
							</header><!-- .page-header -->
						</div>
							<?php
							/* Start the Loop */
							while (have_posts()) :
								the_post();

								/**
								 * Run the loop for the search to output the results.
								 * If you want to overload this in a child theme then include a file
								 * called content-search.php and that will be used instead.
								 */
								get_template_part('template-parts/content', 'search');

							endwhile; ?>
							<div class="custom-margin">
								<?php

								the_posts_pagination(array(
									'class'     => 'text-center',
									'mid_size'  => 2,
									'prev_text' => __('Previous', 'multivas'),
									'next_text' => __('Next', 'multivas'),
								)); ?>
							</div>
						<?php

					else :

						get_template_part('template-parts/content', 'none');

					endif;
						?>
						</div>
			</main><!-- #main -->
		</div>
		<?php if ($selected_blog_grid != 'no') : ?>
			<div class="col-lg-3">
				<?php get_sidebar(); ?>
			</div>
		<?php endif; ?>
	</div>
</div>
<?php get_footer();
