<?php

/**
 * multivas Theme Customizer
 *
 * @package multivas
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function multivas_customize_register($wp_customize)
{
	$theme_options =
		multivas_get_defaults();
	$wp_customize->get_setting('blogname')->transport         = 'postMessage';
	$wp_customize->get_setting('blogdescription')->transport  = 'postMessage';
	$wp_customize->get_setting('header_textcolor')->transport = 'postMessage';


	if (isset($wp_customize->selective_refresh)) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'multivas_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'multivas_customize_partial_blogdescription',
			)
		);
	}

	//Theme options
	$wp_customize->add_panel(
		'multivas_theme_options',
		array(
			'title' => esc_html__('Theme Options', 'multivas'),
			'priority' => 2,
		)
	);

	//Feature images slider section
	$wp_customize->add_section(
		'multivas_feature_images_slider',
		array(
			'title' => esc_html__('Feature Images Slider', 'multivas'),
			'panel' => 'multivas_theme_options',
			'capability' => 'edit_theme_options',
		)
	);

	//List of categories for feature image slides
	$wp_customize->add_setting(
		'multivas_feature_slider_category',
		array(
			'type' => 'theme_mod',
			'sanitize_callback' => 'multivas_sanitize_select',
			'default' => $theme_options['multivas_feature_slider_category'],
		)
	);
	$wp_customize->add_control(
		'multivas_feature_slider_category',
		array(
			'section' => 'multivas_feature_images_slider',
			'type' => 'select',
			'choices' => multivas_list_of_categories(),
			'label' => esc_html__('Select Category for Slider', 'multivas'),
			'description' => esc_html__(
				'List of Categories attached to posts',
				'multivas'
			),
			'priority' => 1,
		)
	);

	//Total allowed number of slides
	$wp_customize->add_setting(
		'multivas_total_feature_slides',
		array(
			'sanitize_callback' => 'absint',
			'default' => $theme_options['multivas_total_feature_slides'],
		)
	);
	$wp_customize->add_control(
		'multivas_total_feature_slides',
		array(
			'label' => esc_html__('Select Total Number of Slides', 'multivas'),
			'description' => esc_html__('1 - 10 slides allowed', 'multivas'),
			'section' => 'multivas_feature_images_slider',
			'type' => 'number',
			'input_attrs' => array(
				'min' => 1,
				'max' => 10
			),
		)
	);

	//Show & hide caption
	$wp_customize->add_setting(
		'multivas_caption_checkbox',
		array(
			'sanitize_callback' 	=> 'multivas_sanitize_checkbox',
			'default' 				=> $theme_options['multivas_caption_checkbox'],
		)
	);
	$wp_customize->add_control(
		'multivas_caption_checkbox',
		array(
			'label' => esc_html__('Post Title for Caption', 'multivas'),
			'section' => 'multivas_feature_images_slider',
			'type' => 'checkbox',
		)
	);

	//Blog grid choices
	$wp_customize->add_section(
		'multivas_blog_grid',
		array(
			'title' => esc_html__('Blog Grid', 'multivas'),
			'panel' => 'multivas_theme_options',
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_setting(
		'multivas_blog_grid_settings',
		array(
			'default' 				=> $theme_options['multivas_blog_grid_settings'],
			'sanitize_callback' => 'multivas_sanitize_radio',
		)
	);
	$wp_customize->add_control(
		'multivas_blog_grid_settings',
		array(
			'label' => esc_html__('Blog Grid Choices', 'multivas'),
			'section' => 'multivas_blog_grid',
			'type' => 'radio',
			'choices' => array(
				'right' => esc_html__('Right Sidebar', 'multivas'),
				'no' => esc_html__('No Sidebar', 'multivas')
			)
		)
	);
	//Posts grid choices
	$wp_customize->add_setting(
		'multivas_posts_grid_settings',
		array(
			'default' 				=> $theme_options['multivas_posts_grid_settings'],
			'sanitize_callback' => 'multivas_sanitize_radio',
		)
	);
	$wp_customize->add_control(
		'multivas_posts_grid_settings',
		array(
			'label' => esc_html__('Posts Grid Choices', 'multivas'),
			'section' => 'multivas_blog_grid',
			'type' => 'radio',
			'choices' => array(
				'1' => esc_html__('Single Post', 'multivas'),
				'2' => esc_html__('Two Posts', 'multivas')
			)
		)
	);

	//Footer Widgets Section Show/Hide 
	$wp_customize->add_section(
		'multivas_footer_section',
		array(
			'title' => esc_html__('Footer', 'multivas'),
			'panel' => 'multivas_theme_options',
			'capability' => 'edit_theme_options',
		)
	);
	//Show & hide footer widgets
	$wp_customize->add_setting(
		'multivas_footer_widgets_checkbox',
		array(
			'sanitize_callback' 	=> 'multivas_sanitize_checkbox',
			'default' 				=> $theme_options['multivas_footer_widgets_checkbox'],
		)
	);
	$wp_customize->add_control(
		'multivas_footer_widgets_checkbox',
		array(
			'label' => esc_html__('Footer Widgets Section', 'multivas'),
			'section' => 'multivas_footer_section',
			'type' => 'checkbox',
		)
	);
	//Facebook profile
	$wp_customize->add_setting(
		'multivas_fb_social_link',
		array(
			'default' 				=> $theme_options['multivas_fb_social_link'],
			'sanitize_callback' => 'wp_filter_nohtml_kses',
		)
	);
	$wp_customize->add_control(
		'multivas_fb_social_link',
		array(
			'label' => esc_html__('Your Facebook Profile URL', 'multivas'),
			'section' => 'multivas_footer_section',
			'type' => 'text'
		)
	);
	//Twitter profile
	$wp_customize->add_setting(
		'multivas_twitter_social_link',
		array(
			'default' 				=> $theme_options['multivas_twitter_social_link'],
			'sanitize_callback' => 'wp_filter_nohtml_kses',
		)
	);
	$wp_customize->add_control(
		'multivas_twitter_social_link',
		array(
			'label' => esc_html__('Your Twitter Profile URL', 'multivas'),
			'section' => 'multivas_footer_section',
			'type' => 'text'
		)
	);
	//Instagram profile
	$wp_customize->add_setting(
		'multivas_instagram_social_link',
		array(
			'default' 				=> $theme_options['multivas_instagram_social_link'],
			'sanitize_callback' => 'wp_filter_nohtml_kses',
		)
	);
	$wp_customize->add_control(
		'multivas_instagram_social_link',
		array(
			'label' => esc_html__('Your Instagram Profile URL', 'multivas'),
			'section' => 'multivas_footer_section',
			'type' => 'text'
		)
	);
	//Youtube profile
	$wp_customize->add_setting(
		'multivas_youtube_social_link',
		array(
			'default' 				=> $theme_options['multivas_youtube_social_link'],
			'sanitize_callback' => 'wp_filter_nohtml_kses',
		)
	);
	$wp_customize->add_control(
		'multivas_youtube_social_link',
		array(
			'label' => esc_html__('Your Youtube Profile URL', 'multivas'),
			'section' => 'multivas_footer_section',
			'type' => 'text'
		)
	);

	//Remove custom header section
	$wp_customize->remove_section('header_image');
}
add_action('customize_register', 'multivas_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function multivas_customize_partial_blogname()
{
	bloginfo('name');
}

//Get list of categories
function multivas_list_of_categories()
{
	$categories = get_categories();
	$choices = array();

	if (!empty($categories)) :
		$choices[''] = __('Select Category', 'multivas');
		foreach ($categories as $category) {
			$choices[$category->slug] = $category->name;
		}
	endif;

	return $choices;
}

//radio box sanitization function
function multivas_sanitize_radio($input, $setting)
{

	$input = sanitize_key($input);

	$choices = $setting->manager->get_control($setting->id)->choices;

	return (array_key_exists($input, $choices) ? $input : $setting->default);
}

//checkbox sanitization function
function multivas_sanitize_checkbox($input)
{
	if (true === $input) {
		return 1;
	} else {
		return 0;
	}
}

//Select sanitization function
function multivas_sanitize_select($input, $setting)
{
	$input = sanitize_key($input);

	$choices = $setting->manager->get_control($setting->id)->choices;

	return array_key_exists($input, $choices) ? $input : $setting->default;
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function multivas_customize_partial_blogdescription()
{
	bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function multivas_customize_preview_js()
{
	wp_enqueue_script('multivas-customizer', get_template_directory_uri() . '/js/customizer.js', array('customize-preview'), MULTIVAS__VERSION, true);
}
add_action('customize_preview_init', 'multivas_customize_preview_js');
