<?php

/**
 * The template for displaying homepage 
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package multivas
 */


get_header();

//Theme defaults and customizer selected values
$default = multivas_get_defaults();

$selected_blog_grid = get_theme_mod('multivas_blog_grid_settings', $default['multivas_blog_grid_settings']);
$selected_cate = get_theme_mod('multivas_feature_slider_category', $default['multivas_feature_slider_category']);
$total_slides = get_theme_mod('multivas_total_feature_slides', $default['multivas_total_feature_slides']);
$slide_caption = get_theme_mod('multivas_caption_checkbox', $default['multivas_caption_checkbox']);

if ($selected_cate != false) :

   $args = array(
      'post_type' => 'post',
      'posts_per_page' => $total_slides,
      'post_status' => 'publish',
      'order' => 'desc',
      'orderby' => 'menu_order date',
      'category_name' => $selected_cate,
   );

   $query = new WP_Query($args);

   if ($query->have_posts()) : ?>
      <div class="container-fluid g-0">
         <section class="slider">
            <?php
            while ($query->have_posts()) :
               $query->the_post();
               $image_src = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
            ?>
               <div class="slide">
                  <div class="slider-img">
                     <img src="<?php the_post_thumbnail_url('multivas-slider-size'); ?>" alt="" class="full-image animated" data-animation-in="zoomInImage" />
                  </div>
                  <?php if ($slide_caption != false) : ?>
                     <div class="slider-content bg-dark bg-opacity-25 p-5 d-none d-md-block">
                        <div class="slider-caption">
                           <h2 class="animated" data-animation-in="fadeInRight"><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h2>
                           <div class="animated " data-animation-in="fadeInRight"><a class="btn btn-light" href="<?php echo esc_url(get_the_permalink()); ?>"><?php esc_html_e(' Read More ', 'multivas') ?></a>
                           </div>
                        </div>
                     </div>
                  <?php endif; ?>
               </div>
            <?php endwhile;
            wp_reset_postdata();
            ?>
         </section>
      </div>
   <?php endif; ?>
<?php else : ?> <div class="text-center my-3"><?php multivas_slider_section(); ?></div>
<?php endif; ?>
<div class="container blog-home mt-5">
   <div class="row g-5">
      <div class="<?php if ($selected_blog_grid == 'no') : ?>col-lg-12<?php else : ?>col-lg-9<?php endif; ?>">
         <main id="primary" class="site-main">
            <div class="row gx-5">
               <?php
               if (have_posts()) :

                  /* Start the Loop */
                  while (have_posts()) :
                     the_post();

                     /*
                     * Include the Post-Type-specific template for the content.
                     * If you want to override this in a child theme, then include a file
                     * called content-___.php (where ___ is the Post Type name) and that will be used instead.
                     */
                     get_template_part('template-parts/content', get_post_type());

                  endwhile; ?>
                  <div class="custom-margin">
                     <?php
                     the_posts_pagination(array(
                        'class'     => 'text-center',
                        'mid_size'  => 2,
                        'prev_text' => __('Previous', 'multivas'),
                        'next_text' => __('Next', 'multivas'),
                     )); ?>
                  </div>
               <?php
               else :

                  get_template_part('template-parts/content', 'none');

               endif;
               ?>
            </div>
         </main><!-- #main -->
      </div>
      <?php if ($selected_blog_grid != 'no') : ?>
         <div class="col-lg-3">
            <?php get_sidebar(); ?>
         </div>
      <?php endif; ?>
   </div>
</div>
<?php get_footer(); ?>