<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package multivas
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'multivas'); ?></a>

		<div class="container text-center">
			<header id="masthead" class="site-header pt-4 pb-4">
				<div class="site-branding">
					<?php
					the_custom_logo();
					?>
					<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
					<?php
					$multivas_description = get_bloginfo('description', 'display');
					if ($multivas_description || is_customize_preview()) :
					?>
						<p class="site-description d-none d-md-block mb-0 "><?php echo $multivas_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
																								?></p>
					<?php endif; ?>
				</div><!-- .site-branding -->
				<nav class="navbar navbar-expand-md navbar-light bg-white main-navigation">
					<div class="container-fluid">
						<button class="navbar-toggler mx-auto" type="button" data-bs-toggle="collapse" data-bs-target="#main-menu" aria-controls="main-menu" aria-expanded="false" aria-label="<?php esc_attr_e('Toggle navigation', 'multivas'); ?>Toggle navigation">
							<span class="navbar-toggler-icon"></span>
						</button>

						<div class="collapse navbar-collapse justify-content-md-center" id="main-menu">
							<?php
							wp_nav_menu(array(
								'theme_location' => 'main-menu',
								'container' => false,
								'menu_class' => '',
								'fallback_cb' => '__return_false',
								'items_wrap' => '<ul id="%1$s" class="navbar-nav mt-4 mb-2 mt-md-0 mb-md-0 %2$s">%3$s</ul>',
								'depth' => 2,
								'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
								'walker' =>
								new WP_Bootstrap_Navwalker(),
							));
							?>
						</div>
					</div>
				</nav><!-- .main-navigation -->
			</header><!-- #masthead -->
		</div>