<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package multivas
 */

//Theme defaults and customizer selected values
$default = multivas_get_defaults();

$footer_widget_section = get_theme_mod('multivas_footer_widgets_checkbox', $default['multivas_footer_widgets_checkbox']);
$footer_fb_profile = get_theme_mod('multivas_fb_social_link', $default['multivas_fb_social_link']);
$footer_twitter_profile = get_theme_mod('multivas_twitter_social_link', $default['multivas_twitter_social_link']);
$footer_instagram_profile = get_theme_mod('multivas_instagram_social_link', $default['multivas_instagram_social_link']);
$footer_youtube_profile = get_theme_mod('multivas_youtube_social_link', $default['multivas_youtube_social_link']);

?>

<footer class="main-footer">
	<?php if ($footer_widget_section != false && !(is_page())) : ?>
		<div class="footer-widget-section">
			<div class="container">
				<div class="row gx-5">
					<div class="col-lg-3">
						<?php if (is_active_sidebar('footer-widget-1')) : ?>
							<?php dynamic_sidebar('footer-widget-1'); ?>
						<?php else : multivas_blog_blank_widget_area(); ?>
						<?php endif;  ?>
					</div>
					<div class="col-lg-3">
						<?php if (is_active_sidebar('footer-widget-2')) : ?>
							<?php dynamic_sidebar('footer-widget-2'); ?>
						<?php else : multivas_blog_blank_widget_area(); ?>
						<?php endif;  ?>
					</div>
					<div class="col-lg-3">
						<?php if (is_active_sidebar('footer-widget-3')) : ?>
							<?php dynamic_sidebar('footer-widget-3'); ?>
						<?php else : multivas_blog_blank_widget_area(); ?>
						<?php endif;  ?>
					</div>
					<div class="col-lg-3">
						<?php if (is_active_sidebar('footer-widget-4')) : ?>
							<?php dynamic_sidebar('footer-widget-4'); ?>
						<?php else : multivas_blog_blank_widget_area(); ?>
						<?php endif;  ?>
					</div>
				</div>
			</div>
		</div>
	<?php endif; ?>
	<div class="social-follow pt-4 pb-4">
		<div class="container">
			<div class="row">
				<div class="col">
					<ul class="list-unstyled m-0 text-center">
						<?php
						if ($footer_fb_profile) :
						?>
							<li class="list-inline-item"><a href="<?php echo $footer_fb_profile; ?>" class="btn btn-outline-light btn-social mx-1"><i class=" fa fa-facebook"></i></a></li>
						<?php endif; ?>
						<?php
						if ($footer_twitter_profile) :
						?>
							<li class="list-inline-item"><a href="<?php echo $footer_twitter_profile; ?>" class="btn btn-outline-light btn-social mx-1"><i class="fa fa-twitter"></i></a></li>
						<?php endif; ?>
						<?php
						if ($footer_instagram_profile) :
						?>
							<li class="list-inline-item"><a href="<?php echo $footer_instagram_profile; ?>" class="btn btn-outline-light btn-social mx-1"><i class="fa fa-instagram"></i></a></li>
						<?php endif; ?>
						<?php
						if ($footer_youtube_profile) :
						?>
							<li class="list-inline-item"><a href="<?php echo $footer_youtube_profile; ?>" class="btn btn-outline-light btn-social mx-1"><i class="fa fa-youtube-play"></i></a></li>
						<?php endif; ?>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<div class="copyrights text-white pt-3 pb-3">
		<div class="container">
			<div class="row">
				<div class="col-lg-4">
					<div class="text-start small">
						<a href="<?php echo esc_url(__('https://profiles.wordpress.org/mobeenraheem/', 'multivas')); ?>" class="text-white text-opacity-50">
							<?php
							printf(esc_html__('Theme Multivas by %s', 'multivas'), 'mobeenraheem');
							?>
						</a>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="text-center small">
						<?php printf('%s &copy; %s &bull; All right reserved.  ', get_bloginfo('name'), date('Y')); ?>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="text-end small">
						<a href="<?php echo esc_url(__('https://wordpress.org/', 'multivas')); ?>" class="text-white text-opacity-50">
							<?php
							printf(esc_html__('Proudly powered by %s', 'multivas'), 'WordPress');
							?>
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</footer>

</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>