<?php

/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package multivas
 */

get_header();

//Theme defaults and customizer selected values
$default = multivas_get_defaults();

$selected_blog_grid = get_theme_mod('multivas_blog_grid_settings', $default['multivas_blog_grid_settings']);

?>
<div class="container archive-container mt-5">
	<div class="row g-5">
		<div class="<?php if ($selected_blog_grid == 'no') : ?>col-lg-12<?php else : ?>col-lg-9<?php endif; ?>">
			<main id="primary" class="site-main">
				<div class="row gx-5">
					<?php if (have_posts()) : ?>

						<div class="col-lg-12">
							<header class="page-header bg-light px-5 py-4 mb-4">
								<?php
								the_archive_title('<h1 class="page-title text-center">', '</h1>');
								the_archive_description('<div class="archive-description">', '</div>');
								?>
							</header><!-- .page-header -->
						</div>

						<?php
						/* Start the Loop */
						while (have_posts()) :
							the_post();

							/*
				 			* Include the Post-Type-specific template for the content.
				 			* If you want to override this in a child theme, then include a file
				 			* called content-___.php (where ___ is the Post Type name) and that will be used instead.
				 			*/
							get_template_part('template-parts/content', get_post_type());

						endwhile; ?>
						<div class="custom-margin">
							<?php
							the_posts_pagination(array(
								'class'     => 'text-center',
								'mid_size'  => 2,
								'prev_text' => __('Previous', 'multivas'),
								'next_text' => __('Next', 'multivas'),
							)); ?>
						</div>
					<?php

					else :

						get_template_part('template-parts/content', 'none');

					endif;
					?>
				</div>
			</main><!-- #main -->
		</div>
		<?php if ($selected_blog_grid != 'no') : ?>
			<div class="col-lg-3">
				<?php get_sidebar(); ?>
			</div>
		<?php endif; ?>
	</div>
</div>
<?php get_footer();
