<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package multivas
 */

get_header();
?>
<div class="container page-container my-5">
	<div class="row g-5">
		<div class="col-lg-12">
			<main id="primary" class="site-main">

				<section class="error-404 not-found bg-light pt-5 pb-5 px-5">
					<header class="page-header">
						<h1 class="page-title text-center pb-3"><?php esc_html_e('Oops! That page can&rsquo;t be found.', 'multivas'); ?></h1>
					</header><!-- .page-header -->

					<div class="page-content">
						<p class="text-center pb-3"><?php esc_html_e('It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'multivas'); ?></p>
						<div class="search-form text-center">
							<?php
							get_search_form();
							?>
						</div>
					</div><!-- .page-content -->
				</section><!-- .error-404 -->

			</main><!-- #main -->
		</div>
	</div>
</div>
<?php
get_footer();
